/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.excute;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.eas.base.dbclean.IJZLogger;
import com.kingdee.eas.base.dbclean.IJZService;
import com.kingdee.eas.base.dbclean.JZProcessOrg;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.JZProcessTaskItem;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.client.IJZThreadListener;
import com.kingdee.eas.base.dbclean.client.JZFrame;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.excute.JZExecuteResultDialog;
import com.kingdee.eas.base.dbclean.client.excute.JZProcessThread;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyleContext;
import org.apache.log4j.Logger;

public class JZExcuteTaskDialog
extends KDDialog
implements IJZThreadListener,
IJZLogger {
    private static Logger logger = Logger.getLogger(JZExcuteTaskDialog.class);
    private KDProgressBar orgProcBar = new KDProgressBar();
    private KDProgressBar itemProcBar = new KDProgressBar();
    private KDCheckBox detailCheckBox = new KDCheckBox("\u8be6\u7ec6\u4fe1\u606f", true);
    private KDButton pauseBtn = new KDButton("\u6682\u505c");
    private KDButton exitBtn = new KDButton("\u9000\u51fa");
    private StyleContext detailStyleContext = new StyleContext();
    private DefaultStyledDocument detailDoc = new DefaultStyledDocument(this.detailStyleContext);
    private KDTextArea detailText = new KDTextArea((Document)this.detailDoc);
    private KDLabel orgRateLabel = new KDLabel();
    private KDLabel taskRateLabel = new KDLabel();
    private JZProcessThread proccessor = null;
    private int curOrgIndex = -1;
    private int curTaskIndex = 0;
    private DateFormat dtFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    private JZProcessOrg currOrg;

    public JZExcuteTaskDialog(JZFrame jzFrame) {
        super((Frame)((Object)jzFrame), true);
        this.setSize(700, 400);
        this.setTitle("EAS\u5e10\u5957\u7ed3\u8f6c-\u4efb\u52a1\u6267\u884c");
        this.setResizable(false);
        this.setLocationRelativeTo((Component)((Object)jzFrame));
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JZExcuteTaskDialog.this.exitExecute();
                JZExcuteTaskDialog.this.setDefaultCloseOperation(0);
            }
        });
    }

    private void initComponent() {
        KDLabel orgLabel = new KDLabel("\u7ed3\u8f6c\u7ec4\u7ec7:");
        orgLabel.setBounds(10, 10, 60, 20);
        this.orgRateLabel.setBounds(70, 10, 600, 20);
        this.orgProcBar.setBounds(10, 30, 670, 30);
        KDLabel taskLabel = new KDLabel("\u7ed3\u8f6c\u4efb\u52a1:");
        taskLabel.setBounds(10, 70, 60, 20);
        this.taskRateLabel.setBounds(70, 70, 600, 20);
        this.itemProcBar.setBounds(10, 90, 670, 30);
        this.detailCheckBox.setBounds(10, 130, 100, 20);
        this.pauseBtn.setBounds(500, 130, 80, 20);
        this.exitBtn.setBounds(590, 130, 80, 20);
        this.detailText.setEditable(false);
        KDScrollPane detailScroll = new KDScrollPane((Component)this.detailText);
        detailScroll.setBounds(10, 155, 670, 200);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)orgLabel);
        this.getContentPane().add((Component)this.orgProcBar);
        this.getContentPane().add((Component)this.orgRateLabel);
        this.getContentPane().add((Component)taskLabel);
        this.getContentPane().add((Component)this.taskRateLabel);
        this.getContentPane().add((Component)this.itemProcBar);
        this.getContentPane().add((Component)this.detailCheckBox);
        this.getContentPane().add((Component)this.pauseBtn);
        this.getContentPane().add((Component)this.exitBtn);
        this.getContentPane().add((Component)detailScroll);
        this.pauseBtn.addActionListener((ActionListener)new PauseThreadAction());
        this.exitBtn.addActionListener((ActionListener)new ExiteExecuteAction());
    }

    @Override
    public void println(String msg) {
        this.print(msg + "\n");
    }

    @Override
    public void print(String msg) {
        if (this.detailCheckBox.isSelected()) {
            this.detailText.append("  " + msg);
            this.detailText.setCaretPosition(this.detailText.getText().length());
            logger.info((Object)("  " + msg));
        }
    }

    public JZProcessTask createProccessor(int periodNumber, String[] orgIds) throws Exception {
        IJZService jzService = JZServiceFactory.getJZService();
        JZProcessTask procTask = jzService.createProcessTask(periodNumber, orgIds, JZUtil.getConnection());
        return procTask;
    }

    public void continueProccessor(JZProcessTask procTask) {
        this.startProccessor(procTask);
    }

    public void startProccessor(JZProcessTask procTask) {
        try {
            logger.info((Object)"========================================================");
            logger.info((Object)"========================================================");
            logger.info((Object)"========================================================");
            logger.info((Object)("\u5f00\u59cb\u6267\u884c\u7ed3\u8f6c[" + procTask.getProcId() + "]"));
            this.proccessor = new JZProcessThread(this);
            this.proccessor.addThreadListener(this);
            this.proccessor.loadProcessTask(procTask.getProcId());
            Thread jzThread = new Thread(this.proccessor);
            jzThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u542f\u52a8\u6267\u884c\u4efb\u52a1\u7ebf\u7a0b\u5931\u8d25: " + ex.getMessage()));
        }
    }

    @Override
    public void processLoadActioin(int orgCount) {
        this.orgProcBar.setMaximum(orgCount);
    }

    @Override
    public void taskItemBeginAction(JZProcessTaskItem taskItem) {
        ++this.curTaskIndex;
        this.itemProcBar.setValue(this.curTaskIndex);
        this.taskRateLabel.setText(this.curTaskIndex + " / " + this.itemProcBar.getMaximum() + "  " + taskItem.getItemName());
        if (this.detailCheckBox.isSelected()) {
            String curTime = this.dtFormat.format(new Date());
            String logInfo = this.fillTaskNameInfo(curTime + " " + taskItem.getOrgName() + " - " + taskItem.getItemName());
            this.detailText.append(logInfo);
            this.detailText.setCaretPosition(this.detailText.getText().length());
            logger.info((Object)logInfo);
        }
    }

    private String fillTaskNameInfo(String nameInfo) {
        int MAX_LENGTH = 80;
        int infoLength = nameInfo.length();
        if (infoLength < MAX_LENGTH) {
            StringBuffer retBuffer = new StringBuffer(nameInfo + " ");
            for (int i = 0; i < MAX_LENGTH - infoLength; ++i) {
                retBuffer.append("=");
            }
            return retBuffer.toString() + "\n";
        }
        return nameInfo + "\n";
    }

    @Override
    public void taskItemResulteAction(String result, String msg) {
        if (this.detailCheckBox.isSelected()) {
            if ("error".equals(result) || "ok".equals(result)) {
                // empty if block
            }
            this.detailText.append("\n        \u6267\u884c\u7ed3\u679c:" + msg + "\n");
            this.detailText.setCaretPosition(this.detailText.getText().length());
            logger.info((Object)("\n        \u6267\u884c\u7ed3\u679c:" + msg + "\n"));
        }
    }

    @Override
    public void taskItemExceptionAction(JZTaskException jzException) {
        if (this.detailCheckBox.isSelected()) {
            this.detailText.append("\n\t" + jzException.getMessage() + "\n");
            this.detailText.setCaretPosition(this.detailText.getText().length());
            logger.info((Object)("\n\t" + jzException.getMessage() + "\n"));
        }
    }

    @Override
    public void proceessFinishAction(long spendTime) {
        ++this.curOrgIndex;
        this.orgProcBar.setValue(this.curOrgIndex);
        if (this.detailCheckBox.isSelected()) {
            this.detailText.append("\u7ed3\u8f6c\u5b8c\u6bd5,\u603b\u5171\u8017\u65f6: " + spendTime + "  \u79d2\n");
            this.detailText.setCaretPosition(this.detailText.getText().length());
            logger.info((Object)("\u7ed3\u8f6c\u5b8c\u6bd5,\u603b\u5171\u8017\u65f6: " + spendTime + "  \u79d2\n"));
            logger.info((Object)"\u7ed3\u675f\u7ed3\u8f6c=================================================");
            logger.info((Object)"========================================================");
            logger.info((Object)"========================================================");
            logger.info((Object)"========================================================");
        }
        JZExecuteResultDialog resultDlg = new JZExecuteResultDialog((JDialog)((Object)this), this.proccessor.getProcTask().getProcId());
        resultDlg.show();
    }

    @Override
    public void orgBeginAction(JZProcessOrg procOrg, int taskCount) {
        this.currOrg = procOrg;
        ++this.curOrgIndex;
        this.orgProcBar.setValue(this.curOrgIndex);
        this.orgRateLabel.setText(this.curOrgIndex + 1 + " / " + this.orgProcBar.getMaximum() + "  " + procOrg.getOrgName());
        this.curTaskIndex = 0;
        this.itemProcBar.setMaximum(taskCount);
        this.itemProcBar.setValue(this.curTaskIndex);
    }

    @Override
    public void orgFinishAction(JZProcessOrg procOrg) {
    }

    private void exitExecute() {
        if (this.proccessor != null && this.proccessor.isProccessing()) {
            if (KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)"\u6b63\u5728\u6267\u884c\u7ed3\u8f6c\u4efb\u52a1,\u60a8\u786e\u5b9a\u8981\u505c\u6b62\u6267\u884c\u7ebf\u7a0b\u800c\u9000\u51fa\u5417?", (String)"\u63d0\u793a", (int)0) == 0) {
                this.proccessor.exitProcess();
                this.setVisible(false);
                this.dispose();
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void pauseExcute() {
        this.orgRateLabel.setText(this.curOrgIndex + 1 + " / " + this.orgProcBar.getMaximum() + "  " + this.currOrg.getOrgName() + "    \u6682\u505c");
        this.pauseBtn.setText("\u7ee7\u7eed");
    }

    public void stopExcute() {
        this.pauseBtn.setEnabled(false);
    }

    public class ExiteExecuteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JZExcuteTaskDialog.this.exitExecute();
        }
    }

    public class PauseThreadAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JZExcuteTaskDialog.this.proccessor != null) {
                if (!JZExcuteTaskDialog.this.proccessor.isPause()) {
                    JZExcuteTaskDialog.this.proccessor.pauseProcess();
                    JZExcuteTaskDialog.this.pauseBtn.setText("\u7ee7\u7eed");
                } else {
                    JZExcuteTaskDialog.this.proccessor.wakeup();
                    JZExcuteTaskDialog.this.pauseBtn.setText("\u6682\u505c");
                }
            }
        }
    }
}

