/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.excute;

import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.eas.base.dbclean.IJZService;
import com.kingdee.eas.base.dbclean.IJZTask;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZModule;
import com.kingdee.eas.base.dbclean.JZProcessOrg;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.JZProcessTaskItem;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.JZTaskFactory;
import com.kingdee.eas.base.dbclean.client.IJZThreadListener;
import com.kingdee.eas.base.dbclean.client.JZFrame;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.excute.JZExcuteTaskDialog;
import java.awt.Component;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class JZProcessThread
implements Runnable {
    private static Logger logger = Logger.getLogger(JZProcessThread.class);
    private JZProcessTask procTask = null;
    private List threadListener = new ArrayList();
    private boolean isPause = false;
    private boolean isExit = false;
    private boolean isProcessing = false;
    private JZExcuteTaskDialog execDlg;
    private JZContext gJZContext = null;
    private DateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean redo = false;
    private JZProcessTaskItem redoTaskItem = null;

    public JZProcessThread(JZExcuteTaskDialog execDlg) {
        this.execDlg = execDlg;
    }

    public void exitProcess() {
        this.isExit = true;
        if (this.gJZContext != null) {
            this.gJZContext.setStop(this.isExit);
        }
    }

    public void pauseProcess() {
        this.isPause = true;
        if (this.gJZContext != null) {
            this.gJZContext.setPause(this.isPause);
        }
    }

    public synchronized void wakeup() {
        this.isPause = false;
        if (this.gJZContext != null) {
            this.gJZContext.setPause(this.isPause);
        }
        this.notify();
    }

    public boolean isPause() {
        return this.isPause;
    }

    public boolean isProccessing() {
        return this.isProcessing;
    }

    public void loadProcessTask(String procId) throws Exception {
        IJZService jzService = JZServiceFactory.getJZService();
        this.procTask = jzService.loadProccessTask(procId, JZUtil.getConnection());
        List moduleList = this.procTask.getModuleTask();
        if (moduleList != null && moduleList.size() > 0) {
            Collections.sort(moduleList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    JZModule module1 = (JZModule)o1;
                    JZModule module2 = (JZModule)o2;
                    if (module1 == null || module2 == null) {
                        return 0;
                    }
                    if (module1.getOrder() > module2.getOrder()) {
                        return 1;
                    }
                    if (module1.getOrder() == module2.getOrder()) {
                        return 0;
                    }
                    if (module1.getOrder() < module2.getOrder()) {
                        return -1;
                    }
                    return 0;
                }

                @Override
                public boolean equals(Object obj) {
                    return false;
                }
            });
        }
        int orgCount = this.procTask.getOrgs().size();
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.processLoadActioin(orgCount);
            }
        }
    }

    public void addThreadListener(IJZThreadListener listener) {
        this.threadListener.add(listener);
    }

    public void removeThreadListener(IJZThreadListener listener) {
        this.threadListener.remove(listener);
    }

    public void notifyTaskItemBegin(JZProcessTaskItem taskItem) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.taskItemBeginAction(taskItem);
            }
        }
    }

    public void notifyTaskItemResult(String result, String msg) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.taskItemResulteAction(result, msg);
            }
        }
    }

    public void notifyTaskItemException(JZTaskException jzException) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.taskItemExceptionAction(jzException);
            }
        }
    }

    public void notifyProcessFinish(long spendTime) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.proceessFinishAction(spendTime);
            }
        }
    }

    public void notifyOrgBegin(JZProcessOrg procOrg, int taskCount) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.orgBeginAction(procOrg, taskCount);
            }
        }
    }

    public void notifyOrgFinish(JZProcessOrg procOrg) {
        if (this.threadListener != null) {
            for (IJZThreadListener listener : this.threadListener) {
                if (listener == null) continue;
                listener.orgFinishAction(procOrg);
            }
        }
    }

    private int getOrgTaskCount(String orgFId) {
        int taskCount = 0;
        List moduleList = this.procTask.getModuleTask();
        for (JZModule module : moduleList) {
            List taskList = module.getTaskList();
            for (JZProcessTaskItem taskItem : taskList) {
                if (!orgFId.equals(taskItem.getOrgFId())) continue;
                ++taskCount;
            }
        }
        return taskCount;
    }

    @Override
    public void run() {
        this.isProcessing = true;
        long start = System.currentTimeMillis();
        List orgIds = this.procTask.getOrgs();
        JZContext jzContext = new JZContext();
        jzContext.setLogger(this.execDlg);
        jzContext.setDbConn(JZUtil.getConnection());
        this.gJZContext = jzContext;
        for (JZProcessOrg procOrg : orgIds) {
            jzContext.setOrgFId(procOrg.getOrgFId());
            jzContext.setOrgNumber(procOrg.getOrgNumber());
            jzContext.setPeriodType(procOrg.getPeriodType());
            jzContext.setPeriodFId(procOrg.getPeriodFid());
            jzContext.setPeriodNumber(procOrg.getPeriodNumber());
            jzContext.setEndDt(procOrg.getPeriodBeginDt());
            Object orgNumber = null;
            int allTaskCount = this.getOrgTaskCount(procOrg.getOrgFId());
            this.notifyOrgBegin(procOrg, allTaskCount);
            try {
                List task;
                List preTask = this.getTaskList(procOrg.getOrgFId(), procOrg.getOrgName(), 1);
                if (this.excuteTask(preTask, jzContext) && this.excuteTask(task = this.getTaskList(procOrg.getOrgFId(), procOrg.getOrgName(), 2), jzContext)) {
                    List postTask = this.getTaskList(procOrg.getOrgFId(), procOrg.getOrgName(), 3);
                    this.excuteTask(postTask, jzContext);
                }
                this.notifyOrgFinish(procOrg);
            }
            catch (Exception ex) {
                this.notifyOrgFinish(procOrg);
            }
        }
        if (this.procTask.isAllFinish()) {
            try {
                JZServiceFactory.getJZService().updateProccessTaskStatus(this.procTask, 1, JZUtil.getConnection());
                this.procTask.setStatus(1);
                JZFrame.getInstance().updateProcessTask(this.procTask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        long spendTime = (end - start) / 1000L;
        this.notifyProcessFinish(spendTime);
        this.isProcessing = false;
        this.gJZContext = null;
    }

    private List getTaskList(String orgFId, String orgName, int execType) {
        ArrayList<JZProcessTaskItem> tasks = new ArrayList<JZProcessTaskItem>();
        List moduleList = this.procTask.getModuleTask();
        if (moduleList != null && moduleList.size() > 0) {
            for (JZModule module : moduleList) {
                List taskList = module.getTaskList();
                for (JZProcessTaskItem taskItem : taskList) {
                    if (!orgFId.equals(taskItem.getOrgFId()) || taskItem.getExecType() != execType) continue;
                    taskItem.setModule(module);
                    taskItem.setOrgName(orgName);
                    tasks.add(taskItem);
                }
            }
        }
        Collections.sort(tasks, new Comparator(){

            public int compare(Object o1, Object o2) {
                JZProcessTaskItem taskItem1 = (JZProcessTaskItem)o1;
                JZProcessTaskItem taskItem2 = (JZProcessTaskItem)o2;
                if (taskItem1 == null || taskItem2 == null) {
                    return 0;
                }
                if (taskItem1.getModule().getOrder() == taskItem2.getModule().getOrder()) {
                    if (taskItem1.getOrder() > taskItem2.getOrder()) {
                        return 1;
                    }
                    if (taskItem1.getOrder() == taskItem2.getOrder()) {
                        return 0;
                    }
                    if (taskItem1.getOrder() < taskItem2.getOrder()) {
                        return -1;
                    }
                } else {
                    if (taskItem1.getModule().getOrder() > taskItem2.getModule().getOrder()) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean excuteTask(List taskList, JZContext jzContext) throws Exception {
        boolean retValue = true;
        if (taskList != null) {
            Iterator preIt = taskList.iterator();
            while (!this.isExit && (preIt.hasNext() || this.redo)) {
                block45: {
                    JZProcessTaskItem taskItem = null;
                    if (this.redo && this.redoTaskItem != null && this.redoTaskItem.getStatus() != 2) {
                        taskItem = this.redoTaskItem;
                    } else {
                        taskItem = (JZProcessTaskItem)preIt.next();
                        this.notifyTaskItemBegin(taskItem);
                    }
                    this.redo = false;
                    if (taskItem.getStatus() == 2) {
                        this.notifyTaskItemResult("ok", "\u4e0a\u6b21\u5df2\u7ecf\u6267\u884c\u6210\u529f");
                        continue;
                    }
                    long start = System.currentTimeMillis();
                    taskItem.setStartDt(this.dtFormat.format(new Date(start)));
                    try {
                        JZUtil.getConnection().setAutoCommit(false);
                        IJZTask jzTask = JZTaskFactory.getJZTask(taskItem);
                        if (jzTask == null) {
                            this.notifyTaskItemResult("error", "\u6ca1\u627e\u5230\u5bf9\u5e94\u6267\u884c\u4ee3\u7801");
                            continue;
                        }
                        jzContext.setTaskConfig(taskItem);
                        jzContext.setDbConn(JZUtil.getConnection());
                        boolean result = false;
                        String resultError = "";
                        if (jzTask.doTask(jzContext)) {
                            result = true;
                            resultError = "";
                        }
                        long end = System.currentTimeMillis();
                        if (result) {
                            taskItem.setCost((int)(end - start));
                            taskItem.setStatus(2);
                            taskItem.setError(resultError);
                            JZServiceFactory.getJZService().updateTaskItem(taskItem, JZUtil.getConnection());
                            JZUtil.getConnection().commit();
                            JZUtil.getConnection().setAutoCommit(true);
                            this.notifyTaskItemResult("ok", "\u7ed3\u8f6c\u6210\u529f");
                            break block45;
                        }
                        if (result) break block45;
                        this.notifyTaskItemResult("error", resultError);
                        try {
                            JZUtil.getConnection().rollback();
                            JZUtil.getConnection().setAutoCommit(true);
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                            logger.fatal((Object)("\u56de\u6eda\u4e8b\u52a1\u5931\u8d25, task[" + taskItem.getClassName() + "]"));
                        }
                        if (taskItem.getExecType() == 1) {
                            boolean bl = false;
                            return bl;
                        }
                        if (taskItem.getExecType() == 2) {
                            retValue = false;
                            break block45;
                        }
                        if (taskItem.getExecType() != 3) break block45;
                    }
                    catch (Exception ex) {
                        try {
                            JZTaskException jzEx;
                            JZUtil.getConnection().rollback();
                            JZUtil.getConnection().setAutoCommit(true);
                            String errMsg = this.getExMsg(ex);
                            this.notifyTaskItemResult("error", errMsg);
                            long end = System.currentTimeMillis();
                            taskItem.setCost((int)(end - start));
                            taskItem.setStatus(1);
                            taskItem.setError(errMsg);
                            if (ex instanceof JZTaskException) {
                                jzEx = (JZTaskException)ex;
                                if (jzEx.getType() == 4) {
                                    taskItem.setStatus(2);
                                } else {
                                    ex.printStackTrace();
                                }
                            } else {
                                ex.printStackTrace();
                                logger.fatal((Object)("\u672a\u77e5\u5f02\u5e38, task[" + taskItem.getClassName() + "]"));
                            }
                            try {
                                JZServiceFactory.getJZService().updateTaskItem(taskItem, JZUtil.getConnection());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.fatal((Object)("task\u6267\u884c\u72b6\u6001\u66f4\u65b0\u5931\u8d25, task[" + taskItem.getClassName() + "]"));
                            }
                            if (ex instanceof JZTaskException) {
                                jzEx = (JZTaskException)ex;
                                if (jzEx.getType() == 5) {
                                    this.exitProcess();
                                    break block45;
                                }
                                if (jzEx.getType() == 2) {
                                    this.pauseProcess();
                                    break block45;
                                }
                                if (jzEx.getType() == 3) {
                                    this.pauseProcess();
                                    if (KDOptionPane.showConfirmDialog((Component)((Object)this.execDlg), (Object)("\u7ed3\u8f6c\u8fc7\u7a0b\u56e0\u4e3a[" + jzEx.getMessage() + "]\u800c\u6682\u505c,\u60a8\u9700\u8981\u7ee7\u7eed\u6267\u884c\u5417?"), (String)"\u63d0\u793a", (int)0, (int)3) == 0) {
                                        this.wakeup();
                                    } else {
                                        this.exitProcess();
                                    }
                                    break block45;
                                }
                                if (jzEx.getType() == 4) {
                                    break block45;
                                }
                                if (jzEx.getType() == 1) {
                                    break block45;
                                }
                                if (jzEx.getType() != 6) break block45;
                                this.redo = true;
                                this.redoTaskItem = taskItem;
                                break block45;
                            }
                            this.redoTaskItem = taskItem;
                            this.redo = true;
                            this.pauseProcess();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                            this.waitProcss();
                            throw ex;
                        }
                    }
                    finally {
                        try {
                            jzContext.getLogger().println("\u91cd\u65b0\u8fde\u63a5\u6570\u636e\u5e93(\u91ca\u653e\u8d44\u6e90)");
                            JZUtil.reConnect();
                        }
                        catch (Exception ex) {
                            jzContext.getLogger().println("\u91cd\u65b0\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25,\u4e0d\u80fd\u7ee7\u7eed\u6267\u884c\u7ed3\u8f6c(\u539f\u56e0:" + ex.getMessage() + "),\u8bf7\u91cd\u65b0\u542f\u52a8\u7ed3\u8f6c\u4efb\u52a1");
                            this.exitProcess();
                        }
                        continue;
                    }
                }
                this.waitProcss();
            }
        }
        return retValue;
    }

    private String getExMsg(Throwable ex) {
        if (ex != null && ex.getMessage() != null && !ex.getMessage().equals("")) {
            return ex.getMessage();
        }
        if (ex == null) {
            return "\u672a\u77e5\u9519\u8bef";
        }
        return this.getExMsg(ex.getCause());
    }

    private synchronized void waitProcss() {
        if (this.isPause()) {
            try {
                this.execDlg.pauseExcute();
                this.wait();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.isExit) {
            this.execDlg.stopExcute();
        }
    }

    public JZProcessTask getProcTask() {
        return this.procTask;
    }
}

