/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.logger;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.dbclean.JZModule;
import com.kingdee.eas.base.dbclean.JZModuleStruct;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.JZProcessTaskItem;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.client.JZFrame;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class JZTaskLogQueryDialog
extends KDDialog {
    private ImageIcon refreshIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_refresh.gif"));
    private ImageIcon exitIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_close.gif"));
    private ImageIcon exportIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/ExportData.gif"));
    private KDToolBar toolBar = new KDToolBar();
    private RefreshAction refreshAction = new RefreshAction();
    private ExitAction exitAction = new ExitAction();
    private ExportAction exportAction = new ExportAction();
    private KDComboBox fieldComboBox = new KDComboBox((Object[])JZModuleStruct.getQueryModules());
    private KDComboBox moduleComboBox = new KDComboBox();
    private KDTextField orgTextField = new KDTextField(15);
    private KDComboBox execStatusBox = new KDComboBox(new Object[]{new ItemValue(new Integer(-1), "\u6240\u6709\u72b6\u6001"), new ItemValue(new Integer(0), "\u672a\u6267\u884c"), new ItemValue(new Integer(2), "\u6210\u529f"), new ItemValue(new Integer(1), "\u5931\u8d25")});
    private KDButton queryBtn = new KDButton("\u67e5\u8be2");
    private KDTable taskTable;
    private KDPanel queryPanel = new KDPanel((LayoutManager)new FlowLayout(0));
    private JZProcessTask procTask;

    public JZTaskLogQueryDialog(JZFrame jzFrame) {
        super((Frame)((Object)jzFrame), true);
        this.setSize(780, 500);
        this.setTitle("EAS\u5e10\u5957\u7ed3\u8f6c-\u67e5\u770b\u7ed3\u8f6c\u65e5\u5fd7");
        this.setLocationRelativeTo((Component)((Object)jzFrame));
        this.initComponent();
    }

    public void initComponent() {
        this.toolBar.add((Action)this.refreshAction);
        this.toolBar.add((Action)this.exportAction);
        this.toolBar.add((Action)this.exitAction);
        this.queryPanel.add((Component)new KDLabel("\u9886\u57df\uff1a"));
        this.fieldComboBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.fieldComboBox);
        this.fieldComboBox.addItemListener((ItemListener)new ModuleItemChangedListener());
        this.queryPanel.add((Component)new KDLabel("\u6a21\u5757\uff1a"));
        this.moduleComboBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.moduleComboBox);
        this.queryPanel.add((Component)new KDLabel("\u7ec4\u7ec7\u540d\u79f0\uff1a"));
        this.queryPanel.add((Component)this.orgTextField);
        this.queryPanel.add((Component)new KDLabel("\u72b6\u6001\uff1a"));
        this.execStatusBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.execStatusBox);
        this.queryPanel.add((Component)this.queryBtn);
        this.queryBtn.addActionListener((ActionListener)new QueryAction());
        this.taskTable = new KDTable(9, 1, 0);
        this.taskTable.getSelectManager().setSelectMode(10);
        this.taskTable.setCursor(this.getCursor());
        this.taskTable.getColumn(0).setWidth(0);
        this.taskTable.getColumn(1).setWidth(100);
        this.taskTable.getColumn(2).setWidth(100);
        this.taskTable.getColumn(3).setWidth(150);
        this.taskTable.getColumn(4).setWidth(150);
        this.taskTable.getColumn(5).setWidth(100);
        this.taskTable.getColumn(6).setWidth(55);
        this.taskTable.getColumn(7).setWidth(120);
        this.taskTable.getColumn(8).setWidth(200);
        this.taskTable.getColumn(1).setSortable(true);
        this.taskTable.getColumn(2).setSortable(true);
        this.taskTable.getColumn(3).setSortable(true);
        this.taskTable.getColumn(4).setSortable(true);
        this.taskTable.getColumn(5).setSortable(true);
        this.taskTable.getColumn(6).setSortable(true);
        this.taskTable.getColumn(7).setSortable(true);
        this.taskTable.getColumn(8).setSortable(true);
        KDTSortManager sortMgr = new KDTSortManager(this.taskTable);
        sortMgr.setSortAuto(true);
        this.taskTable.setSortMange(sortMgr);
        IRow headRow = this.taskTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)"\u4efb\u52a1\u7f16\u53f7");
        headRow.getCell(1).setValue((Object)"\u7ed3\u8f6c\u9886\u57df");
        headRow.getCell(2).setValue((Object)"\u7ed3\u8f6c\u6a21\u5757");
        headRow.getCell(3).setValue((Object)"\u7ed3\u8f6c\u7ec4\u7ec7");
        headRow.getCell(4).setValue((Object)"\u7ed3\u8f6c\u5185\u5bb9");
        headRow.getCell(5).setValue((Object)"\u6267\u884c\u65f6\u95f4");
        headRow.getCell(6).setValue((Object)"\u8017\u65f6(s)");
        headRow.getCell(7).setValue((Object)"\u72b6\u6001");
        headRow.getCell(8).setValue((Object)"\u5931\u8d25\u4fe1\u606f");
        KDPanel workPanel = new KDPanel((LayoutManager)new BorderLayout());
        workPanel.add((Component)this.queryPanel, (Object)"North");
        workPanel.add((Component)this.taskTable, (Object)"Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)workPanel, "Center");
        this.fieldComboBox.setSelectedIndex(0);
        this.moduleComboBox.removeAllItems();
        this.moduleComboBox.addItems((Object[])((JZModule)this.fieldComboBox.getSelectedItem()).getChildModule());
    }

    public void loadLog(JZProcessTask procTask) {
        this.procTask = procTask;
        try {
            this.taskTable.refresh();
            List taskLogList = JZServiceFactory.getJZService().queryAllTaskLog(procTask.getProcId(), JZUtil.getConnection());
            for (JZProcessTaskItem logItem : taskLogList) {
                IRow dataRow = this.taskTable.addRow();
                if (logItem.getStatus() == 1) {
                    dataRow.getStyleAttributes().setFontColor(Color.RED);
                } else if (logItem.getStatus() == 2) {
                    dataRow.getStyleAttributes().setFontColor(Color.BLUE);
                }
                dataRow.getCell(0).setValue((Object)logItem.getProcId());
                dataRow.getCell(1).setValue((Object)logItem.getModuleValue());
                dataRow.getCell(2).setValue((Object)logItem.getCModuleValue());
                dataRow.getCell(3).setValue((Object)logItem.getOrgName());
                dataRow.getCell(4).setValue((Object)logItem.getItemName());
                dataRow.getCell(5).setValue((Object)logItem.getStartDt());
                dataRow.getCell(6).setValue((Object)new Integer(logItem.getCost() / 1000));
                dataRow.getCell(7).setValue((Object)logItem.getStatusName());
                dataRow.getCell(8).setValue((Object)logItem.getError());
            }
            this.taskTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u9519\u8bef:" + ex.getMessage()));
        }
    }

    public void query() {
        try {
            this.taskTable.refresh();
            String moduleId = ((JZModule)this.fieldComboBox.getSelectedItem()).getModuleId();
            String cModuleId = ((JZModule)this.moduleComboBox.getSelectedItem()).getModuleId();
            int execStatus = ((ItemValue)this.execStatusBox.getSelectedItem()).getIntValue();
            String orgName = this.orgTextField.getText();
            List taskLogList = JZServiceFactory.getJZService().queryTaskLog(this.procTask.getProcId(), moduleId, cModuleId, orgName, execStatus, JZUtil.getConnection());
            for (JZProcessTaskItem logItem : taskLogList) {
                IRow dataRow = this.taskTable.addRow();
                if (logItem.getStatus() == 1) {
                    dataRow.getStyleAttributes().setFontColor(Color.RED);
                } else if (logItem.getStatus() == 2) {
                    dataRow.getStyleAttributes().setFontColor(Color.BLUE);
                }
                dataRow.getCell(0).setValue((Object)logItem.getProcId());
                dataRow.getCell(1).setValue((Object)logItem.getModuleValue());
                dataRow.getCell(2).setValue((Object)logItem.getCModuleValue());
                dataRow.getCell(3).setValue((Object)logItem.getOrgName());
                dataRow.getCell(4).setValue((Object)logItem.getItemName());
                dataRow.getCell(5).setValue((Object)logItem.getStartDt());
                dataRow.getCell(6).setValue((Object)new Integer(logItem.getCost()));
                dataRow.getCell(7).setValue((Object)logItem.getStatusName());
                dataRow.getCell(8).setValue((Object)logItem.getError());
            }
            this.taskTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u9519\u8bef:" + ex.getMessage()));
        }
    }

    private class ItemValue {
        private Object value;
        private String title;

        public ItemValue(Object value, String title) {
            this.value = value;
            this.title = title;
        }

        public int getIntValue() {
            return (Integer)this.value;
        }

        public String getStringValue() {
            return this.value.toString();
        }

        public String toString() {
            return this.title;
        }
    }

    private class ModuleItemChangedListener
    implements ItemListener {
        private ModuleItemChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JZModule jzModle = (JZModule)e.getItem();
            JZTaskLogQueryDialog.this.moduleComboBox.removeAllItems();
            JZTaskLogQueryDialog.this.moduleComboBox.addItems((Object[])jzModle.getChildModule());
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("\u5bfc\u51fa", JZTaskLogQueryDialog.this.exportIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTIOManager excelManager = JZTaskLogQueryDialog.this.taskTable.getIOManager();
            File tempFile = null;
            try {
                tempFile = File.createTempFile("eastemp", ".xls");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            excelManager.setTempFileDirection(tempFile.getPath());
            excelManager.exportExcelToTempFile(false);
            tempFile.deleteOnExit();
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("\u9000\u51fa", JZTaskLogQueryDialog.this.exitIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskLogQueryDialog.this.dispose();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super("\u5237\u65b0", JZTaskLogQueryDialog.this.refreshIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskLogQueryDialog.this.loadLog(JZTaskLogQueryDialog.this.procTask);
            JZTaskLogQueryDialog.this.taskTable.updateUI();
        }
    }

    private class QueryAction
    implements ActionListener {
        private QueryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskLogQueryDialog.this.query();
        }
    }
}

