/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.register;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.dbclean.JZModule;
import com.kingdee.eas.base.dbclean.JZModuleItem;
import com.kingdee.eas.base.dbclean.JZModuleStruct;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.client.JZFrame;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.register.JZTaskRegisterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class JZTaskQueryDialog
extends KDDialog
implements KDTMouseListener {
    private ImageIcon enableIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/task_running.gif"));
    private ImageIcon disEnableIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/tbtn_forcelocking.gif"));
    private ImageIcon deleteIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_delete.gif"));
    private ImageIcon exitIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_close.gif"));
    private KDToolBar toolBar = new KDToolBar();
    private RegisterAction registerTaskAction = new RegisterAction();
    private EnableTaskAction enableTaskAction = new EnableTaskAction();
    private DisEnableTaskAction disEnableTaskAction = new DisEnableTaskAction();
    private DeleteTaskAction deleteTaskAction = new DeleteTaskAction();
    private ExitAction exitAction = new ExitAction();
    private KDComboBox fieldComboBox = new KDComboBox((Object[])JZModuleStruct.getQueryModules());
    private KDComboBox moduleComboBox = new KDComboBox();
    private KDComboBox execTypeBox = new KDComboBox(new Object[]{new ItemValue(new Integer(0), "\u6240\u6709\u4efb\u52a1"), new ItemValue(new Integer(1), "\u524d\u7f6e\u4efb\u52a1"), new ItemValue(new Integer(2), "\u6267\u884c\u9879"), new ItemValue(new Integer(3), "\u540e\u7f6e\u4efb\u52a1")});
    private KDTextField valueTextField = new KDTextField(15);
    private KDButton queryBtn = new KDButton("\u67e5\u8be2");
    private KDTable taskTable;
    private KDPanel queryPanel;

    public JZTaskQueryDialog(JZFrame jzFrame) {
        super((Frame)((Object)jzFrame), true);
        this.setSize(800, 600);
        this.setTitle("EAS\u5e10\u5957\u7ed3\u8f6c-\u67e5\u8be2\u7ed3\u8f6c\u4efb\u52a1");
        this.setLocationRelativeTo((Component)((Object)jzFrame));
        this.initComponent();
        this.loadData();
    }

    private void initComponent() {
        this.toolBar.add((Action)this.enableTaskAction);
        this.toolBar.add((Action)this.disEnableTaskAction);
        this.toolBar.add((Action)this.deleteTaskAction);
        this.toolBar.add((Action)this.exitAction);
        this.queryBtn.addActionListener((ActionListener)new QueryTaskAction());
        this.queryPanel = new KDPanel((LayoutManager)new FlowLayout(0));
        this.queryPanel.add((Component)new KDLabel("\u9886\u57df\uff1a"));
        this.fieldComboBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.fieldComboBox);
        this.fieldComboBox.addItemListener((ItemListener)new ModuleItemChangedListener());
        this.queryPanel.add((Component)new KDLabel("\u6a21\u5757\uff1a"));
        this.moduleComboBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.moduleComboBox);
        this.queryPanel.add((Component)new KDLabel("\u4efb\u52a1\u540d\u79f0\uff1a"));
        this.queryPanel.add((Component)this.valueTextField);
        this.queryPanel.add((Component)new KDLabel("\u6267\u884c\u9636\u6bb5\uff1a"));
        this.execTypeBox.setPreferredSize(new Dimension(100, 10));
        this.queryPanel.add((Component)this.execTypeBox);
        this.queryPanel.add((Component)this.queryBtn);
        this.taskTable = new KDTable(9, 1, 0);
        this.taskTable.setCursor(this.getCursor());
        this.taskTable.getSelectManager().setSelectMode(10);
        this.taskTable.setEditable(false);
        this.taskTable.addKDTMouseListener((KDTMouseListener)this);
        this.taskTable.getColumn(0).setWidth(60);
        this.taskTable.getColumn(1).setWidth(60);
        this.taskTable.getColumn(2).setWidth(30);
        this.taskTable.getColumn(3).setWidth(120);
        this.taskTable.getColumn(4).setWidth(60);
        this.taskTable.getColumn(5).setWidth(60);
        this.taskTable.getColumn(6).setWidth(310);
        this.taskTable.getColumn(7).setWidth(60);
        this.taskTable.getColumn(8).setWidth(0);
        IRow headRow = this.taskTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)"\u6240\u5c5e\u9886\u57df");
        headRow.getCell(1).setValue((Object)"\u6240\u5c5e\u6a21\u5757");
        headRow.getCell(2).setValue((Object)"\u5e8f\u53f7");
        headRow.getCell(3).setValue((Object)"\u4efb\u52a1\u540d\u79f0");
        headRow.getCell(4).setValue((Object)"\u6267\u884c\u65b9\u5f0f");
        headRow.getCell(5).setValue((Object)"\u6267\u884c\u9636\u6bb5");
        headRow.getCell(6).setValue((Object)"\u6267\u884c\u4ee3\u7801");
        headRow.getCell(7).setValue((Object)"\u6709\u6548\u72b6\u6001");
        headRow.getCell(8).setValue((Object)"\u7f16\u7801");
        KDPanel workPanel = new KDPanel((LayoutManager)new BorderLayout());
        workPanel.add((Component)this.queryPanel, (Object)"North");
        workPanel.add((Component)this.taskTable, (Object)"Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)workPanel, "Center");
        this.fieldComboBox.setSelectedIndex(0);
        this.moduleComboBox.removeAllItems();
        this.moduleComboBox.addItems((Object[])((JZModule)this.fieldComboBox.getSelectedItem()).getChildModule());
        this.fieldComboBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 121) {
                    JZTaskQueryDialog.this.registerTaskAction.actionPerformed(null);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.taskTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 121) {
                    JZTaskQueryDialog.this.registerTaskAction.actionPerformed(null);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void loadData() {
    }

    public void tableClicked(KDTMouseEvent event) {
        if (event.getClickCount() >= 2) {
            int curRowIndex = this.taskTable.getSelectManager().getActiveRowIndex();
            IRow row = this.taskTable.getRow(curRowIndex);
            JZModuleItem moduleItem = (JZModuleItem)row.getUserObject();
            JZTaskRegisterDialog registerDlg = new JZTaskRegisterDialog(this);
            registerDlg.setModuleItem(moduleItem);
            registerDlg.show();
        }
    }

    private void query() {
        try {
            this.taskTable.refresh();
            String moduleId = ((JZModule)this.fieldComboBox.getSelectedItem()).getModuleId();
            String cModuleId = ((JZModule)this.moduleComboBox.getSelectedItem()).getModuleId();
            int execType = ((ItemValue)this.execTypeBox.getSelectedItem()).getIntValue();
            String itemName = this.valueTextField.getText();
            List dataList = JZServiceFactory.getJZService().queryModuleItems(moduleId, cModuleId, execType, itemName, JZUtil.getConnection());
            if (dataList != null && dataList.size() > 0) {
                for (JZModuleItem moduleItem : dataList) {
                    IRow dataRow = this.taskTable.addRow();
                    dataRow.getCell(0).setValue((Object)moduleItem.getModuleValue());
                    dataRow.getCell(1).setValue((Object)moduleItem.getCModuleValue());
                    dataRow.getCell(2).setValue((Object)new Integer(moduleItem.getOrder()));
                    dataRow.getCell(3).setValue((Object)moduleItem.getItemName());
                    dataRow.getCell(4).setValue((Object)moduleItem.getCodeTypeName());
                    dataRow.getCell(5).setValue((Object)moduleItem.getExecTypeName());
                    dataRow.getCell(6).setValue((Object)moduleItem.getCode());
                    dataRow.getCell(7).setValue((Object)moduleItem.getStatusName());
                    dataRow.getCell(8).setValue((Object)moduleItem.getItemId());
                    dataRow.setUserObject((Object)moduleItem);
                }
            }
            this.taskTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void disabled() {
        JZModuleItem moduleItem;
        IRow row;
        int i;
        KDTSelectBlock selectBlock = this.taskTable.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u914d\u7f6e\u9879!");
            return;
        }
        ArrayList<JZModuleItem> itemList = new ArrayList<JZModuleItem>();
        int num = selectBlock.getEndRow();
        for (i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
            row = this.taskTable.getRow(i);
            moduleItem = (JZModuleItem)row.getUserObject();
            if (moduleItem.getStatus() != 0) continue;
            itemList.add(moduleItem);
        }
        if (itemList.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u542f\u7528\u9879!");
            return;
        }
        try {
            JZServiceFactory.getJZService().disabledModuleItems(itemList, JZUtil.getConnection());
            num = selectBlock.getEndRow();
            for (i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = this.taskTable.getRow(i);
                moduleItem = (JZModuleItem)row.getUserObject();
                if (moduleItem.getStatus() != 0) continue;
                moduleItem.setStatus(1);
                row.getCell(7).setValue((Object)"\u7981\u7528");
            }
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u7981\u7528\u914d\u7f6e\u9879\u6210\u529f!");
            this.taskTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u7981\u7528\u5931\u8d25:" + ex.getMessage()));
        }
    }

    private void enAble() {
        JZModuleItem moduleItem;
        IRow row;
        int i;
        KDTSelectBlock selectBlock = this.taskTable.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u914d\u7f6e\u9879!");
            return;
        }
        ArrayList<JZModuleItem> itemList = new ArrayList<JZModuleItem>();
        int num = selectBlock.getEndRow();
        for (i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
            row = this.taskTable.getRow(i);
            moduleItem = (JZModuleItem)row.getUserObject();
            if (moduleItem.getStatus() != 1) continue;
            itemList.add(moduleItem);
        }
        if (itemList.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u7981\u7528\u9879!");
            return;
        }
        try {
            JZServiceFactory.getJZService().enAbledModuleItems(itemList, JZUtil.getConnection());
            num = selectBlock.getEndRow();
            for (i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = this.taskTable.getRow(i);
                moduleItem = (JZModuleItem)row.getUserObject();
                if (moduleItem.getStatus() != 1) continue;
                moduleItem.setStatus(0);
                row.getCell(7).setValue((Object)"\u542f\u7528");
            }
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u542f\u7528\u914d\u7f6e\u9879\u6210\u529f!");
            this.taskTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u542f\u7528\u5931\u8d25:" + ex.getMessage()));
        }
    }

    private void remove() {
        KDTSelectBlock selectBlock = this.taskTable.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u914d\u7f6e\u9879!");
            return;
        }
        ArrayList<JZModuleItem> itemList = new ArrayList<JZModuleItem>();
        int num = selectBlock.getEndRow();
        for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
            IRow row = this.taskTable.getRow(i);
            JZModuleItem moduleItem = (JZModuleItem)row.getUserObject();
            if (moduleItem.getStatus() != 1) continue;
            itemList.add(moduleItem);
        }
        if (itemList.size() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u542f\u7528\u9879\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u9009\u62e9\u7981\u7528\u9879!");
            return;
        }
        try {
            int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6240\u9009\u914d\u7f6e\u9879", (String)"\u786e\u8ba4\u63d0\u793a\u6846", (int)0, (int)3);
            if (result == 0) {
                JZServiceFactory.getJZService().removeModuleItems(itemList, JZUtil.getConnection());
                this.query();
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u5220\u9664\u914d\u7f6e\u9879\u6210\u529f!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u5220\u9664\u5931\u8d25:" + ex.getMessage()));
        }
    }

    private class ModuleItemChangedListener
    implements ItemListener {
        private ModuleItemChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JZModule jzModle = (JZModule)e.getItem();
            JZTaskQueryDialog.this.moduleComboBox.removeAllItems();
            JZTaskQueryDialog.this.moduleComboBox.addItems((Object[])jzModle.getChildModule());
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("\u9000\u51fa", JZTaskQueryDialog.this.exitIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog.this.dispose();
        }
    }

    private class DeleteTaskAction
    extends AbstractAction {
        public DeleteTaskAction() {
            super("\u5220\u9664", JZTaskQueryDialog.this.deleteIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog.this.remove();
        }
    }

    private class DisEnableTaskAction
    extends AbstractAction {
        public DisEnableTaskAction() {
            super("\u7981\u7528", JZTaskQueryDialog.this.disEnableIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog.this.disabled();
        }
    }

    private class EnableTaskAction
    extends AbstractAction {
        public EnableTaskAction() {
            super("\u542f\u7528", JZTaskQueryDialog.this.enableIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog.this.enAble();
        }
    }

    private class RegisterAction
    extends AbstractAction {
        public RegisterAction() {
            super("\u6ce8\u518c\u4ee3\u7801");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskRegisterDialog registerDlg = new JZTaskRegisterDialog(JZTaskQueryDialog.this);
            registerDlg.show();
        }
    }

    private class QueryTaskAction
    implements ActionListener {
        private QueryTaskAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog.this.query();
        }
    }

    private class ItemValue {
        private Object value;
        private String title;

        public ItemValue(Object value, String title) {
            this.value = value;
            this.title = title;
        }

        public int getIntValue() {
            return (Integer)this.value;
        }

        public String getStringValue() {
            return this.value.toString();
        }

        public String toString() {
            return this.title;
        }
    }
}

