/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.register;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.dbclean.IJZTask;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZModule;
import com.kingdee.eas.base.dbclean.JZModuleItem;
import com.kingdee.eas.base.dbclean.JZModuleStruct;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.JZTaskFactory;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.register.JZDefaultLogger;
import com.kingdee.eas.base.dbclean.client.register.JZExportSqlDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Date;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;

public class JZTaskRegisterDialog
extends KDDialog {
    private ImageIcon newIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_new.gif"));
    private ImageIcon saveIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_save.gif"));
    private ImageIcon checkIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/tbtn_check.gif"));
    private ImageIcon outPutIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/tbtn_inputoutput.gif"));
    private ImageIcon exitIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_close.gif"));
    private static final int NEW = 0;
    private static final int UPDATE = 1;
    private int type = -1;
    private int isKeyDo = -1;
    private KDToolBar toolBar = new KDToolBar();
    private AddTaskAction addTask = new AddTaskAction();
    private SaveTaskAction saveTask = new SaveTaskAction();
    private CheckTaskAction checkTask = new CheckTaskAction();
    private ExportTaskAction exportTask = new ExportTaskAction();
    private ExitTaskAction exitTask = new ExitTaskAction();
    private String itemId = null;
    private KDTextField nameField = new KDTextField(8);
    private KDComboBox fieldComboBox = new KDComboBox((Object[])JZModuleStruct.getRegisterModules());
    private KDComboBox moduleComboBox = new KDComboBox();
    private KDRadioButton sqlRadio = new KDRadioButton("sql", true);
    private KDRadioButton codeRadio = new KDRadioButton("code");
    private KDComboBox stepBox = new KDComboBox(new Object[]{"\u524d\u7f6e\u4efb\u52a1", "\u6267\u884c\u9879", "\u540e\u7f6e\u4efb\u52a1"});
    private KDTextArea codeText = new KDTextArea();
    private KDTextArea noteText = new KDTextArea();
    private KDTextField orderField = new KDTextField(2);

    public JZTaskRegisterDialog(KDDialog parent) {
        super((Dialog)parent, true);
        this.setSize(800, 500);
        this.setTitle("EAS\u5e10\u5957\u7ed3\u8f6c-\u6ce8\u518c\u7ed3\u8f6c\u4ee3\u7801");
        this.setLocationRelativeTo((Component)parent);
        this.initComponent();
        this.type = 0;
        this.isKeyDo = 0;
    }

    private void initComponent() {
        this.toolBar.add((Action)this.checkTask);
        this.toolBar.add((Action)this.exportTask);
        this.toolBar.add((Action)this.exitTask);
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(0));
        btnPanel.add((Component)new KDLabel("\u4efb\u52a1\u540d\u79f0\uff1a"));
        btnPanel.add((Component)this.nameField);
        btnPanel.add((Component)new KDLabel(" \u9886\u57df\uff1a"));
        this.fieldComboBox.setPreferredSize(new Dimension(90, 10));
        btnPanel.add((Component)this.fieldComboBox);
        this.fieldComboBox.addItemListener((ItemListener)new ModuleItemChangedListener());
        btnPanel.add((Component)new KDLabel(" \u6a21\u5757\uff1a"));
        this.moduleComboBox.setPreferredSize(new Dimension(90, 10));
        btnPanel.add((Component)this.moduleComboBox);
        btnPanel.add((Component)new KDLabel("\u6267\u884c\u65b9\u5f0f"));
        ButtonGroup codeGrp = new ButtonGroup();
        codeGrp.add((AbstractButton)this.sqlRadio);
        codeGrp.add((AbstractButton)this.codeRadio);
        btnPanel.add((Component)this.sqlRadio);
        btnPanel.add((Component)this.codeRadio);
        btnPanel.add((Component)new KDLabel(" \u6267\u884c\u9636\u6bb5"));
        this.stepBox.setPreferredSize(new Dimension(80, 10));
        this.stepBox.setSelectedIndex(1);
        btnPanel.add((Component)this.stepBox);
        btnPanel.add((Component)new KDLabel(" \u5e8f\u53f7"));
        btnPanel.add((Component)this.orderField);
        this.orderField.setText("0");
        KDScrollPane codeScroll = new KDScrollPane((Component)this.codeText);
        KDScrollPane noteScroll = new KDScrollPane((Component)this.noteText);
        KDTabbedPane tabPanel = new KDTabbedPane();
        tabPanel.addTab("\u6267\u884c\u4ee3\u7801", (Component)codeScroll);
        tabPanel.addTab("\u5907\u6ce8\u8bf4\u660e", (Component)noteScroll);
        KDPanel workPanel = new KDPanel((LayoutManager)new BorderLayout());
        workPanel.add((Component)btnPanel, (Object)"North");
        workPanel.add((Component)tabPanel, (Object)"Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)workPanel, "Center");
        this.fieldComboBox.setSelectedIndex(0);
        this.moduleComboBox.removeAllItems();
        this.moduleComboBox.addItems((Object[])((JZModule)this.fieldComboBox.getSelectedItem()).getChildModule());
        this.codeText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 121 && JZTaskRegisterDialog.this.isKeyDo == 0) {
                    JZTaskRegisterDialog.this.toolBar.add((Action)JZTaskRegisterDialog.this.saveTask, 1);
                    JZTaskRegisterDialog.this.toolBar.add((Action)JZTaskRegisterDialog.this.addTask, 1);
                    JZTaskRegisterDialog.this.isKeyDo = 1;
                }
                JZTaskRegisterDialog.this.toolBar.updateUI();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.nameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 121 && JZTaskRegisterDialog.this.isKeyDo == 0) {
                    JZTaskRegisterDialog.this.toolBar.add((Action)JZTaskRegisterDialog.this.saveTask, 1);
                    JZTaskRegisterDialog.this.toolBar.add((Action)JZTaskRegisterDialog.this.addTask, 1);
                    JZTaskRegisterDialog.this.isKeyDo = 1;
                }
                JZTaskRegisterDialog.this.toolBar.updateUI();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public JZModuleItem getModuleItem() throws Exception {
        String itemName = this.nameField.getText();
        String moduleId = ((JZModule)this.fieldComboBox.getSelectedItem()).getModuleId();
        String cModuleId = ((JZModule)this.moduleComboBox.getSelectedItem()).getModuleId();
        int codeType = 1;
        if (this.sqlRadio.isSelected()) {
            codeType = 1;
        } else if (this.codeRadio.isSelected()) {
            codeType = 2;
        }
        int execType = 2;
        if (this.stepBox.getSelectedItem().equals("\u524d\u7f6e\u4efb\u52a1")) {
            execType = 1;
        } else if (this.stepBox.getSelectedItem().equals("\u6267\u884c\u9879")) {
            execType = 2;
        } else if (this.stepBox.getSelectedItem().equals("\u540e\u7f6e\u4efb\u52a1")) {
            execType = 3;
        }
        if (itemName == null || itemName.trim().length() <= 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u586b\u5199\u4efb\u52a1\u540d\u79f0");
            return null;
        }
        String code = this.codeText.getText();
        String content = this.noteText.getText();
        int order = Integer.parseInt(this.orderField.getText());
        JZModuleItem moduleItem = new JZModuleItem();
        moduleItem.setItemId(this.itemId);
        moduleItem.setItemName(itemName);
        moduleItem.setModuleId(moduleId);
        moduleItem.setCModuleId(cModuleId);
        moduleItem.setCodeType(codeType);
        moduleItem.setExecType(execType);
        moduleItem.setCode(code);
        moduleItem.setContent(content);
        moduleItem.setOrder(order);
        if (this.type == 0 && (moduleItem.getItemId() == null || moduleItem.getItemId().length() <= 0)) {
            this.itemId = JZServiceFactory.getJZService().getMaxModuleItemId(moduleItem, JZUtil.getConnection());
            moduleItem.setItemId(this.itemId);
        }
        return moduleItem;
    }

    public void setModuleItem(JZModuleItem moduleItem) {
        JZModule jzModule;
        int i;
        this.itemId = moduleItem.getItemId();
        this.nameField.setText(moduleItem.getItemName());
        for (i = 0; i < this.fieldComboBox.getItemCount(); ++i) {
            jzModule = (JZModule)this.fieldComboBox.getItemAt(i);
            if (!jzModule.getModuleId().equals(moduleItem.getModuleId())) continue;
            this.fieldComboBox.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.moduleComboBox.getItemCount(); ++i) {
            jzModule = (JZModule)this.moduleComboBox.getItemAt(i);
            if (!jzModule.getModuleId().equals(moduleItem.getCModuleId())) continue;
            this.moduleComboBox.setSelectedIndex(i);
            break;
        }
        if (moduleItem.getCodeType() == 1) {
            this.sqlRadio.setSelected(true);
        } else {
            this.codeRadio.setSelected(true);
        }
        this.stepBox.setSelectedItem((Object)moduleItem.getExecTypeName());
        this.noteText.setText(moduleItem.getContent());
        this.codeText.setText(moduleItem.getCode());
        this.orderField.setText(String.valueOf(moduleItem.getOrder()));
        this.type = 1;
    }

    private void add() {
        this.type = 0;
        this.nameField.setText("");
        this.fieldComboBox.setSelectedIndex(0);
        this.sqlRadio.setSelected(true);
        this.codeRadio.setSelected(false);
        this.stepBox.setSelectedIndex(1);
        this.codeText.setText("");
        this.noteText.setText("");
    }

    private void save() {
        try {
            JZModuleItem moduleItem = this.getModuleItem();
            if (moduleItem == null) {
                return;
            }
            if (this.type == 0) {
                JZServiceFactory.getJZService().createModuleItem(moduleItem, JZUtil.getConnection());
                this.type = 1;
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u6ce8\u518c\u6210\u529f");
            } else if (this.type == 1) {
                JZServiceFactory.getJZService().updateModuleItem(moduleItem, JZUtil.getConnection());
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u4fee\u6539\u6210\u529f");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u6ce8\u518c\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    private void check() {
        block7: {
            try {
                JZModuleItem moduleItem = this.getModuleItem();
                if (moduleItem == null) {
                    return;
                }
                IJZTask jzTask = JZTaskFactory.getJZTask(moduleItem);
                JZContext jzContext = new JZContext();
                jzContext.setLogger(new JZDefaultLogger());
                jzContext.setDbConn(JZUtil.getConnection());
                jzContext.setPeriodFId("test_procid");
                jzContext.setPeriodNumber(190010);
                jzContext.setEndDt(new Date(System.currentTimeMillis()));
                jzContext.setTaskConfig(moduleItem);
                JZUtil.getConnection().setAutoCommit(false);
                boolean result = false;
                String resultError = "";
                if (jzTask.doTask(jzContext)) {
                    result = true;
                    resultError = "";
                }
                if (result) {
                    JZUtil.getConnection().commit();
                    JZUtil.getConnection().setAutoCommit(true);
                    KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u6821\u9a8c\u6210\u529f");
                    break block7;
                }
                try {
                    JZUtil.getConnection().rollback();
                    JZUtil.getConnection().setAutoCommit(true);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u6821\u9a8c\u5931\u8d25:" + resultError));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u6821\u9a8c\u5931\u8d25\uff1a" + ex.getMessage()));
            }
        }
    }

    private class ModuleItemChangedListener
    implements ItemListener {
        private ModuleItemChangedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JZModule jzModle = (JZModule)e.getItem();
            JZTaskRegisterDialog.this.moduleComboBox.removeAllItems();
            JZTaskRegisterDialog.this.moduleComboBox.addItems((Object[])jzModle.getChildModule());
        }
    }

    private class ExitTaskAction
    extends AbstractAction {
        public ExitTaskAction() {
            super("\u9000\u51fa", JZTaskRegisterDialog.this.exitIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskRegisterDialog.this.dispose();
        }
    }

    private class ExportTaskAction
    extends AbstractAction {
        public ExportTaskAction() {
            super("\u5bfc\u51fa", JZTaskRegisterDialog.this.outPutIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JZModuleItem moduleItem = JZTaskRegisterDialog.this.getModuleItem();
                if (moduleItem == null) {
                    return;
                }
                JZExportSqlDialog exportDlg = new JZExportSqlDialog(JZTaskRegisterDialog.this);
                exportDlg.setModuleItem(moduleItem);
                exportDlg.show();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                KDOptionPane.showMessageDialog((Component)((Object)JZTaskRegisterDialog.this), (Object)"\u5bfc\u51fa\u5931\u8d25!");
            }
        }
    }

    private class CheckTaskAction
    extends AbstractAction {
        public CheckTaskAction() {
            super("\u6821\u9a8c", JZTaskRegisterDialog.this.checkIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskRegisterDialog.this.check();
        }
    }

    private class SaveTaskAction
    extends AbstractAction {
        public SaveTaskAction() {
            super("\u4fdd\u5b58", JZTaskRegisterDialog.this.saveIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JZTaskRegisterDialog.this.save();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                KDOptionPane.showMessageDialog((Component)((Object)JZTaskRegisterDialog.this), (Object)"\u4fdd\u5b58\u5931\u8d25!");
            }
        }
    }

    private class AddTaskAction
    extends AbstractAction {
        public AddTaskAction() {
            super("\u65b0\u589e", JZTaskRegisterDialog.this.newIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskRegisterDialog.this.add();
        }
    }
}

