/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.wizard;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.dbclean.JZProcessOrg;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardOrgPanel;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardPeriodPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class JZOrgDialog
extends KDDialog {
    private ImageIcon refreshIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_refresh.gif"));
    private ImageIcon exitIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_close.gif"));
    private FreshAction freshAction = new FreshAction();
    private ExitAction exitAction = new ExitAction();
    private KDButton okBtn = new KDButton("\u786e\u5b9a");
    private KDButton cancelBtn = new KDButton("\u53d6\u6d88");
    private KDToolBar toolBar = new KDToolBar();
    private KDComboBox queryComboBox = new KDComboBox();
    private KDTextField queryTextField = new KDTextField(15);
    private KDButton queryBtn = new KDButton("\u67e5\u8be2");
    private KDCheckBox checkBox = new KDCheckBox("\u6a21\u7cca\u67e5\u8be2");
    private KDTable orgTable;
    private String periodNumber;
    private KDCheckBox selectAllcheckBox;
    private JZWizardOrgPanel jzWizardOrgPanel;

    public JZOrgDialog(JZWizardPeriodPanel periodPanel, JZWizardOrgPanel parent) {
        super((Dialog)((Object)periodPanel.parent), true);
        this.periodNumber = periodPanel.getPeriodNumber();
        this.jzWizardOrgPanel = parent;
        this.setSize(450, 400);
        this.setTitle("\u589e\u52a0\u7ec4\u7ec7");
        this.setResizable(false);
        this.setLocationRelativeTo((Component)((Object)periodPanel.parent));
        this.initComponent();
        this.query();
    }

    private void initComponent() {
        this.toolBar.add((Action)this.freshAction);
        this.toolBar.add((Action)this.exitAction);
        KDPanel orgQueryPanel = new KDPanel((LayoutManager)new FlowLayout(0));
        this.queryComboBox.setPreferredSize(new Dimension(100, 10));
        orgQueryPanel.add((Component)this.queryComboBox);
        this.queryComboBox.addItems(new Object[]{"\u7f16\u7801+\u540d\u79f0", "\u7ec4\u7ec7\u7f16\u7801", "\u7ec4\u7ec7\u540d\u79f0", "\u52a9\u8bb0\u7801"});
        orgQueryPanel.add((Component)this.queryTextField);
        orgQueryPanel.add((Component)this.queryBtn);
        orgQueryPanel.add((Component)this.checkBox);
        this.checkBox.setSelected(true);
        this.queryBtn.addActionListener((ActionListener)new QueryAction());
        KDPanel cancelPanel = new KDPanel((LayoutManager)new FlowLayout(2));
        cancelPanel.add((Component)this.okBtn);
        cancelPanel.add((Component)this.cancelBtn);
        this.cancelBtn.addActionListener((ActionListener)new CancelAction());
        this.okBtn.addActionListener((ActionListener)new OKAction());
        this.orgTable = new KDTable(6, 1, 0);
        this.orgTable.setCursor(this.getCursor());
        this.orgTable.getColumn(0).setWidth(60);
        this.orgTable.getColumn(1).setWidth(100);
        this.orgTable.getColumn(2).setWidth(210);
        this.orgTable.getColumn(3).setWidth(105);
        this.orgTable.getColumn(4).setWidth(0);
        this.orgTable.getColumn(5).setWidth(0);
        IRow headRow = this.orgTable.getHeadRow(0);
        this.selectAllcheckBox = new KDCheckBox("\u5168\u9009");
        KDTDefaultCellEditor ckCellEditor = new KDTDefaultCellEditor((JCheckBox)this.selectAllcheckBox);
        headRow.getCell(0).getStyleAttributes().setLocked(false);
        headRow.getCell(0).setEditor((ICellEditor)ckCellEditor);
        headRow.getCell(0).setValue((Object)new Boolean(false));
        this.selectAllcheckBox.addActionListener((ActionListener)new SelectAllAction());
        headRow.getCell(1).setValue((Object)"\u7ec4\u7ec7\u7f16\u7801");
        headRow.getCell(2).setValue((Object)"\u7ec4\u7ec7\u540d\u79f0");
        headRow.getCell(3).setValue((Object)"\u52a9\u8bb0\u7801");
        headRow.getCell(4).setValue((Object)"ID");
        KDPanel workPanel = new KDPanel((LayoutManager)new BorderLayout());
        workPanel.add((Component)orgQueryPanel, (Object)"North");
        workPanel.add((Component)this.orgTable, (Object)"Center");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)workPanel, "Center");
        this.getContentPane().add((Component)cancelPanel, "South");
    }

    private void query() {
        try {
            String[] orgNumbers;
            this.orgTable.refresh();
            String queryType = this.queryComboBox.getSelectedItem().toString();
            String queryText = this.queryTextField.getText();
            int isCheckBox = this.checkBox.getSelected();
            List dataList = JZServiceFactory.getJZService().queryOrg(queryType, queryText, isCheckBox, this.periodNumber, JZUtil.getConnection());
            if (dataList != null && dataList.size() > 0) {
                for (JZProcessOrg org : dataList) {
                    IRow dataRow = this.orgTable.addRow();
                    dataRow.getCell(0).setValue((Object)Boolean.FALSE);
                    dataRow.getCell(1).setValue((Object)org.getOrgNumber());
                    dataRow.getCell(2).setValue((Object)org.getOrgName());
                    dataRow.getCell(3).setValue((Object)org.getOrgCode());
                    dataRow.getCell(4).setValue((Object)org.getOrgFId());
                    dataRow.getCell(5).setValue((Object)new Integer(org.getPeriodNumber()));
                    dataRow.setUserObject((Object)org);
                }
            }
            if ((orgNumbers = this.jzWizardOrgPanel.getOrgNumbers()).length > 0) {
                for (int i = this.orgTable.getRowCount() - 1; i >= 0; --i) {
                    IRow row = this.orgTable.getRow(i);
                    String orgNumber = row.getCell(1).getValue().toString();
                    for (int j = 0; j < orgNumbers.length; ++j) {
                        if (!orgNumber.equalsIgnoreCase(orgNumbers[j])) continue;
                        this.orgTable.removeRow(i);
                    }
                }
            }
            this.orgTable.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List getOrgItem() {
        ArrayList<JZProcessOrg> orgList = new ArrayList<JZProcessOrg>();
        for (int i = 0; i < this.orgTable.getRowCount(); ++i) {
            IRow row = this.orgTable.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(0).getValue())) continue;
            JZProcessOrg orgItem = new JZProcessOrg();
            orgItem.setOrgNumber(row.getCell(1).getValue().toString());
            orgItem.setOrgName(row.getCell(2).getValue().toString());
            orgItem.setOrgFId(row.getCell(4).getValue().toString());
            orgItem.setPeriodNumber((Integer)row.getCell(5).getValue());
            orgList.add(orgItem);
        }
        return orgList;
    }

    private class SelectAllAction
    extends AbstractAction {
        private boolean selectAllBoolean;

        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selectAllBoolean = (Boolean)JZOrgDialog.this.orgTable.getHeadRow(0).getCell(0).getValue();
            if (!this.selectAllBoolean) {
                JZOrgDialog.this.orgTable.getHeadRow(0).getCell(0).setValue((Object)Boolean.TRUE);
                for (int i = 0; i < JZOrgDialog.this.orgTable.getRowCount(); ++i) {
                    IRow row = JZOrgDialog.this.orgTable.getRow(i);
                    row.getCell(0).setValue((Object)Boolean.TRUE);
                }
                this.selectAllBoolean = true;
                JZOrgDialog.this.orgTable.updateUI();
            } else {
                JZOrgDialog.this.orgTable.getHeadRow(0).getCell(0).setValue((Object)Boolean.FALSE);
                for (int i = 0; i < JZOrgDialog.this.orgTable.getRowCount(); ++i) {
                    IRow row = JZOrgDialog.this.orgTable.getRow(i);
                    row.getCell(0).setValue((Object)Boolean.FALSE);
                }
                this.selectAllBoolean = false;
                JZOrgDialog.this.orgTable.updateUI();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZOrgDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List dataList = JZOrgDialog.this.getOrgItem();
            if (dataList != null && dataList.size() > 0) {
                for (JZProcessOrg org : dataList) {
                    IRow dataRow = ((JZOrgDialog)JZOrgDialog.this).jzWizardOrgPanel.orgTable.addRow();
                    dataRow.getCell(0).setValue((Object)org.getOrgNumber());
                    dataRow.getCell(1).setValue((Object)org.getOrgName());
                    dataRow.getCell(2).setValue((Object)new Integer(org.getPeriodNumber()));
                    dataRow.getCell(3).setValue((Object)org.getOrgFId());
                    dataRow.setUserObject((Object)org);
                }
            }
            ((JZOrgDialog)JZOrgDialog.this).jzWizardOrgPanel.orgTable.updateUI();
            JZOrgDialog.this.dispose();
        }
    }

    private class QueryAction
    implements ActionListener {
        private QueryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZOrgDialog.this.query();
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("\u9000\u51fa", JZOrgDialog.this.exitIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZOrgDialog.this.dispose();
        }
    }

    private class FreshAction
    extends AbstractAction {
        public FreshAction() {
            super("\u5237\u65b0", JZOrgDialog.this.refreshIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

