/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client.wizard;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.client.JZFrame;
import com.kingdee.eas.base.dbclean.client.excute.JZExcuteTaskDialog;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardInfoPanel;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardOrgPanel;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardPanel;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardPeriodPanel;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardSummaryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JZWizardDialog
extends KDDialog {
    private ImageIcon image = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/guide_pic338.png"));
    private JZFrame parent;
    private KDButton cancelBtn = new KDButton("\u53d6\u6d88");
    private KDButton nextBtn = new KDButton("\u4e0b\u4e00\u6b65");
    private KDButton preBtn = new KDButton("\u4e0a\u4e00\u6b65");
    private KDButton finishBtn = new KDButton("\u5b8c\u6210");
    private KDPanel wizardContainer = new KDPanel((LayoutManager)new BorderLayout());
    private static final int WIZARD_INFO = 1;
    private static final int WIZARD_PERIOD = 2;
    private static final int WIZARD_ORG = 3;
    private static final int WIZARD_SUMMARY = 4;
    private int curWizard = -1;
    private String oldPeriodNumber = null;
    private String newPeriodNumber = null;
    private JZWizardPanel infoPanel = null;
    private JZWizardPeriodPanel periodPanel = null;
    private JZWizardOrgPanel orgPanel = null;
    private JZWizardPanel summaryPanel = null;

    public JZWizardDialog(JZFrame parent) {
        super((Frame)((Object)parent), true);
        this.parent = parent;
        this.setSize(600, 400);
        this.setTitle("\u65b0\u5efa\u7ed3\u8f6c_\u7b2c1\u6b65\uff0c\u51714\u6b65");
        this.setResizable(false);
        this.setLocationRelativeTo((Component)((Object)parent));
        this.initComponent();
        this.setCurWizard(1);
    }

    private void initComponent() {
        KDPanel workPanl = new KDPanel((LayoutManager)new BorderLayout());
        KDLabel picPanel = new KDLabel((Icon)this.image);
        picPanel.setPreferredSize(new Dimension(150, 200));
        picPanel.setBackground(Color.DARK_GRAY);
        workPanl.add((Component)picPanel, (Object)"West");
        workPanl.add((Component)this.wizardContainer, (Object)"Center");
        workPanl.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(2));
        btnPanel.add((Component)this.cancelBtn);
        btnPanel.add((Component)this.preBtn);
        btnPanel.add((Component)this.nextBtn);
        btnPanel.add((Component)this.finishBtn);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)workPanl, "Center");
        this.getContentPane().add((Component)btnPanel, "South");
        this.cancelBtn.addActionListener((ActionListener)new CancelWizardAction());
        this.nextBtn.addActionListener((ActionListener)new NextWizardAction());
        this.preBtn.addActionListener((ActionListener)new PreWizardAction());
        this.finishBtn.addActionListener((ActionListener)new FinishWizardAction());
    }

    private void setCurWizard(int wizard) {
        JZWizardPanel oldWizardPanel = this.getWizardPanel(this.curWizard);
        if (oldWizardPanel != null && wizard > this.curWizard && !oldWizardPanel.isCanNext()) {
            return;
        }
        if (oldWizardPanel != null && wizard < this.curWizard && !oldWizardPanel.isCanPre()) {
            return;
        }
        JZWizardPanel newWizardPanel = this.getWizardPanel(wizard);
        if (oldWizardPanel != null) {
            this.wizardContainer.remove((Component)((Object)oldWizardPanel));
        }
        this.wizardContainer.updateUI();
        if (newWizardPanel != null) {
            this.wizardContainer.add((Component)((Object)newWizardPanel), (Object)"Center");
        }
        this.wizardContainer.updateUI();
        this.curWizard = wizard;
        if (this.curWizard == 1) {
            this.setTitle("\u65b0\u5efa\u7ed3\u8f6c_\u7b2c1\u6b65\uff0c\u51714\u6b65");
            this.preBtn.setEnabled(false);
        } else {
            this.preBtn.setEnabled(true);
        }
        if (this.curWizard == 2) {
            this.setTitle("\u65b0\u5efa\u7ed3\u8f6c_\u7b2c2\u6b65\uff0c\u51714\u6b65");
        }
        if (this.curWizard == 3) {
            this.setTitle("\u65b0\u5efa\u7ed3\u8f6c_\u7b2c3\u6b65\uff0c\u51714\u6b65");
        }
        if (this.curWizard == 4) {
            this.setTitle("\u65b0\u5efa\u7ed3\u8f6c_\u7b2c4\u6b65\uff0c\u51714\u6b65");
            this.nextBtn.setEnabled(false);
            this.finishBtn.setEnabled(true);
        } else {
            this.nextBtn.setEnabled(true);
            this.finishBtn.setEnabled(false);
        }
    }

    public JZWizardPanel getWizardPanel(int wizard) {
        JZWizardPanel retPanel = null;
        if (wizard == 1) {
            if (this.infoPanel == null) {
                this.infoPanel = new JZWizardInfoPanel();
            }
            retPanel = this.infoPanel;
        } else if (wizard == 2) {
            if (this.periodPanel == null) {
                this.periodPanel = new JZWizardPeriodPanel(this);
            }
            retPanel = this.periodPanel;
        } else if (wizard == 3) {
            if (this.orgPanel == null) {
                this.orgPanel = new JZWizardOrgPanel(this.periodPanel);
            }
            retPanel = this.orgPanel;
        } else if (wizard == 4) {
            if (this.summaryPanel == null) {
                this.summaryPanel = new JZWizardSummaryPanel(this.periodPanel, this.orgPanel);
            }
            retPanel = this.summaryPanel;
        }
        if (retPanel != null) {
            retPanel.loadData();
        }
        return retPanel;
    }

    private class FinishWizardAction
    extends AbstractAction {
        private FinishWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int result;
                JZExcuteTaskDialog execDlg = new JZExcuteTaskDialog(JZWizardDialog.this.parent);
                JZWizardDialog.this.setVisible(false);
                JZWizardDialog.this.dispose();
                int periodNumber = Integer.parseInt(JZWizardDialog.this.periodPanel.getPeriodNumber());
                String[] orgIds = JZWizardDialog.this.orgPanel.getOrgIds();
                JZProcessTask procTask = execDlg.createProccessor(periodNumber, orgIds);
                if (procTask != null) {
                    JZWizardDialog.this.parent.addProcessTask(procTask);
                }
                if ((result = KDOptionPane.showConfirmDialog((Component)((Object)JZWizardDialog.this), (Object)"\u60a8\u662f\u5426\u73b0\u5728\u6267\u884c\u7ed3\u8f6c\u4efb\u52a1", (String)"\u786e\u8ba4", (int)0, (int)3)) == 0) {
                    execDlg.startProccessor(procTask);
                    execDlg.show();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                KDOptionPane.showMessageDialog((Component)((Object)JZWizardDialog.this), (Object)("\u521b\u5efa\u4efb\u52a1\u5931\u8d25: " + ex.getMessage()));
            }
        }
    }

    private class CancelWizardAction
    extends AbstractAction {
        private CancelWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZWizardDialog.this.dispose();
        }
    }

    private class PreWizardAction
    extends AbstractAction {
        private PreWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JZWizardDialog.this.curWizard == 3) {
                JZWizardDialog.this.oldPeriodNumber = JZWizardDialog.this.periodPanel.getPeriodNumber();
            }
            JZWizardDialog.this.setCurWizard(JZWizardDialog.this.curWizard - 1);
        }
    }

    private class NextWizardAction
    extends AbstractAction {
        private NextWizardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JZWizardDialog.this.curWizard == 2 && (JZWizardDialog.this.periodPanel.getQiNumber().equalsIgnoreCase("") || JZWizardDialog.this.periodPanel.getYearNumner().equalsIgnoreCase(""))) {
                KDOptionPane.showMessageDialog(null, (Object)"\u8bf7\u9009\u62e9\u8981\u7ed3\u8f6c\u7684\u4f1a\u8ba1\u5e74\u5ea6\u548c\u671f\u95f4\uff01", (String)"\u4fe1\u606f\u63d0\u793a", (int)0);
                return;
            }
            if (JZWizardDialog.this.curWizard == 3 && JZWizardDialog.this.orgPanel.getOrgCount() <= 0) {
                KDOptionPane.showMessageDialog(null, (Object)"\u8bf7\u9009\u62e9\u8981\u7ed3\u8f6c\u7684\u7ec4\u7ec7\uff01", (String)"\u4fe1\u606f\u63d0\u793a", (int)0);
                return;
            }
            if (JZWizardDialog.this.curWizard == 2) {
                JZWizardDialog.this.newPeriodNumber = JZWizardDialog.this.periodPanel.getPeriodNumber();
                if (!JZWizardDialog.this.newPeriodNumber.equalsIgnoreCase(JZWizardDialog.this.oldPeriodNumber)) {
                    JZWizardDialog.this.orgPanel = null;
                }
                JZWizardDialog.this.setCurWizard(JZWizardDialog.this.curWizard + 1);
            } else {
                JZWizardDialog.this.summaryPanel = null;
                JZWizardDialog.this.setCurWizard(JZWizardDialog.this.curWizard + 1);
            }
        }
    }
}

