/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.BankVCResultFilterParam;
import com.kingdee.eas.base.vc.BankVcProcessFacadeFactory;
import com.kingdee.eas.base.vc.IBankVcProcessFacade;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultFactory;
import com.kingdee.eas.base.vc.VcResultInfo;
import com.kingdee.eas.base.vc.client.AbstractBankVcResultUI;
import com.kingdee.eas.base.vc.client.BankVCResultFilterUI;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BankVCFilterParam;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankVcResultUI
extends AbstractBankVcResultUI {
    private static final long serialVersionUID = -5280688658242153898L;
    private static final Logger logger = CoreUIObject.getLogger(BankVcResultUI.class);
    private static final String BankState = "com.kingdee.eas.fi.cas.app.BankStatement";
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CheckoutResource";
    private BankVCResultFilterUI filter = null;
    private CurrencyInfo currency = this.currentCompanyCommon.getBaseCurrency();
    boolean isDirectShow = false;
    public static String PARAM_VC_FILTER_PARAM = "";
    FillListener fillListener = new FillListener();
    Set<String> idSet = new HashSet<String>();

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getDataRequestManager().setPageRowCount(100);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isDirectShow() {
        if (!EmptyUtil.isEmpty(this.getUIContext().get("isDirectShow"))) {
            this.isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
        }
        return this.isDirectShow;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.actionAntiBook.setEnabled(true);
        this.btnLocate.setVisible(true);
        this.actionSelectAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionClearAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionAntiBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
    }

    protected void execQuery() {
        if (this.isDirectShow) {
            BankVCFilterParam params = (BankVCFilterParam)this.getUIContext().get("PARAM_VC_FILTER_PARAM");
            AccountBankInfo bankAcct = params.getAccountBank();
            this.currency = params.getCurrency();
            Date beginDate = params.getBeginDate();
            Date endDate = params.getEndDate();
            this.txtBankAccount.setText(bankAcct.getName() + " " + bankAcct.getBankAccountNumber());
            this.txtAccountView.setText(bankAcct.getAccount().getNumber() + " - " + bankAcct.getAccount().getName());
            this.txtCurrency.setText(this.currency.getName());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            if (params.getType() == 4) {
                this.txtPeriod.setText(params.getPeriodYear() + EASResource.getString((String)resourcePath, (String)"CHECHOUT_year") + params.getPeriodNum() + EASResource.getString((String)resourcePath, (String)"CHECKOUT_period") + " - " + params.getPeriodYear() + EASResource.getString((String)resourcePath, (String)"CHECHOUT_year") + params.getPeriodNum() + EASResource.getString((String)resourcePath, (String)"CHECKOUT_period"));
            } else {
                this.txtPeriod.setText(df.format(beginDate) + " - " + df.format(endDate));
            }
            FilterInfo filter = new FilterInfo();
            if (!EmptyUtil.isEmpty(this.getUIContext().get("vcResult"))) {
                VcResultCollection vcResult = (VcResultCollection)((Object)this.getUIContext().get("vcResult"));
                HashSet<String> keySet = new HashSet<String>();
                for (int index = 0; index < vcResult.size(); ++index) {
                    keySet.add(vcResult.get(index).getKey());
                }
                filter.getFilterItems().add(new FilterItemInfo("key", keySet, CompareType.INCLUDE));
            }
            try {
                if (this.mainQuery.getFilter() == null) {
                    this.mainQuery.setFilter(filter);
                } else {
                    this.mainQuery.getFilter().mergeFilter(filter, "AND");
                }
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("key"));
                SorterItemInfo sorter = new SorterItemInfo("createDate");
                sorter.setSortType(SortType.DESCEND);
                sort.add(sorter);
                this.mainQuery.setSorter(sort);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            this.actionQuery.setVisible(false);
        }
        super.execQuery();
        this.idSet.clear();
    }

    public void refresh(ActionEvent e) throws Exception {
        try {
            this.getNewResult();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        super.refresh(e);
    }

    private void getNewResult() throws BOSException {
        if (!EmptyUtil.isEmpty((Object)this.filter.getParam())) {
            BankVCResultFilterParam param = (BankVCResultFilterParam)this.filter.getParam();
            this.executeQuery(param);
        }
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterInfo defaultFilterForQuery;
        BankVCResultFilterParam params = (BankVCResultFilterParam)param;
        if (super.getDialog().getEntityViewInfoResult() != null) {
            this.mainQuery = (EntityViewInfo)super.getDialog().getEntityViewInfoResult().clone();
        }
        if (this.mainQuery.getFilter() == null || this.mainQuery.getFilter().getFilterItems().size() == 0) {
            this.mainQuery.setFilter(params.getFilter());
        } else {
            this.mainQuery.getFilter().mergeFilter(params.getFilter(), "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterItemCollection filterItems = this.mainQuery.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItems.get(i);
            if (!filterItemInfo.getCompareValue().toString().equalsIgnoreCase("empty")) continue;
            filterItemInfo.setCompareValue(null);
        }
        view.setFilter(this.mainQuery.getFilter());
        HashSet<String> keySet = new HashSet<String>();
        VcResultCollection vcResultCollection = VcResultFactory.getRemoteInstance().getVcResultCollection("where " + view.getFilter().toSql());
        for (int i = 0; i < vcResultCollection.size(); ++i) {
            keySet.add(vcResultCollection.get(i).getKey());
        }
        if (keySet.size() > 0) {
            FilterInfo filterInfo2 = new FilterInfo();
            filterInfo2.getFilterItems().add(new FilterItemInfo("key", keySet, CompareType.INCLUDE));
            this.mainQuery.setFilter(filterInfo2);
        }
        if ((defaultFilterForQuery = this.getDefaultFilterForQuery()) != null && defaultFilterForQuery.getFilterItems().size() > 0) {
            if (this.mainQuery.getFilter().getFilterItems().size() == 0) {
                this.mainQuery.setFilter(defaultFilterForQuery);
            } else {
                this.mainQuery.getFilter().mergeFilter(defaultFilterForQuery, "AND");
            }
        }
        if (param != null) {
            this.mainQuery.getSorter().addObjectCollection((IObjectCollection)param.getSorterItems());
        }
        if (this.isSupportDynQuery()) {
            try {
                this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        super.execQuery();
        AccountBankInfo bankAcct = params.getAccountBank();
        this.currency = params.getCurrency();
        Date beginDate = params.getBeginDate();
        Date endDate = params.getEndDate();
        this.txtBankAccount.setText(bankAcct.getName() + " " + bankAcct.getBankAccountNumber());
        this.txtAccountView.setText(bankAcct.getAccount().getNumber() + " - " + bankAcct.getAccount().getName());
        this.txtCurrency.setText(this.currency.getName());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (params.isPeriodQuery()) {
            this.txtPeriod.setText(params.getBeginPeriod().getPeriodYear() + EASResource.getString((String)resourcePath, (String)"CHECHOUT_year") + params.getBeginPeriod().getPeriodNumber() + EASResource.getString((String)resourcePath, (String)"CHECKOUT_period") + " - " + params.getEndPeriod().getPeriodYear() + EASResource.getString((String)resourcePath, (String)"CHECHOUT_year") + params.getEndPeriod().getPeriodNumber() + EASResource.getString((String)resourcePath, (String)"CHECKOUT_period"));
        } else {
            this.txtPeriod.setText(df.format(beginDate) + " - " + df.format(endDate));
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            BankVCFilterParam param = (BankVCFilterParam)this.getUIContext().get("PARAM_VC_FILTER_PARAM");
            this.filter = new BankVCResultFilterUI(param);
        }
        return this.filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VcResultFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        VcResultInfo objectValue = new VcResultInfo();
        return objectValue;
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecordNullMsg"));
            return;
        }
        this.idSet.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)Boolean.TRUE);
            String key = (String)this.tblMain.getRow(i).getCell("key").getValue();
            this.idSet.add(key);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    @Override
    public void actionAntiBook_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId().toString()), "cas_bankVcCheck_03cancelContrast");
        Set<String> idSet = this.getResultSetSelected();
        if (idSet.size() > 0) {
            IBankVcProcessFacade iBankVcProcess = BankVcProcessFacadeFactory.getRemoteInstance();
            iBankVcProcess.undoProcess(idSet);
            this.refresh(e);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected Set<String> getResultSetSelected() throws Exception {
        return this.idSet;
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        Object value;
        int index = e.getRowIndex();
        if (e.getColIndex() == this.tblMain.getColumn("selected").getColumnIndex() && (value = e.getValue()) != null) {
            String key = (String)this.tblMain.getRow(index).getCell("key").getValue();
            if (((Boolean)value).booleanValue()) {
                this.idSet.add(key);
            } else {
                this.idSet.remove(key);
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"company.name", "createDate", "bizDate", "VoucherType.name", "VoucherNumber", "settleType.name", "settleNumber", "billType", "billNumber", "description", "debitAmount", "creditAmount"};
        return locateNames;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                IRow row = BankVcResultUI.this.tblMain.getRow(i);
                row.getCell("selected").setValue((Object)false);
                row.getCell("selected").getStyleAttributes().setLocked(false);
                if (row.getCell("bizObjectFullName").getValue().equals(BankVcResultUI.BankState)) {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)BankVcResultUI.resourcePath, (String)"78_FinalCheckOutUI"));
                } else {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)BankVcResultUI.resourcePath, (String)"79_FinalCheckOutUI"));
                }
                String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)BankVcResultUI.this.currency.getId());
                BankVcResultUI.this.tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(numberFmt);
                BankVcResultUI.this.tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(numberFmt);
                BankVcResultUI.this.tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                BankVcResultUI.this.tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

