/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.vc.client.AbstractBizObjPropSelectF7;
import com.kingdee.eas.base.vc.client.BizPropSelectObject;
import com.kingdee.eas.base.vc.util.VcUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class BizObjPropSelectF7
extends AbstractBizObjPropSelectF7
implements KDPromptSelector {
    protected IUIWindow currDialog = null;
    private ArrayList entityObjList = null;
    private boolean canceled = false;
    private IMetaDataLoader metaLoader;
    private Logger logger = Logger.getLogger(BizObjPropSelectF7.class);
    private boolean isBindingProperty = false;
    private Object parentWindow = null;
    private DefaultKingdeeTreeNode treeRootNode = new DefaultKingdeeTreeNode();
    private boolean isVAProp = false;
    private boolean isWriteBackProp = false;
    private String title = "";

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void setEntityObjectList(ArrayList entityObjList) {
        this.entityObjList = entityObjList;
    }

    public ArrayList getEntityObjectInfoList() {
        return this.entityObjList;
    }

    public void setMetaLoader(IMetaDataLoader metaLoader) {
        this.metaLoader = metaLoader;
    }

    public IMetaDataLoader getMetaLoader() {
        return this.metaLoader;
    }

    public void setIsVAProp(boolean isVAProp) {
        this.isVAProp = isVAProp;
    }

    public boolean getIsVAProp() {
        return this.isVAProp;
    }

    public void setIsWriteBackProp(boolean isWriteBackProp) {
        this.isWriteBackProp = isWriteBackProp;
    }

    public boolean getIsWriteBackProp() {
        return this.isWriteBackProp;
    }

    public void setIsBindingProperty(boolean isBindingProperty) {
        this.isBindingProperty = isBindingProperty;
    }

    public boolean isIsBindingProperty() {
        return this.isBindingProperty;
    }

    public void setParentWindow(Object parentWindow) {
        this.parentWindow = parentWindow;
    }

    public Object getParentWindow() {
        return this.parentWindow;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.logger.debug((Object)"bt_OK_mouseClicked Event!");
        KDTree tree = this.treeProp;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            Object uo = selectedNode.getUserObject();
            if (uo != null && uo.getClass().getName().equals("java.lang.String")) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"no_billprop_selected"));
                return;
            }
        } else {
            this.logger.debug((Object)"tree event:No select Node!");
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"no_billprop_selected"));
            return;
        }
        this.canceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    public void onLoad() {
        if (this.getUIContext().get("entityObjInfoList") != null) {
            this.entityObjList = (ArrayList)this.getUIContext().get("entityObjInfoList");
        }
        this.metaLoader = this.getUIContext().get("metaLoader") != null ? (IMetaDataLoader)this.getUIContext().get("metaLoader") : this.createIMetaDataLoader();
        this.isVAProp = this.getUIContext().get("isvaprop") != null ? (Boolean)this.getUIContext().get("isvaprop") : false;
        this.isWriteBackProp = this.getUIContext().get("iswritebackprop") != null ? (Boolean)this.getUIContext().get("iswritebackprop") : false;
        this.title = this.getUIContext().get("title") != null ? (String)this.getUIContext().get("title") : VcUtil.getString("Prop_Setting");
        this.butSelect.setEnabled(true);
        this.butCancel.setEnabled(true);
        this.setUITitle(this.title);
        this.initTree();
    }

    public void show() {
        this.logger.debug((Object)"show Event!");
        IUIFactory uiFactory = null;
        try {
            UIContext hm = new UIContext(this.getParentWindow());
            hm.put("entityObjInfoList", this.getEntityObjectInfoList());
            hm.put("metaLoader", this.getMetaLoader());
            hm.put("isvaprop", this.getIsVAProp());
            hm.put("iswritebackprop", this.getIsWriteBackProp());
            hm.put("title", this.getTitle());
            hm.put("isBindingProperty", this.isBindingProperty);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.currDialog = uiFactory.create(((Object)((Object)this)).getClass().getName(), (Map)hm);
            this.currDialog.show();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
    }

    public IMetaDataLoader createIMetaDataLoader() {
        this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return this.metaLoader;
    }

    private void initTree() {
        DefaultKingdeeTreeNode entityRoot = null;
        EntityObjectInfo entityObjInfo = null;
        this.treeProp.setRootVisible(false);
        for (int i = 0; i < this.entityObjList.size(); ++i) {
            entityObjInfo = (EntityObjectInfo)this.entityObjList.get(i);
            entityRoot = this.createNode(entityObjInfo);
            this.treeRootNode.add((MutableTreeNode)entityRoot);
        }
        this.treeProp.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRootNode));
        this.treeProp.repaint();
        TreeSelectionModel treeSelectionModel = this.treeProp.getSelectionModel();
        this.treeProp.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.treeProp.expandAllNodes(true, (TreeNode)this.treeRootNode);
    }

    private DefaultKingdeeTreeNode createNode(EntityObjectInfo entityObjInfo) {
        DefaultKingdeeTreeNode entityRootNode = null;
        DefaultKingdeeTreeNode childNode = null;
        DefaultKingdeeTreeNode grandchildNode = null;
        VcUtil vcUtil = new VcUtil();
        IBotpMetaData propMeta = null;
        String strPack = "";
        String strPropFullName = "";
        ArrayList propList = null;
        ArrayList childInfoList = null;
        String billFullName = entityObjInfo.getFullName();
        try {
            Locale mylocale = SysContext.getSysContext().getLocale();
            String nodeText = entityObjInfo.getAlias(mylocale);
            entityRootNode = nodeText != null && nodeText.length() > 0 ? new DefaultKingdeeTreeNode((Object)nodeText) : new DefaultKingdeeTreeNode((Object)"no name");
            propList = this.isVAProp ? vcUtil.getOwnerVerifyFiled(entityObjInfo) : (this.isWriteBackProp ? vcUtil.getOwnerWriteBackFiled(entityObjInfo) : vcUtil.getOwnerPropByEntityInfo(entityObjInfo));
            strPack = entityObjInfo.getPackage();
            for (int i = 0; i < propList.size(); ++i) {
                propMeta = (IBotpMetaData)propList.get(i);
                nodeText = propMeta.getDisplayName();
                childNode = new DefaultKingdeeTreeNode((Object)nodeText);
                strPropFullName = strPack + "." + propMeta.getParent().getName().trim() + "." + propMeta.getName();
                childNode.setUserObject((Object)new TreeObject(propMeta, strPropFullName, billFullName));
                entityRootNode.add((MutableTreeNode)childNode);
            }
            childInfoList = VcUtil.getAllChildByEntityInfo(entityObjInfo);
            ArrayList childPropList = null;
            EntityObjectInfo childObjInfo = null;
            for (int i = 0; i < childInfoList.size(); ++i) {
                childObjInfo = (EntityObjectInfo)childInfoList.get(i);
                nodeText = entityObjInfo.getAlias(mylocale) + "." + childObjInfo.getAlias();
                childNode = new DefaultKingdeeTreeNode((Object)nodeText);
                entityRootNode.add((MutableTreeNode)childNode);
                childPropList = this.isVAProp ? vcUtil.getOwnerVerifyFiled(childObjInfo) : (this.isWriteBackProp ? vcUtil.getOwnerWriteBackFiled(childObjInfo) : vcUtil.getOwnerPropByEntityInfo(childObjInfo));
                strPack = childObjInfo.getPackage();
                for (int j = 0; j < childPropList.size(); ++j) {
                    propMeta = (IBotpMetaData)childPropList.get(j);
                    nodeText = propMeta.getDisplayName();
                    grandchildNode = new DefaultKingdeeTreeNode((Object)nodeText);
                    strPropFullName = strPack + "." + propMeta.getParent().getName().trim() + "." + propMeta.getName();
                    grandchildNode.setUserObject((Object)new TreeObject(propMeta, strPropFullName, billFullName));
                    childNode.add((MutableTreeNode)grandchildNode);
                }
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_PropertyTree"), (Throwable)err);
        }
        return entityRootNode;
    }

    public boolean isCanceled() {
        BizObjPropSelectF7 me = (BizObjPropSelectF7)this.currDialog.getUIObject();
        me.setTitle(me.title);
        return me.canceled;
    }

    public Object getData() {
        BizObjPropSelectF7 me = (BizObjPropSelectF7)this.currDialog.getUIObject();
        this.logger.debug((Object)("getData Event: " + this.canceled));
        if (me.canceled) {
            return null;
        }
        BizPropSelectObject ep = this.createDataObject();
        return ep;
    }

    @Override
    protected void treeProp_mouseClicked(MouseEvent e) throws Exception {
        this.logger.debug((Object)"treeProperty_mouseClicked!");
        if (e.getClickCount() == 2) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)this.treeProp.getLastSelectedPathComponent();
            if (selectedNode != null) {
                Object uo = selectedNode.getUserObject();
                if (uo != null && uo.getClass().getName().equals("java.lang.String")) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Select_Property"));
                    return;
                }
            } else {
                this.logger.debug((Object)"tree event:No select Node!");
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Select_Property"));
                return;
            }
            this.canceled = false;
            this.getUIWindow().close();
        }
    }

    private BizPropSelectObject createDataObject() {
        Object o;
        BizObjPropSelectF7 me = (BizObjPropSelectF7)this.currDialog.getUIObject();
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)me.treeProp.getLastSelectedPathComponent();
        if (selectedNode != null && (o = selectedNode.getUserObject()) != null && !o.getClass().getName().equals("java.lang.String")) {
            TreeObject to = (TreeObject)o;
            IBotpMetaData op = to.getOwnPropertyMeta();
            BizPropSelectObject ep = to.parentNodeText == null || to.parentNodeText.length() < 1 ? new BizPropSelectObject(selectedNode.getParent().toString() + "." + op.getDisplayName(), to.propFullText, to.getBillFullName()) : new BizPropSelectObject(to.parentNodeValue + "." + op.getAlias(), to.parentNodeText + "." + to.propFullText, to.getBillFullName());
            return ep;
        }
        return null;
    }

    protected JButton getDefaultButton() {
        return this.butSelect;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bt_OK_mouseClicked(MouseEvent e) throws Exception {
        super.bt_OK_mouseClicked(e);
    }

    @Override
    protected void bt_Cancel_mouseClicked(MouseEvent e) throws Exception {
        super.bt_Cancel_mouseClicked(e);
    }

    class TreeObject {
        private IBotpMetaData op;
        private String propFullText;
        public String parentNodeText;
        public String parentNodeValue;
        public String billFullName;

        public TreeObject(IBotpMetaData poropMeta, String propFullText, String billFullName) {
            this.op = poropMeta;
            this.propFullText = propFullText;
            this.billFullName = billFullName;
        }

        public TreeObject(IBotpMetaData poropMeta, String propFullText, String parentNodeText, String parentNodeValue) {
            this.op = poropMeta;
            this.propFullText = propFullText;
            this.parentNodeText = parentNodeText;
            this.parentNodeValue = parentNodeValue;
        }

        public IBotpMetaData getOwnPropertyMeta() {
            return this.op;
        }

        public String getBillFullName() {
            return this.billFullName;
        }

        public String toString() {
            return this.propFullText;
        }
    }
}

