/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.vc.VcFormulaInfo;
import com.kingdee.eas.base.vc.VcSchemeBizObjCollection;
import com.kingdee.eas.base.vc.VcSchemeBizObjInfo;
import com.kingdee.eas.base.vc.VcSchemeDSItemCollection;
import com.kingdee.eas.base.vc.VcSchemeDSItemInfo;
import com.kingdee.eas.base.vc.client.AbstractVcFormulaF7UI;
import com.kingdee.eas.base.vc.util.VcUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VcFormulaF7UI
extends AbstractVcFormulaF7UI {
    private static final Logger logger = CoreUIObject.getLogger(VcFormulaF7UI.class);
    VcFormulaInfo info = null;
    HashMap hash = new HashMap();
    private boolean isCancel = true;
    private String expression = "";
    private String alias = "";
    private VcSchemeBizObjCollection boColl;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        Map context = this.getUIContext();
        this.boColl = (VcSchemeBizObjCollection)((Object)context.get("boColl"));
        int m = this.boColl.size();
        for (int i = 0; i < m; ++i) {
            VcSchemeBizObjInfo boInfo = this.boColl.get(i);
            VcSchemeDSItemCollection propColl = boInfo.getBizObjDSItem();
            int n = propColl.size();
            for (int j = 0; j < n; ++j) {
                VcSchemeDSItemInfo propInfo = propColl.get(j);
                if (!propInfo.isIsVAField()) continue;
                String fullName = propInfo.getFieldFullName();
                String displayName = VcUtil.getPropFullDisNameByFullName(fullName);
                this.hash.put(displayName, fullName);
                this.kDListElement.addElement((Object)displayName);
            }
        }
        this.info = (VcFormulaInfo)context.get("formulaInfo");
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        if (this.info.getFormulaAlias() != null && this.info.getForumla() != null) {
            if (loc.equals(LocaleUtils.locale_l1.toString())) {
                this.alias = new String(this.info.getForumla());
                this.txtExpression.setText(this.alias);
            } else {
                this.alias = new String(this.info.getFormulaAlias());
                this.txtExpression.setText(this.alias);
            }
        }
    }

    private void setIcon() {
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.alias = this.txtExpression.getText();
        if (this.alias.trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcFormulaNotValid"));
            SysUtil.abort();
        }
        boolean state = false;
        String subAlias = this.alias.substring(0, this.alias.indexOf("="));
        String[] words = subAlias.split(" ");
        for (int i = 0; i < words.length; ++i) {
            boolean tmpState = false;
            if (words[i].trim().equals("")) continue;
            String fullName = (String)this.hash.get(words[i]);
            if (fullName == null) {
                tmpState = false;
                this.expression = this.expression + words[i];
            } else {
                tmpState = true;
                this.expression = this.expression + fullName;
            }
            if (tmpState == state) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcFormulaNotValid"));
                SysUtil.abort();
            } else {
                state = tmpState;
            }
            this.expression = this.expression + " ";
        }
        if (!state) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcFormulaNotValid"));
            SysUtil.abort();
        }
        this.expression = this.expression + " = 0 ";
        this.isCancel = false;
        this.info.setForumla(this.expression.getBytes());
        this.info.setFormulaAlias(this.alias.getBytes());
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kDListElement_mouseClicked(MouseEvent e) throws Exception {
        String element;
        if (e.getClickCount() == 2 && (element = (String)this.kDListElement.getSelectedValue()) != null && !element.trim().equals("")) {
            this.addAWord(element);
        }
    }

    @Override
    protected void btnPlus_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("+");
    }

    @Override
    protected void btnMinus_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("-");
    }

    @Override
    protected void btnMultiply_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("*");
    }

    @Override
    protected void btnDivide_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("/");
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtExpression.setText("");
        this.expression = "";
    }

    private void addAWord(String word) {
        String formula = this.txtExpression.getText();
        int index = formula.indexOf("=");
        if (index >= 0) {
            formula = formula.substring(0, index);
        }
        formula = formula + " " + word + " = 0 ";
        this.txtExpression.setText(formula);
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

