/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.IVcScheme;
import com.kingdee.eas.base.vc.SchemeTypeEnum;
import com.kingdee.eas.base.vc.VcSchemeFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.base.vc.client.AbstractVcSchemeListUI;
import com.kingdee.eas.base.vc.client.VcWizard;
import com.kingdee.eas.base.vc.util.VcUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VcSchemeListUI
extends AbstractVcSchemeListUI {
    public VcSchemeListUI() throws Exception {
        this.init();
    }

    public void init() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).setResizeable(false);
        this.btnLocate.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        String strTitle = EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource.VcSchemeListUI_Title");
        return strTitle;
    }

    protected String getEditUIName() {
        return VcWizard.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VcSchemeFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "VcScheme.id";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnLocate.setVisible(false);
        this.initSubSysTree();
        this.treeSubSys.setSelectionRow(0);
        String strFilter = "";
        if (this.getUIContext().get("UIClassParam") != null) {
            String subSystem = (String)this.getUIContext().get("UIClassParam");
            strFilter = "scheme.subSysName = '" + subSystem + "'";
        }
        if (VcUtil.getUsedCompany() != null) {
            CompanyOrgUnitInfo userCompanyInfo = VcUtil.getUsedCompany();
            String companyID = userCompanyInfo.getId().toString();
            strFilter = strFilter.trim().length() > 0 ? strFilter + " and companyID = '" + companyID + "'" : "companyID = '" + companyID + "'";
        }
        EntityViewInfo mainQuery = this.getMainQuery();
        this.btnStartUsing.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnStopUsing.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        int colIndex = this.tblMain.getColumnIndex("VcScheme.number");
        this.tblMain.getViewManager().freeze(0, colIndex);
        colIndex = this.tblMain.getColumnIndex("VcScheme.name");
        this.tblMain.getViewManager().freeze(0, colIndex);
    }

    private void initSubSysTree() throws Exception {
        TreePath treePath = this.treeSubSys.getSelectionPath();
        String en = "l1";
        String cn = "l2";
        String tw = "l3";
        String column = "FSubSys_";
        String language = SysContext.getSysContext().getLocale().getLanguage();
        column = language != null && !"".equals(language.trim()) ? (en.equalsIgnoreCase(language = language.trim()) ? column + en : (cn.equalsIgnoreCase(language) ? column + cn : (tw.equalsIgnoreCase(language) ? column + tw : column + en))) : column + en;
        ArrayList<String> subSysList = new ArrayList<String>();
        String sql = "select distinct " + column + " from T_VC_Scheme where FControlUnitID='" + SysContext.getSysContext().getCurrentCtrlUnit().getId() + "' or FControlUnitID='" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            String subSys = rs.getString(1);
            if (subSys == null || subSys.trim().equals("")) continue;
            subSysList.add(subSys);
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        int m = subSysList.size();
        for (int i = 0; i < m; ++i) {
            String subSys = (String)subSysList.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)subSys);
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        this.treeSubSys.setModel((TreeModel)model);
        this.treeSubSys.repaint();
        this.treeSubSys.getSelectionModel().setSelectionMode(1);
        this.treeSubSys.expandAllNodes(true, (TreeNode)root);
        if (treePath != null) {
            this.treeSubSys.setSelectionPath(treePath);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        IVcScheme aIVcScheme;
        VcSchemeInfo aSVcSchemeInfo;
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0 && (aSVcSchemeInfo = (VcSchemeInfo)(aIVcScheme = (IVcScheme)this.getBizInterface()).getValue((IObjectPK)(pk = new ObjectUuidPK(strId)))).getSchemeType() != null && aSVcSchemeInfo.getSchemeType() == SchemeTypeEnum.SYSTEM_PREPARED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource.VcSchemeListUI_Msg");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        IVcScheme aIVcScheme;
        VcSchemeInfo aSVcSchemeInfo;
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0 && (aSVcSchemeInfo = (VcSchemeInfo)(aIVcScheme = (IVcScheme)this.getBizInterface()).getValue((IObjectPK)(pk = new ObjectUuidPK(strId)))).getSchemeType() != null && aSVcSchemeInfo.getSchemeType() == SchemeTypeEnum.SYSTEM_PREPARED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource.VcSchemeListUI_Edit");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public static void main(String[] args) {
        FMLoginModel login = FMLoginModel.newInstance();
        login.login("mm", "", "eas", "EAS50_0728");
        String uiName = VcSchemeListUI.class.getName();
        login.loginMain(uiName);
    }

    @Override
    public void actionStartUsing_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartUsing_actionPerformed(e);
        this.checkSelected();
        String schemeId = this.getSelectedKeyValue();
        if (schemeId != null && schemeId.length() > 0) {
            IVcScheme iVcScheme = (IVcScheme)this.getBizInterface();
            VcSchemeInfo schemeInfo = iVcScheme.getVcSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
            schemeInfo.setIsUsing(true);
            SelectorItemCollection itemColl = new SelectorItemCollection();
            itemColl.add(new SelectorItemInfo("isUsing"));
            iVcScheme.updatePartial((CoreBaseInfo)schemeInfo, itemColl);
            this.refreshList();
        }
    }

    @Override
    public void actionStopUsing_actionPerformed(ActionEvent e) throws Exception {
        super.actionStopUsing_actionPerformed(e);
        this.checkSelected();
        String schemeId = this.getSelectedKeyValue();
        if (schemeId != null && schemeId.length() > 0) {
            IVcScheme iVcScheme = (IVcScheme)this.getBizInterface();
            VcSchemeInfo schemeInfo = iVcScheme.getVcSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
            schemeInfo.setIsUsing(false);
            SelectorItemCollection itemColl = new SelectorItemCollection();
            itemColl.add(new SelectorItemInfo("isUsing"));
            iVcScheme.updatePartial((CoreBaseInfo)schemeInfo, itemColl);
            this.refreshList();
        }
    }

    @Override
    public void actionClone_actionPerformed(ActionEvent e) throws Exception {
        super.actionClone_actionPerformed(e);
        this.checkSelected();
        String fid = this.getSelectedKeyValue();
        IVcScheme iVcScheme = (IVcScheme)this.getBizInterface();
        iVcScheme.addClone(BOSUuid.read((String)fid));
        this.refreshList();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index >= 0) {
            IRow irow = this.tblMain.getRow(index);
            BizEnumValueInfo schemeType = (BizEnumValueInfo)irow.getCell("VcScheme.schemeType").getValue();
            if (schemeType.getName().equals(SchemeTypeEnum.SYSTEM_PREPARED.getName())) {
                this.btnEdit.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                Boolean isUsing = (Boolean)irow.getCell("VcScheme.isUsing").getValue();
                if (isUsing.booleanValue()) {
                    this.actionStartUsing.setEnabled(false);
                    this.actionStopUsing.setEnabled(true);
                } else {
                    this.actionStartUsing.setEnabled(true);
                    this.actionStopUsing.setEnabled(false);
                }
            } else {
                Boolean isUsing = (Boolean)irow.getCell("VcScheme.isUsing").getValue();
                if (isUsing.booleanValue()) {
                    this.actionStartUsing.setEnabled(false);
                    this.actionStopUsing.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.menuItemEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                } else {
                    this.actionStartUsing.setEnabled(true);
                    this.actionStopUsing.setEnabled(false);
                    this.btnEdit.setEnabled(true);
                    this.menuItemEdit.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                }
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor query = super.getQueryExecutor(queryPK, viewInfo);
        try {
            Object uo;
            String subSys = "%";
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeSubSys.getLastSelectedPathComponent();
            if (node != null && (uo = node.getUserObject()) != null && uo instanceof String && (subSys = (String)uo).equals("EAS")) {
                subSys = "%";
            }
            query.setParameter(1, (Object)subSys);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return query;
    }

    @Override
    protected void treeSubSys_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeSubSys_valueChanged(e);
        super.refresh(null);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.initSubSysTree();
    }
}

