/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.vc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.vc.BankVcProcessFacadeFactory;
import com.kingdee.eas.base.vc.Direction;
import com.kingdee.eas.base.vc.IBankVcProcessFacade;
import com.kingdee.eas.base.vc.IVcProcess;
import com.kingdee.eas.base.vc.IVcScheme;
import com.kingdee.eas.base.vc.VcMatchConditionCollection;
import com.kingdee.eas.base.vc.VcProcessFactory;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultInfo;
import com.kingdee.eas.base.vc.VcSchemeBizObjCollection;
import com.kingdee.eas.base.vc.VcSchemeBizObjInfo;
import com.kingdee.eas.base.vc.VcSchemeCollection;
import com.kingdee.eas.base.vc.VcSchemeFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.base.vc.VcVerifyInfo;
import com.kingdee.eas.base.vc.client.AbstractVcVerifyUI;
import com.kingdee.eas.base.vc.client.VcSchemeSelectUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VcVerifyUI
extends AbstractVcVerifyUI {
    private static final Logger logger = CoreUIObject.getLogger(VcVerifyUI.class);
    protected HashMap mapAll = new HashMap();
    protected HashMap mapNotVerify = new HashMap();
    protected HashMap mapVerify = new HashMap();
    VcMatchConditionCollection bizMatchConditionColl = new VcMatchConditionCollection();
    HashMap mapOQL = new HashMap();
    protected boolean isPoPFilterUIAtFirst = false;
    static VcSchemeInfo curScheme = null;
    protected CompanyOrgUnitInfo curCompany = null;
    private VcResultCollection vcResult = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        if (!this.isPoPFilterUIAtFirst) {
            this.initVcVerify();
        }
    }

    public void initVcVerify() {
        this.entityVcVerify = new VcVerifyInfo();
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
        this.entityVcVerify.setOrgUnit(orgUnitInfo);
        VcSchemeInfo vcSchemeInfo = this.getVcSchemeInfoByBiz();
        this.entityVcVerify.setVcScheme(vcSchemeInfo);
        curScheme = vcSchemeInfo;
    }

    protected void setIcon() {
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnConfig.setIcon(EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.btnAuto.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnManual.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnShowVerified.setIcon(EASResource.getIcon((String)"imgTbtn_alreadycollate"));
        this.btnShowNotVerify.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.btnShowAll.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnResult.setIcon(EASResource.getIcon((String)"imgTbtn_collateresult"));
        this.btnHistory.setIcon(EASResource.getIcon((String)"imgTbtn_demandhistorydata"));
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.entityVcVerify == null || this.entityVcVerify.getVcScheme() == null) {
            return;
        }
        this.mapOQL = this.getBizFilter();
        this.filterBizObj(this.mapOQL);
        SimpleTimer timer = new SimpleTimer();
        this.getBizObj(this.mapAll);
        System.out.println("get BO time: " + timer.getTime() + "-------------------------------");
        timer.reset();
        this.displayBizObj(this.mapAll);
        System.out.println("get display time: " + timer.getTime() + "-------------------------------");
    }

    protected void filterBizObj(HashMap mapOQL) throws Exception {
        SimpleTimer timer = new SimpleTimer();
        IBankVcProcessFacade iVcProcess = BankVcProcessFacadeFactory.getRemoteInstance();
        this.mapAll = iVcProcess.filter(this.entityVcVerify.getVcScheme().getId(), mapOQL);
        System.out.println("filter time: " + timer.getTime() + "-------------------------------");
        this.mapNotVerify.clear();
        this.mapVerify.clear();
        VcSchemeBizObjCollection boColl = this.entityVcVerify.getVcScheme().getSchemeBizObj();
        int m = boColl.size();
        for (int i = 0; i < m; ++i) {
            VcSchemeBizObjInfo boInfo = boColl.get(i);
            String boName = boInfo.getBizObj();
            ArrayList idListAll = (ArrayList)this.mapAll.get(boName);
            ArrayList idListNotVerify = new ArrayList(idListAll);
            ArrayList idListVerify = new ArrayList();
            this.mapNotVerify.put(boName, idListNotVerify);
            this.mapVerify.put(boName, idListVerify);
        }
    }

    protected void getBizObj(HashMap mapAll) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        Object[] vecIdList;
        HashMap mapSelected = this.getBizSelected();
        ArrayList idList = null;
        Object[] vecBOName = mapSelected.keySet().toArray();
        for (int i = 0; i < vecBOName.length; ++i) {
            ArrayList boIdList = (ArrayList)mapSelected.get(vecBOName[i]);
            if (boIdList != null && boIdList.size() != 0) continue;
            mapSelected.remove(vecBOName[i]);
        }
        Object[] vecList = mapSelected.values().toArray();
        if (vecList != null && vecList.length > 0) {
            if (vecList.length != 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcSearchCount"));
                return;
            }
            idList = (ArrayList)vecList[0];
            if (idList.size() != 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcSearchCount"));
                return;
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcSearchCount"));
            return;
        }
        IVcProcess iVcProcess = VcProcessFactory.getRemoteInstance();
        HashMap mapMatchedIdList = iVcProcess.searchBO(this.entityVcVerify.getVcScheme().getId(), this.mapNotVerify, mapSelected);
        int total = 0;
        if (mapMatchedIdList != null && (vecIdList = mapMatchedIdList.values().toArray()) != null) {
            for (int i = 0; i < vecIdList.length; total += ((ArrayList)vecIdList[i]).size(), ++i) {
            }
        }
        if (total > 0) {
            mapMatchedIdList.put("filterID", "filterID");
            this.displayBizObj(mapMatchedIdList);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.mapOQL == null) {
            this.mapOQL = new HashMap();
        }
        this.filterBizObj(this.mapOQL);
        this.getBizObj(this.mapAll);
        this.displayBizObj(this.mapAll);
    }

    @Override
    public void actionConfig_actionPerformed(ActionEvent e) throws Exception {
        this.bizMatchConditionColl = this.getMatchConditionByBiz();
    }

    protected VcMatchConditionCollection getMatchConditionByBiz() {
        VcMatchConditionCollection conditionColl = new VcMatchConditionCollection();
        return conditionColl;
    }

    @Override
    public void actionAuto_actionPerformed(ActionEvent e) throws Exception {
        SimpleTimer timer = new SimpleTimer();
        IBankVcProcessFacade iVcProcess = BankVcProcessFacadeFactory.getRemoteInstance();
        if (this.bizMatchConditionColl == null) {
            this.bizMatchConditionColl = new VcMatchConditionCollection();
        }
        this.vcResult = (VcResultCollection)iVcProcess.autoProcess(this.mapNotVerify, (IObjectCollection)this.bizMatchConditionColl);
        System.out.println("auto verify time: " + timer.getTime() + "-------------------------------");
        int m = this.vcResult.size();
        for (int i = 0; i < m; ++i) {
            VcResultInfo resultInfo = this.vcResult.get(i);
            String boName = resultInfo.getBizObjectFullName();
            String boId = resultInfo.getBizObjectId().toString();
            ArrayList idListVerify = (ArrayList)this.mapVerify.get(boName);
            ArrayList idListNotVerify = (ArrayList)this.mapNotVerify.get(boName);
            if (!idListVerify.contains(boId)) {
                idListVerify.add(boId);
            }
            if (!idListNotVerify.contains(boId)) continue;
            idListNotVerify.remove(boId);
        }
    }

    protected VcResultCollection getBankVcResult() {
        return this.vcResult;
    }

    @Override
    public void actionManual_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapSelectedIdList = this.getBizSelected();
        IBankVcProcessFacade iVcProcess = BankVcProcessFacadeFactory.getRemoteInstance();
        VcResultCollection resultColl = (VcResultCollection)iVcProcess.manualProcess(mapSelectedIdList);
        int m = resultColl.size();
        for (int i = 0; i < m; ++i) {
            VcResultInfo resultInfo = resultColl.get(i);
            String boName = resultInfo.getBizObjectFullName();
            String boId = resultInfo.getBizObjectId().toString();
            ArrayList idListVerify = (ArrayList)this.mapVerify.get(boName);
            ArrayList idListNotVerify = (ArrayList)this.mapNotVerify.get(boName);
            if (!idListVerify.contains(boId)) {
                idListVerify.add(boId);
            }
            if (!idListNotVerify.contains(boId)) continue;
            idListNotVerify.remove(boId);
        }
        if (resultColl == null || resultColl.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"CanNotManualVerify"));
            SysUtil.abort();
        }
        this.displayBizObj(this.mapNotVerify);
    }

    protected HashMap getBizSelected() {
        HashMap mapSelected = new HashMap();
        Object[] vecKey = this.mapNotVerify.keySet().toArray();
        for (int i = 0; i < vecKey.length; ++i) {
            ArrayList idList = (ArrayList)this.mapNotVerify.get(vecKey[i]);
            if (idList == null) continue;
            ArrayList tmpIdList = new ArrayList(idList);
            mapSelected.put(vecKey[i], tmpIdList);
        }
        return mapSelected;
    }

    protected HashMap getBizFilter() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.entityVcVerify != null) {
            VcSchemeBizObjCollection boColl = this.entityVcVerify.getVcScheme().getSchemeBizObj();
            int m = boColl.size();
            for (int i = 0; i < m; ++i) {
                VcSchemeBizObjInfo boInfo = boColl.get(i);
                map.put(boInfo.getBizObj(), "");
            }
        }
        return map;
    }

    protected VcSchemeInfo getVcSchemeInfoByBiz() {
        VcSchemeInfo info = null;
        try {
            IVcScheme iVcScheme = VcSchemeFactory.getRemoteInstance();
            String subSysName = this.getSubSysName();
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            String oql = "CU.id in ('" + cuId + "', '" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "', '" + "11111111-1111-1111-1111-111111111111CCE7AED4" + "') and isUsing=1";
            if (subSysName != null) {
                oql = "where subSysName='" + subSysName + "'  and " + oql;
            }
            VcSchemeCollection schemeColl = iVcScheme.getVcSchemeCollection(oql);
            for (int i = 0; i < schemeColl.size(); ++i) {
                VcSchemeInfo vcSchemeInfo = schemeColl.get(i);
            }
            if (schemeColl.size() > 1) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"schemeColl", (Object)schemeColl);
                IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VcSchemeSelectUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                popUI.show();
                VcSchemeSelectUI selectUI = (VcSchemeSelectUI)popUI.getUIObject();
                if (selectUI.isOK) {
                    info = selectUI.schemeInfo;
                } else {
                    SysUtil.abort();
                }
            } else if (schemeColl.size() == 1) {
                info = schemeColl.get(0);
            } else if (schemeColl.size() <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"NoValidVcScheme"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (info == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"NoValidVcScheme"));
            SysUtil.abort();
        }
        return info;
    }

    protected String getSubSysName() {
        return "";
    }

    protected void displayBizObj(HashMap map) {
        VcSchemeBizObjCollection boColl = this.entityVcVerify.getVcScheme().getSchemeBizObj();
        int m = boColl.size();
        for (int i = 0; i < m; ++i) {
            VcSchemeBizObjInfo boInfo = boColl.get(i);
            if (boInfo.getDirection() == Direction.SOURCE) {
                ArrayList idList = (ArrayList)map.get(boInfo.getBizObj());
                if (idList == null) continue;
                int n = idList.size();
                for (int j = 0; j < n; ++j) {
                    System.out.println((String)idList.get(j));
                }
                continue;
            }
            if (boInfo.getDirection() != Direction.DEST) continue;
        }
    }

    protected VcVerifyInfo getVcResult() {
        return this.entityVcVerify;
    }

    public boolean destroyWindow() {
        VcSchemeBizObjCollection boColl = this.entityVcVerify.getVcScheme().getSchemeBizObj();
        int m = boColl.size();
        for (int i = 0; i < m; ++i) {
            VcSchemeBizObjInfo boInfo = boColl.get(i);
            String boName = boInfo.getBizObj();
            ArrayList idListAll = (ArrayList)this.mapAll.get(boName);
            if (idListAll == null) continue;
            int j = 0;
            int n = idListAll.size();
            while (i < n) {
                String string = (String)idListAll.get(j);
                ++i;
            }
        }
        return super.destroyWindow();
    }

    protected HashMap getMapOQL() {
        return this.mapOQL;
    }

    protected void setBizMatchConditionColl(VcMatchConditionCollection bizMatchConditionColl) {
        this.bizMatchConditionColl = bizMatchConditionColl;
    }
}

