/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BizPayBillReBack
implements IPaymentDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.BizPayBillReBack");

    public void dispose(Context context, BillDisposerAction billDisposer) throws BOSException, EASBizException {
        int i;
        if (billDisposer == null || billDisposer.getDestBill() == null) {
            return;
        }
        DisposerActionEnum actionType = billDisposer.getActionType();
        if (!(DisposerActionEnum.SAVE.equals((Object)actionType) || DisposerActionEnum.SUBMIT.equals((Object)actionType) || DisposerActionEnum.PAY.equals((Object)actionType) || DisposerActionEnum.CANCEL_PAY.equals((Object)actionType) || DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType) || DisposerActionEnum.DELETE.equals((Object)actionType))) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        PaymentBillInfo paymentInfo = (PaymentBillInfo)billDisposer.getDestBill();
        PaymentBillEntryCollection payBillEntry = (PaymentBillEntryCollection)paymentInfo.get("entries");
        PaymentBillTypeInfo paymentBillType = paymentInfo.getPayBillType();
        if (paymentBillType != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("preSetBillType.id"));
            sic.add(new SelectorItemInfo("preSetBillType.number"));
            paymentBillType = PaymentBillTypeFactory.getLocalInstance((Context)context).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(paymentBillType.getId()), sic);
        }
        PaymentBillTypeInfo preSetBillType = paymentBillType.getPreSetBillType();
        boolean isPrePayment = "202".equals(paymentBillType.getNumber());
        boolean isCancelPrePayment = "204".equals(paymentBillType.getNumber());
        if (preSetBillType != null) {
            isPrePayment = isPrePayment || "202".equals(preSetBillType.getNumber());
            isCancelPrePayment = isCancelPrePayment || "204".equals(preSetBillType.getNumber());
        }
        Boolean isCreatePrePaymentBill = BizCollUtil.isCreatePrePaymentBill(context);
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        paramMap.put("isPrePayment", isPrePayment);
        paramMap.put("isCancelPrePayment", isCancelPrePayment);
        paramMap.put("isCreatePrePaymentBill", isCreatePrePaymentBill);
        String srcBillId = paymentInfo.getSourceBillId();
        if (payBillEntry != null && payBillEntry.size() > 0) {
            for (int i2 = 0; i2 < payBillEntry.size() && StringUtils.isEmpty((String)(srcBillId = payBillEntry.get(i2).getSourceBillId())); ++i2) {
            }
        }
        if (StringUtils.isEmpty((String)srcBillId)) {
            if (DisposerActionEnum.SUBMIT.equals((Object)actionType) || DisposerActionEnum.PAY.equals((Object)actionType) || DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
                throw new BizCollException(BizCollException.PAYBILLSOURCEBILLIDNOTNULL);
            }
            return;
        }
        BizCollBillBaseInfo billInfo = null;
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(context, BOSUuid.read((String)srcBillId));
        if (!(iCoreBase instanceof IBizCollBillBase)) {
            throw new CreateToException(CreateToException.SOURCEBILLIDERROR);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)iCoreBase;
        billInfo = iBizCollBillBase.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(srcBillId), this.getSelector());
        boolean isPay = false;
        List reverseDelSrcBillIdList = null;
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            isPay = true;
            BillReverseHandler.paymentHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PaymentBillInfo)paymentInfo, (String)"payment", (boolean)true, paramMap);
        } else if (DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
            isPay = false;
            BillReverseHandler.paymentHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PaymentBillInfo)paymentInfo, (String)"payment", (boolean)false, paramMap);
        } else if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
            BillReverseHandler.paymentHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PaymentBillInfo)paymentInfo, (String)"Submit", (boolean)false, paramMap);
            List<String> delSourceBillIdList = this.getDelSrcBillIdList(billDisposer, paymentInfo);
            if (delSourceBillIdList != null && delSourceBillIdList.size() > 0) {
                reverseDelSrcBillIdList = BizCollUtil.reversePayDeleteSourceBill(context, paymentInfo.getString("id"), delSourceBillIdList);
            }
        } else if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            BillReverseHandler.paymentHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PaymentBillInfo)paymentInfo, (String)"Save", (boolean)false, paramMap);
            List<String> delSrcBillIdList = this.getDelSrcBillIdList(billDisposer, paymentInfo);
            if (delSrcBillIdList != null && delSrcBillIdList.size() > 0) {
                reverseDelSrcBillIdList = BizCollUtil.reversePayDeleteSourceBill(context, paymentInfo.getString("id"), delSrcBillIdList);
            }
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            BillReverseHandler.paymentHandler((Context)context, (IBizCollBillBase)iBizCollBillBase, (BizCollBillBaseInfo)billInfo, (PaymentBillInfo)paymentInfo, (String)"Delete", (boolean)false, paramMap);
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            // empty if block
        }
        Long endTime = System.currentTimeMillis();
        logger.error((Object)("cpbc BizPayBillReBack finished number=" + billInfo.getNumber() + ", paynumber=" + paymentInfo.getNumber() + ",actionType=" + actionType + ",time\uff1a" + (endTime - startTime) + "ms"));
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        PaymentBillEntryCollection entries = paymentInfo.getEntries();
        String sourceBillId = null;
        BizCollBillBaseInfo info = null;
        int size = entries.size();
        for (i = 0; i < size; ++i) {
            sourceBillId = entries.get(i).getSourceBillId();
            if (StringUtils.isEmpty((String)sourceBillId)) continue;
            BizCollBillBaseInfo bizCollBillBaseInfo = info = billInfo.getId().toString().equals(sourceBillId) ? billInfo : null;
            if (sourceBillIdSet.contains(sourceBillId)) continue;
            iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(sourceBillId), info);
            sourceBillIdSet.add(sourceBillId);
        }
        if (reverseDelSrcBillIdList != null && reverseDelSrcBillIdList.size() > 0) {
            size = reverseDelSrcBillIdList.size();
            for (i = 0; i < size; ++i) {
                iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK((String)reverseDelSrcBillIdList.get(i)), null);
            }
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)("cpbc BizPayBillReBack ngisc_reverse number=" + billInfo.getNumber() + ", paynumber=" + paymentInfo.getNumber() + ",actionType=" + actionType + ",time\uff1a" + (endTime - startTime) + "ms"));
    }

    private void updateIsCreatePayBill(Context context, String billTableName, String value, Set<String> sourceBillIds) throws BOSException {
        String sourceBillIdsStr = StringUtils.join(sourceBillIds.iterator(), (String)"','");
        sourceBillIdsStr = "'" + sourceBillIdsStr + "'";
        String updateSql = null;
        updateSql = " UPDATE " + billTableName + " SET FisCreatePayBill=%s WHERE FID in (%s)";
        DbUtil.execute((Context)context, (String)String.format(updateSql, value, sourceBillIdsStr));
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public List<String> getDelSrcBillIdList(BillDisposerAction billDisposer, PaymentBillInfo paymentInfo) {
        ArrayList<String> delSrcBillIdList = null;
        try {
            billDisposer.getClass().getMethod("getDeleteEntry", new Class[0]);
            AbstractObjectCollection payBillDelEntry = billDisposer.getDeleteEntry();
            logger.info((Object)("##getDeleteEntry.size =" + (payBillDelEntry == null ? "0" : Integer.valueOf(payBillDelEntry.size()))));
            if (payBillDelEntry != null && payBillDelEntry.size() > 0) {
                HashSet<String> sourceBillIdSet = new HashSet<String>();
                PaymentBillEntryCollection entries = paymentInfo.getEntries();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    sourceBillIdSet.add(entries.get(i).getSourceBillId());
                }
                String sourceBillId = null;
                delSrcBillIdList = new ArrayList<String>();
                int size2 = payBillDelEntry.size();
                for (int i = 0; i < size2; ++i) {
                    sourceBillId = payBillDelEntry.getObject(i).getString("sourceBillId");
                    if (StringUtils.isEmpty((String)sourceBillId) || delSrcBillIdList.contains(sourceBillId) || sourceBillIdSet.contains(sourceBillId)) continue;
                    delSrcBillIdList.add(sourceBillId);
                }
            }
        }
        catch (SecurityException e) {
            logger.error((Object)("##getDeleteEntry. " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("##NoSuchMethod getDeleteEntry. " + e.getMessage()));
        }
        return delSrcBillIdList;
    }
}

