/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.RePaymentBillFactory;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryCollection;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryFactory;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;

public class RePayBillReBack
implements IReceivingDisposer {
    public void dispose(Context ctx, BillDisposerAction arg1) throws BOSException, EASBizException {
        if (arg1 == null || arg1.getDestBill() == null) {
            return;
        }
        ReceivingBillInfo receivingBillInfo = null;
        if (arg1.getDestBill() instanceof ReceivingBillInfo) {
            receivingBillInfo = (ReceivingBillInfo)arg1.getDestBill();
        }
        if (receivingBillInfo == null) {
            return;
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"dispose", (BOSObjectType)receivingBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(receivingBillInfo.getId()), (String)("\u6536\u6b3e\u5355\u53cd\u5199 dispose \u6536\u6b3e\u5355\u5355\u636e\u7f16\u7801\uff1a" + receivingBillInfo.getNumber() + ",\u5355\u636e\u72b6\u6001\uff1a" + receivingBillInfo.getBillStatus() + ",mode:" + arg1.getActionType()));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        if (DisposerActionEnum.SAVE.equals((Object)arg1.getActionType())) {
            if (arg1.getDestBill() instanceof ReceivingBillInfo) {
                String srcBillId2 = null;
                receivingBillInfo = (ReceivingBillInfo)arg1.getDestBill();
                ReceivingBillEntryCollection entryColl = null;
                ReceivingBillEntryInfo entryInfo = null;
                entryColl = receivingBillInfo.getEntries();
                HashSet<String> set = new HashSet<String>();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = entryColl.get(i);
                    if (entryInfo == null) continue;
                    srcBillId2 = entryInfo.getSourceBillId();
                    set.add(srcBillId2);
                }
                for (String srcBillId2 : set) {
                    if (srcBillId2 == null || "".equals(srcBillId2)) {
                        throw new ExpAccException(ExpAccException.SOURCEBILLID_IS_NULL);
                    }
                    this.reWriteBillState(ctx, srcBillId2, StateEnum.ISRECEIVEBILL);
                }
            }
        } else if (DisposerActionEnum.DELETE.equals((Object)arg1.getActionType())) {
            if (arg1.getDestBill() instanceof ReceivingBillInfo && BillStatusEnum.SAVE.equals((Object)(receivingBillInfo = (ReceivingBillInfo)arg1.getDestBill()).getBillStatus())) {
                String srcBillId3 = null;
                ReceivingBillEntryCollection entryColl = null;
                ReceivingBillEntryInfo entryInfo = null;
                entryColl = receivingBillInfo.getEntries();
                HashSet<String> set = new HashSet<String>();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = entryColl.get(i);
                    if (entryInfo == null) continue;
                    srcBillId3 = entryInfo.getSourceBillId();
                    if (srcBillId3 == null || "".equals(srcBillId3)) {
                        throw new BizCollException(BizCollException.SOURCEBILLIDNOTNULL);
                    }
                    set.add(srcBillId3);
                }
                for (String srcBillId3 : set) {
                    this.doDeleteRePaymentBillBusiness(ctx, srcBillId3, receivingBillInfo);
                }
            }
        } else {
            return;
        }
    }

    protected void doDeleteRePaymentBillBusiness(Context ctx, String srcBillId, ReceivingBillInfo receivingBillInfo) throws BOSException, EASBizException {
        RePaymentBillInfo rePaymentBill = RePaymentBillFactory.getLocalInstance(ctx).getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(srcBillId));
        if (rePaymentBill.getState().getValue() > 60) {
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            facade.setState(rePaymentBill.getId(), StateEnum.CHECKED);
            RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()));
        }
        RePaymentBillReceiveEntryCollection con = rePaymentBill.getReceiveEntries();
        RePaymentBillReceiveEntryCollection conNew = new RePaymentBillReceiveEntryCollection();
        if (con.size() > 0) {
            for (int i = 0; i < con.size(); ++i) {
                if (con.get(i).getReceiveBillId().equals(receivingBillInfo.getId())) {
                    RePaymentBillReceiveEntryFactory.getLocalInstance(ctx).delete("where receiveBillId='" + receivingBillInfo.getId() + "'");
                    continue;
                }
                conNew.add(con.get(i));
            }
            rePaymentBill.getReceiveEntries().clear();
            rePaymentBill.getReceiveEntries().addCollection(conNew);
            this.buildReceiveBotpRelation(ctx, rePaymentBill);
        }
    }

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void buildReceiveBotpRelation(Context ctx, RePaymentBillInfo rePaymentBillInfo) throws EASBizException, BOSException, UuidException {
        RePaymentBillReceiveEntryCollection con = rePaymentBillInfo.getReceiveEntries();
        RePaymentBillReceiveEntryInfo info = null;
        if (rePaymentBillInfo.getId() != null) {
            BizCollUtil.deleteBotpRelationBySrcBillId(ctx, rePaymentBillInfo.getId().toString());
        }
        if (con.size() > 0) {
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                info = con.get(i);
                BizCollUtil.bulidBotpRelation(ctx, BizCollUtil.rePaymentBillBosType.toString(), rePaymentBillInfo.getId().toString(), BOSUuid.read((String)info.getReceiveBillId()).getType().toString(), info.getReceiveBillId());
            }
        }
    }
}

