/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BillTypeCollection;
import com.kingdee.eas.cp.bc.BillTypeFactory;
import com.kingdee.eas.cp.bc.BillTypeInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.client.AbstractBillMatchOperationOrExpenseEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BillMatchOperationOrExpenseEditUI
extends AbstractBillMatchOperationOrExpenseEditUI {
    private static final long serialVersionUID = 1619106128863746432L;
    private static final Logger logger = CoreUIObject.getLogger(BillMatchOperationOrExpenseEditUI.class);
    private static final String BizCR = "com.kingdee.eas.cp.bc.BizCollResource";
    private Set<String> idSet;
    private IObjectCollection collection;
    private Map<BOSUuid, BillTypeInfo> billTypes = new HashMap<BOSUuid, BillTypeInfo>();

    protected void initWorkButton() {
        super.initWorkButton();
        this.submit.setEnabled(true);
        this.cancel.setEnabled(true);
        JButton btnAddRuleNew = this.kDContainer1.add((Action)((Object)this.actionAddLine));
        JButton btnRemoveRuleNew = this.kDContainer1.add((Action)((Object)this.actionRemoveLine));
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setSize(22, 19);
        btnRemoveRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveRuleNew.setSize(22, 19);
        btnAddRuleNew.setEnabled(true);
        btnRemoveRuleNew.setEnabled(true);
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        super.onLoad();
        HashSet<String> billTypeId = new HashSet<String>();
        if (this.getUIContext().get("ParentNode") instanceof OperationTypeInfo) {
            OperationTypeInfo operationTypeInfo = (OperationTypeInfo)this.getUIContext().get("ParentNode");
        }
        final KDBizPromptBox billTypePromBox = new KDBizPromptBox();
        this.kdtEntries.getColumn("billType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)billTypePromBox));
        this.kdtEntries.getColumn("isFilterControl").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("isSupportWeb").getStyleAttributes().setHided(true);
        this.kdtEntries.getColumn("isSupportWeb").getStyleAttributes().setLocked(false);
        HashSet idSet = (HashSet)this.getUIContext().get("idSet");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.billType.id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        this.collection = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeCollection(view);
        EntityViewInfo viewbill = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        viewbill.setSelector(selector);
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        viewbill.getSorter().add(sortInfo);
        String oql = viewbill.toString();
        BillTypeCollection billTypeCol = BillTypeFactory.getRemoteInstance().getBillTypeCollection(oql);
        BillTypeInfo btInfo = null;
        int size = billTypeCol.size();
        for (int i = 0; i < size; ++i) {
            btInfo = billTypeCol.get(i);
            this.billTypes.put(btInfo.getId(), btInfo);
        }
        if (this.collection.size() == 1) {
            ExpenseTypeEntryCollection entryCol = ExpenseTypeEntryFactory.getRemoteInstance().getExpenseTypeEntryCollection(" where expenseType = '" + ((ExpenseTypeInfo)this.collection.getObject(0)).getId() + "'");
            int n = entryCol.size();
            for (int i = 0; i < n; ++i) {
                ExpenseTypeEntryInfo entryInfo = entryCol.get(i);
                IRow iRow = this.kdtEntries.addRow();
                BillTypeInfo info = this.billTypes.get(entryInfo.getBillType().getId());
                iRow.getCell("billType").setValue((Object)info);
                iRow.getCell("isFilterControl").setValue((Object)entryInfo.isIsFilterControl());
                iRow.getCell("isSupportWeb").setValue((Object)entryInfo.isIsSupportWeb());
                billTypeId.add(entryInfo.getBillType().getId().toString());
            }
            MakeControl.makeBillTypeF7(billTypePromBox, billTypeId);
        } else {
            this.kdtEntries.addRow();
            this.kdtEntries.getCell(0, "isFilterControl").setValue((Object)false);
            this.kdtEntries.getCell(0, "isSupportWeb").setValue((Object)false);
            MakeControl.makeBillTypeF7(billTypePromBox, null);
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                HashSet<String> innerBillTypeId = new HashSet<String>();
                innerBillTypeId.clear();
                if (e.getColIndex() == BillMatchOperationOrExpenseEditUI.this.kdtEntries.getColumnIndex("billType")) {
                    for (int i = 0; i < BillMatchOperationOrExpenseEditUI.this.kdtEntries.getRowCount(); ++i) {
                        BillTypeInfo info = (BillTypeInfo)BillMatchOperationOrExpenseEditUI.this.kdtEntries.getCell(i, "billType").getValue();
                        if (info == null || innerBillTypeId.contains(info.getId().toString())) continue;
                        innerBillTypeId.add(info.getId().toString());
                    }
                    MakeControl.makeBillTypeF7(billTypePromBox, innerBillTypeId);
                    BillMatchOperationOrExpenseEditUI.this.kdtEntries.getColumn("billType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)billTypePromBox));
                }
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == BillMatchOperationOrExpenseEditUI.this.kdtEntries.getColumnIndex("billType")) {
                    boolean isChanged = true;
                    isChanged = BizCollUtil.isF7EditedChanged(e);
                    if (!isChanged) {
                        return;
                    }
                    if (e.getValue() != null && e.getValue() instanceof Object[]) {
                        Object[] objs = (Object[])e.getValue();
                        BillTypeInfo[] infos = new BillTypeInfo[objs.length];
                        for (int i = 0; i < objs.length; ++i) {
                            infos[i] = (BillTypeInfo)objs[i];
                        }
                        BillTypeInfo info = infos[0];
                        IRow iRow = BillMatchOperationOrExpenseEditUI.this.kdtEntries.getRow(e.getRowIndex());
                        iRow.getCell("billType").setValue((Object)info);
                        iRow.getCell("isFilterControl").setValue((Object)Boolean.TRUE);
                        if (info.getNumber().equals("EvectionReqBill") || info.getNumber().equals("DailyPurchaseAccountBill")) {
                            iRow.getCell("isSupportWeb").getStyleAttributes().setLocked(Boolean.TRUE.booleanValue());
                            iRow.getCell("isSupportWeb").getStyleAttributes().setBackground(Color.lightGray);
                        }
                        BillMatchOperationOrExpenseEditUI.this.addLine(BillMatchOperationOrExpenseEditUI.this.kdtEntries, infos);
                    }
                }
            }
        });
    }

    protected void addLine(KDTable table, BillTypeInfo[] billTypes) {
        if (billTypes != null && billTypes.length > 1) {
            for (int i = 1; i < billTypes.length; ++i) {
                IRow iRow = table.addRow();
                iRow.getCell("billType").setValue((Object)billTypes[i]);
                iRow.getCell("isFilterControl").setValue((Object)Boolean.TRUE);
                iRow.getCell("isSupportWeb").setValue((Object)Boolean.FALSE);
                if (!billTypes[i].getNumber().equals("EvectionReqBill") && !billTypes[i].getNumber().equals("DailyPurchaseAccountBill")) continue;
                iRow.getCell("isSupportWeb").getStyleAttributes().setLocked(Boolean.TRUE.booleanValue());
                iRow.getCell("isSupportWeb").getStyleAttributes().setBackground(Color.lightGray);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void submit_actionPerformed(ActionEvent e) throws Exception {
        super.submit_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IRow row = this.kdtEntries.addRow();
        row.getCell("isFilterControl").setValue((Object)false);
        row.getCell("isSupportWeb").setValue((Object)false);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        KDTable table = this.kdtEntries;
        if (this.kdtEntries == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null) continue;
                int index = -1;
                if (collection != null) {
                    for (int j = collection.size() - 1; j >= 0; --j) {
                        if (detailData != collection.getObject(j)) continue;
                        index = j;
                    }
                }
                if (index < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            BillTypeInfo info = (BillTypeInfo)this.kdtEntries.getCell(i, "billType").getValue();
            if (info != null) continue;
            throw new OperationException(OperationException.BILLTYPE_CANNOT_NULL);
        }
        final MonitorInfo info = new MonitorInfo(this.getUITitle(), null, (Object)this, true);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    BillMatchOperationOrExpenseEditUI.this.expenseTypeMatch();
                }
                catch (Exception e) {
                    BillMatchOperationOrExpenseEditUI.this.handUIException(e);
                }
                catch (Throwable ex) {
                    BillMatchOperationOrExpenseEditUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                BillMatchOperationOrExpenseEditUI.this.finishedSubmit();
            }
        };
        info.setWorker(worker);
        ThreadPool.addActionThread((MonitorInfo)info);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    private void expenseTypeMatch() throws Exception {
        int rowCount = this.kdtEntries.getRowCount();
        HashSet<ExpenseTypeEntryInfo> entryInfos = new HashSet<ExpenseTypeEntryInfo>();
        for (int i = 0; i < rowCount; ++i) {
            ExpenseTypeEntryInfo entryInfo = new ExpenseTypeEntryInfo();
            entryInfo.setBillType((BillTypeInfo)this.kdtEntries.getCell(i, "billType").getValue());
            entryInfo.setIsFilterControl((Boolean)this.kdtEntries.getCell(i, "isFilterControl").getValue());
            entryInfo.setIsSupportWeb((Boolean)this.kdtEntries.getCell(i, "isSupportWeb").getValue());
            entryInfos.add(entryInfo);
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        if (this.batchSpend.isSelected()) {
            this.batchAddExpenseBillMatch(this.collection, entryInfos, colls, true);
        } else if (this.batchAdd.isSelected()) {
            this.batchAddExpenseBillMatch(this.collection, entryInfos, colls, false);
        } else if (this.batchDelete.isSelected()) {
            this.batchDeleteExpenseBillMatch(this.collection, entryInfos, colls);
        }
    }

    private void finishedSubmit() {
        this.disposeUIWindow();
    }

    private void batchAddExpenseBillMatch(IObjectCollection collection, Set<ExpenseTypeEntryInfo> entryInfos, CoreBaseCollection colls, Boolean flag) throws Exception {
        for (int i = 0; i < collection.size(); ++i) {
            ExpenseTypeInfo expenseTypeInfo = (ExpenseTypeInfo)collection.getObject(i);
            ExpenseTypeEntryCollection entryColl = expenseTypeInfo.getEntry();
            HashSet<BOSUuid> billTypesId = new HashSet<BOSUuid>();
            for (int j = 0; j < entryColl.size(); ++j) {
                billTypesId.add(entryColl.get(j).getBillType().getId());
            }
            HashMap<BOSUuid, ExpenseTypeEntryInfo> map = new HashMap<BOSUuid, ExpenseTypeEntryInfo>();
            for (int j = 0; j < entryColl.size(); ++j) {
                map.put(entryColl.get(j).getBillType().getId(), entryColl.get(j));
            }
            if (!flag.booleanValue()) {
                entryColl.clear();
            }
            for (ExpenseTypeEntryInfo entryInfoTmp : entryInfos) {
                ExpenseTypeEntryInfo entryInfo = new ExpenseTypeEntryInfo();
                entryInfo.setId(BOSUuid.create((BOSObjectType)expenseTypeInfo.getBOSType()));
                entryInfo.setExpenseType(expenseTypeInfo);
                entryInfo.setBillType(entryInfoTmp.getBillType());
                entryInfo.setIsFilterControl(entryInfoTmp.isIsFilterControl());
                entryInfo.setIsSupportWeb(entryInfoTmp.isIsSupportWeb());
                if (flag.booleanValue()) {
                    if (!billTypesId.contains(entryInfo.getBillType().getId())) {
                        entryColl.add(entryInfo);
                        continue;
                    }
                    entryColl.removeObject((IObjectValue)map.get(entryInfo.getBillType().getId()));
                    entryColl.add(entryInfo);
                    continue;
                }
                entryColl.add(entryInfo);
            }
            expenseTypeInfo.setBillTypeName(this.setBillTypeName((CoreBaseInfo)expenseTypeInfo));
            expenseTypeInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            expenseTypeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            colls.add((CoreBaseInfo)expenseTypeInfo);
        }
        ExpenseTypeFactory.getRemoteInstance().updateBatchData(colls);
    }

    private void batchDeleteExpenseBillMatch(IObjectCollection collection, Set<ExpenseTypeEntryInfo> entryInfos, CoreBaseCollection colls) throws Exception {
        for (int i = 0; i < collection.size(); ++i) {
            ExpenseTypeInfo expenseTypeInfo = (ExpenseTypeInfo)collection.getObject(i);
            ExpenseTypeEntryCollection entryColl = expenseTypeInfo.getEntry();
            HashMap<BOSUuid, ExpenseTypeEntryInfo> map = new HashMap<BOSUuid, ExpenseTypeEntryInfo>();
            for (int j = 0; j < entryColl.size(); ++j) {
                map.put(entryColl.get(j).getBillType().getId(), entryColl.get(j));
            }
            for (ExpenseTypeEntryInfo entryInfo : entryInfos) {
                if (!map.containsKey(entryInfo.getBillType().getId())) continue;
                entryColl.removeObject((IObjectValue)map.get(entryInfo.getBillType().getId()));
            }
            expenseTypeInfo.setBillTypeName(this.setBillTypeName((CoreBaseInfo)expenseTypeInfo));
            colls.add((CoreBaseInfo)expenseTypeInfo);
        }
        ExpenseTypeFactory.getRemoteInstance().updateBatchData(colls);
    }

    private String setBillTypeName(CoreBaseInfo info) {
        StringBuffer stb = new StringBuffer();
        ExpenseTypeInfo expenseTypeInfo = (ExpenseTypeInfo)info;
        ExpenseTypeEntryCollection entryColl = expenseTypeInfo.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            ExpenseTypeEntryInfo entryInfo = entryColl.get(i);
            stb.append(this.billTypes.get(entryInfo.getBillType().getId())).append(", ");
        }
        String retrunValue = stb.toString();
        return retrunValue.length() > 0 ? retrunValue.substring(0, retrunValue.length() - 2) : "";
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }
}

