/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BudgetBalanceCollection;
import com.kingdee.eas.cp.bc.BudgetBalanceInfo;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.BudgetControlInfo;
import com.kingdee.eas.cp.bc.client.AbstractBudgetControlEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class BudgetControlEditUI
extends AbstractBudgetControlEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetControlEditUI.class);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    private BudgetControlInfo bcInfo = null;
    private BudgetControlInfo tempInfo = null;

    public BudgetControlEditUI() throws Exception {
        this.txtSumAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BudgetControlEditUI.this.averageChange(eventObj);
            }
        });
        this.chkIsStart.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                BudgetControlEditUI.this.setSumAccount(arg0);
            }
        });
    }

    private void setSumAccount(ItemEvent arg0) {
        if (arg0.getStateChange() == 1) {
            this.txtSumAccount.setEnabled(false);
        } else if (arg0.getStateChange() == 2) {
            this.txtSumAccount.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSumAccount.setRemoveingZeroInDispaly(false);
        this.txtSumAccount.setRemoveingZeroInEdit(false);
        this.txtYearTime.setGroupingUsed(false);
        this.txtYearTime.setRequired(true);
        this.txtSumAccount.setRequired(true);
        this.txtSumAccount.setHorizontalAlignment(4);
        this.txtSumAccount.setDataType(1);
        this.txtSumAccount.setPrecision(2);
        this.txtAverage.setDataType(1);
        this.txtAverage.setPrecision(2);
        this.txtAverage.setHorizontalAlignment(4);
        this.prmtExpenseSort.setRequired(true);
        this.prmtControlObj.setRequired(true);
        this.prmtExpenseSort.setEditable(true);
        this.prmtControlObj.setEditable(true);
        this.kdtEntries.getStyleAttributes().setLocked(true);
        this.kdtEntries.setEditable(false);
        this.kdtEntries.setColumnMoveable(true);
        KDCheckBox isAccumulate = new KDCheckBox();
        isAccumulate.setEnabled(true);
        this.kdtEntries.getColumn("isAdd").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isAccumulate));
        this.prmtExpenseSort.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmtExpenseSort.setEntityViewInfo(evi);
        if (this.chkIsStart.isSelected()) {
            this.txtSumAccount.setEnabled(false);
        }
        this.txtYearTime.setValue((Object)new Integer(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())).getYear() + 1900));
        this.initEntries(this.kdtEntries);
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.bcInfo = this.editData;
            this.tempInfo = (BudgetControlInfo)this.bcInfo.clone();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuTool.setVisible(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        BigDecimal obj;
        super.beforeStoreFields(e);
        if (this.txtYearTime.getIntegerValue() == null || this.txtYearTime.getIntegerValue().toString().length() != 4) {
            this.txtYearTime.requestFocus();
            throw new BudgetControlException(BudgetControlException.YEAR_NOT_CORRECT);
        }
        BigDecimal max = new BigDecimal("999999999999999999");
        BigDecimal bigDecimal = obj = this.txtSumAccount.getBigDecimalValue() == null ? new BigDecimal("0.00") : this.txtSumAccount.getBigDecimalValue();
        if (BudgetControlEditUI.toBigDecimal(obj).compareTo(max) > 0) {
            this.txtSumAccount.requestFocus();
            throw new BudgetControlException(BudgetControlException.SUMACCOUNT_TOO_BIG);
        }
        if (BudgetControlEditUI.toBigDecimal(obj).compareTo(new BigDecimal("0.00")) <= 0) {
            this.txtSumAccount.requestFocus();
            throw new BudgetControlException(BudgetControlException.SUMACCOUNT_NOT_ZERO);
        }
        if (this.prmtControlObj.getValue() == null) {
            this.prmtControlObj.requestFocus();
            throw new BudgetControlException(BudgetControlException.CONTROL_NOT_NULL);
        }
        if (this.prmtExpenseSort.getValue() == null) {
            throw new BudgetControlException(BudgetControlException.SORTNAME_NOT_NULL);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("yearBalance"));
        return sic;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BudgetBalanceInfo info = new BudgetBalanceInfo();
        info.setIsAdd(false);
        info.setFreezeAccount(new BigDecimal("0.00"));
        return info;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        BudgetControlInfo info = new BudgetControlInfo();
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setYearTime(new Date().getYear() + 1900);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BudgetControlFactory.getRemoteInstance();
    }

    private void averageChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != eventObj.getOldValue()) {
            this.setAverage((BigDecimal)eventObj.getNewValue());
            if (OprtState.EDIT.equals(this.getOprtState())) {
                this.setEntries_edit((BigDecimal)eventObj.getNewValue(), this.bcInfo == null ? (BigDecimal)eventObj.getOldValue() : this.bcInfo.getSumAccount());
            } else {
                this.setEntries((BigDecimal)eventObj.getNewValue());
            }
        }
    }

    private void setAverage(BigDecimal bd) {
        if (bd == null) {
            this.txtAverage.setValue((Object)new BigDecimal("0.00"));
            return;
        }
        this.txtAverage.setValue((Object)bd.divide(new BigDecimal("12"), 2));
    }

    private void setEntries_edit(BigDecimal newValue, BigDecimal oldValue) {
        BigDecimal tempBD = null;
        BigDecimal addedValue = null;
        int month = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())).getMonth();
        tempBD = newValue == null ? new BigDecimal("0.00") : newValue.divide(new BigDecimal("12"), 2);
        IRow row = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = month; i < n; ++i) {
            if (i == month) {
                addedValue = this.chkIsCumulate.getSelected() > 0 ? newValue.subtract(oldValue).divide(new BigDecimal("12"), 2).multiply(new BigDecimal(String.valueOf(month + 1))) : newValue.subtract(oldValue).divide(new BigDecimal("12"), 2);
                row = this.kdtEntries.getRow(i);
                row.getCell("monthAccount").setValue((Object)tempBD);
                BudgetBalanceInfo bbInfo = null;
                BudgetBalanceCollection tempCollection = this.bcInfo.getEntries();
                if (tempCollection == null || tempCollection.size() <= 0) continue;
                bbInfo = tempCollection.get(month);
                row.getCell("monthBalance").setValue((Object)bbInfo.getMonthBalance().add(addedValue));
                continue;
            }
            row = this.kdtEntries.getRow(i);
            row.getCell("monthAccount").setValue((Object)tempBD);
            row.getCell("monthBalance").setValue((Object)tempBD);
        }
        if (this.chkIsCumulate.getSelected() > 0 && this.bcInfo != null) {
            this.bcInfo.setYearBalance(this.tempInfo.getYearBalance().add(newValue.subtract(oldValue)));
        } else if (this.bcInfo != null) {
            this.bcInfo.setYearBalance(this.tempInfo.getYearBalance().add(newValue.subtract(oldValue)).divide(new BigDecimal("12"), 2).multiply(new BigDecimal(String.valueOf(12 - month))));
        }
    }

    private void setEntries(BigDecimal bd) {
        BigDecimal tempBD = null;
        tempBD = bd == null ? new BigDecimal("0.00") : bd.divide(new BigDecimal("12"), 2);
        IRow row = null;
        if (this.kdtEntries.getRowCount() <= 0) {
            this.initEntries(this.kdtEntries);
        }
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntries.getRow(i);
            row.getCell("monthAccount").setValue((Object)tempBD);
            row.getCell("monthBalance").setValue((Object)tempBD);
        }
    }

    private void initEntries(KDTable table) {
        IObjectValue detailData = null;
        IRow row = null;
        if (table.getRowCount() > 0) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            row = table.addRow();
            detailData = this.createNewDetailData(table);
            ((BudgetBalanceInfo)detailData).setMonthTime((short)i);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, detailData);
        }
    }

    protected static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String str = obj.toString().trim();
        if (str.matches("\\d+\\.?\\d*")) {
            return new BigDecimal(str);
        }
        return ZERO;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsStart.getSelected() == 32) {
            throw new BudgetControlException(BudgetControlException.START_NOT_DELETE);
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.chkIsStart.isSelected()) {
            this.txtSumAccount.setEnabled(false);
        }
    }
}

