/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.client.AbstractBudgetControlForViewListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetControlForViewListUI
extends AbstractBudgetControlForViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetControlForViewListUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String numberFormat = CtrlFormatUtilities.getDecimalFormatString();
        this.tblMain.getColumn("entries.monthBalance").getStyleAttributes().setNumberFormat(numberFormat);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnView.setVisible(false);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        Map txt = this.getUIContext();
        ExpenseSortInfo sortInfo = null;
        CostCenterOrgUnitInfo costInfo = null;
        boolean markSort = false;
        boolean markObj = false;
        int year = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())).getYear() + 1900;
        int month = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())).getMonth() + 1;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        Object tempObj = txt.get("expenseSort");
        if (tempObj != null) {
            sortInfo = (ExpenseSortInfo)tempObj;
            filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)sortInfo.getId().toString(), CompareType.EQUALS));
            markSort = true;
        }
        if ((tempObj = txt.get("controlObj")) != null) {
            costInfo = (CostCenterOrgUnitInfo)tempObj;
            filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)costInfo.getId().toString(), CompareType.EQUALS));
            markObj = true;
        }
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ENTRIES.MONTHTIME", (Object)new Integer(month), CompareType.EQUALS));
        String tempStr = "#0 and #1 and #2 ";
        if (markSort) {
            tempStr = tempStr + " and  #3 ";
        }
        if (markObj) {
            tempStr = markSort ? tempStr + " and #4 " : tempStr + " and #3 ";
        }
        filter.setMaskString(tempStr);
        ev.setFilter(filter);
        super.beforeExcutQuery(ev);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BudgetControlFactory.getRemoteInstance();
    }
}

