/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpEmpBankAccException;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.client.AbstractCollectionAccountEditUI;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class CollectionAccountEditUI
extends AbstractCollectionAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CollectionAccountEditUI.class);
    public static final String RES = "com.kingdee.eas.cp.bc.client.ExpAccResource";
    private boolean isBebankChange = true;
    private boolean isClearApplier = true;
    private boolean isBebankEdit = false;
    private boolean isFireChange = true;

    @Override
    public void storeFields() {
        if (this.chkIsDefault.isSelected()) {
            this.editData.setIsDefault(true);
        } else {
            this.editData.setIsDefault(false);
        }
        if (this.chkIsPublicAccount.isSelected()) {
            this.editData.setIsPublicAccount(true);
        } else {
            this.editData.setIsPublicAccount(false);
        }
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.privateVerifyModel()) {
            this.storeFields();
            super.actionSubmit_actionPerformed(e);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        CollectionAccountInfo info = new CollectionAccountInfo();
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CollectionAccountFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.privateVerifyModel();
    }

    public boolean privateVerifyModel() throws ExpEmpBankAccException {
        boolean result = true;
        if (this.txtPayee.getText() == null || StringUtils.isEmpty((String)this.txtPayee.getText())) {
            result = false;
            throw new ExpEmpBankAccException(ExpEmpBankAccException.PAYEE_NOT_NULL);
        }
        if (this.kDTextBankStr.getText() == null || StringUtils.isEmpty((String)this.kDTextBankStr.getText())) {
            result = false;
            throw new ExpEmpBankAccException(ExpEmpBankAccException.BEBANK_NOT_NULL);
        }
        if (this.txtBankAccount.getText() == null || StringUtils.isEmpty((String)this.txtBankAccount.getText())) {
            result = false;
            throw new ExpEmpBankAccException(ExpEmpBankAccException.BANKACCOUNT_NOT_NULL);
        }
        return result;
    }

    public void onLoad() throws Exception {
        String creatorId;
        super.onLoad();
        this.initParam();
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.kDTextBankStr.setEditable(this.isBebankEdit);
        this.menuBiz.setVisible(false);
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String string = creatorId = this.editData.getCreator() != null ? this.editData.getCreator().getId().toString() : "";
        if (this.oprtState == "EDIT" && !currentUserId.equals(creatorId)) {
            this.chkIsShare.setEnabled(false);
        }
        this.prmtBebank.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getOldValue() == eventObj.getNewValue() || !CollectionAccountEditUI.this.isBebankChange) {
                    return;
                }
                if (eventObj.getNewValue() == null) {
                    CollectionAccountEditUI.this.kDTextBankStr.setText(null);
                }
                if (eventObj.getNewValue() != null && eventObj.getNewValue() instanceof BEBankInfo) {
                    CollectionAccountEditUI.this.kDTextBankStr.setText(((BEBankInfo)eventObj.getNewValue()).getName(CollectionAccountEditUI.this.getCurrentLocale()), false);
                }
            }
        });
        this.kDTextBankStr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextBankStrChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextBankStrChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextBankStrChange(e);
            }
        });
        MakeControl.makeCommonApplierF7(this.prmtPayee);
        this.prmtPayee.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getOldValue() == eventObj.getNewValue()) {
                    return;
                }
                if (eventObj.getNewValue() == null) {
                    CollectionAccountEditUI.this.txtPayee.setText(null);
                }
                if (eventObj.getNewValue() != null && eventObj.getNewValue() instanceof PersonInfo) {
                    PersonInfo personInfo = (PersonInfo)eventObj.getNewValue();
                    CollectionAccountEditUI.this.txtPayee.setText(personInfo.getName(CollectionAccountEditUI.this.getCurrentLocale()), false);
                    CollectionAccountEditUI.this.prmtApplier.setValue(eventObj.getNewValue());
                    CollectionAccountEditUI.this.setDefault();
                }
            }
        });
        this.txtPayee.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextPayeeChange(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextPayeeChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CollectionAccountEditUI.this.kDTextPayeeChange(e);
            }
        });
    }

    protected void initParam() throws EASBizException, BOSException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP053");
        paramList.add("CP078");
        Map paramMap = ExpenseCommenFacadeFactory.getRemoteInstance().getParams(paramList);
        this.isClearApplier = paramMap.get("CP078") == null ? true : new Boolean(paramMap.get("CP078").toString());
        this.isBebankEdit = paramMap.get("CP053") == null ? false : new Boolean(paramMap.get("CP053").toString());
    }

    public void kDTextBankStrChange(DocumentEvent e) {
        BEBankInfo bEBankInfo = (BEBankInfo)this.prmtBebank.getData();
        String textBankStr = this.kDTextBankStr.getText();
        if (bEBankInfo != null && !StringUtils.isEmpty((String)textBankStr) && !textBankStr.equals(bEBankInfo.getName())) {
            this.prmtBebank.setDataNoNotify(null);
        }
    }

    public void kDTextPayeeChange(DocumentEvent e) {
        if (!this.isFireChange) {
            return;
        }
        if (this.isClearApplier) {
            this.prmtApplier.setValue(null);
        }
        this.setDefault();
    }

    protected void setDefault() {
        if (this.prmtApplier.getValue() != null) {
            this.chkIsDefault.setEnabled(true);
        } else {
            this.chkIsDefault.setEnabled(false);
            this.chkIsDefault.setSelected(false);
        }
    }

    @Override
    public void loadFields() {
        this.isFireChange = false;
        super.loadFields();
        this.isFireChange = true;
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        if (this.editData.getState().equals((Object)EnableStateEnum.DISABLE)) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        if (this.editData.isIsDefault()) {
            this.actionRemove.setEnabled(false);
        }
        this.setDefault();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.editData == null) {
            return;
        }
        this.actionRemove.setEnabled(true);
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.actionRemove.setEnabled(false);
        }
        if (this.editData.isIsDefault()) {
            this.actionRemove.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        if (sic == null) {
            sic = new SelectorItemCollection();
        }
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String creatorId;
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String string = creatorId = this.editData.getCreator() != null ? this.editData.getCreator().getId().toString() : "";
        if (this.editData.isIsShare() && !currentUserId.equals(creatorId)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SHARED_COLLECTIONINFO_ONLY_EDITED_BY_CREATOR"));
            SysUtil.abort();
        }
        if (!currentUserId.equals(creatorId)) {
            this.chkIsShare.setEnabled(false);
        }
        this.isFireChange = false;
        super.actionEdit_actionPerformed(e);
        this.isFireChange = true;
        try {
            if (!this.isBebankEdit) {
                this.kDTextBankStr.setEditable(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

