/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.easprogressbar.KDProgressBar;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.ProxyReimburseCollection;
import com.kingdee.eas.cp.bc.ProxyReimburseFactory;
import com.kingdee.eas.cp.bc.UpgradeBillFacadeFactory;
import com.kingdee.eas.cp.bc.client.AbstractCollectionAccountListUI;
import com.kingdee.eas.cp.bc.client.CollectionAccountEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectionAccountListUI
extends AbstractCollectionAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(CollectionAccountListUI.class);
    public static final String RES = "com.kingdee.eas.cp.bc.client.ExpAccResource";
    private static final String COLLECTIONAACCOUNT_VIEW = "cp_bc_CollectionAccount";
    private KDLabel kDLabelMarkSucc = new KDLabel();
    private KDFrame updateBeBankFrame = null;
    private String UPDATEBEBANK_PERMISSION = "cp_bc_CollectionAccount_updateBeBank";

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"payee", "bankAccount"};
        return locateNames;
    }

    public CollectionAccountListUI() throws Exception {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user != null && user.getType() != null && user.getType() != UserType.PERSON) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"userTypeIsWrong"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        boolean hasFunctionPermission = BizCollUtil.hasFunctionPermission(null, this.UPDATEBEBANK_PERMISSION);
        if (!hasFunctionPermission) {
            this.actionUpdateBeBank.setVisible(false);
            this.actionUpdateBeBank.setEnabled(false);
        }
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    CollectionAccountListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionUpdateBeBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e == null) {
            return;
        }
        KDTSelectBlock selectBlock = e.getSelectBlock();
        if (selectBlock == null) {
            return;
        }
        String applier = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        int size = this.tblMain.getSelectManager().size();
        this.actionRemove.setEnabled(true);
        this.actionEdit.setEnabled(true);
        String stateType = "";
        boolean hasEnable = false;
        boolean hasDefault = false;
        boolean isBanByShare = false;
        boolean hasPermission = BizCollUtil.isHasPermission(COLLECTIONAACCOUNT_VIEW);
        block0: for (int i = 0; i < size; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            int k = selectBlock.getBottom();
            int bottom = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= bottom; ++j) {
                IRow row = this.tblMain.getRow(j);
                BizEnumValueDTO enuminfo = (BizEnumValueDTO)row.getCell("state").getValue();
                String creatorId = (String)row.getCell("applier.id").getValue();
                if (enuminfo != null && enuminfo.getInt() == 1) {
                    hasEnable = true;
                }
                if (Boolean.valueOf(row.getCell("isDefault").getValue().toString()).booleanValue()) {
                    hasDefault = true;
                }
                if (!hasPermission && Boolean.valueOf(row.getCell("isShare").getValue().toString()).booleanValue() && creatorId != currentUserId) {
                    isBanByShare = true;
                }
                if (k == j) {
                    this.actionEdit.setEnabled(hasEnable);
                    continue block0;
                }
                this.actionEdit.setEnabled(false);
            }
        }
        this.btnCancelCancel.setEnabled(!hasEnable && (hasPermission || !hasPermission && !isBanByShare));
        this.btnCancel.setEnabled(hasEnable && (hasPermission || !hasPermission && !isBanByShare));
        this.actionRemove.setEnabled(!hasEnable && !hasDefault && (hasPermission || !hasPermission && !isBanByShare));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ICollectionAccount iCollectionAccount = CollectionAccountFactory.getRemoteInstance();
        if (iCollectionAccount.isDefault(this.getSelectedIdList())) {
            this.confirmDialog(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"DEFUALT_ACCOUNT_NO_DISABLED"));
            return;
        }
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            iCollectionAccount.changeState(this.getSelectedIdList(), false);
        }
        this.refresh(e);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            CollectionAccountFactory.getRemoteInstance().changeState(this.getSelectedIdList(), true);
        }
        this.refresh(e);
    }

    @Override
    protected String getEditUIName() {
        return CollectionAccountEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CollectionAccountFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (BizCollUtil.isHasPermission(COLLECTIONAACCOUNT_VIEW)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isShare", (Object)1, CompareType.EQUALS));
            String MaskString = "(#0 or #1)";
            filter.setMaskString(MaskString);
        } else {
            String applierId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            String creatorId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            StringBuffer maskString = new StringBuffer();
            maskString.append("(#0 or #1 ");
            filter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)applierId));
            filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)creatorId));
            HashSet<String> proxyPersonIds = new HashSet<String>();
            int maskIndex = 2;
            try {
                String queryOql = "select reimbursePerson.id where proxyPerson.id = '%s' and state = 1";
                ProxyReimburseCollection proxyReimburseCollection = ProxyReimburseFactory.getRemoteInstance().getProxyReimburseCollection(String.format(queryOql, applierId));
                int is = proxyReimburseCollection.size();
                for (int i = 0; i < is; ++i) {
                    if (proxyReimburseCollection.get(i).getReimbursePerson() == null) continue;
                    proxyPersonIds.add(proxyReimburseCollection.get(i).getReimbursePerson().getId().toString());
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (proxyPersonIds != null && proxyPersonIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("applier.id", proxyPersonIds, CompareType.INCLUDE));
                maskString.append(" or #" + maskIndex++);
            }
            Set proxyCenterApplierIds = new HashSet();
            try {
                proxyCenterApplierIds = CommonUtilFacadeFactory.getRemoteInstance().getCollectionAccounts(applierId);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (proxyCenterApplierIds != null && proxyCenterApplierIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("applier.id", proxyCenterApplierIds, CompareType.INCLUDE));
                maskString.append(" or #" + maskIndex++);
            }
            filter.getFilterItems().add(new FilterItemInfo("isShare", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            maskString.append(" or ( #" + maskIndex++);
            maskString.append(" and  #" + maskIndex++);
            maskString.append(" ) )");
            filter.setMaskString(maskString.toString());
        }
        return filter;
    }

    private List getSelectedIdList() {
        this.checkSelected();
        ArrayList<Object> ids = new ArrayList<Object>();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        int num = 0;
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            num = sb.getBottom();
            for (int j = sb.getTop(); j <= num; ++j) {
                row = this.tblMain.getRow(j);
                ids.add(row.getCell("id").getValue());
            }
        }
        return ids;
    }

    @Override
    public void actionUpdateBeBank_actionPerformed(ActionEvent e) throws Exception {
        JPanel tempPanel = new JPanel();
        KDProgressBar pbar = new KDProgressBar();
        pbar.setMinimum(0);
        pbar.setIndeterminate(true);
        tempPanel.add((Component)pbar);
        tempPanel.setBounds(new Rectangle(10, 10, 300, 62));
        tempPanel.setLayout(null);
        tempPanel.setPreferredSize(new Dimension(300, 62));
        pbar.setBounds(new Rectangle(15, 29, 280, 19));
        tempPanel.add((Component)pbar, null);
        tempPanel.setLayout(null);
        this.kDLabelMarkSucc.setVisible(true);
        this.kDLabelMarkSucc.setBounds(new Rectangle(75, 10, 170, 19));
        this.kDLabelMarkSucc.setHorizontalAlignment(0);
        tempPanel.add((Component)this.kDLabelMarkSucc, null);
        this.kDLabelMarkSucc.setText(EASResource.getString((String)RES, (String)"ISUPDATE"));
        this.updateBeBankFrame = new KDFrame(EASResource.getString((String)RES, (String)"UPDATEBEBANK"));
        this.updateBeBankFrame.setSize(new Dimension(300, 62));
        this.updateBeBankFrame.setContentPane((Container)tempPanel);
        this.updateBeBankFrame.pack();
        this.updateBeBankFrame.setLayout(null);
        this.updateBeBankFrame.setResizable(false);
        this.updateBeBankFrame.setLocationRelativeTo(null);
        this.updateBeBankFrame.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Map resultMap = UpgradeBillFacadeFactory.getRemoteInstance().updateCollectionBeBank(null);
                    int count = 0;
                    int succUpdateCount = 0;
                    int failUpdateCount = 0;
                    List failIds = new ArrayList();
                    if (resultMap.get("count") != null) {
                        count = (Integer)resultMap.get("count");
                    }
                    if (resultMap.get("succUpdateCount") != null) {
                        succUpdateCount = (Integer)resultMap.get("succUpdateCount");
                    }
                    if (resultMap.get("failIds") != null) {
                        failIds = (List)resultMap.get("failIds");
                        failUpdateCount = failIds.size();
                    }
                    CollectionAccountListUI.this.updateBeBankFrame.dispose();
                    StringBuffer msg = new StringBuffer();
                    StringBuffer DeMsg = new StringBuffer();
                    msg = msg.append(EASResource.getString((String)CollectionAccountListUI.RES, (String)"UPDATEBEBANKSUCC", (Object[])new Object[]{String.valueOf(count), String.valueOf(succUpdateCount + failUpdateCount), String.valueOf(succUpdateCount), String.valueOf(failUpdateCount)}));
                    if (failUpdateCount > 0) {
                        DeMsg.append(EASResource.getString((String)CollectionAccountListUI.RES, (String)"UPDATEBEBANKERRORMSG")).append(": '").append(StringUtils.join((Object[])failIds.toArray(), (String)"','")).append("'");
                    }
                    if (DeMsg.length() > 0) {
                        MsgBox.showDetailAndOK(null, (String)msg.toString(), (String)DeMsg.toString(), (int)0);
                    } else {
                        MsgBox.showInfo((String)msg.toString());
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    CollectionAccountListUI.this.updateBeBankFrame.dispose();
                    MsgBox.showInfo((String)EASResource.getString((String)CollectionAccountListUI.RES, (String)"UPDATEBEBANKFAIL"));
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    CollectionAccountListUI.this.updateBeBankFrame.dispose();
                    MsgBox.showInfo((String)EASResource.getString((String)CollectionAccountListUI.RES, (String)"UPDATEBEBANKFAIL"));
                }
            }
        }).start();
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isShare;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0 && (isShare = ((Boolean)this.tblMain.getRow(selectRows[0]).getCell("isShare").getValue()).booleanValue())) {
            String userInfoId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            if (this.tblMain.getRow(selectRows[0]).getCell("creator.id").getValue() == null || !userInfoId.equals((String)this.tblMain.getRow(selectRows[0]).getCell("creator.id").getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SHARED_COLLECTIONINFO_ONLY_EDITED_BY_CREATOR"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }
}

