/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.client.AbstractDapVoucherListUI;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DapVoucherListUI
extends AbstractDapVoucherListUI {
    private static final Logger logger = CoreUIObject.getLogger(DapVoucherListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.BizCollResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        String billid = ctx.get("billid").toString();
        List voucherList = CommonUtilFacadeFactory.getRemoteInstance().getDapVoucherInfos(billid);
        this.fillDataToVoucherRcrdsTable(voucherList);
        int columns = this.kdSourceBills.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            this.kdSourceBills.getColumn(i).setSortable(true);
        }
        this.kdSourceBills.setEditable(false);
        this.kdSourceBills.getSelectManager().setSelectMode(2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void checkSelected() {
        if (this.kdSourceBills.getRowCount() == 0 || this.kdSourceBills.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDBtnOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"is_do_delete"));
        if (result == 0) {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdSourceBills);
            IRow row = null;
            String voucherId = null;
            for (int i = 0; i < rows.length; ++i) {
                row = this.kdSourceBills.getRow(rows[i]);
                voucherId = (String)row.getCell("id").getValue();
                if (voucherId == null) continue;
                VoucherFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(voucherId));
                BOTRelationFactory.getRemoteInstance().removeRelationByDestObjId(voucherId, null);
                this.kdSourceBills.removeRow(rows[i]);
            }
        }
    }

    @Override
    protected void kDBtnCal_actionPerformed(ActionEvent e) throws Exception {
        super.kDBtnCal_actionPerformed(e);
        this.getUIWindow().close();
    }

    private void initKDTable(KDTable tbl, int rowNum) {
        tbl.checkParsed();
        tbl.addRows(rowNum);
    }

    private void fillDataToVoucherRcrdsTable(List infos) {
        this.kdSourceBills.removeRows();
        this.kdSourceBills.setEditable(false);
        if (infos != null && infos.size() <= 0) {
            KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
            sort.setSortAuto(true);
            this.kdSourceBills.setSortMange(sort);
            return;
        }
        int rowNum = infos.size();
        this.initKDTable(this.kdSourceBills, rowNum);
        for (int i = 0; i < rowNum; ++i) {
            Map info = (Map)infos.get(i);
            if (info == null) continue;
            this.kdSourceBills.getCell(i, 0).setValue(info.get("voucherType"));
            this.kdSourceBills.getCell(i, 1).setValue(info.get("number"));
            this.kdSourceBills.getCell(i, 2).setValue(info.get("bizReqDate"));
            this.kdSourceBills.getCell(i, 3).setValue(info.get("cause"));
            this.kdSourceBills.getCell(i, 4).setValue(info.get("debitAmount"));
            this.kdSourceBills.getCell(i, 5).setValue(info.get("creditAmount"));
            this.kdSourceBills.getCell(i, 6).setValue(info.get("state"));
            this.kdSourceBills.getCell(i, 7).setValue(info.get("id"));
        }
        this.kdSourceBills.checkParsed();
        KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
        sort.setSortAuto(true);
        sort.addGroup(0, this.kdSourceBills.getRowCount() - 2);
        this.kdSourceBills.setSortMange(sort);
    }
}

