/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractExpenseAccountListUI;
import com.kingdee.eas.cp.bc.client.BizAccountEditUI;
import com.kingdee.eas.cp.bc.client.DailyAccountEditUI;
import com.kingdee.eas.cp.bc.client.ExpenseQueryUI;
import com.kingdee.eas.cp.bc.client.MarketAccountEditUI;
import com.kingdee.eas.cp.bc.client.TravelAccountEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class ExpenseAccountListUI
extends AbstractExpenseAccountListUI {
    private static TextRender render = new TextRender();
    private static int NOTHING = -1;
    private CommonQueryDialog dialog;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bizReqDate").getStyleAttributes().setNumberFormat(MultilingualUtil.getDateFormatString());
        this.tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getCurrencyFormatString());
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("billTypeCode").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object == null) {
                    return;
                }
                String text = BizCollBillTypeEnum.getEnum(Integer.parseInt(object.toString())).toString();
                render.draw(graphics, clip, text, cellStyle);
            }
        });
        this.tblMain.getColumn("state").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object == null) {
                    return;
                }
                String text = StateEnum.getEnum(Integer.parseInt(object.toString())).toString();
                render.draw(graphics, clip, text, cellStyle);
            }
        });
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.afterSelectLine(e);
    }

    private void afterSelectLine(KDTSelectEvent e) {
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionCreateTo.setVisible(false);
        ICell cell = null;
        ICell cellBill = null;
        StateEnum state = null;
        boolean isSameBill = false;
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            cell = this.tblMain.getRow(rowNum).getCell("state");
            if (cell == null || cell.getValue() == null) {
                return;
            }
            state = StateEnum.getEnum(Integer.parseInt(cell.getValue().toString()));
        } else {
            StateEnum stateOld = null;
            Object typeOld = null;
            BizCollBillTypeEnum type = null;
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    cell = this.tblMain.getRow(j).getCell("state");
                    cellBill = this.tblMain.getRow(j).getCell(this.getEditValue());
                    if (cell == null || cell.getValue() == null || cellBill == null || cellBill.getValue() == null) {
                        return;
                    }
                    state = StateEnum.getEnum(Integer.parseInt(cell.getValue().toString()));
                    type = BizCollBillTypeEnum.getEnum(Integer.parseInt(cellBill.getValue().toString()));
                    if (typeOld != null && !typeOld.equals((Object)type)) {
                        return;
                    }
                    if (stateOld != null && !stateOld.equals((Object)state)) {
                        return;
                    }
                    stateOld = state;
                }
            }
        }
        this.enableByState(state);
    }

    private void enableByState(StateEnum state) {
        boolean isVoucher = StateEnum.CHECKED.equals((Object)state) || StateEnum.ALREADYPAYMENT.equals((Object)state);
        this.actionVoucher.setVisible(isVoucher);
        this.actionDelVoucher.setVisible(isVoucher);
        this.actionCreateTo.setVisible(StateEnum.CHECKED.equals((Object)state));
    }

    private void setStateByBill(boolean isSameBill) {
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
        }
        if (this.dialog.show()) {
            this.mainQuery = this.getEntityViewInfo(this.dialog.getEntityViewInfoResult());
            SorterItemInfo sort = new SorterItemInfo("bizReqDate");
            sort.setSortType(SortType.DESCEND);
            this.mainQuery.getSorter().add(sort);
            this.refreshList();
            if (this.mainQuery.getSorter() != null) {
                this.mainQuery.getSorter().clear();
            }
        } else {
            SysUtil.abort();
        }
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        try {
            if (this.getUIWindow() == null) {
                dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                dialog.setOwner((Component)((Object)this));
            }
            dialog.setShowSorter(false);
            dialog.setShowToolbar(true);
            dialog.clearUserPanels();
            dialog.addUserPanel((KDPanel)new ExpenseQueryUI());
            dialog.setHeight(280);
            dialog.setWidth(500);
        }
        catch (Exception e) {
            dialog.clearUserPanels();
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(this.mainQuery);
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    @Override
    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public SelectorItemCollection getBOTPSelectors() {
        int select = this.getSelectedEditValue();
        if (select == NOTHING) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("tel"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("prior"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("supportedObj.number"));
        sic.add(new SelectorItemInfo("supportedObj.name"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("expenseType.typeName"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("fundPlan.name"));
        sic.add(new SelectorItemInfo("fundPlan.number"));
        sic.add(new SelectorItemInfo("budgetAmount"));
        sic.add(new SelectorItemInfo("budgetBalance"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountStriked"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountRefunded"));
        sic.add(new SelectorItemInfo("payMode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        switch (select) {
            case 90: {
                sic.add(new SelectorItemInfo("entries.id"));
                sic.add(new SelectorItemInfo("entries.name"));
                sic.add(new SelectorItemInfo("entries.purpose"));
                sic.add(new SelectorItemInfo("entries.happenTime"));
                sic.add(new SelectorItemInfo("entries.comment"));
                sic.add(new SelectorItemInfo("entries.amount"));
                break;
            }
            case 80: {
                sic.add(new SelectorItemInfo("entries.id"));
                sic.add(new SelectorItemInfo("entries.name"));
                sic.add(new SelectorItemInfo("entries.purpose"));
                sic.add(new SelectorItemInfo("entries.happenTime"));
                sic.add(new SelectorItemInfo("entries.comment"));
                sic.add(new SelectorItemInfo("entries.amount"));
                break;
            }
            case 100: {
                sic.add(new SelectorItemInfo("entries.id"));
                sic.add(new SelectorItemInfo("entries.name"));
                sic.add(new SelectorItemInfo("entries.purpose"));
                sic.add(new SelectorItemInfo("entries.happenTime"));
                sic.add(new SelectorItemInfo("entries.amount"));
                sic.add(new SelectorItemInfo("entries.measurement.number"));
                sic.add(new SelectorItemInfo("entries.measurement.name"));
                sic.add(new SelectorItemInfo("entries.count"));
                sic.add(new SelectorItemInfo("entries.price"));
                break;
            }
            case 110: {
                sic.add(new SelectorItemInfo("entries.id"));
                sic.add(new SelectorItemInfo("entries.from"));
                sic.add(new SelectorItemInfo("entries.to"));
                sic.add(new SelectorItemInfo("entries.startDate"));
                sic.add(new SelectorItemInfo("entries.endDate"));
                sic.add(new SelectorItemInfo("entries.vehicle"));
                sic.add(new SelectorItemInfo("entries.taxiExpense"));
                sic.add(new SelectorItemInfo("entries.bussesExpense"));
                sic.add(new SelectorItemInfo("entries.hotelExpense"));
                sic.add(new SelectorItemInfo("entries.otherExpense"));
                sic.add(new SelectorItemInfo("entries.amount"));
                break;
            }
        }
        return sic;
    }

    private int getSelectedEditValue() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return NOTHING;
            }
            ICell cell = row.getCell(this.getEditValue());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return Integer.parseInt(keyValue.toString());
            }
        }
        return NOTHING;
    }

    public String getEntriesPKName() {
        return "entries.id";
    }

    public String getEntriesName() {
        return "entries";
    }

    private String getEditValue() {
        return "billTypeCode";
    }

    @Override
    protected BizCollBillTypeEnum[] fillBillType() {
        return new BizCollBillTypeEnum[]{BizCollBillTypeEnum.BIZ_ACCOUNT, BizCollBillTypeEnum.MARKET_ACCOUNT, BizCollBillTypeEnum.DAILY_PURCHASE_ACCOUNT, BizCollBillTypeEnum.TRAVEL_ACCOUNT};
    }

    protected String getEditUIName() {
        if (this.getBillType() != null) {
            switch (this.getBillType().getValue()) {
                case 90: {
                    return BizAccountEditUI.class.getName();
                }
                case 80: {
                    return MarketAccountEditUI.class.getName();
                }
                case 100: {
                    return DailyAccountEditUI.class.getName();
                }
                case 110: {
                    return TravelAccountEditUI.class.getName();
                }
            }
            return BizAccountEditUI.class.getName();
        }
        return BizCollUtil.getEditUINameByID(this.getSelectedKeyValue());
    }

    private boolean canPayment(ArrayList list) {
        return true;
    }

    @Override
    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        ArrayList billIdlist = this.getSelectedIdValues();
        if (!this.canPayment(billIdlist)) {
            return;
        }
        super.actionCreateTo_actionPerformed(e);
        IExpenseAccountBill expense = (IExpenseAccountBill)this.getBizInterface();
        if (expense == null) {
            return;
        }
        Iterator ite = billIdlist.iterator();
        while (ite.hasNext()) {
            expense.wfPayment(BOSUuid.read((String)ite.next().toString()));
        }
    }

    private boolean canVoucher(ArrayList list) {
        return true;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList billIdlist = this.getSelectedIdValues();
        if (!this.canVoucher(billIdlist)) {
            return;
        }
        super.actionVoucher_actionPerformed(e);
        IExpenseAccountBill expense = (IExpenseAccountBill)this.getBizInterface();
        if (expense == null) {
            return;
        }
        Iterator ite = billIdlist.iterator();
        while (ite.hasNext()) {
            expense.wfGenVoucher(BOSUuid.read((String)ite.next().toString()));
        }
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return BizAccountBillFactory.getRemoteInstance();
        }
        return BizCollUtil.getBizInterfaceByID(this.getSelectedKeyValue());
    }

    private void calCreateBill() {
        BizCollBillTypeEnum[] billTypes = new BizCollBillTypeEnum[]{BizCollBillTypeEnum.DAILY_LOAN, BizCollBillTypeEnum.OTHER_EXPENSE, BizCollBillTypeEnum.EVECTION_LOAN, BizCollBillTypeEnum.EVECTION_REQ};
    }

    @Override
    public boolean isPrepareActionTraceUp() {
        return true;
    }

    @Override
    public boolean isPrepareActionTraceDown() {
        return true;
    }
}

