/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseFilterParam;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractExpenseQueryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.AbstractButton;

public class ExpenseQueryUI
extends AbstractExpenseQueryUI {
    private final String RES_EXPENSE = "com.kingdee.eas.cp.bc.client.ExpAccResource";
    private final String ALL = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpAccResource", (String)"all");
    private ExpenseFilterParam param;

    public ExpenseQueryUI() throws Exception {
        this.initData();
    }

    private void initData() {
        this.grpState = new KDButtonGroup();
        this.grpState.add((AbstractButton)this.btnAll);
        this.btnDraft.setUserObject((Object)StateEnum.DRAFT);
        this.grpState.add((AbstractButton)this.btnDraft);
        this.btnChecking.setUserObject((Object)StateEnum.CHECKING);
        this.grpState.add((AbstractButton)this.btnChecking);
        this.btnCheckFaild.setUserObject((Object)StateEnum.CHECKFAILD);
        this.grpState.add((AbstractButton)this.btnCheckFaild);
        this.btnCancel.setUserObject((Object)StateEnum.SUBMIT);
        this.grpState.add((AbstractButton)this.btnCancel);
        this.btnChecked.setUserObject((Object)StateEnum.CHECKED);
        this.grpState.add((AbstractButton)this.btnChecked);
        this.btnAlreadyPay.setUserObject((Object)StateEnum.ALREADYPAYMENT);
        this.grpState.add((AbstractButton)this.btnAlreadyPay);
        this.btnClose.setUserObject((Object)StateEnum.CLOSED);
        this.grpState.add((AbstractButton)this.btnClose);
        this.grpState.setSelected(this.btnAll.getModel(), true);
        MakeControl.makeCostCentorF7(this.prmtCostCenter, (CoreUIObject)this);
        MakeControl.makeMutiApplierF7(this.prmtApplier, false);
        MakeControl.makeCurrency(this.prmtCurrency);
        this.initDate();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.pkDateFrom.setValue((Object)cal.getTime());
        this.pkDateTo.setValue((Object)date);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        if (this.pkDateFrom.getValue() != null) {
            Date dtFrom = (Date)this.pkDateFrom.getValue();
            fic.add(new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.truncateDate((Date)dtFrom), CompareType.GREATER_EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.pkDateTo.getValue() != null) {
            Date dtTo = (Date)this.pkDateTo.getValue();
            dtTo = DateTimeUtils.addDay((Date)dtTo, (long)1L);
            fic.add(new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.format((Date)dtTo), CompareType.LESS_EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtCurrency.getData() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
            fic.add(new FilterItemInfo("currencyType.id", (Object)currency.getId().toString(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (!BizCollUtil.objectIsNull(this.txtName.getText())) {
            fic.add(new FilterItemInfo("name", (Object)("%" + this.txtName.getText() + "%"), CompareType.LIKE));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtCostCenter.getData() != null) {
            CostCenterOrgUnitInfo costCenter = (CostCenterOrgUnitInfo)this.prmtCostCenter.getData();
            fic.add(new FilterItemInfo("costedDept.id", (Object)costCenter.getId().toString(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            fic.add(new FilterItemInfo("number", (Object)("%" + this.txtNumberFrom.getText() + "%"), CompareType.LIKE));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.grpState.getSelection() != this.btnAll.getModel()) {
            fic.add(new FilterItemInfo("state", this.getSelectedState(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtApplier.getData() != null) {
            PersonInfo person = (PersonInfo)this.prmtApplier.getData();
            fic.add(new FilterItemInfo("applier.id", (Object)person.getId().toString(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    private String trim(String str, String trim) {
        if (str == null) {
            return "";
        }
        if (trim == null || "".equals(trim)) {
            return trim;
        }
        if (str.startsWith(trim)) {
            return this.trim(str.substring(trim.length()), trim);
        }
        if (str.endsWith(trim)) {
            return this.trim(str.substring(0, str.length() - trim.length()), trim);
        }
        return str;
    }

    private Object getSelectedState() {
        Enumeration e = this.grpState.getElements();
        int count = 0;
        int bc = this.grpState.getButtonCount();
        while (e.hasMoreElements()) {
            KDRadioButton ab = (KDRadioButton)e.nextElement();
            if (this.grpState.isSelected(ab.getModel())) {
                return new Integer(((StateEnum)((Object)ab.getUserObject())).getValue());
            }
            if (++count <= bc) continue;
            break;
        }
        return null;
    }

    private void checkError() throws ExpAccException {
        Date dtTo;
        if (this.pkDateFrom.getValue() == null || this.pkDateTo.getValue() == null) {
            return;
        }
        Date dtFrom = (Date)this.pkDateFrom.getValue();
        if (dtFrom.compareTo(dtTo = (Date)this.pkDateTo.getValue()) > 0) {
            throw new ExpAccException(ExpAccException.REQDATE_FROM_GT_TO);
        }
    }

    private void setSelectedState(StateEnum sEnum) {
        Enumeration e = this.grpState.getElements();
        int count = 0;
        int bc = this.grpState.getButtonCount();
        while (e.hasMoreElements()) {
            KDRadioButton ab = (KDRadioButton)e.nextElement();
            if (sEnum.equals(ab.getUserObject())) {
                this.grpState.setSelected(ab.getModel(), true);
            }
            if (++count <= bc) continue;
            break;
        }
    }

    public void loadData(EntityViewInfo view) {
        BOSUuid costId;
        Object obj;
        if (view.getFilter() == null) {
            return;
        }
        FilterItemCollection fic = view.getFilter().getFilterItems();
        this.clear();
        if (this.param == null) {
            return;
        }
        int flag = this.param.getFlag();
        int index = 0;
        if ((flag & 0x80) != 0 && fic.size() > index) {
            try {
                Date dtFrom = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
                this.pkDateFrom.setValue((Object)dtFrom);
            }
            catch (ParseException e) {
                this.pkDateFrom.setValue(null);
            }
        } else if ((flag & 0x80) == 0) {
            this.pkDateFrom.setValue(null);
        }
        if ((flag & 0x100) != 0 && fic.size() > index) {
            try {
                Date dtTo = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
                dtTo = DateTimeUtils.addDay((Date)dtTo, (long)-1L);
                this.pkDateTo.setValue((Object)dtTo);
            }
            catch (ParseException e) {
                this.pkDateTo.setValue(null);
            }
        } else if ((flag & 0x100) == 0) {
            this.pkDateTo.setValue(null);
        }
        if ((flag & 1) != 0 && fic.size() > index) {
            if ((obj = fic.get(index++).getCompareValue()) == null) {
                return;
            }
            BOSUuid curId = BOSUuid.read((String)obj.toString());
            try {
                ICurrency iCur = CurrencyFactory.getRemoteInstance();
                CurrencyInfo cur = (CurrencyInfo)iCur.getValue((IObjectPK)new ObjectUuidPK(curId));
                this.prmtCurrency.setData((Object)cur);
            }
            catch (BOSException e1) {
                this.prmtCurrency.setData(null);
            }
            catch (EASBizException e) {
                this.prmtCurrency.setData(null);
            }
        }
        if ((flag & 2) != 0 && fic.size() > index) {
            this.txtName.setText(this.trim(fic.get(index++).getCompareValue().toString(), "%"));
        }
        if ((flag & 4) != 0 && fic.size() > index) {
            if ((obj = fic.get(index++).getCompareValue()) == null) {
                return;
            }
            costId = BOSUuid.read((String)obj.toString());
            try {
                ICostCenterOrgUnit iCost = CostCenterOrgUnitFactory.getRemoteInstance();
                CostCenterOrgUnitInfo cost = (CostCenterOrgUnitInfo)iCost.getValue((IObjectPK)new ObjectUuidPK(costId));
                this.prmtCostCenter.setData((Object)cost);
            }
            catch (BOSException e1) {
                this.prmtCostCenter.setData(null);
            }
            catch (EASBizException e) {
                this.prmtCostCenter.setData(null);
            }
        }
        if ((flag & 8) != 0 && fic.size() > index) {
            this.txtNumberFrom.setText(this.trim(fic.get(index++).getCompareValue().toString(), "%"));
        }
        if ((flag & 0x20) != 0 && fic.size() > index) {
            Integer state = (Integer)fic.get(index++).getCompareValue();
            StateEnum sEnum = StateEnum.getEnum(state);
            this.setSelectedState(sEnum);
        }
        if ((flag & 0x40) != 0 && fic.size() > index) {
            if ((obj = fic.get(index++).getCompareValue()) == null) {
                return;
            }
            costId = BOSUuid.read((String)obj.toString());
            try {
                IPerson iPerson = PersonFactory.getRemoteInstance();
                PersonInfo person = (PersonInfo)iPerson.getValue((IObjectPK)new ObjectUuidPK(costId));
                this.prmtApplier.setData((Object)person);
            }
            catch (BOSException e1) {
                this.prmtApplier.setData(null);
            }
            catch (EASBizException e) {
                this.prmtApplier.setData(null);
            }
        }
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new ExpenseFilterParam();
        }
        int flag = 0;
        if (this.prmtCurrency.getData() != null) {
            flag |= 1;
        }
        if (!BizCollUtil.objectIsNull(this.txtName.getText())) {
            flag |= 2;
        }
        if (this.prmtCostCenter.getData() != null) {
            flag |= 4;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            flag |= 8;
        }
        if (this.grpState.getSelection() != this.btnAll.getModel()) {
            flag |= 0x20;
        }
        if (this.prmtApplier.getData() != null) {
            flag |= 0x40;
        }
        if (this.pkDateFrom.getValue() != null) {
            flag |= 0x80;
        }
        if (this.pkDateTo.getValue() != null) {
            flag |= 0x100;
        }
        this.param.setFlag(flag);
        return this.param;
    }

    public void setParam(Object param) {
        this.param = (ExpenseFilterParam)param;
    }

    public void clear() {
        super.clear();
        this.prmtApplier.setData(null);
        this.prmtCostCenter.setData(null);
        this.prmtCurrency.setData(null);
        this.txtName.setText("");
        this.txtNumberFrom.setText("");
        this.txtNumberTo.setText("");
        this.grpState.setSelected(this.btnAll.getModel(), true);
        this.initDate();
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ExpAccException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append(" ");
            maskString.append("#" + index);
            maskString.append(" ");
        } else {
            maskString.append(" ");
            maskString.append(logicWord + " #" + index);
            maskString.append(" ");
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object object = null;
        if (this.param == null) {
            this.param = new ExpenseFilterParam();
        }
        int flag = 0;
        if (this.prmtCurrency.getData() != null) {
            flag |= 1;
        }
        if (!BizCollUtil.objectIsNull(this.txtName.getText())) {
            flag |= 2;
        }
        if (this.prmtCostCenter.getData() != null) {
            flag |= 4;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            flag |= 8;
        }
        if (this.grpState.getSelection() != this.btnAll.getModel()) {
            flag |= 0x20;
        }
        if (this.prmtApplier.getData() != null) {
            flag |= 0x40;
        }
        if (this.pkDateFrom.getValue() != null) {
            flag |= 0x80;
        }
        if (this.pkDateTo.getValue() != null) {
            flag |= 0x100;
        }
        cp.putInt("flag", flag);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CustomerParams result = cp;
        this.clear();
        this.param.setFlag(cp.getInt("flag"));
    }
}

