/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CompareSymbolEnum;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.HasPaymentBillEnum;
import com.kingdee.eas.cp.bc.IOperationType;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.client.AbstractExpenseReqCommonQueryUI;
import com.kingdee.eas.cp.bc.client.ExpenseTypePromptBox;
import com.kingdee.eas.cp.bc.client.OperationTypePromptBox;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class ExpenseReqCommonQueryUI
extends AbstractExpenseReqCommonQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseReqCommonQueryUI.class);
    protected static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseReqResource";
    private static final String AND = " AND ";
    private static final String ORG_UNIT = "orgUnit";
    private static final String APPLIER = "applier";
    private static final String SUPPORTEDOBJ = "supportedObj";
    private static final String REQ_DATE_FROM = "reqDateFrom";
    private static final String REQ_DATE_TO = "reqDateTo";
    private static final String NUMBER_FROM = "numberFrom";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";
    private static final String OPERATIONTYPE = "operationType";
    private static final String CURRENCYTYPE = "currencyType";
    private static final String OPRT = "oprt";
    private static final String COSTCOMPANY = "costCompany";
    private static final String APPLIERCOMPANY = "applierCompany";
    private static final String CAUSE = "cause";
    private static final String PRIOR = "prior";
    private static final String PAYMODE = "payMode";
    private static final String ABANDON = "abandon";
    private static final String STATEPAYED = "statePayed";
    private static final String STATEAUDITED = "stateAudited";
    private static final String STATEAUDITFAILED = "stateAuditFailed";
    private static final String STATECANCEL = "stateCancel";
    private static final String STATECLOSED = "stateClosed";
    private static final String STATEINAUDIT = "stateInAudit";
    private static final String STATENEW = "stateNew";
    private static final int SELECTNULL = -1;
    private static final String ENTRYAMOUNTOPRT = "entryAmountOprt";
    private static final String ENTRYAMOUNT = "entryAmount";
    private static final String ENTRYAMOUNTAPPROVEDOPRT = "entryAmountApprovedOprt";
    private static final String ENTRYAMOUNTAPPROVED = "entryAmountApproved";
    private static final String ENTRYEXPENSETYPE = "entryExpenseType";
    private static final String ENTRYOPERATIONTYPE = "entryOperationType";
    private static final String ENTRYCOSTCOMPANY = "entryCostCompany";
    private static final String ENTRYCOSTCENTER = "entryCostCenter";
    Map params = null;
    private boolean isCalledByAccount = false;
    boolean guiApplierCompanyFilter = false;

    public ExpenseReqCommonQueryUI() throws Exception {
        MakeControl.makePayMode(this.prmtPayMode);
        this.prmtPayMode.setRequired(false);
        MakeControl.makeCostTargetBizQuery(this.bizPromptSupportObj);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isShowDisable", Boolean.TRUE);
        OperationTypePromptBox selector = new OperationTypePromptBox((IUIObject)this, params);
        selector.setMultiSelect(true);
        this.prmtOperationType.setSelector((KDPromptSelector)selector);
        this.prmtOperationType.setEnabledMultiSelection(true);
        this.prmtOperationType.setEditFormat("$number$");
        this.prmtOperationType.setDisplayFormat("$name$");
        this.prmtOperationType.setCommitFormat("$number$");
        this.cbOprt.addItem((Object)"  ");
        this.cbOprt.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.CompareSymbolEnum").toArray());
        this.cbPrior.setEditable(false);
        this.cbPrior.addItem((Object)"  ");
        this.cbPrior.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.PriorEnum").toArray());
        this.cbPrior.setEditable(false);
        this.hasPaymentBill.setEditable(false);
        this.hasPaymentBill.addItem((Object)"  ");
        this.hasPaymentBill.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.HasPaymentBillEnum").toArray());
        this.bizPromptApplier.setEnabledMultiSelection(true);
        this.bizPromptSupportObj.setEnabledMultiSelection(true);
        this.initDate();
        this.bizPromptReqDept.requestFocus();
        this.txtAmount.setDataType(1);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        MakeControl.makeCurrency(this.kdbpCurrency);
        MakeControl.makeOperationTypeF7(this.entryOperationType, (CoreUIObject)this);
        this.entryOperationType.setEnabledMultiSelection(true);
        OperationTypePromptBox operf7 = (OperationTypePromptBox)this.entryOperationType.getSelector();
        operf7.setMultiSelect(true);
        MakeControl.makeAccountF7_mul(this.entryExpenseType, (CoreUIObject)this, true);
        this.entryExpenseType.setEnabledMultiSelection(true);
        this.entryExpenseType.setDisplayFormat("$name");
        ExpenseTypePromptBox f7 = (ExpenseTypePromptBox)this.entryExpenseType.getSelector();
        f7.setMultiSelect(true);
        this.entryAmountOprt.addItem((Object)"  ");
        this.entryAmountOprt.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.CompareSymbolEnum").toArray());
        this.entryAmountApprovedOprt.addItem((Object)"  ");
        this.entryAmountApprovedOprt.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.CompareSymbolEnum").toArray());
    }

    public ExpenseReqCommonQueryUI(Map params) throws Exception {
        this();
        this.params = params;
        if (this.params != null) {
            this.guiApplierCompanyFilter = this.params.get("guiApplierCompanyFilter") == null ? false : new Boolean(this.params.get("guiApplierCompanyFilter").toString());
            MakeControl.makeApplierF7(this.bizPromptApplier, (CoreUIObject)this);
            MakeControl.makeReqDepF7(this.bizPromptReqDept, null, params);
            MakeControl.makeCompanyF7(this.prmtCostCompany, (CoreUIObject)this, params, null);
            this.prmtCostCompany.setEnabledMultiSelection(true);
            if (this.prmtCostCompany.getSelector() instanceof NewCompanyF7) {
                ((NewCompanyF7)this.prmtCostCompany.getSelector()).setMultiSelect(true);
            }
            MakeControl.makeCompanyF7(this.entryCostCompany, (CoreUIObject)this, params, null);
            this.entryCostCompany.setEnabledMultiSelection(true);
            if (this.entryCostCompany.getSelector() instanceof NewCompanyF7) {
                ((NewCompanyF7)this.entryCostCompany.getSelector()).setMultiSelect(true);
            }
            MakeControl.makeCostCenterF7(this.entryCostCenter, null, params);
            this.entryCostCenter.setEnabledMultiSelection(true);
            String uiName = (String)this.params.get("uiName");
            String permItemName = MakeControl.getPermItemByUI(uiName);
            MakeControl.makeApplierCompanyF7(this.prmtApplierCompany, (CoreUIObject)this, params, null, permItemName);
            Object obj = this.params.get("isCalledByTravelReq");
            boolean isRelaCn = false;
            if (this.params.get("isRelaCn") != null) {
                isRelaCn = (Boolean)this.params.get("isRelaCn");
            }
            if (isRelaCn) {
                this.showIsPayBillBox();
            }
            boolean showEntry = false;
            if (this.params.get("isShowEntry") != null) {
                showEntry = (Boolean)this.params.get("isShowEntry");
            }
            boolean isJoinBudget = false;
            if (this.params.get("isJoinBudget") != null) {
                isJoinBudget = (Boolean)this.params.get("isJoinBudget");
            }
            if (obj != null && obj instanceof Boolean) {
                if (((Boolean)obj).booleanValue()) {
                    this.kDLabelContainer11.setVisible(false);
                }
                this.labAmount.setVisible(true);
                this.labAmount.setEnabled(showEntry);
                this.labAmountApproved.setEnabled(showEntry);
                this.entryAmountApprovedOprt.setEnabled(showEntry);
                this.labEntryExpenseType.setEnabled(showEntry);
                this.txtEntryAmountApproved.setEnabled(showEntry);
                this.entryExpenseType.setEnabled(showEntry);
                this.txtEntryAmount.setVisible(true);
                this.txtEntryAmount.setEnabled(showEntry);
                this.entryAmountOprt.setEnabled(showEntry);
                if (isJoinBudget) {
                    this.labEntryExpenseType.setVisible(isJoinBudget);
                    this.labAmountApproved.setVisible(isJoinBudget);
                    this.txtEntryAmountApproved.setVisible(isJoinBudget);
                } else {
                    this.labEntryExpenseType.setVisible(false);
                    this.labAmountApproved.setVisible(false);
                    this.txtEntryAmountApproved.setVisible(false);
                }
                this.kDLabelContainer16.setVisible(false);
            }
            if ((obj = this.params.get("isCalledByAccount")) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                this.isCalledByAccount = true;
                this.labEntryExpenseType.setVisible(true);
                this.labAmount.setVisible(true);
                this.labAmountApproved.setVisible(true);
                this.txtEntryAmountApproved.setVisible(true);
                this.txtEntryAmount.setVisible(true);
                this.labEntryCostCenter.setVisible(true);
                this.labEntryCostCompany.setVisible(true);
                this.labEntryOperationType.setVisible(true);
                this.labEntryExpenseType.setEnabled(showEntry);
                this.entryAmountOprt.setEnabled(showEntry);
                this.labAmount.setEnabled(showEntry);
                this.labAmountApproved.setEnabled(showEntry);
                this.entryAmountApprovedOprt.setEnabled(showEntry);
                this.txtEntryAmountApproved.setEnabled(showEntry);
                this.txtEntryAmount.setEnabled(showEntry);
                this.labEntryCostCenter.setEnabled(showEntry);
                this.labEntryCostCompany.setEnabled(showEntry);
                this.labEntryOperationType.setEnabled(showEntry);
                this.entryOperationType.setEnabled(showEntry);
                this.entryExpenseType.setEnabled(showEntry);
                this.entryCostCompany.setEnabled(showEntry);
                this.entryCostCenter.setEnabled(showEntry);
            }
            if ((obj = this.params.get("isCalledByLoanOrOtherExpense")) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                this.labEntryExpenseType.setVisible(true);
                this.labAmount.setVisible(true);
                this.labAmountApproved.setVisible(true);
                this.txtEntryAmountApproved.setVisible(true);
                this.txtEntryAmount.setVisible(true);
                this.labEntryExpenseType.setEnabled(showEntry);
                this.entryExpenseType.setEnabled(showEntry);
                this.entryAmountOprt.setEnabled(showEntry);
                this.labAmount.setEnabled(showEntry);
                this.labAmountApproved.setEnabled(showEntry);
                this.entryAmountApprovedOprt.setEnabled(showEntry);
                this.txtEntryAmountApproved.setEnabled(showEntry);
                this.txtEntryAmount.setEnabled(showEntry);
                this.labEntryCostCenter.setEnabled(false);
                this.labEntryCostCompany.setEnabled(false);
                this.labEntryOperationType.setEnabled(false);
                this.entryOperationType.setEnabled(false);
                this.entryCostCompany.setEnabled(false);
                this.entryCostCenter.setEnabled(false);
            }
            if ((obj = this.params.get("isCalledByOtherExpense")) != null && obj instanceof Boolean) {
                this.kDLabelContainer16.setVisible(false);
            }
            this.labAmount.getBoundLabel().setEnabled(showEntry);
            this.labAmountApproved.getBoundLabel().setEnabled(showEntry);
            this.labEntryExpenseType.getBoundLabel().setEnabled(showEntry);
            this.labEntryOperationType.getBoundLabel().setEnabled(showEntry);
            this.labEntryCostCompany.getBoundLabel().setEnabled(showEntry);
            this.labEntryCostCenter.getBoundLabel().setEnabled(showEntry);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isCalledByAccount) {
            this.kDLabelContainer10.setVisible(false);
        } else {
            this.kDLabelContainer14.setVisible(false);
        }
    }

    public FilterInfo getFilterInfo() {
        String cause;
        Object[] dataArray;
        int i;
        HashSet<String> set;
        String name;
        int i2;
        HashSet<String> set2;
        Object[] dataArray2;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        Object data = null;
        data = this.bizPromptReqDept.getData();
        if (!BizCollUtil.objectIsNull(data) && data instanceof AdminOrgUnitInfo) {
            item = new FilterItemInfo("orgUnit.id", (Object)((AdminOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.bizPromptApplier.getData()) != null && data instanceof Object[] && (dataArray2 = (Object[])data).length > 0) {
            set2 = new HashSet<String>();
            for (i2 = 0; i2 < dataArray2.length; ++i2) {
                if (dataArray2[i2] == null || !(dataArray2[i2] instanceof PersonInfo)) continue;
                set2.add(((PersonInfo)dataArray2[i2]).getId().toString());
            }
            if (set2.size() > 0) {
                item = new FilterItemInfo("applier.id", set2, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.bizPromptSupportObj.getData()) != null && data instanceof Object[] && (dataArray2 = (Object[])data).length > 0) {
            set2 = new HashSet();
            for (i2 = 0; i2 < dataArray2.length; ++i2) {
                if (dataArray2[i2] == null || !(dataArray2[i2] instanceof CostObjectInfo)) continue;
                set2.add(((CostObjectInfo)dataArray2[i2]).getId().toString());
            }
            if (set2.size() > 0) {
                item = new FilterItemInfo("supportedObj.id", set2, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateFrom.getTimestamp())) {
            item = new FilterItemInfo("bizReqDate", (Object)BizCollUtil.covertToSimpleDate(this.dateBizReqDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateTo.getTimestamp())) {
            Date end = this.dateBizReqDateTo.getTimestamp();
            Calendar cal = Calendar.getInstance();
            cal.setTime(end);
            cal.add(5, 1);
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            cal.add(13, -1);
            end = cal.getTime();
            item = new FilterItemInfo("bizReqDate", (Object)end, CompareType.LESS_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            item = new FilterItemInfo("number", (Object)("%" + this.txtNumberFrom.getText().trim() + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!StringUtils.isEmpty((String)(name = this.txtName.getText()))) {
            item = new FilterItemInfo(NAME, (Object)("%" + name + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        data = this.cbOprt.getSelectedItem();
        String amountString = this.txtAmount.getText();
        BigDecimal amount = null;
        if (!StringUtils.isEmpty((String)amountString)) {
            amountString = amountString.replaceAll(",", "");
            amount = new BigDecimal(amountString);
        }
        if (amount != null && data != null && data instanceof CompareSymbolEnum) {
            int oprt = ((CompareSymbolEnum)((Object)data)).getValue();
            CompareType op = null;
            switch (oprt) {
                case 0: {
                    op = CompareType.LESS;
                    break;
                }
                case 1: {
                    op = CompareType.LESS_EQUALS;
                    break;
                }
                case 2: {
                    op = CompareType.EQUALS;
                    break;
                }
                case 3: {
                    op = CompareType.GREATER_EQUALS;
                    break;
                }
                case 4: {
                    op = CompareType.GREATER;
                }
            }
            if (op != null) {
                item = new FilterItemInfo(AMOUNT, (Object)amount, op);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        data = this.entryAmountOprt.getSelectedItem();
        String entryamountString = this.txtEntryAmount.getText();
        BigDecimal entryamount = null;
        if (!StringUtils.isEmpty((String)entryamountString)) {
            entryamountString = entryamountString.replaceAll(",", "");
            entryamount = new BigDecimal(entryamountString);
        }
        if (entryamount != null && data != null && data instanceof CompareSymbolEnum) {
            int oprt = ((CompareSymbolEnum)((Object)data)).getValue();
            CompareType op = null;
            switch (oprt) {
                case 0: {
                    op = CompareType.LESS;
                    break;
                }
                case 1: {
                    op = CompareType.LESS_EQUALS;
                    break;
                }
                case 2: {
                    op = CompareType.EQUALS;
                    break;
                }
                case 3: {
                    op = CompareType.GREATER_EQUALS;
                    break;
                }
                case 4: {
                    op = CompareType.GREATER;
                }
            }
            if (op != null) {
                item = new FilterItemInfo("entries.amount", (Object)entryamount, op);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        data = this.entryAmountApprovedOprt.getSelectedItem();
        String entryamountApprovedString = this.txtEntryAmountApproved.getText();
        BigDecimal entryamountApproved = null;
        if (!StringUtils.isEmpty((String)entryamountApprovedString)) {
            entryamountApprovedString = entryamountApprovedString.replaceAll(",", "");
            entryamountApproved = new BigDecimal(entryamountApprovedString);
        }
        if (entryamountApproved != null && data != null && data instanceof CompareSymbolEnum) {
            int oprt = ((CompareSymbolEnum)((Object)data)).getValue();
            CompareType op = null;
            switch (oprt) {
                case 0: {
                    op = CompareType.LESS;
                    break;
                }
                case 1: {
                    op = CompareType.LESS_EQUALS;
                    break;
                }
                case 2: {
                    op = CompareType.EQUALS;
                    break;
                }
                case 3: {
                    op = CompareType.GREATER_EQUALS;
                    break;
                }
                case 4: {
                    op = CompareType.GREATER;
                }
            }
            if (op != null) {
                item = new FilterItemInfo("entries.amountApproved", (Object)entryamountApproved, op);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.cbPrior.getSelectedItem()) != null && data instanceof PriorEnum) {
            item = new FilterItemInfo(PRIOR, (Object)new Integer(((PriorEnum)((Object)data)).getValue()), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.prmtCostCompany.getValue()) != null && data instanceof Object[]) {
            Object[] dataArray3 = (Object[])data;
            if (dataArray3.length > 0) {
                set = new HashSet<String>();
                for (i = 0; i < dataArray3.length; ++i) {
                    if (dataArray3[i] == null || !(dataArray3[i] instanceof CompanyOrgUnitInfo)) continue;
                    set.add(((CompanyOrgUnitInfo)dataArray3[i]).getId().toString());
                }
                item = new FilterItemInfo("company.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        } else if (data != null && data instanceof CompanyOrgUnitInfo) {
            item = new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        data = this.prmtApplierCompany.getValue();
        if (data != null && data instanceof CompanyOrgUnitInfo) {
            if (this.isCalledByAccount && !this.guiApplierCompanyFilter) {
                item = new FilterItemInfo("entries.company.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                maskString.append(" and (#" + index);
                item = new FilterItemInfo("applierCompany.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                maskString.append(" or #" + ++index + ")");
                ++index;
            } else {
                item = new FilterItemInfo("applierCompany.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        } else if (data != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            set = new HashSet();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof CompanyOrgUnitInfo)) continue;
                set.add(((CompanyOrgUnitInfo)dataArray[i]).getId().toString());
            }
            if (this.isCalledByAccount && !this.guiApplierCompanyFilter) {
                item = new FilterItemInfo("entries.company.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                maskString.append(" and (#" + index);
                item = new FilterItemInfo("applierCompany.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                maskString.append(" or #" + ++index + ")");
                ++index;
            } else {
                item = new FilterItemInfo("applierCompany.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if (this.isCalledByAccount) {
            data = this.kdbpCurrency.getValue();
            if (data != null) {
                item = new FilterItemInfo("currencyType.id", (Object)((CurrencyInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        } else {
            data = this.prmtOperationType.getValue();
            if (data != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
                set = new HashSet();
                for (i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i] == null || !(dataArray[i] instanceof OperationTypeInfo)) continue;
                    set.add(((OperationTypeInfo)dataArray[i]).getId().toString());
                }
                if (set.size() > 0) {
                    item = new FilterItemInfo("operationType.id", set, CompareType.INCLUDE);
                    itemCollection.add(item);
                    this.makeMaskString(maskString, index, AND);
                    ++index;
                }
            }
        }
        if ((data = this.prmtPayMode.getValue()) != null && data instanceof SettlementTypeInfo) {
            item = new FilterItemInfo("payMode.id", (Object)((SettlementTypeInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.entryExpenseType.getData()) != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            set = new HashSet();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof ExpenseTypeInfo)) continue;
                set.add(((ExpenseTypeInfo)dataArray[i]).getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("entries.expenseType.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.entryOperationType.getData()) != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            set = new HashSet();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof OperationTypeInfo)) continue;
                set.add(((OperationTypeInfo)dataArray[i]).getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("entries.operationType.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.entryCostCompany.getData()) != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            set = new HashSet();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof CompanyOrgUnitInfo)) continue;
                set.add(((CompanyOrgUnitInfo)dataArray[i]).getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("entries.company.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.entryCostCenter.getData()) != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            set = new HashSet();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof CostCenterOrgUnitInfo)) continue;
                set.add(((CostCenterOrgUnitInfo)dataArray[i]).getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("entries.costCenter.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if (!StringUtils.isEmpty((String)(cause = this.txtCause.getText()))) {
            item = new FilterItemInfo(CAUSE, (Object)("%" + cause + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((item = this.getFilterStates()) != null) {
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.hasPaymentBill.getSelectedItem()) != null && data instanceof HasPaymentBillEnum) {
            if ((data = (HasPaymentBillEnum)((Object)data)).equals((Object)HasPaymentBillEnum.NO)) {
                item = new FilterItemInfo("isCreatePayBill", (Object)0, CompareType.EQUALS);
                itemCollection.add(item);
                maskString.append(" and (#" + index);
                item = new FilterItemInfo("isCreatePayBill", null, CompareType.IS);
                itemCollection.add(item);
                maskString.append(" or #" + ++index + ") ");
                ++index;
            } else if (data.equals((Object)HasPaymentBillEnum.YES)) {
                item = new FilterItemInfo("isCreatePayBill", (Object)1, CompareType.EQUALS);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        this.filterInfo.setMaskString(maskString.toString());
        logger.error((Object)("####ExpenseReqCommonQueryUI getFilterInfo=" + this.filterInfo));
        return this.filterInfo;
    }

    private FilterItemInfo getFilterStates() {
        FilterItemInfo filterItemInfo = null;
        HashSet<Integer> set = new HashSet<Integer>();
        if (this.btnAbandon.isSelected()) {
            set.add(new Integer(27));
        }
        if (this.btnStateAudited.isSelected()) {
            set.add(new Integer(60));
        }
        if (this.btnStateAuditFailed.isSelected()) {
            set.add(new Integer(40));
        }
        if (this.btnStateCancel.isSelected()) {
            set.add(new Integer(25));
        }
        if (this.btnStateClosed.isSelected()) {
            set.add(new Integer(80));
        }
        if (this.btnStateInAudit.isSelected()) {
            set.add(new Integer(30));
        }
        if (this.btnStateNew.isSelected()) {
            set.add(new Integer(20));
        }
        if (this.btnStateIsPayBill.isSelected()) {
            set.add(new Integer(65));
        }
        if (this.btnStatePayed.isSelected()) {
            set.add(new Integer(70));
        }
        if (set.size() > 0) {
            filterItemInfo = new FilterItemInfo("state", set, CompareType.INCLUDE);
        }
        return filterItemInfo;
    }

    public boolean verify() {
        Object obj = null;
        Timestamp dateFrom = null;
        Timestamp dateTo = null;
        obj = this.prmtApplierCompany.getValue();
        if (obj == null) {
            this.prmtApplierCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"a_company_notnull"));
            return false;
        }
        if (!(StringUtils.isEmpty((String)this.txtAmount.getText()) || (obj = this.cbOprt.getSelectedItem()) != null && obj instanceof CompareSymbolEnum)) {
            this.cbOprt.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"compareSymbolNotNull"));
            return false;
        }
        obj = this.cbOprt.getSelectedItem();
        if (obj != null && obj instanceof CompareSymbolEnum && StringUtils.isEmpty((String)this.txtAmount.getText())) {
            this.txtAmount.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"amountNotNull"));
            return false;
        }
        obj = this.dateBizReqDateFrom.getValue();
        dateFrom = this.dateBizReqDateFrom.getTimestamp();
        if (obj == null) {
            this.dateBizReqDateFrom.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"dateFromNotNull"));
            return false;
        }
        obj = this.dateBizReqDateTo.getValue();
        dateTo = this.dateBizReqDateTo.getTimestamp();
        if (obj == null) {
            this.dateBizReqDateTo.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"dateToNotNull"));
            return false;
        }
        if (dateTo.compareTo(dateFrom) < 0) {
            this.dateBizReqDateFrom.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bgDateOverEndDate"));
            return false;
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        this.txtName.setText(null);
        this.txtNumberFrom.setText(null);
        this.bizPromptReqDept.setData(null);
        this.bizPromptApplier.setData(null);
        this.bizPromptSupportObj.setData(null);
        this.txtCause.setText(null);
        this.txtAmount.setText(null);
        this.cbOprt.setSelectedItem(null);
        this.cbPrior.setSelectedItem(null);
        this.hasPaymentBill.setSelectedItem(null);
        this.prmtCostCompany.setValue(null);
        this.prmtApplierCompany.setValue(null);
        this.prmtOperationType.setValue(null);
        this.kdbpCurrency.setValue(null);
        this.prmtPayMode.setValue(null);
        this.btnAbandon.setSelected(false);
        this.btnStatePayed.setSelected(false);
        this.btnStateAudited.setSelected(false);
        this.btnStateAuditFailed.setSelected(false);
        this.btnStateCancel.setSelected(false);
        this.btnStateClosed.setSelected(false);
        this.btnStateInAudit.setSelected(false);
        this.btnStateNew.setSelected(false);
        this.txtEntryAmount.setText(null);
        this.txtEntryAmountApproved.setText(null);
        this.entryAmountOprt.setSelectedItem(null);
        this.entryAmountApprovedOprt.setSelectedItem(null);
        this.entryOperationType.setValue(null);
        this.entryExpenseType.setValue(null);
        this.entryCostCenter.setValue(null);
        this.entryCostCompany.setValue(null);
        this.initDate();
        this.prmtApplierCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    private void initDate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dateFormat = DateFormat.getDateInstance();
        String dateString = dateFormat.format(date);
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.dateBizReqDateFrom.setValue((Object)cal.getTime());
        this.dateBizReqDateTo.setValue((Object)date);
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public CustomerParams getCustomerParams() {
        Object[] arry;
        int len;
        AbstractStringBuilder types;
        int i;
        CustomerParams cp = new CustomerParams();
        Object object = null;
        object = this.txtName.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(NAME, (String)object);
        }
        if ((object = this.bizPromptApplier.getValue()) != null && object instanceof Object[]) {
            String personId = "";
            Object[] personInfoObject = (Object[])object;
            for (i = 0; i < personInfoObject.length; ++i) {
                if (personInfoObject[i] == null) continue;
                PersonInfo personInfo = (PersonInfo)personInfoObject[i];
                personId = personId + personInfo.getId().toString() + ",";
            }
            cp.addCustomerParam(APPLIER, personId);
        }
        if ((object = this.bizPromptSupportObj.getValue()) != null && object instanceof Object[]) {
            StringBuffer costObjectId = new StringBuffer("");
            Object[] supportedObj = (Object[])object;
            for (i = 0; i < supportedObj.length; ++i) {
                if (supportedObj[i] == null) continue;
                CostObjectInfo costObjectInfo = (CostObjectInfo)supportedObj[i];
                costObjectId.append(costObjectInfo.getId().toString()).append(",");
            }
            cp.addCustomerParam(SUPPORTEDOBJ, costObjectId.toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.bizPromptReqDept.getValue()) && object instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)object;
            cp.addCustomerParam(ORG_UNIT, adminOrgUnitInfo.getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.txtNumberFrom.getText())) {
            cp.addCustomerParam(NUMBER_FROM, object.toString());
        }
        DateFormat df = MultilingualUtil.getDateFormat();
        object = this.dateBizReqDateFrom.getValue();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(REQ_DATE_FROM, df.format(object));
        }
        if (!BizCollUtil.objectIsNull(object = this.dateBizReqDateTo.getValue())) {
            cp.addCustomerParam(REQ_DATE_TO, df.format(object));
        }
        if ((object = this.cbOprt.getSelectedItem()) != null && object instanceof CompareSymbolEnum) {
            cp.putInt(OPRT, ((CompareSymbolEnum)((Object)object)).getValue());
        } else {
            cp.putInt(OPRT, -1);
        }
        object = this.txtAmount.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(AMOUNT, object.toString());
        }
        if ((object = this.txtEntryAmount.getText()) != null) {
            cp.addCustomerParam(ENTRYAMOUNT, object.toString());
        }
        if ((object = this.entryAmountOprt.getSelectedItem()) != null && object instanceof CompareSymbolEnum) {
            cp.putInt(ENTRYAMOUNTOPRT, ((CompareSymbolEnum)((Object)object)).getValue());
        } else {
            cp.putInt(ENTRYAMOUNTOPRT, -1);
        }
        object = this.txtEntryAmountApproved.getText();
        if (object != null) {
            cp.addCustomerParam(ENTRYAMOUNTAPPROVED, object.toString());
        }
        if ((object = this.entryAmountApprovedOprt.getSelectedItem()) != null && object instanceof CompareSymbolEnum) {
            cp.putInt(ENTRYAMOUNTAPPROVEDOPRT, ((CompareSymbolEnum)((Object)object)).getValue());
        } else {
            cp.putInt(ENTRYAMOUNTAPPROVEDOPRT, -1);
        }
        if (this.isCalledByAccount) {
            object = this.kdbpCurrency.getValue();
            if (!BizCollUtil.objectIsNull(object) && object instanceof CurrencyInfo) {
                cp.addCustomerParam(CURRENCYTYPE, ((CurrencyInfo)object).getId().toString());
            }
        } else {
            object = this.prmtOperationType.getValue();
            if (!BizCollUtil.objectIsNull(object) && object instanceof Object[] && ((Object[])object).length > 0 && ((Object[])object)[0] != null) {
                int i2;
                types = new StringBuffer();
                Object[] ps = (Object[])object;
                for (i2 = 0; i2 < ps.length - 1; ++i2) {
                    ((StringBuffer)types).append(((OperationTypeInfo)ps[i2]).getId().toString());
                    ((StringBuffer)types).append("\u2014\u2014");
                }
                ((StringBuffer)types).append(((OperationTypeInfo)ps[i2]).getId().toString());
                cp.addCustomerParam(OPERATIONTYPE, ((StringBuffer)types).toString());
            }
        }
        if (!BizCollUtil.objectIsNull(object = this.entryOperationType.getValue()) && object instanceof Object[] && ((Object[])object).length > 0 && ((Object[])object)[0] != null) {
            types = new StringBuilder();
            Object[] ps = (Object[])object;
            len = ps.length;
            for (int i3 = 0; i3 < len; ++i3) {
                if (ps[i3] == null) continue;
                ((StringBuilder)types).append(((OperationTypeInfo)ps[i3]).getId().toString());
                if (i3 >= len - 1) continue;
                ((StringBuilder)types).append("\u2014\u2014");
            }
            if (((StringBuilder)types).length() > 0) {
                cp.addCustomerParam(ENTRYOPERATIONTYPE, ((StringBuilder)types).toString());
            }
        }
        if (!BizCollUtil.objectIsNull(object = this.entryExpenseType.getValue()) && object instanceof Object[] && ((Object[])object).length > 0 && ((Object[])object)[0] != null) {
            types = new StringBuilder();
            Object[] ps = (Object[])object;
            len = ps.length;
            for (int i4 = 0; i4 < len; ++i4) {
                if (ps[i4] == null) continue;
                ((StringBuilder)types).append(((ExpenseTypeInfo)ps[i4]).getId().toString());
                if (i4 >= len - 1) continue;
                ((StringBuilder)types).append("\u2014\u2014");
            }
            if (((StringBuilder)types).length() > 0) {
                cp.addCustomerParam(ENTRYEXPENSETYPE, ((StringBuilder)types).toString());
            }
        }
        if (!BizCollUtil.objectIsNull(object = this.prmtCostCompany.getValue()) && object instanceof CompanyOrgUnitInfo) {
            cp.addCustomerParam(COSTCOMPANY, ((CompanyOrgUnitInfo)object).getId().toString());
        } else if (!BizCollUtil.objectIsNull(object) && object instanceof Object[]) {
            arry = (Object[])object;
            String ids = "";
            for (int i5 = 0; i5 < arry.length; ++i5) {
                ids = ids + ((CompanyOrgUnitInfo)arry[i5]).getId().toString() + ",";
            }
            cp.addCustomerParam(COSTCOMPANY, ids.substring(0, ids.length() - 1));
        }
        object = this.prmtApplierCompany.getValue();
        if (!BizCollUtil.objectIsNull(object) && object instanceof CompanyOrgUnitInfo) {
            cp.addCustomerParam(APPLIERCOMPANY, ((CompanyOrgUnitInfo)object).getId().toString());
        } else if (!BizCollUtil.objectIsNull(object) && object instanceof Object[]) {
            arry = (Object[])object;
            String ids = "";
            for (int i6 = 0; i6 < arry.length; ++i6) {
                ids = ids + ((CompanyOrgUnitInfo)arry[i6]).getId().toString() + ",";
            }
            cp.addCustomerParam(APPLIERCOMPANY, ids.substring(0, ids.length() - 1));
        }
        object = this.entryCostCompany.getValue();
        if (object != null) {
            if (object instanceof CompanyOrgUnitInfo) {
                cp.addCustomerParam(ENTRYCOSTCOMPANY, ((CompanyOrgUnitInfo)object).getId().toString());
            } else if (object instanceof Object[]) {
                arry = (Object[])object;
                StringBuilder ids = new StringBuilder();
                len = arry.length;
                for (int i7 = 0; i7 < len; ++i7) {
                    if (arry[i7] == null) continue;
                    ids.append(((CompanyOrgUnitInfo)arry[i7]).getId().toString() + ",");
                }
                if (ids.length() != 0) {
                    cp.addCustomerParam(ENTRYCOSTCOMPANY, ids.deleteCharAt(ids.length() - 1).toString());
                }
            }
        }
        if ((object = this.entryCostCenter.getValue()) != null) {
            if (object instanceof CostCenterOrgUnitInfo) {
                cp.addCustomerParam(ENTRYCOSTCENTER, ((CostCenterOrgUnitInfo)object).getId().toString());
            } else if (object instanceof Object[]) {
                arry = (Object[])object;
                StringBuilder ids = new StringBuilder();
                len = arry.length;
                for (int i8 = 0; i8 < len; ++i8) {
                    if (arry[i8] == null) continue;
                    ids.append(((CostCenterOrgUnitInfo)arry[i8]).getId().toString() + ",");
                }
                if (ids.length() != 0) {
                    cp.addCustomerParam(ENTRYCOSTCENTER, ids.deleteCharAt(ids.length() - 1).toString());
                }
            }
        }
        if (!BizCollUtil.objectIsNull(object = this.prmtPayMode.getValue()) && object instanceof SettlementTypeInfo) {
            cp.addCustomerParam(PAYMODE, ((SettlementTypeInfo)object).getId().toString());
        }
        if ((object = this.cbPrior.getSelectedItem()) != null && object instanceof PriorEnum) {
            cp.putInt(PRIOR, ((PriorEnum)((Object)object)).getValue());
        } else {
            cp.putInt(PRIOR, -1);
        }
        object = this.txtCause.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(CAUSE, object.toString());
        }
        cp.putBoolean(ABANDON, this.btnAbandon.isSelected());
        cp.putBoolean(STATEPAYED, this.btnStatePayed.isSelected());
        cp.putBoolean(STATEAUDITED, this.btnStateAudited.isSelected());
        cp.putBoolean(STATEAUDITFAILED, this.btnStateAuditFailed.isSelected());
        cp.putBoolean(STATECANCEL, this.btnStateCancel.isSelected());
        cp.putBoolean(STATECLOSED, this.btnStateClosed.isSelected());
        cp.putBoolean(STATEINAUDIT, this.btnStateInAudit.isSelected());
        cp.putBoolean(STATENEW, this.btnStateNew.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        try {
            this.prepareCustomerParams(cp).callHandler();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        CustomerParams result = cp;
        String value = null;
        ObjectUuidPK pk = null;
        this.clear();
        this.txtName.setText(result.getCustomerParam(NAME));
        String id = result.getCustomerParam(APPLIER);
        Object[] personValue = null;
        if (id != null) {
            String[] personId = id.split(",");
            personValue = new Object[personId.length];
            for (int i = 0; i < personId.length; ++i) {
                personValue[i] = BizCollUtil.returnObjectValueById(personId[i]);
            }
        }
        this.bizPromptApplier.setData(personValue);
        String costObjectId = result.getCustomerParam(SUPPORTEDOBJ);
        Object[] supportedObj = null;
        if (costObjectId != null) {
            String[] supportedObjId = costObjectId.split(",");
            supportedObj = new Object[supportedObjId.length];
            for (int i = 0; i < supportedObjId.length; ++i) {
                supportedObj[i] = BizCollUtil.returnObjectValueById(supportedObjId[i]);
            }
        }
        this.bizPromptSupportObj.setData(supportedObj);
        id = result.getCustomerParam(ORG_UNIT);
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (id != null) {
            try {
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                adminOrgUnitInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.bizPromptReqDept.setData(adminOrgUnitInfo);
        this.txtNumberFrom.setText(result.getCustomerParam(NUMBER_FROM));
        DateFormat df = MultilingualUtil.getDateFormat();
        try {
            this.dateBizReqDateFrom.setValue((Object)df.parse(result.getCustomerParam(REQ_DATE_FROM)));
            this.dateBizReqDateTo.setValue((Object)df.parse(result.getCustomerParam(REQ_DATE_TO)));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        this.cbOprt.setSelectedItem((Object)CompareSymbolEnum.getEnum(result.getInt(OPRT)));
        this.txtAmount.setText(result.getCustomerParam(AMOUNT));
        this.entryAmountOprt.setSelectedItem((Object)CompareSymbolEnum.getEnum(result.getInt(ENTRYAMOUNTOPRT)));
        this.txtEntryAmount.setText(result.getCustomerParam(ENTRYAMOUNT));
        this.entryAmountApprovedOprt.setSelectedItem((Object)CompareSymbolEnum.getEnum(result.getInt(ENTRYAMOUNTAPPROVEDOPRT)));
        this.txtEntryAmountApproved.setText(result.getCustomerParam(ENTRYAMOUNTAPPROVED));
        try {
            CompanyOrgUnitCollection coll;
            HashSet idSet;
            FilterInfo filter;
            CompanyOrgUnitCollection companyCollection;
            EntityViewInfo entityView;
            FilterInfo companyFilter;
            CoreBaseCollection coll2;
            HashSet idset;
            EntityViewInfo evi;
            Object[] types;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo(NAME));
            if (this.isCalledByAccount) {
                value = cp.getCustomerParam(CURRENCYTYPE);
                if (!StringUtils.isEmpty((String)value)) {
                    ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                    pk = new ObjectUuidPK(value);
                    this.kdbpCurrency.setValue((Object)iCurrency.getCurrencyInfo((IObjectPK)pk, selector));
                }
            } else {
                value = cp.getCustomerParam(OPERATIONTYPE);
                if (!StringUtils.isEmpty((String)value)) {
                    String[] types2 = StringUtils.split((String)value, (String)"\u2014\u2014");
                    Object[] objs = new Object[types2.length];
                    IOperationType operationType = OperationTypeFactory.getRemoteInstance();
                    for (int i = 0; i < types2.length; ++i) {
                        pk = new ObjectUuidPK(types2[i]);
                        objs[i] = operationType.getOperationTypeInfo((IObjectPK)pk, selector);
                    }
                    this.prmtOperationType.setValue((Object)objs);
                }
            }
            value = cp.getCustomerParam(ENTRYOPERATIONTYPE);
            Object[] objs = null;
            if (!StringUtils.isEmpty((String)value)) {
                types = StringUtils.split((String)value, (String)"\u2014\u2014");
                evi = new EntityViewInfo();
                FilterInfo filter2 = new FilterInfo();
                if (types.length == 1) {
                    filter2.getFilterItems().add(new FilterItemInfo("id", types[0]));
                } else {
                    idset = new HashSet();
                    CollectionUtils.addAll(idset, (Object[])types);
                    filter2.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                }
                evi.setFilter(filter2);
                evi.setSelector(selector);
                coll2 = OperationTypeFactory.getRemoteInstance().getCollection(evi);
                objs = coll2.toArray();
            }
            this.entryOperationType.setValue(objs);
            value = cp.getCustomerParam(ENTRYEXPENSETYPE);
            objs = null;
            if (!StringUtils.isEmpty((String)value)) {
                types = StringUtils.split((String)value, (String)"\u2014\u2014");
                evi = new EntityViewInfo();
                FilterInfo filter3 = new FilterInfo();
                if (types.length == 1) {
                    filter3.getFilterItems().add(new FilterItemInfo("id", types[0]));
                } else {
                    idset = new HashSet();
                    CollectionUtils.addAll(idset, (Object[])types);
                    filter3.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                }
                evi.setFilter(filter3);
                evi.setSelector(selector);
                coll2 = ExpenseTypeFactory.getRemoteInstance().getCollection(evi);
                objs = coll2.toArray();
            }
            this.entryExpenseType.setValue(objs);
            value = cp.getCustomerParam(COSTCOMPANY);
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            if (!StringUtils.isEmpty((String)value)) {
                HashSet costCompanyIds = new HashSet();
                Object[] ids = value.split(",");
                CollectionUtils.addAll(costCompanyIds, (Object[])ids);
                companyFilter = new FilterInfo();
                companyFilter.getFilterItems().add(new FilterItemInfo("id", costCompanyIds, CompareType.INCLUDE));
                entityView = new EntityViewInfo();
                entityView.setFilter(companyFilter);
                entityView.setSelector(selector);
                companyCollection = companyOrgUnit.getCompanyOrgUnitCollection(entityView);
                this.prmtCostCompany.setValue((Object)companyCollection.toArray());
            }
            HashSet applierCompanyIds = new HashSet();
            value = cp.getCustomerParam(APPLIERCOMPANY);
            if (!StringUtils.isEmpty((String)value)) {
                Object[] ids = value.split(",");
                CollectionUtils.addAll(applierCompanyIds, (Object[])ids);
                companyFilter = new FilterInfo();
                companyFilter.getFilterItems().add(new FilterItemInfo("id", applierCompanyIds, CompareType.INCLUDE));
                entityView = new EntityViewInfo();
                entityView.setFilter(companyFilter);
                entityView.setSelector(selector);
                companyCollection = companyOrgUnit.getCompanyOrgUnitCollection(entityView);
                this.prmtApplierCompany.setData((Object)companyCollection.toArray());
            }
            value = cp.getCustomerParam(ENTRYCOSTCOMPANY);
            objs = null;
            if (!StringUtils.isEmpty((String)value)) {
                Object[] ids = value.split(",");
                filter = new FilterInfo();
                if (ids.length == 1) {
                    filter.getFilterItems().add(new FilterItemInfo("id", ids[0]));
                } else {
                    idSet = new HashSet();
                    CollectionUtils.addAll(idSet, (Object[])ids);
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                }
                entityView = new EntityViewInfo();
                entityView.setFilter(filter);
                entityView.setSelector(selector);
                coll = companyOrgUnit.getCompanyOrgUnitCollection(entityView);
                objs = coll.toArray();
            }
            this.entryCostCompany.setValue((Object)objs);
            value = cp.getCustomerParam(ENTRYCOSTCENTER);
            objs = null;
            if (!StringUtils.isEmpty((String)value)) {
                Object[] ids = value.split(",");
                filter = new FilterInfo();
                if (ids.length == 1) {
                    filter.getFilterItems().add(new FilterItemInfo("id", ids[0]));
                } else {
                    idSet = new HashSet();
                    CollectionUtils.addAll(idSet, (Object[])ids);
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                }
                entityView = new EntityViewInfo();
                entityView.setFilter(filter);
                entityView.setSelector(selector);
                coll = CostCenterOrgUnitFactory.getRemoteInstance().getCollection(entityView);
                objs = coll.toArray();
            }
            this.entryCostCenter.setValue((Object)objs);
            value = cp.getCustomerParam(PAYMODE);
            if (!StringUtils.isEmpty((String)value)) {
                ISettlementType settlementType = SettlementTypeFactory.getRemoteInstance();
                pk = new ObjectUuidPK(value);
                this.prmtPayMode.setValue((Object)settlementType.getSettlementTypeInfo((IObjectPK)pk, selector));
            }
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        if (result.getInt(PRIOR) != -1) {
            this.cbPrior.setSelectedItem((Object)PriorEnum.getEnum(result.getInt(PRIOR)));
        }
        if (!StringUtils.isEmpty((String)result.getCustomerParam(CAUSE))) {
            this.txtCause.setText(result.getCustomerParam(CAUSE));
        }
        this.btnAbandon.setSelected(cp.getBoolean(ABANDON));
        this.btnStatePayed.setSelected(cp.getBoolean(STATEPAYED));
        this.btnStateAudited.setSelected(cp.getBoolean(STATEAUDITED));
        this.btnStateAuditFailed.setSelected(cp.getBoolean(STATEAUDITFAILED));
        this.btnStateCancel.setSelected(cp.getBoolean(STATECANCEL));
        this.btnStateClosed.setSelected(cp.getBoolean(STATECLOSED));
        this.btnStateInAudit.setSelected(cp.getBoolean(STATEINAUDIT));
        this.btnStateNew.setSelected(cp.getBoolean(STATENEW));
    }

    public IUIActionPostman prepareCustomerParams(CustomerParams cp) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare((String)"CustomerParams", (CoreUIObject)this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handleCustomerParams");
        requestContext.put("customerParams", (Object)cp.getCustomerParamsHashMap());
        requestContext.put("isCalledByAccount", (Object)new Boolean(this.isCalledByAccount));
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    public boolean isPrepareCustomerParams() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void showIsPayBillBox() throws Exception {
        this.btnStateIsPayBill.setVisible(true);
        this.btnStatePayed.setVisible(true);
    }
}

