/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.ExpenseSortCollection;
import com.kingdee.eas.cp.bc.ExpenseSortFactory;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.client.AbstractExpenseSortEditUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class ExpenseSortEditUI
extends AbstractExpenseSortEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseSortEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.menuItemPrint.setEnabled(false);
        this.menuItemPrintPreview.setEnabled(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.btnSubmit.setEnabled(true);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnFirst.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            this.txtNumber.requestFocus();
            throw new ExpSortException(ExpSortException.SORTNUMBER_NOT_NULL);
        }
        if (this.txtSortName.getText() == null || this.txtSortName.getText().trim().equals("")) {
            this.txtSortName.requestFocus();
            throw new ExpSortException(ExpSortException.SORTNAME_NOT_NULL);
        }
        super.beforeStoreFields(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnFirst.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionRemove_actionPerformed(e);
        }
        catch (SQLException ee) {
            new ExpSortException(ExpSortException.SORTNAME_NOT_NULL);
        }
    }

    protected IObjectValue createNewData() {
        ExpenseSortInfo tempInfo = new ExpenseSortInfo();
        tempInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        tempInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tempInfo.setIsStart(true);
        return tempInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ExpenseSortFactory.getRemoteInstance();
    }

    private void checkSortName() throws Exception {
        String tempName = null;
        tempName = this.txtSortName.getText().trim();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        ExpenseSortInfo tempInfo = null;
        ExpenseSortCollection tempCollection = ExpenseSortFactory.getRemoteInstance().getExpenseSortCollection(ev);
        int n = tempCollection.size();
        for (int i = 0; i < n; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.get("sortName").equals(tempName)) continue;
            this.txtSortName.requestFocus();
            throw new ExpSortException(ExpSortException.SORTNAME_REPEAT);
        }
    }
}

