/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BillTypeFactory;
import com.kingdee.eas.cp.bc.BillTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.client.AbstractExpenseTypeBillTypeSettingEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ExpenseTypeBillTypeSettingEditUI
extends AbstractExpenseTypeBillTypeSettingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseTypeBillTypeSettingEditUI.class);
    private static final String BizCR = "com.kingdee.eas.cp.bc.BizCollResource";
    private ExpenseTypeCollection expenseTypeCollection;
    private Object[] billTypes;

    public void onLoad() throws Exception {
        FilterInfo filter;
        super.onLoad();
        List idList = (List)this.getUIContext().get("idList");
        if (idList != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            this.expenseTypeCollection = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeCollection(viewInfo);
        }
        CoreBaseCollection coreBase = new CoreBaseCollection();
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        coreBase = BillTypeFactory.getRemoteInstance().getCollection(view);
        ArrayList<BillTypeInfo> list = new ArrayList<BillTypeInfo>();
        for (int i = 0; i < coreBase.size(); ++i) {
            BillTypeInfo info = (BillTypeInfo)coreBase.get(i);
            list.add(info);
        }
        this.billTypeF7.setMyCommonUseEnabled(false);
        this.billTypes = list.toArray();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        Object[] billTypes = (Object[])this.billTypeF7.getData();
        if (billTypes == null || billTypes[0] == null) {
            MsgBox.showInfo((String)EASResource.getString((String)BizCR, (String)"RelationBillInfo"));
            return;
        }
        boolean isAddOperation = this.doRelease.isSelected();
        if (isAddOperation) {
            this.updateExpenseType();
            this.disposeUIWindow();
        } else {
            this.batchDeleteBillType();
            this.disposeUIWindow();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void batchDeleteBillType() throws EASBizException, BOSException {
        Object[] billTypes = (Object[])this.billTypeF7.getData();
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < this.expenseTypeCollection.size(); ++i) {
            ExpenseTypeInfo expenseTypeInfo = this.expenseTypeCollection.get(i);
            for (int j = 0; j < billTypes.length; ++j) {
                BillTypeInfo billTypeInfo = (BillTypeInfo)billTypes[j];
                ExpenseTypeEntryInfo info = new ExpenseTypeEntryInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setBillType(billTypeInfo);
                info.setExpenseType(expenseTypeInfo);
                boolean isRelationTable = false;
                for (int k = 0; k < expenseTypeInfo.getEntry().size(); ++k) {
                    ExpenseTypeEntryInfo entry = expenseTypeInfo.getEntry().get(k);
                    BOSUuid uuid = entry.getBillType().getId();
                    if (!uuid.equals((Object)billTypeInfo.getId())) continue;
                    expenseTypeInfo.getEntry().removeObject(k);
                }
            }
            StringBuffer billTypeName = this.setExpenseBillTypeName(expenseTypeInfo);
            expenseTypeInfo.setBillTypeName(billTypeName.toString());
            colls.add((CoreBaseInfo)expenseTypeInfo);
        }
        ExpenseTypeFactory.getRemoteInstance().update(colls);
    }

    private void updateExpenseType() throws EASBizException, BOSException {
        Object[] billTypes = (Object[])this.billTypeF7.getData();
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < this.expenseTypeCollection.size(); ++i) {
            ExpenseTypeInfo expenseTypeInfo = this.expenseTypeCollection.get(i);
            StringBuffer billTypeName = null;
            for (int j = 0; j < billTypes.length; ++j) {
                BillTypeInfo billTypeInfo = (BillTypeInfo)billTypes[j];
                ExpenseTypeEntryInfo info = new ExpenseTypeEntryInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setBillType(billTypeInfo);
                info.setExpenseType(expenseTypeInfo);
                boolean isRelationTable = false;
                for (int k = 0; k < expenseTypeInfo.getEntry().size(); ++k) {
                    BOSUuid uuid = expenseTypeInfo.getEntry().get(k).getBillType().getId();
                    if (!uuid.equals((Object)billTypeInfo.getId())) continue;
                    isRelationTable = true;
                }
                if (isRelationTable) continue;
                expenseTypeInfo.getEntry().add(info);
            }
            billTypeName = this.setExpenseBillTypeName(expenseTypeInfo);
            expenseTypeInfo.setBillTypeName(billTypeName.toString());
            colls.add((CoreBaseInfo)expenseTypeInfo);
        }
        ExpenseTypeFactory.getRemoteInstance().update(colls);
    }

    private StringBuffer setExpenseBillTypeName(ExpenseTypeInfo expenseTypeInfo) {
        StringBuffer billTypeName = new StringBuffer();
        for (int k = 0; k < expenseTypeInfo.getEntry().size(); ++k) {
            BOSUuid uuid = expenseTypeInfo.getEntry().get(k).getBillType().getId();
            for (int l = 0; l < this.billTypes.length; ++l) {
                BillTypeInfo billTypeInfo = (BillTypeInfo)this.billTypes[l];
                if (!uuid.equals((Object)billTypeInfo.getId())) continue;
                billTypeName.append(billTypeInfo.getName());
                break;
            }
            if (k >= expenseTypeInfo.getEntry().size() - 1) continue;
            billTypeName.append(",");
        }
        return billTypeName;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void submit_actionPerformed(ActionEvent e) throws Exception {
        super.submit_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.submit.setEnabled(true);
        this.cancel.setEnabled(true);
    }
}

