/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.bc.IItemApprovedTree;
import com.kingdee.eas.cp.bc.ItemApprovedFacadeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeCollection;
import com.kingdee.eas.cp.bc.ItemApprovedTreeException;
import com.kingdee.eas.cp.bc.ItemApprovedTreeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeInfo;
import com.kingdee.eas.cp.bc.VehicleBaseDataInfo;
import com.kingdee.eas.cp.bc.client.AbstractItemTest;
import com.kingdee.eas.cp.bc.client.ItemTestEdit;
import com.kingdee.eas.cp.bc.util.ReadBudgetType;
import com.kingdee.eas.cp.bc.util.SourceInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class ItemTest
extends AbstractItemTest {
    private static final Logger logger = CoreUIObject.getLogger(ItemTest.class);
    private static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseAccountResource";
    private static final String ROOT = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"ITEM_ROOT_NAME");

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblMain();
        this.kDWorkButton1.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("longNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("displayName").getStyleAttributes().setLocked(true);
        this.treeMain_valueChanged(null);
        this.btnEdit.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemView.setVisible(false);
        this.btnView.setVisible(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo tempFilter = super.getDefaultFilterForTree();
        FilterInfo addFilter = null;
        if (tempFilter != null) {
            addFilter = new FilterInfo();
            addFilter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0", CompareType.EQUALS));
            addFilter.setMaskString(" #0 ");
            try {
                tempFilter.mergeFilter(addFilter, "AND");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return tempFilter;
    }

    protected String getRootName() {
        return ROOT;
    }

    private void initTblMain() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"tree", (Object)this.treeMain);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return ItemApprovedTreeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ItemTestEdit.class.getName();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        ItemApprovedTreeInfo selectInfo = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            if (!this.getSelectedTreeNode().getUserObject().toString().equals(ROOT)) {
                try {
                    selectInfo = (ItemApprovedTreeInfo)this.getSelectedTreeNode().getUserObject();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)selectInfo.getLongNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString("(#0 or #1)");
                    view.getSorter().add(new SorterItemInfo("longNumber"));
                    view.setFilter(filter);
                    this.mainQuery = view;
                }
                catch (Exception view) {}
            } else {
                this.mainQuery = new EntityViewInfo();
            }
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        int rows = this.tblMain.getRowCount();
        IRow tempRow = null;
        boolean isLeaf = true;
        int tempDepartID = -1;
        int tempClassID = -1;
        String longNumber = null;
        boolean isDepartRoot = false;
        KDBizPromptBox promptBox = null;
        for (int i = 0; i < rows; ++i) {
            promptBox = new KDBizPromptBox();
            promptBox.setEditable(false);
            promptBox.setCommitFormat("$id$");
            promptBox.setEditFormat("$name$");
            promptBox.setDisplayFormat("$name$");
            tempRow = this.tblMain.getRow(i);
            isLeaf = (Boolean)tempRow.getCell("isLeaf").getValue();
            tempDepartID = (Integer)tempRow.getCell("itemClassID").getValue();
            longNumber = (String)tempRow.getCell("longNumber").getValue();
            tempClassID = (Integer)tempRow.getCell("itemClassID").getValue();
            isDepartRoot = longNumber != null && longNumber.indexOf(33) < 0;
            if (!isLeaf && tempDepartID != ReadBudgetType.DEPARTIDVALUE) {
                this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
            }
            if (isDepartRoot) {
                this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
            }
            if (tempClassID == ReadBudgetType.PERSONIDVALUE) {
                promptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
            } else if (tempClassID == ReadBudgetType.DEPARTIDVALUE) {
                promptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery");
            } else if (tempClassID == ReadBudgetType.VEHICLEIDVALUE) {
                promptBox.setQueryInfo("com.kingdee.eas.cp.bc.app.F7VehicleBaseQuery");
                promptBox.setHasCUDefaultFilter(false);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
                evi.setFilter(filter);
                promptBox.setEntityViewInfo(evi);
            }
            this.tblMain.getRow(i).getCell("displayInfo").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        }
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    @Override
    public void actionItem_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"SYNCHROITEM_K3_CONFIRM")) != 0) {
            return;
        }
        String filePath = SourceInfo.PROPERTIESFILE;
        if (filePath == null || filePath.length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ITEMFILE_NOT_EXIST"));
            return;
        }
        List tempList = ReadBudgetType.getBudgetArray(ReadBudgetType.getBudgetList(filePath));
        if (tempList == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ITEMFILE_IS_NULL"));
            return;
        }
        String[] tempArray = new String[tempList.size()];
        int m = tempList.size();
        for (int i = 0; i < m; ++i) {
            tempArray[i] = (String)tempList.get(i);
        }
        if (ItemApprovedFacadeFactory.getRemoteInstance().synchroItem(tempArray)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SYNITEM_SUCCESS"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SYNITEM_FAILURE"));
        }
        this.refresh(e);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.getOldValue() != null && e.getOldValue().equals(this.tblMain.getRow(e.getRowIndex()).getCell("displayInfo").getValue())) {
            return;
        }
        if (e.getColIndex() == this.tblMain.getColumnIndex("displayInfo")) {
            VehicleBaseDataInfo vehInfo;
            int rowIndex = e.getRowIndex();
            int itemClassId = (Integer)this.tblMain.getRow(rowIndex).getCell("itemClassID").getValue();
            String uuid = null;
            String displayName = null;
            String id = null;
            IItemApprovedTree iItem = null;
            ItemApprovedTreeInfo itemInfo = null;
            iItem = ItemApprovedTreeFactory.getRemoteInstance();
            itemInfo = iItem.getItemApprovedTreeInfo((IObjectPK)new ObjectUuidPK(this.tblMain.getRow(rowIndex).getCell("id").getValue().toString()));
            id = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            if (this.tblMain.getRow(rowIndex).getCell("displayInfo").getValue() == null) {
                itemInfo.setLinkId(null);
                itemInfo.setDisplayInfo(null);
                itemInfo.setItemNumber(null);
                iItem.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)itemInfo);
                return;
            }
            String itemNumber = null;
            String selfName = this.tblMain.getRow(rowIndex).getCell("name").getValue().toString();
            String longNumber = this.tblMain.getRow(rowIndex).getCell("longNumber").getValue().toString();
            if (longNumber != null) {
                longNumber = longNumber.substring(longNumber.indexOf("!") + 1);
                longNumber = longNumber.replace('!', '.');
            }
            String mainName = this.tblMain.getRow(rowIndex).getCell("displayName").getValue().toString();
            if ((mainName = mainName.substring(0, mainName.indexOf("_"))) != null && selfName != null) {
                StringBuffer tempItem = new StringBuffer();
                tempItem.append(mainName);
                tempItem.append("---");
                tempItem.append(longNumber);
                tempItem.append("---");
                tempItem.append(selfName);
                itemNumber = tempItem.toString();
            }
            if (itemClassId == ReadBudgetType.DEPARTIDVALUE) {
                CostCenterOrgUnitInfo tempInfo = (CostCenterOrgUnitInfo)this.tblMain.getRow(rowIndex).getCell("displayInfo").getValue();
                if (tempInfo != null) {
                    uuid = tempInfo.getId().toString();
                    displayName = tempInfo.getName();
                }
            } else if (itemClassId == ReadBudgetType.PERSONIDVALUE) {
                PersonInfo personInfo = (PersonInfo)this.tblMain.getRow(rowIndex).getCell("displayInfo").getValue();
                if (personInfo != null) {
                    uuid = personInfo.getId().toString();
                    displayName = personInfo.getName();
                }
            } else if (itemClassId == ReadBudgetType.VEHICLEIDVALUE && (vehInfo = (VehicleBaseDataInfo)this.tblMain.getRow(rowIndex).getCell("displayInfo").getValue()) != null) {
                uuid = vehInfo.getId().toString();
                displayName = vehInfo.getName();
            }
            if (this.checkExistEASBudget(uuid)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"69_ItemTest"));
                KDTEditManager kdtManager = this.tblMain.getEditManager();
                kdtManager.editCellAt(rowIndex, this.tblMain.getColumnIndex("displayInfo"));
                SysUtil.abort();
            }
            itemInfo.setLinkId(uuid);
            itemInfo.setDisplayInfo(displayName);
            itemInfo.setItemNumber(itemNumber);
            iItem.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)itemInfo);
            this.tblMain.getRow(rowIndex).getCell("linkId").setValue((Object)uuid);
        }
    }

    protected boolean checkExistEASBudget(String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("linkId", (Object)id, CompareType.EQUALS));
        filter.setMaskString(" (#0 or #1) and #2 ");
        ev.setFilter(filter);
        IItemApprovedTree iItem = null;
        Object itemInfo = null;
        ItemApprovedTreeCollection itemCollection = null;
        iItem = ItemApprovedTreeFactory.getRemoteInstance();
        itemCollection = iItem.getItemApprovedTreeCollection(ev);
        return itemCollection.size() > 0;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.setEASQuery(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (!treeNode.isRoot()) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"70_ItemTest")) == 0) {
                ItemApprovedTreeInfo selectInfo = (ItemApprovedTreeInfo)this.getSelectedTreeNode().getUserObject();
                this.removeNode(selectInfo);
                this.refresh(e);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"71_ItemTest"));
            return;
        }
    }

    protected void removeNode(ItemApprovedTreeInfo info) throws ItemApprovedTreeException {
        if (info == null) {
            return;
        }
        IItemApprovedTree iItemTree = null;
        try {
            iItemTree = ItemApprovedTreeFactory.getRemoteInstance();
            if (info.isIsLeaf()) {
                iItemTree.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            } else {
                BOSUuid id = info.getId();
                ItemApprovedTreeInfo tempInfo = null;
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
                filter.setMaskString(" #0 ");
                ev.setFilter(filter);
                ItemApprovedTreeCollection collection = iItemTree.getItemApprovedTreeCollection(ev);
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    tempInfo = collection.get(i);
                    this.removeNode(tempInfo);
                }
                iItemTree.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
        catch (Exception e) {
            throw new ItemApprovedTreeException(ItemApprovedTreeException.DELETE_TREENODE_ERROR);
        }
    }

    protected void setEASQuery(KDTMouseEvent e) {
        boolean isLeaf = true;
        int tempDepartID = -1;
        int tempClassID = -1;
        String longNumber = null;
        boolean isDepartRoot = false;
        int rowIndex = e.getRowIndex();
        IRow tempRow = this.tblMain.getRow(rowIndex);
        isLeaf = (Boolean)tempRow.getCell("isLeaf").getValue();
        tempDepartID = (Integer)tempRow.getCell("itemClassID").getValue();
        longNumber = (String)tempRow.getCell("longNumber").getValue();
        tempClassID = (Integer)tempRow.getCell("itemClassID").getValue();
        isDepartRoot = longNumber != null && longNumber.indexOf(33) < 0;
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setEditable(false);
        promptBox.setCommitFormat("$id$");
        promptBox.setEditFormat("$name$");
        promptBox.setDisplayFormat("$name$");
        if (!isLeaf && tempDepartID != ReadBudgetType.DEPARTIDVALUE) {
            this.tblMain.getRow(rowIndex).getStyleAttributes().setLocked(true);
        }
        if (isDepartRoot) {
            this.tblMain.getRow(rowIndex).getStyleAttributes().setLocked(true);
        }
        if (tempClassID == ReadBudgetType.PERSONIDVALUE) {
            promptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        } else if (tempClassID == ReadBudgetType.DEPARTIDVALUE) {
            promptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery");
        } else if (tempClassID == ReadBudgetType.VEHICLEIDVALUE) {
            promptBox.setQueryInfo("com.kingdee.eas.cp.bc.app.F7VehicleBaseQuery");
            promptBox.setHasCUDefaultFilter(false);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
            promptBox.setEntityViewInfo(evi);
        }
        this.tblMain.getRow(rowIndex).getCell("displayInfo").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }
}

