/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractLoanReqQueryPanelUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanReqQueryPanelUI
extends AbstractLoanReqQueryPanelUI {
    private String RES = "com.kingdee.eas.cp.bc.client.LoanReqResource";
    private static final Logger logger = CoreUIObject.getLogger(LoanReqQueryPanelUI.class);
    boolean isToVoucher = false;
    boolean isRelaFi = false;

    public LoanReqQueryPanelUI() throws Exception {
        this.jbInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void jbInit() throws Exception {
        try {
            this.prepareInitUIData().callHandler();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        MakeControl.makeReqDepF7(this.promptOrgUnit);
        this.comboPrior.setSelectedItem(null);
        this.comboLoanType.addItems((Object[])new BizCollBillTypeEnum[]{BizCollBillTypeEnum.DAILY_LOAN, BizCollBillTypeEnum.EVECTION_LOAN});
        this.comboLoanType.setSelectedItem(null);
        this.isRelaFi = BizCollUtil.isNeedRelaFi();
        this.isToVoucher = BizCollUtil.isLoanToVoucher();
        if (!this.isToVoucher) {
            this.radioButtonAlreadyPayment.setText(StateEnum.ALREADYVOUCHER.toString());
        }
        this.clear();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = this.uiToData();
        BizCollUtil.getAndMask(this.filterInfo);
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        Map result = (Map)param;
        this.clear();
        this.txtName.setText((String)result.get("name"));
        this.promptApplier.setValue(result.get("applier"));
        this.promptOrgUnit.setValue(result.get("orgUnit"));
        this.promptCompany.setValue(result.get("company"));
        this.comboPrior.setSelectedItem(result.get("prior"));
        this.comboLoanType.setSelectedItem(result.get("loanType"));
        this.bizPromptCurrencyType.setValue(result.get("currency"));
        this.txtNumberFrom.setText((String)result.get("numberFrom"));
        this.dateStartDate.setValue(result.get("startDate"));
        this.dateEndDate.setValue(result.get("endDate"));
        int state = (Integer)result.get("state");
        this.stategroup.setValue(state);
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.txtName.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            result.put("name", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.promptApplier.getValue())) {
            result.put("applier", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.promptOrgUnit.getValue())) {
            result.put("orgUnit", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.promptCompany.getValue())) {
            result.put("company", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.comboPrior.getSelectedItem())) {
            result.put("prior", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.comboLoanType.getSelectedItem())) {
            result.put("loanType", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.bizPromptCurrencyType.getValue())) {
            result.put("currency", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.txtNumberFrom.getText())) {
            result.put("numberFrom", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.dateStartDate.getValue())) {
            result.put("startDate", object);
        }
        if (!BizCollUtil.objectIsNull(object = this.dateEndDate.getValue())) {
            result.put("endDate", object);
        }
        object = new Integer(this.stategroup.getValue());
        result.put("state", object);
        return result;
    }

    protected FilterInfo uiToData() {
        FilterItemInfo filterItemInfo;
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)this.txtName.getText())) {
            filterItemInfo = new FilterItemInfo("name", (Object)("%" + this.txtName.getText().trim() + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.promptApplier.getData())) {
            filterItemInfo = new FilterItemInfo("applier.id", (Object)((PersonInfo)this.promptApplier.getData()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.promptOrgUnit.getData())) {
            filterItemInfo = new FilterItemInfo("orgUnit.id", (Object)((AdminOrgUnitInfo)this.promptOrgUnit.getData()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.promptCompany.getValue())) {
            filterItemInfo = new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)this.promptCompany.getValue()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.comboPrior.getSelectedItem())) {
            filterItemInfo = new FilterItemInfo("prior", (Object)new Integer(((PriorEnum)((Object)this.comboPrior.getSelectedItem())).getValue()), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.comboLoanType.getSelectedItem())) {
            filterItemInfo = new FilterItemInfo("billTypeCode", (Object)new Integer(((BizCollBillTypeEnum)((Object)this.comboLoanType.getSelectedItem())).getValue()), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.bizPromptCurrencyType.getValue())) {
            filterItemInfo = new FilterItemInfo("currencyType.id", (Object)((CurrencyInfo)this.bizPromptCurrencyType.getValue()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            filterItemInfo = new FilterItemInfo("number", (Object)("%" + this.txtNumberFrom.getText().trim() + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.dateStartDate.getTimestamp())) {
            filterItemInfo = new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.format((Date)BizCollUtil.downTimestamp(this.dateStartDate.getTimestamp())), CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!BizCollUtil.objectIsNull(this.dateEndDate.getTimestamp())) {
            filterItemInfo = new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.format((Date)BizCollUtil.downTimestamp(this.dateEndDate.getTimestamp())), CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (this.radioButtonAlreadyPayment.isSelected()) {
            if (!this.isToVoucher) {
                filterItemInfo = new FilterItemInfo("state", (Object)new Integer(45), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                filterItemInfo = new FilterItemInfo("state", (Object)new Integer(70), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (this.radioButtonCancel.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(25), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (this.radioButtonChecked.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (this.radioButtonCheckFaild.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(40), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (this.radioButtonChecking.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(30), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (this.radioButtonClosed.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(80), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (this.radioButtonSave.isSelected()) {
            filterItemInfo = new FilterItemInfo("state", (Object)new Integer(20), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        return filterInfo;
    }

    private void initDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.dateStartDate.setValue((Object)cal.getTime());
        this.dateEndDate.setValue((Object)date);
    }

    public void clear() {
        super.clear();
        this.txtName.setText(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.bizPromptCurrencyType.setValue(null);
        this.promptOrgUnit.setData(null);
        this.promptApplier.setData(null);
        this.comboPrior.setSelectedItem(null);
        this.comboLoanType.setSelectedItem(null);
        this.promptCompany.setValue(null);
        this.dateStartDate.setValue(null);
        this.dateEndDate.setValue(null);
        this.radioButtonAll.setSelected(true);
        this.initDate();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object object = null;
        object = this.txtName.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("name", (String)object);
        }
        object = this.promptApplier.getValue();
        PersonInfo personInfo = (PersonInfo)object;
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("applier", personInfo.getId().toString());
        }
        object = this.promptOrgUnit.getValue();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)object;
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("orgUnit", adminOrgUnitInfo.getId().toString());
        }
        object = this.promptCompany.getValue();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)object;
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("company", companyOrgUnitInfo.getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.comboPrior.getSelectedItem())) {
            cp.addCustomerParam("prior", String.valueOf(((PriorEnum)((Object)object)).getName()));
        }
        if (!BizCollUtil.objectIsNull(object = this.comboLoanType.getSelectedItem())) {
            cp.addCustomerParam("loanType", String.valueOf(((BizCollBillTypeEnum)((Object)object)).getName()));
        }
        object = this.bizPromptCurrencyType.getValue();
        CurrencyInfo currencyInfo = (CurrencyInfo)object;
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("currency", currencyInfo.getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.txtNumberFrom.getText())) {
            cp.addCustomerParam("numberFrom", object.toString());
        }
        object = this.dateStartDate.getValue();
        DateFormat df = MultilingualUtil.getDateFormat();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam("startDate", df.format(object));
        }
        if (!BizCollUtil.objectIsNull(object = this.dateEndDate.getValue())) {
            cp.addCustomerParam("endDate", df.format(object));
        }
        object = new Integer(this.stategroup.getValue());
        cp.addCustomerParam("state", object.toString());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CustomerParams result = cp;
        this.clear();
        this.txtName.setText(result.getCustomerParam("name"));
        String id = result.getCustomerParam("applier");
        Object value = BizCollUtil.returnObjectValueById(id);
        this.promptApplier.setData(value);
        id = result.getCustomerParam("orgUnit");
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (id != null) {
            try {
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                adminOrgUnitInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.promptOrgUnit.setData(adminOrgUnitInfo);
        id = result.getCustomerParam("company");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (id != null) {
            try {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompany.getValue((IObjectPK)new ObjectUuidPK(id));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.promptCompany.setData(companyOrgUnitInfo);
        String priorName = result.getCustomerParam("prior");
        int nSize = this.comboPrior.getItemCount();
        for (int i = 0; i < nSize; ++i) {
            PriorEnum info = (PriorEnum)((Object)this.comboPrior.getItemAt(i));
            if (info == null || info.getName() == null || !info.getName().equals(priorName)) continue;
            this.comboPrior.setSelectedIndex(i);
            break;
        }
        String bizCollBillTypeName = result.getCustomerParam("loanType");
        nSize = this.comboPrior.getItemCount();
        for (int i = 0; i < nSize; ++i) {
            BizCollBillTypeEnum info = (BizCollBillTypeEnum)((Object)this.comboLoanType.getItemAt(i));
            if (info == null || info.getName() == null || !info.getName().equals(bizCollBillTypeName)) continue;
            this.comboLoanType.setSelectedIndex(i);
            break;
        }
        id = result.getCustomerParam("currency");
        value = BizCollUtil.returnObjectValueById(id);
        this.bizPromptCurrencyType.setData(value);
        this.txtNumberFrom.setText(result.getCustomerParam("numberFrom"));
        DateFormat df = MultilingualUtil.getDateFormat();
        try {
            this.dateStartDate.setValue((Object)df.parse(result.getCustomerParam("startDate")));
            this.dateEndDate.setValue((Object)df.parse(result.getCustomerParam("endDate")));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        int state = Integer.parseInt(result.getCustomerParam("state"));
        this.stategroup.setValue(state);
    }

    public boolean isPrepareInitUIData() {
        return true;
    }

    public IUIActionPostman prepareInitUIData() {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare((String)"InitUIData", (CoreUIObject)this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handleInitUIData");
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    public static class ConditionSearchParam
    implements Serializable {
        public static final String NAME = "name";
        public static final String APPLIER = "applier";
        public static final String ORGUNIT = "orgUnit";
        public static final String COMPANY = "company";
        public static final String PRIOR = "prior";
        public static final String LOANTYPE = "loanType";
        public static final String CURRENCY = "currency";
        public static final String NUMBERFROM = "numberFrom";
        public static final String NUMBERTO = "numberTo";
        public static final String STARTDATE = "startDate";
        public static final String ENDDATE = "endDate";
        public static final String STATE = "state";
    }
}

