/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.MarketAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.MarketAccountBillFactory;
import com.kingdee.eas.cp.bc.MarketAccountBillInfo;
import com.kingdee.eas.cp.bc.client.AbstractMarketAccountEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;

public class MarketAccountEditUI
extends AbstractMarketAccountEditUI {
    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuItemViewSubmitProccess.setVisible(false);
        this.menuItemViewBudget.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
    }

    @Override
    protected void initUIData() {
        super.initUIData();
        this.getDetailTable().getColumn("happenTime").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        KDDatePicker dateBox = new KDDatePicker();
        dateBox.setTimeEnabled(false);
        dateBox.setMilliSecondEnable(false);
        dateBox.setDateEnabled(true);
        dateBox.setDatePattern(MultilingualUtil.getDateFormatString());
        this.getDetailTable().getColumn("happenTime").setEditor((ICellEditor)new KDTDefaultCellEditor(dateBox));
        this.getDetailTable().getColumn("amount").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        this.getDetailTable().getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDTDefaultCellEditor itemEditor = null;
        KDFormattedTextField txtAmountQuatity = new KDFormattedTextField(1);
        txtAmountQuatity.setEditable(true);
        txtAmountQuatity.setPrecision(2);
        itemEditor = new KDTDefaultCellEditor((JTextField)txtAmountQuatity);
        this.getDetailTable().getColumn("amount").setEditor((ICellEditor)itemEditor);
        JButton btnAddRuleNew = this.ctnEntry.add((Action)this.actionAddLine);
        JButton btnDelRuleNew = this.ctnEntry.add((Action)this.actionRemoveLine);
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setToolTipText(this.btnAddLine.getToolTipText());
        btnAddRuleNew.setSize(22, 19);
        btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelRuleNew.setToolTipText(this.btnRemoveLine.getToolTipText());
        btnDelRuleNew.setSize(22, 19);
        this.kdtEntries.getColumn("happenTime").getStyleAttributes().setBackground(BizCollUtil.REQUIRE_COLOR);
        this.kdtEntries.getColumn("amount").getStyleAttributes().setBackground(BizCollUtil.REQUIRE_COLOR);
        this.kdtEntries.getColumn("name").getStyleAttributes().setBackground(BizCollUtil.REQUIRE_COLOR);
        this.kdtEntries.getColumn("purpose").getStyleAttributes().setBackground(BizCollUtil.REQUIRE_COLOR);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        MarketAccountBillEntryInfo lineInfo = new MarketAccountBillEntryInfo();
        lineInfo.setAmount(new BigDecimal("0.00"));
        return lineInfo;
    }

    @Override
    protected IObjectValue createNewData() {
        MarketAccountBillInfo info = new MarketAccountBillInfo();
        info.setName(BizCollBillTypeEnum.MARKET_ACCOUNT.toString());
        this.buildData(info);
        info.getEntries().add((MarketAccountBillEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    @Override
    protected void checkEntry(KDTable table) throws Exception {
        super.checkEntry(table);
        int rows = this.getDetailTable().getRowCount();
        IRow row = null;
        KDTEditManager kdtManager = this.getDetailTable().getEditManager();
        for (int i = 0; i < rows; ++i) {
            BigDecimal obj;
            row = this.getDetailTable().getRow(i);
            if (this.objectIsNull(row.getCell("name").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("name"));
                throw new ExpAccException(ExpAccException.ACTIVE_NOT_NULL);
            }
            if (this.objectIsNull(row.getCell("happenTime").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("happenTime"));
                throw new ExpAccException(ExpAccException.ACTIVEDATA_NOT_NULL);
            }
            if (this.objectIsNull(row.getCell("purpose").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("purpose"));
                throw new ExpAccException(ExpAccException.CONTENT_NOT_NULL);
            }
            BigDecimal bigDecimal = obj = row.getCell("amount") == null ? ZERO : row.getCell("amount").getValue();
            if (MarketAccountEditUI.toBigDecimal(obj).compareTo(ZERO) >= 0) continue;
            kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("amount"));
            throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("tel"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("prior"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("supportedObj.number"));
        sic.add(new SelectorItemInfo("supportedObj.name"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("expenseType.typeName"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("budgetAmount"));
        sic.add(new SelectorItemInfo("budgetBalance"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountStriked"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountRefunded"));
        sic.add(new SelectorItemInfo("amountSendedBack"));
        sic.add(new SelectorItemInfo("payMode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("accessoryCount"));
        sic.add(new SelectorItemInfo("payMode.number"));
        sic.add(new SelectorItemInfo("payMode.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.name"));
        sic.add(new SelectorItemInfo("entries.purpose"));
        sic.add(new SelectorItemInfo("entries.happenTime"));
        sic.add(new SelectorItemInfo("entries.comment"));
        sic.add(new SelectorItemInfo("entries.amount"));
        return sic;
    }

    @Override
    protected BizCollBillTypeEnum[] getCountBillType() {
        return new BizCollBillTypeEnum[]{BizCollBillTypeEnum.MARKET_ACTIVITY_EXPENSE};
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MarketAccountBillFactory.getRemoteInstance();
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }
}

