/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.MarketActivityBillEntryInfo;
import com.kingdee.eas.cp.bc.MarketActivityBillFactory;
import com.kingdee.eas.cp.bc.MarketActivityBillInfo;
import com.kingdee.eas.cp.bc.client.AbstractMarketActivityEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JTextField;

public class MarketActivityEditUI
extends AbstractMarketActivityEditUI {
    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        MarketActivityBillEntryInfo ret = new MarketActivityBillEntryInfo();
        ret.setAmount(new BigDecimal("0.0"));
        return ret;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected IObjectValue createNewData() {
        MarketActivityBillInfo ret = new MarketActivityBillInfo();
        super.fillBillHeader(ret);
        ret.getEntries().add((MarketActivityBillEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return ret;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MarketActivityBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getBaseSelectors();
        SelectorItemCollection superSic = super.getSelectors();
        int n = superSic.size();
        for (int i = 0; i < n; ++i) {
            sic.add(superSic.get(i));
        }
        return sic;
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.kdtEntries.getColumnIndex("amount")) {
            super.caculateBillAmount();
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntries.getColumn("amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)BizCollUtil.getMoneyEditor()));
        KDDatePicker dateBox = new KDDatePicker();
        this.kdtEntries.getColumn("happenTime").setEditor((ICellEditor)new KDTDefaultCellEditor(dateBox));
        this.btnWFViewSubmitProccess.setVisible(false);
        this.menuItemViewSubmitProccess.setVisible(false);
        this.menuItemViewBudget.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        KDTSelectManager kdtManager = this.getDetailTable().getSelectManager();
        IRow row = null;
        ICell cell = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntries.getRow(i);
            cell = row.getCell("name");
            if (BizCollUtil.objectIsNull(cell.getValue())) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYNAME_EXCEPTION);
            }
            cell = row.getCell("happenTime");
            if (cell.getValue() == null) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYTIME_EXCEPTION);
            }
            cell = row.getCell("purpose");
            if (BizCollUtil.objectIsNull(cell.getValue())) {
                kdtManager.select(i, cell.getColumnIndex());
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYCONTENT_EXCEPTION);
            }
            cell = row.getCell("amount");
            if (this.isEntryAmountZero || !BizCollUtil.bigDecimalObjectLessEqual(cell.getValue(), BizCollUtil.ZERO)) continue;
            kdtManager.select(i, cell.getColumnIndex());
            throw new ExpenseReqException(ExpenseReqException.NEGTIVE_ENTRY_AMOUNT_ERROR);
        }
    }

    @Override
    protected void setRequiredColumn() {
        String[] columns = new String[]{"name", "happenTime", "purpose", "amount"};
        this.requiredColumn = columns;
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }
}

