/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.IMarketAccountBill;
import com.kingdee.eas.cp.bc.MarketAccountBillFactory;
import com.kingdee.eas.cp.bc.MarketAccountBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractMarketExpenseAccountListUI;
import com.kingdee.eas.cp.bc.client.MarketAccountEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class MarketExpenseAccountListUI
extends AbstractMarketExpenseAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(MarketExpenseAccountListUI.class);
    private static final String RESIMPORT = "com.kingdee.eas.cp.bc.ImportDataResource";
    private static BizCollBillTypeEnum[] billTypes = new BizCollBillTypeEnum[]{BizCollBillTypeEnum.MARKET_ACTIVITY_EXPENSE};

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bizReqDate").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.tblMain.getColumn("amount").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}n");
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.menuItemBatchSubmit.setEnabled(true);
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("tel"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("prior"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("supportedObj.number"));
        sic.add(new SelectorItemInfo("supportedObj.name"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("expenseType.typeName"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("fundPlan.name"));
        sic.add(new SelectorItemInfo("fundPlan.number"));
        sic.add(new SelectorItemInfo("budgetAmount"));
        sic.add(new SelectorItemInfo("budgetBalance"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountStriked"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountRefunded"));
        sic.add(new SelectorItemInfo("payMode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.name"));
        sic.add(new SelectorItemInfo("entries.purpose"));
        sic.add(new SelectorItemInfo("entries.happenTime"));
        sic.add(new SelectorItemInfo("entries.comment"));
        sic.add(new SelectorItemInfo("entries.amount"));
        return sic;
    }

    @Override
    protected BizCollBillTypeEnum[] getCountBillType() {
        return billTypes;
    }

    @Override
    protected String getEditUIName() {
        return MarketAccountEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MarketAccountBillFactory.getRemoteInstance();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.cpbc.MarketExpenseAccount";
        param.alias = BizCollUtil.getTemplateSheetName("MarketExpenseAccount");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.cpbc.MarketExpenseAccount";
        param.alias = BizCollUtil.getTemplateSheetName("MarketExpenseAccount");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        List idList = this.getSelectIdList();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        IMarketAccountBill iMarket = null;
        MarketAccountBillInfo marketInfo = null;
        String tempId = null;
        iMarket = MarketAccountBillFactory.getRemoteInstance();
        Iterator ite = idList.iterator();
        int count = 0;
        try {
            while (ite.hasNext()) {
                tempId = (String)ite.next();
                marketInfo = iMarket.getMarketAccountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempId)));
                if (!StateEnum.DRAFT.equals((Object)marketInfo.getState()) && !StateEnum.NEW.equals((Object)marketInfo.getState())) continue;
                marketInfo.setState(StateEnum.SUBMIT);
                iMarket.submit((CoreBaseInfo)marketInfo);
                ++count;
            }
        }
        catch (Exception ee) {
            int sizecount = idList.size() - count;
            StringBuffer sb = new StringBuffer(EASResource.getString((String)RESIMPORT, (String)"BATCHSUBMITFAILED"));
            sb.append("(");
            sb.append(sizecount);
            sb.append(")");
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
        }
        StringBuffer sb = new StringBuffer(EASResource.getString((String)RESIMPORT, (String)"BATCHSUBMITSUCCESS"));
        sb.append("(");
        sb.append(count);
        sb.append(")");
        MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
        this.refresh(e);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatchsubmit.setVisible(true);
        this.btnBatchsubmit.setEnabled(true);
        this.btnBatchsubmit.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
    }
}

