/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.client.AbstractOperationTypeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class OperationTypeEditUI
extends AbstractOperationTypeEditUI {
    private static final long serialVersionUID = 5248049270530467513L;
    private static final Logger logger = CoreUIObject.getLogger(OperationTypeEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setButtonState();
        MakeControl.makeCompanyF7(this.promCompanyName, (CoreUIObject)this);
        KDBizPromptBox billTypePromBox = new KDBizPromptBox();
        MakeControl.makeBillTypeF7(billTypePromBox, null);
        if (this.oprtState.equals(OprtState.EDIT) || this.oprtState.equals(OprtState.VIEW)) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("billType.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parentId", (Object)this.editData.getId().toString()));
            view.setFilter(filterInfo);
        }
        if (this.oprtState.equals(OprtState.VIEW)) {
            this.btnRemove.setVisible(false);
            this.btnEdit.setVisible(false);
        }
    }

    protected IObjectValue createNewData() {
        OperationTypeInfo data = new OperationTypeInfo();
        data.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        data.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        data.setIsEnable(true);
        return data;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OperationTypeFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            throw new OperationException(OperationException.OPRTTYPE_NUMBER_NOT_NULL);
        }
        if (this.txtName.getSelectedItem() == null || StringUtils.isEmpty((String)this.txtName.getSelectedItem().toString())) {
            this.txtName.requestFocus();
            throw new OperationException(OperationException.OPRTTYPE_NAME_NOT_NULL);
        }
        if (this.promCompanyName.getData() == null) {
            this.promCompanyName.requestFocus();
            throw new ExpAccException(ExpSortException.COMPANY_NOTNULL);
        }
    }

    @Override
    public void loadFields() {
        this.setAutoNumber();
        super.loadFields();
        this.promCompanyName.setData((Object)this.editData.getCompany());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("isEnable"));
        sic.add(new SelectorItemInfo("discription"));
        sic.add(new SelectorItemInfo("CU.name"));
        return sic;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.promCompanyName.setEnabled(false);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setButtonState();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setButtonState();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setButtonState();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setButtonState();
    }

    protected void setButtonState() {
        if ("ADDNEW".equals(this.oprtState)) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
        } else if ("EDIT".equals(this.oprtState)) {
            this.btnRemove.setEnabled(this.editData.isIsEnable());
            this.menuItemRemove.setEnabled(this.editData.isIsEnable());
            this.btnEdit.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
        } else if ("VIEW".equals(this.oprtState)) {
            this.btnRemove.setEnabled(this.editData.isIsEnable());
            this.menuItemRemove.setEnabled(this.editData.isIsEnable());
            this.btnEdit.setEnabled(this.editData.isIsEnable());
            this.menuItemEdit.setEnabled(this.editData.isIsEnable());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo unitInfo = null;
        unitInfo = this.editData.getCompany();
        if (!SysContext.getSysContext().getCurrentFIUnit().getId().equals((Object)unitInfo.getId())) {
            throw new OperationException(OperationException.OPRTTYPE_NOT_BELONGTOCURRCOMPANY);
        }
        super.actionEdit_actionPerformed(e);
        this.setButtonState();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
    }

    private void setAutoNumber() {
        if (OprtState.ADDNEW.equals(this.oprtState)) {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            OperationTypeInfo info = this.editData;
            if (info == null || orgUnitInfo == null || orgUnitInfo.getId() == null) {
                return;
            }
            String orgUnitId = orgUnitInfo.getId().toString();
            ICodingRuleManager codingRuleManager = null;
            try {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                boolean result = codingRuleManager.isExist((IObjectValue)info, orgUnitId);
                if (result) {
                    if (codingRuleManager.isAddView((IObjectValue)info, orgUnitId)) {
                        String[] properties = codingRuleManager.getProperties((IObjectValue)info, orgUnitId);
                        if (properties != null && properties.length > 0) {
                            throw new OperationException(OperationException.CODINGRULE_HAS_PROPERTIES);
                        }
                        String number = codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
                        info.setString("number", number);
                    }
                    boolean isModifiable = codingRuleManager.isModifiable((IObjectValue)info, orgUnitId);
                    this.txtNumber.setEnabled(isModifiable);
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setButtonState();
    }
}

