/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.OperationTypeCollection;
import com.kingdee.eas.cp.bc.OperationTypeF7Enum;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.client.AbstractOperationTypeF7UI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class OperationTypeF7UI
extends AbstractOperationTypeF7UI {
    private static final long serialVersionUID = -5586700593910757385L;
    private static final Logger logger = CoreUIObject.getLogger(OperationTypeF7UI.class);
    public boolean isCanceled = true;
    public OperationTypeInfo data = null;
    public OperationTypeCollection datas = null;
    private boolean isMultiSelect = false;
    private boolean isContainParent = true;
    private EntityViewInfo entityViewInfo = null;
    private String billType;
    String containParent = null;

    public void onLoad() throws Exception {
        this.billType = (String)this.getUIContext().get("billType");
        if (this.getUIContext().get("containParent") != null) {
            this.entityViewInfo = (EntityViewInfo)this.getUIContext().get("containParent");
            if (this.entityViewInfo.getFilter() != null) {
                this.containParent = this.entityViewInfo.getFilter().getFilterItems().get(0).getCompareValue().toString();
            }
        }
        if ("checked".equals(this.containParent)) {
            this.ckContainParent.setEnabled(false);
            this.ckContainParent.setSelected(true);
        }
        if (this.getUIContext().get("isMultiSelect") != null) {
            this.isMultiSelect = (Boolean)this.getUIContext().get("isMultiSelect");
        }
        super.onLoad();
        this.btnConfirm.setEnabled(true);
        this.btnQuit.setEnabled(true);
        this.btnFastQuery.setEnabled(true);
        this.ckLike.setSelected(true);
        if (this.isMultiSelect) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        this.ckContainParent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OperationTypeF7UI.this.mainQuery = new EntityViewInfo();
                OperationTypeF7UI.this.mainQuery.setFilter(OperationTypeF7UI.this.getDefaultFilterForQuery());
                OperationTypeF7UI.this.execQuery();
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0) {
            if (e.getClickCount() == 2) {
                this.actionConfirm_actionPerformed(null);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OperationTypeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        this.getData();
        if (this.data == null && !this.isMultiSelect) {
            return;
        }
        if (this.datas == null && this.isMultiSelect) {
            return;
        }
        this.getUIWindow().close();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(null);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.isContainParent != this.ckContainParent.isSelected()) {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        }
        this.execQuery();
    }

    @Override
    public void actionFastQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        String value = this.txtValue.getText();
        if (!StringUtils.isEmpty((String)value)) {
            if (this.ckLike.isSelected()) {
                value = "%" + value.trim() + "%";
                if (OperationTypeF7Enum.Name.equals(this.cbKey.getSelectedItem())) {
                    filter.getFilterItems().add(new FilterItemInfo("operationType.name", (Object)value, CompareType.LIKE));
                } else if (OperationTypeF7Enum.Number.equals(this.cbKey.getSelectedItem())) {
                    filter.getFilterItems().add(new FilterItemInfo("operationType.number", (Object)value, CompareType.LIKE));
                }
            } else {
                value = value.trim();
                if (OperationTypeF7Enum.Name.equals(this.cbKey.getSelectedItem())) {
                    filter.getFilterItems().add(new FilterItemInfo("operationType.name", (Object)value));
                } else if (OperationTypeF7Enum.Number.equals(this.cbKey.getSelectedItem())) {
                    filter.getFilterItems().add(new FilterItemInfo("operationType.number", (Object)value));
                }
            }
            FilterInfo defaultFilter = this.getDefaultFilterForQuery();
            if (defaultFilter.getFilterItems() != null && defaultFilter.getFilterItems().size() > 0) {
                filter.mergeFilter(defaultFilter, "AND");
            }
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(filter);
            this.execQuery();
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        } else {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
            this.execQuery();
        }
    }

    private void getData() throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        ObjectUuidPK selectedPk = null;
        HashSet<String> selectedIds = null;
        int bottom = 0;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isEnable"));
        if (this.isMultiSelect) {
            selectedIds = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    selectedIds.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
                }
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
            SelectorItemCollection sc = viewInfo.getSelector();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("number"));
            sc.add(new SelectorItemInfo("name"));
            this.datas = OperationTypeFactory.getRemoteInstance().getOperationTypeCollection(viewInfo);
            if (this.datas == null || this.datas.size() <= 0) {
                this.datas = null;
            }
        } else if (size > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            selectedPk = new ObjectUuidPK(this.tblMain.getRow(sb.getTop()).getCell("id").getValue().toString());
            this.data = OperationTypeFactory.getRemoteInstance().getOperationTypeInfo((IObjectPK)selectedPk, sic);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String companyId = (String)this.getUIContext().get("companyId");
        String costCenterId = (String)this.getUIContext().get("costCenterId");
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (companyId == null && company != null) {
            companyId = company.getId().toString();
        }
        if (this.ckContainParent.isSelected()) {
            this.isContainParent = true;
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        } else {
            this.isContainParent = false;
        }
        if ("query".equals(this.billType)) {
            if (!this.isContainParent) {
                String[] numbers = StringUtils.split((String)company.getLongNumber(), (String)"!");
                List<String> numberList = Arrays.asList(numbers);
                filter.getFilterItems().add(new FilterItemInfo("company.number", new HashSet<String>(numberList), CompareType.INCLUDE));
            }
        } else {
            Set operationIds = new HashSet();
            try {
                operationIds = BizBaseDataWebFacadeFactory.getRemoteInstance().getOperationIdsByCompany(companyId, this.billType, costCenterId);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (operationIds.size() == 0) {
                filter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)"nodata"));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("operationType.id", operationIds, CompareType.INCLUDE));
            }
        }
        return filter;
    }

    @Override
    public boolean isPrepareActionConfirm() {
        return true;
    }

    @Override
    public RequestContext prepareActionConfirm(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionConfirm(itemAction);
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        ObjectUuidPK selectedPk = null;
        HashSet<String> selectedIds = null;
        int bottom = 0;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isEnable"));
        request.put("isMultiSelect", (Object)new Boolean(this.isMultiSelect));
        if (this.isMultiSelect) {
            selectedIds = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    selectedIds.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
                }
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
            SelectorItemCollection sc = viewInfo.getSelector();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("number"));
            sc.add(new SelectorItemInfo("name"));
            request.put("viewInfo", (Object)viewInfo);
        } else {
            request.put("size", (Object)new Integer(size));
            if (size > 0) {
                sb = this.tblMain.getSelectManager().get(0);
                selectedPk = new ObjectUuidPK(this.tblMain.getRow(sb.getTop()).getCell("id").getValue().toString());
                request.put("selectedPk", (Object)selectedPk);
                request.put("sic", (Object)sic);
            }
        }
        return request;
    }
}

