/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.client.AbstractRecordsOfCheckSourceBillUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordsOfCheckSourceBillUI
extends AbstractRecordsOfCheckSourceBillUI {
    private static final Logger logger = CoreUIObject.getLogger(RecordsOfCheckSourceBillUI.class);
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.doForLoanAndReturn();
        int columns = this.kdSourceBills.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            this.kdSourceBills.getColumn(i).setSortable(true);
        }
        this.kdSourceBills.setEditable(false);
        this.kdSourceBills.getSelectManager().setSelectMode(10);
    }

    private void doForLoanAndReturn() {
        Map ctx = this.getUIContext();
        if (ctx.get("sourceBillType").equals("otherExpense") || ctx.get("sourceBillType").equals("evectionReq")) {
            this.setUITitle(EASResource.getString((String)RESBIZCOLL, (String)"reqCheck"));
        } else if (ctx.get("billtype").equals((Object)BizCollBillTypeEnum.REPAYMENT)) {
            this.setUITitle(EASResource.getString((String)RESBIZCOLL, (String)"loanRepay"));
        } else {
            this.setUITitle(EASResource.getString((String)RESBIZCOLL, (String)"loanCheck"));
        }
        List results = null;
        try {
            results = CommonUtilFacadeFactory.getRemoteInstance().getSourceBills((String)ctx.get("sourceBillType"), (Map)ctx.get("filterValue"));
            this.fillDataToLoanRcrdsTable(results);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void initKDTable(KDTable tbl, int rowNum) {
        tbl.checkParsed();
        tbl.addRows(rowNum);
    }

    private void fillDataToLoanRcrdsTable(List infos) {
        SimpleDateFormat sdf = (SimpleDateFormat)MultilingualUtil.getDateTimeFormat();
        this.kdSourceBills.removeRows();
        if (infos != null && infos.size() <= 0) {
            KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
            sort.setSortAuto(true);
            this.kdSourceBills.setSortMange(sort);
            return;
        }
        int rowNum = infos.size();
        this.initKDTable(this.kdSourceBills, rowNum);
        int exchangeRatePrecision = 4;
        for (int i = 0; i < rowNum; ++i) {
            Map info = (Map)infos.get(i);
            if (info == null) continue;
            int colIndex = 0;
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("number"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("applier.name"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("bizReqDate"));
            if (info.get("cause") != null) {
                this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("cause"));
            } else {
                this.kdSourceBills.getCell(i, colIndex++).setValue((Object)"");
            }
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("expenseType"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("sourceBillProjectName"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("sourceBillCostCenterName"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("currencyTypeName"));
            this.kdSourceBills.getCell(i, colIndex).setValue(info.get("exchangeRate"));
            if (info.get("exchangeRatePrecision") != null) {
                exchangeRatePrecision = Integer.valueOf(info.get("exchangeRatePrecision").toString());
            }
            this.kdSourceBills.getCell(i, colIndex++).getFormattedStyleAttributes().setNumberFormat(BizCollUtil.getFormatString(exchangeRatePrecision));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("amountBalanceOri"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("amountBalance"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("id"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("entryid"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("amountUsed"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("hasSourceBill"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("sourceBillExpenseTypeId"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("sourceBillCostCenterId"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("convertMode"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("amountControlType"));
            this.kdSourceBills.getCell(i, colIndex++).setValue((Object)exchangeRatePrecision);
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("currencyTypeId"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("sourceBillProjectId"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("amountApproved"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("isCreatePrePaymentBill"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("isCreatePayBill"));
            this.kdSourceBills.getCell(i, colIndex++).setValue(info.get("isCreatePayPlanBill"));
        }
        this.kdSourceBills.checkParsed();
        KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
        sort.setSortAuto(true);
        sort.addGroup(0, this.kdSourceBills.getRowCount() - 2);
        this.kdSourceBills.setSortMange(sort);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    protected void kDBtnOk_actionPerformed(ActionEvent e) throws Exception {
        Map ctx = this.getUIContext();
        List list = BizCollUtil.getSelectRowList(this.kdSourceBills);
        if (list != null && (ctx.get("billtype").equals((Object)BizCollBillTypeEnum.BIZ_ACCOUNT_OUT) || ctx.get("billtype").equals((Object)BizCollBillTypeEnum.DAILY_PURCHASE_ACCOUNT))) {
            Boolean isCreatePrePayment = false;
            Boolean isCreatePay = false;
            Boolean isCreatePlanPay = false;
            String prePayBillNumber = "";
            String payBillNumber = "";
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Map map = (Map)list.get(i);
                if (map.get("isCreatePrePaymentBill") != null && ((Boolean)map.get("isCreatePrePaymentBill")).booleanValue()) {
                    isCreatePrePayment = true;
                    prePayBillNumber = (String)map.get("number");
                }
                if (map.get("isCreatePayBill") != null && ((Boolean)map.get("isCreatePayBill")).booleanValue()) {
                    isCreatePay = true;
                    payBillNumber = (String)map.get("number");
                }
                if (map.get("isCreatePayPlanBill") == null || !((Boolean)map.get("isCreatePayPlanBill")).booleanValue()) continue;
                isCreatePlanPay = true;
                payBillNumber = (String)map.get("number");
            }
            if (isCreatePrePayment.booleanValue() && (isCreatePay.booleanValue() || isCreatePlanPay.booleanValue())) {
                throw new BizCollException(BizCollException.PROHIBITMIXEDBUSINESS, new Object[]{prePayBillNumber, payBillNumber});
            }
        }
        SysContext.getSysContext().setProperty((Object)"checkSourceIds", null);
        if (list != null && list.size() > 0) {
            SysContext.getSysContext().setProperty((Object)"checkSourceIds", (Object)list);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void kDBtnCal_actionPerformed(ActionEvent e) throws Exception {
        SysContext.getSysContext().setProperty((Object)"checkSourceIds", null);
        this.getUIWindow().close();
    }

    public void onShow() throws Exception {
        Map ctx;
        boolean isShowProject;
        super.onShow();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP033");
        Map paramMap = ExpenseCommenFacadeFactory.getRemoteInstance().getParams(paramList);
        boolean bl = isShowProject = paramMap.get("CP033") == null ? false : new Boolean(paramMap.get("CP033").toString());
        if (!isShowProject && this.kdSourceBills.getColumn("sourceBillProjectName") != null) {
            this.kdSourceBills.getColumn("sourceBillProjectName").getStyleAttributes().setHided(true);
        }
        if ("dailyLoan".equals((ctx = this.getUIContext()).get("sourceBillType")) || "evectionLoan".equals(ctx.get("sourceBillType"))) {
            this.kdSourceBills.getColumn("isCreatePrePaymentBill").getStyleAttributes().setHided(false);
            this.kdSourceBills.getColumn("isCreatePayBill").getStyleAttributes().setHided(false);
        }
    }
}

