/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.bc.BizCollRptUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.RecordsOfLoanAndRepayFacadeFactory;
import com.kingdee.eas.cp.bc.client.AbstractRecordsOfLendAndRepayUI;
import com.kingdee.eas.cp.bc.client.LoanAndReturnDateUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RecordsOfLendAndRepayUI
extends AbstractRecordsOfLendAndRepayUI {
    private static final long serialVersionUID = -442387679170453746L;
    private static final Date[] DEFAULT_RETURN_DATE = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private boolean isRelaFi;
    private boolean isRelaCn;
    private PersonInfo applierInfo;
    private Object currentTime;
    private Date startDate;
    private Date endDate;
    private static final SimpleDateFormat DATE_FORMAT = (SimpleDateFormat)MultilingualUtil.getDateTimeFormat();
    private DateFormat dateFomate = MultilingualUtil.getDateFormat();
    private boolean containsHasRepay = false;
    private final String sum = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.LoanReqResource", (String)"SumOfMoney");
    static SimpleDateFormat sdf = (SimpleDateFormat)MultilingualUtil.getDateFormat();
    private static final Logger logger = CoreUIObject.getLogger(RecordsOfLendAndRepayUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        if (this.containsHasRepay) {
            this.containsHasRepayChecked.setVisible(false);
        } else {
            this.containsHasRepayChecked.setVisible(true);
        }
        this.containsHasRepayChecked.setSelected(this.containsHasRepay);
        this.initUIParam();
        this.setDateLable(null);
        this.setPersonLable();
        this.doForLoanAndReturn();
        int columns = this.lendMoneyRcrdTbl.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            this.lendMoneyRcrdTbl.getColumn(i).setSortable(true);
        }
        this.lendMoneyRcrdTbl.setEditable(false);
        this.lendMoneyRcrdTbl.getSelectManager().setSelectMode(2);
    }

    private void setPersonLable() throws EASBizException, BOSException {
        this.kDLabel12.setText(this.applierInfo.getName());
    }

    private void setDateLable(String[] dateArray) {
        if (dateArray == null) {
            String startDateTmp = MultilingualUtil.formatDate(this.startDate);
            String endDateTmp = MultilingualUtil.formatDate(this.endDate);
            this.kDLabel4.setText(startDateTmp);
            this.kDLabel6.setText(endDateTmp);
        } else {
            this.kDLabel4.setText(dateArray[0]);
            this.kDLabel6.setText(dateArray[1]);
        }
    }

    private void initUIParam() {
        Map ctx = this.getUIContext();
        this.applierInfo = (PersonInfo)ctx.get("applier");
        this.currentTime = ctx.get("createTime");
        this.isRelaFi = (Boolean)ctx.get("isRelaFi");
        this.isRelaCn = (Boolean)ctx.get("isRelaCn");
        this.dealWithTime();
    }

    private void dealWithTime() {
        if (this.currentTime instanceof KDDatePicker) {
            this.dealWithTime((KDDatePicker)this.currentTime);
        } else if (this.currentTime instanceof Timestamp) {
            this.dealWithTime((Timestamp)this.currentTime);
        }
    }

    private void dealWithTime(KDDatePicker currentTime) {
        String strTime = currentTime.getText();
        String[] array = strTime.trim().split("-");
        this.startDate = new Date(this.changeStrToInt(array[0]) - 1900, this.changeStrToInt(array[1]) - 1, 1);
        this.endDate = array[1].trim().equals("12") ? new Date(this.changeStrToInt(array[0]) - 1899, 1, 1) : new Date(this.changeStrToInt(array[0]) - 1900, this.changeStrToInt(array[1]), 1);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.endDate = new Date(now.getTime());
    }

    private void dealWithTime(Timestamp currentTime) {
        int year = currentTime.getYear();
        int month = currentTime.getMonth();
        this.startDate = new Date(year, month, 1);
        this.endDate = month == 12 ? new Date(year + 1, 1, 1) : new Date(year, month + 1, 1);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.endDate = new Date(now.getTime());
    }

    private void doForLoanAndReturn() {
        if (this.applierInfo == null) {
            return;
        }
        Map params = this.initParams();
        try {
            List results = RecordsOfLoanAndRepayFacadeFactory.getRemoteInstance().getRecordsOfLoanAndRepay(params);
            this.doForLoan(results);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Map initParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", this.startDate);
        params.put("endDate", this.endDate);
        params.put("applierId", this.applierInfo.getId().toString());
        params.put("containsHasRepay", new Boolean(this.containsHasRepay));
        params.put("isRelaFi", this.isRelaFi);
        params.put("isRelaCn", this.isRelaCn);
        return params;
    }

    private void fillDataToLoanRcrdsTable(List infos) {
        this.lendMoneyRcrdTbl.removeRows();
        if (infos != null && infos.size() <= 0) {
            KDTSortManager sort = new KDTSortManager(this.lendMoneyRcrdTbl);
            sort.setSortAuto(true);
            this.lendMoneyRcrdTbl.setSortMange(sort);
            return;
        }
        int rowNum = infos.size();
        this.initKDTable(this.lendMoneyRcrdTbl, rowNum);
        BigDecimal amountApprovedTotal = new BigDecimal("0.00");
        BigDecimal amountUsedTotal = new BigDecimal("0.00");
        BigDecimal returnAmountTotal = new BigDecimal("0.00");
        BigDecimal noReturnAmountTotal = new BigDecimal("0.00");
        BigDecimal amountApproved = new BigDecimal("0.00");
        BigDecimal amountUsed = new BigDecimal("0.00");
        BigDecimal returnAmount = new BigDecimal("0.00");
        BigDecimal noReturnAmount = new BigDecimal("0.00");
        BigDecimal amountBalance = new BigDecimal("0.0");
        String loanState = "";
        String cause = "";
        for (int i = 0; i < rowNum; ++i) {
            Map info = (Map)infos.get(i);
            if (info == null) continue;
            amountApproved = (BigDecimal)info.get("amountApproved");
            amountUsed = (BigDecimal)info.get("amountUsed");
            returnAmount = (BigDecimal)info.get("returnAmount");
            noReturnAmount = (BigDecimal)info.get("noReturnAmount");
            amountBalance = (BigDecimal)info.get("amountBalance");
            cause = (String)info.get("cause");
            this.lendMoneyRcrdTbl.getCell(i, 1).setValue((Object)MultilingualUtil.formatDate((Date)info.get("bizReqDate")));
            this.lendMoneyRcrdTbl.getCell(i, 7).setValue((Object)MultilingualUtil.formatDate((Date)info.get("foreseeDate")));
            this.lendMoneyRcrdTbl.getCell(i, 0).setValue(info.get("id"));
            this.lendMoneyRcrdTbl.getCell(i, 2).setValue(info.get("number"));
            this.lendMoneyRcrdTbl.getCell(i, 3).setValue((Object)amountApproved);
            this.lendMoneyRcrdTbl.getCell(i, 4).setValue((Object)amountUsed);
            this.lendMoneyRcrdTbl.getCell(i, 5).setValue((Object)returnAmount);
            this.lendMoneyRcrdTbl.getCell(i, 6).setValue((Object)amountBalance);
            loanState = noReturnAmount.compareTo(new BigDecimal("0.00")) <= 0 ? BizCollRptUtil.IS_LOAN : BizCollRptUtil.NO_LOAN;
            this.lendMoneyRcrdTbl.getCell(i, 8).setValue((Object)loanState);
            this.lendMoneyRcrdTbl.getCell(i, 9).setValue((Object)cause);
            amountApprovedTotal = amountApprovedTotal.add(amountApproved);
            amountUsedTotal = amountUsedTotal.add(amountUsed);
            returnAmountTotal = returnAmountTotal.add(returnAmount);
            noReturnAmountTotal = noReturnAmountTotal.add(amountBalance);
        }
        this.lendMoneyRcrdTbl.getCell(rowNum, 1).setValue((Object)this.sum);
        this.lendMoneyRcrdTbl.getCell(rowNum, 3).setValue((Object)amountApprovedTotal);
        this.lendMoneyRcrdTbl.getCell(rowNum, 4).setValue((Object)amountUsedTotal);
        this.lendMoneyRcrdTbl.getCell(rowNum, 5).setValue((Object)returnAmountTotal);
        this.lendMoneyRcrdTbl.getCell(rowNum, 6).setValue((Object)noReturnAmountTotal);
        this.lendMoneyRcrdTbl.checkParsed();
        KDTSortManager sort = new KDTSortManager(this.lendMoneyRcrdTbl);
        sort.setSortAuto(true);
        sort.addGroup(0, this.lendMoneyRcrdTbl.getRowCount() - 2);
        this.lendMoneyRcrdTbl.setSortMange(sort);
    }

    private int changeStrToInt(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        return Integer.valueOf(str);
    }

    private Date changeStrToDate(String str) {
        String[] array = str.split("-|/");
        return new Date(this.changeStrToInt(array[0]) - 1900, this.changeStrToInt(array[1]) - 1, this.changeStrToInt(array[2]));
    }

    private Date[] getDateArray(String[] array) {
        Date[] dateArray = new Date[2];
        for (int i = 0; i < 2; ++i) {
            try {
                dateArray[i] = sdf.parse(array[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return dateArray;
    }

    protected void excuteQuery(String[] array) {
        if (this.applierInfo == null) {
            return;
        }
        Date[] dateArray = this.getDateArray(array);
        this.startDate = dateArray[0];
        this.endDate = dateArray[1];
        this.containsHasRepay = array[2].equals("32");
        Map params = this.initParams();
        try {
            List results = RecordsOfLoanAndRepayFacadeFactory.getRemoteInstance().getRecordsOfLoanAndRepay(params);
            this.doForLoan(results);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.setDateLable(array);
        if (!this.containsHasRepay) {
            this.containsHasRepayChecked.setVisible(false);
        } else {
            this.containsHasRepayChecked.setVisible(true);
        }
        this.containsHasRepayChecked.setSelected(this.containsHasRepay);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("loanStartDate", this.kDLabel4.getText());
        ctx.put("loanEndDate", this.kDLabel6.getText());
        ctx.put("containsHasRepay", this.containsHasRepay);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow messageDialog = uiFactory.create(LoanAndReturnDateUI.class.getName(), ctx);
        messageDialog.show();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.viewBillInfo();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected void doForLoan(List infos) {
        this.fillDataToLoanRcrdsTable(infos);
    }

    private void initKDTable(KDTable tbl, int rowNum) {
        tbl.checkParsed();
        tbl.addRows(rowNum + 1);
    }

    private Date maxDate(Date currentDate) {
        Date date = null;
        try {
            date = DATE_FORMAT.parse(currentDate.toString() + " 23:59:59");
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        return date;
    }

    private boolean isRelatingWithFinance() {
        BOSUuid companyId = SysContext.getSysContext().getCurrentFIUnit().getId();
        IParamControl iParam = null;
        try {
            iParam = ParamControlFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        String value = null;
        try {
            value = iParam.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CP002");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return "true".equals(value);
    }

    private void viewBillInfo() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.lendMoneyRcrdTbl);
        if (rows != null) {
            if (rows.length < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            if (this.lendMoneyRcrdTbl.getCell(rows[0], 0).getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            String billID = this.lendMoneyRcrdTbl.getCell(rows[0], 0).getValue().toString();
            uiContext.put((Object)"ID", (Object)billID);
            String editUIName = null;
            DailyLoanBillInfo dailyLoanBillInfo = new DailyLoanBillInfo();
            BOSObjectType dailyBosType = dailyLoanBillInfo.getBOSType();
            EvectionLoanBillInfo evectionLoanBillInfo = new EvectionLoanBillInfo();
            BOSObjectType evectionBosType = evectionLoanBillInfo.getBOSType();
            if (new ObjectUuidPK(billID).getObjectType().equals((Object)dailyBosType)) {
                editUIName = "com.kingdee.eas.cp.bc.client.DailyLoanBillEditUI";
            } else if (new ObjectUuidPK(billID).getObjectType().equals((Object)evectionBosType)) {
                editUIName = "com.kingdee.eas.cp.bc.client.EvectionLoanBillEditUI";
            }
            try {
                IUIWindow uiWindow = null;
                uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void lendMoneyRcrdTbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.viewBillInfo();
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareRelatingWithFinance() throws Exception {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare((String)"RelatingWithFinance", (CoreUIObject)this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handlePrepareRelatingWithFinance");
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    public boolean isPrepareRelatingWithFinance() {
        return true;
    }
}

