/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.client.AbstractRecordsOfReceiveSourceBillUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordsOfReceiveSourceBillUI
extends AbstractRecordsOfReceiveSourceBillUI {
    private static final Logger logger = CoreUIObject.getLogger(RecordsOfReceiveSourceBillUI.class);
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.doForReceiveAndReturn();
        int columns = this.kdSourceBills.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            this.kdSourceBills.getColumn(i).setSortable(true);
        }
        this.kdSourceBills.setEditable(false);
        this.kdSourceBills.getSelectManager().setSelectMode(10);
    }

    private void doForReceiveAndReturn() {
        Map ctx = this.getUIContext();
        try {
            this.setUITitle(EASResource.getString((String)RESBIZCOLL, (String)"receiveBill"));
            List results = CommonUtilFacadeFactory.getRemoteInstance().getReceiveBillList((Map)ctx.get("filterValue"));
            this.fillDataToReceiveRcrdsTable(results);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void fillDataToReceiveRcrdsTable(List infos) {
        SimpleDateFormat sdf = (SimpleDateFormat)MultilingualUtil.getDateTimeFormat();
        this.kdSourceBills.removeRows();
        if (infos == null || infos != null && infos.size() <= 0) {
            KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
            sort.setSortAuto(true);
            this.kdSourceBills.setSortMange(sort);
            return;
        }
        int rowNum = infos.size();
        this.initKDTable(this.kdSourceBills, rowNum);
        for (int i = 0; i < rowNum; ++i) {
            Map info = (Map)infos.get(i);
            if (info == null) continue;
            this.kdSourceBills.getCell(i, 0).setValue(info.get("receivePayerName"));
            this.kdSourceBills.getCell(i, 1).setValue(info.get("receivePayerAccount"));
            this.kdSourceBills.getCell(i, 2).setValue(info.get("receivePayerBank"));
            this.kdSourceBills.getCell(i, 3).setValue(info.get("receiveBillNumber"));
            this.kdSourceBills.getCell(i, 4).setValue(info.get("receiveDate"));
            this.kdSourceBills.getCell(i, 5).setValue(info.get("recBillType"));
            this.kdSourceBills.getCell(i, 6).setValue(info.get("receiveBank"));
            this.kdSourceBills.getCell(i, 7).setValue(info.get("receiveAccountBank"));
            this.kdSourceBills.getCell(i, 8).setValue(info.get("receiveAccount"));
            this.kdSourceBills.getCell(i, 9).setValue(info.get("receiveCurrency"));
            this.kdSourceBills.getCell(i, 10).setValue(info.get("receiveExchangeRate"));
            this.kdSourceBills.getCell(i, 11).setValue(info.get("receiveAmount"));
            this.kdSourceBills.getCell(i, 12).setValue(info.get("receiveAmountLoc"));
            this.kdSourceBills.getCell(i, 13).setValue(info.get("receiveBillId"));
        }
        this.kdSourceBills.checkParsed();
        KDTSortManager sort = new KDTSortManager(this.kdSourceBills);
        sort.setSortAuto(true);
        sort.addGroup(0, this.kdSourceBills.getRowCount() - 2);
        this.kdSourceBills.setSortMange(sort);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void initKDTable(KDTable tbl, int rowNum) {
        tbl.checkParsed();
        tbl.addRows(rowNum);
    }

    @Override
    protected void kDBtnOk_actionPerformed(ActionEvent e) throws Exception {
        List list = RecordsOfReceiveSourceBillUI.getSelectRowList(this.kdSourceBills);
        SysContext.getSysContext().setProperty((Object)"checkSourceIds", null);
        if (list != null && list.size() > 0) {
            SysContext.getSysContext().setProperty((Object)"checkSourceIds", (Object)list);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void kDBtnCal_actionPerformed(ActionEvent e) throws Exception {
        SysContext.getSysContext().setProperty((Object)"checkSourceIds", null);
        this.getUIWindow().close();
    }

    public static List getSelectRowList(KDTable table) throws ParseException {
        ArrayList<Map> list = new ArrayList<Map>();
        int size = table.getSelectManager().size();
        if (size == 0) {
            return null;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < rows.length && rows[i] >= 0; ++i) {
            list.add(RecordsOfReceiveSourceBillUI.convertRowToMap(table.getRow(rows[i])));
        }
        return list;
    }

    public static Map convertRowToMap(IRow row) throws ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("receiveBillId", row.getCell("receiveBillId").getValue());
        map.put("receivePayerName", row.getCell("receivePayerName").getValue());
        map.put("receivePayerAccount", row.getCell("receivePayerAccount").getValue());
        map.put("receivePayerBank", row.getCell("receivePayerBank").getValue());
        map.put("receiveBillNumber", row.getCell("receiveBillNumber").getValue());
        map.put("receiveDate", row.getCell("receiveDate").getValue());
        map.put("recBillType", row.getCell("recBillType").getValue());
        map.put("receiveBank", row.getCell("receiveBank").getValue());
        map.put("receiveAccountBank", row.getCell("receiveAccountBank").getValue());
        map.put("receiveAccount", row.getCell("receiveAccount").getValue());
        map.put("receiveCurrency", row.getCell("receiveCurrency").getValue());
        map.put("receiveExchangeRate", row.getCell("receiveExchangeRate").getValue());
        map.put("receiveAmount", row.getCell("receiveAmount").getValue());
        map.put("receiveAmountLoc", row.getCell("receiveAmountLoc").getValue());
        return map;
    }
}

