/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillWKFactory;
import com.kingdee.eas.cp.bc.client.AbstractTravelAccountWKListUI;
import com.kingdee.eas.cp.bc.client.TravelAccountWKEditUI;
import com.kingdee.eas.cp.bc.client.TravelAccountWKQueryUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TravelAccountWKListUI
extends AbstractTravelAccountWKListUI {
    private static final Logger logger = CoreUIObject.getLogger(TravelAccountWKListUI.class);
    private final String RES_EXPENSE = "com.kingdee.eas.cp.bc.client.ExpenseAccountResource";
    private Color countLineColor = new Color(240, 238, 217);
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.client.ForPrintResource";
    private static final String BILLQUERYNAME = "com.kingdee.eas.cp.bc.app.TravelAccWKForPrintQuery";
    private static final String MULTIAPPROVEQUERYNAME = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    private static final String DATAPATH = "/cp/bc/wk/tra";
    private String id = null;

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("IDList") != null) {
            return;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIContext().get("IDList") != null) {
            return;
        }
    }

    private void calculateColumnAmount(IRow countRow, String columnName) {
        if (countRow == null) {
            return;
        }
        KDTable table = this.tblMain;
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.0");
        BigDecimal amount = null;
        Object value = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = table.getRow(i);
            cell = row.getCell(columnName);
            if (cell == null || (amount = BizCollUtil.toBigDecimal(value = cell.getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        countRow.getCell(columnName).setValue((Object)columnAmount);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return TravelAccountWKEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TravelAccountBillWKFactory.getRemoteInstance();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    private List getSelectedByStatus(StateEnum status) {
        ArrayList<Object> ret = new ArrayList<Object>();
        KDTSelectBlock sb = null;
        Object obj = null;
        IRow row = null;
        int n = this.tblMain.getSelectManager().size();
        for (int i = 0; i < n; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                obj = row.getCell("state").getValue();
                if (!obj.toString().equals(status.toString())) continue;
                obj = row.getCell("id").getValue();
                ret.add(obj);
            }
        }
        return ret;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    @Override
    protected KDPanel getUserPanel() {
        super.getUserPanel();
        TravelAccountWKQueryUI ret = null;
        try {
            ret = new TravelAccountWKQueryUI();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return ret;
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"TRAVELACCOUNT_VIEW"));
        return dialog;
    }

    public KDTMenuManager getMenuManager(KDTable table) {
        return super.getMenuManager(table);
    }

    private void setPayFormatButton() {
        this.btnPayFormat.setEnabled(!this.getSelectedByStatus(StateEnum.CHECKED).isEmpty());
    }

    private void setToKVoucherButton() {
        this.btnToKVoucher.setEnabled(!this.getSelectedByStatus(StateEnum.CHECKED).isEmpty());
    }

    private void setRemoveButton() {
        this.btnRemove.setEnabled(!this.getSelectedByStatus(StateEnum.DRAFT).isEmpty());
    }

    private void setEditButton() {
        boolean flag = false;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object obj;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                flag = false;
            }
            if ((obj = (cell = row.getCell("state")).getValue()).toString().equals(StateEnum.NEW.toString()) || obj.toString().equals(StateEnum.DRAFT.toString())) {
                flag = true;
            }
        }
        this.btnEdit.setEnabled(flag);
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_TravelAccountBillWKEntry";
    }

    @Override
    protected String getTableName() {
        return "T_BC_TravelAccountBillWK";
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "name", "amount", "currencyType.id", "currencyType.name", "applier.id", "applier.name", "orgUnit.id", "orgUnit.name", "bizReqDate", "state"};
    }

    @Override
    protected void setTotalLine() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().setOrientation(1);
        IRow row0 = this.tblMain.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setBackground(new Color(240, 238, 217));
        row0.getCell(this.tblMain.getColumnIndex("number")).setValue((Object)EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpAccResource", (String)"total"));
        row0.getCell(this.getKeyFieldName()).setValue((Object)"0");
        row0.getCell("amount").setExpressions("SUM");
        row0.getCell("amount").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("entries.taxiExpense").setExpressions("SUM");
        row0.getCell("entries.taxiExpense").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("entries.taxiExpense").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("entries.bussesExpense").setExpressions("SUM");
        row0.getCell("entries.bussesExpense").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("entries.bussesExpense").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("entries.hotelExpense").setExpressions("SUM");
        row0.getCell("entries.hotelExpense").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("entries.hotelExpense").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("entries.subsidy").setExpressions("SUM");
        row0.getCell("entries.subsidy").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("entries.subsidy").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("entries.otherExpense").setExpressions("SUM");
        row0.getCell("entries.otherExpense").getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        row0.getCell("entries.otherExpense").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getStyleAttributes().setLocked(true);
        this.tblMain.getGroupManager().setTotalize(true);
        this.tblMain.getGroupManager().group();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, false);
    }

    private void methodForPrint(ActionEvent e, boolean noPreview) {
        this.id = this.getSelectedKeyValue();
        KDNoteHelper appHlp = new KDNoteHelper();
        if (this.id != null) {
            DataProvider data = new DataProvider();
            if (noPreview) {
                appHlp.print(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            } else {
                appHlp.printPreview(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"NO_SELECT_ROW"));
        }
    }

    @Override
    public boolean isPrepareActionTraceUp() {
        return true;
    }

    @Override
    public boolean isPrepareActionTraceDown() {
        return true;
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            block7: {
                IRowSet rowSet = null;
                try {
                    Variant paramVal = null;
                    ArrayList ps = ds.getParams();
                    if (ps.size() > 0) {
                        DSParam param = (DSParam)ps.get(0);
                        paramVal = param.getValue();
                    }
                    String oprId = ds.getID();
                    String tempQuery = null;
                    IForPrintFacade ibizForPrint = ForPrintFacadeFactory.getRemoteInstance();
                    if ("trabill".equals(oprId)) {
                        tempQuery = TravelAccountWKListUI.BILLQUERYNAME;
                        rowSet = ibizForPrint.getRowset(TravelAccountWKListUI.this.id, tempQuery);
                        if (rowSet.next()) {
                            rowSet.previous();
                        }
                        return TravelAccountWKListUI.this.parseEnumValue(rowSet, "prior", "prioralias", PriorEnum.getEnumList());
                    }
                    if ("trabill_a".equals(oprId)) {
                        tempQuery = TravelAccountWKListUI.MULTIAPPROVEQUERYNAME;
                        rowSet = ibizForPrint.getRowset(tempQuery, new String[]{"MultiApprove.billId"}, new String[]{TravelAccountWKListUI.this.id});
                        if (rowSet.next()) {
                            rowSet.previous();
                            rowSet = (IRowSet)TravelAccountWKListUI.this.parseEnumValue1(rowSet, "MultiApprove.handlerOpinion", "MultiApprove.handlerOpinion", OptionEnum.getEnumList());
                            return rowSet;
                        }
                        break block7;
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

