/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.ItemApprovedTreeCollection;
import com.kingdee.eas.cp.bc.ItemApprovedTreeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountWKFacadeFactory;
import com.kingdee.eas.cp.bc.VehicleBaseDataInfo;
import com.kingdee.eas.cp.bc.VehicleExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.VehicleExpenseBillFactory;
import com.kingdee.eas.cp.bc.VehicleExpenseBillInfo;
import com.kingdee.eas.cp.bc.VoucherImplFacadeFactory;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.client.AbstractVehicleExpenseEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.cp.bc.util.ReadBudgetType;
import com.kingdee.eas.cp.bc.util.SourceInfo;
import com.kingdee.eas.cp.bc.util.VoucherImpl;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class VehicleExpenseEditUI
extends AbstractVehicleExpenseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(VehicleExpenseEditUI.class);
    private static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseAccountResource";
    private static final String VEHICLEEXPENSE_AMOUNT = "amount";
    private static final String VEHICLEEXPENSE_VEHNUMBER = "vehNumber.name";
    private static final String VEHICLEEXPENSE_VEHNAME = "vehName";
    private static final Color countLineColor = new Color(246, 246, 191);
    private static final BigDecimal DEFAULTZERO = new BigDecimal("0.00");
    private static final String[] columns = new String[]{"amount"};
    private static final String BILLNAME = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"VEHICLEEXPENSE_NAME");

    @Override
    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    @Override
    public void onLoad() throws Exception {
        int state;
        super.onLoad();
        this.kdtEntries.setColumnMoveable(true);
        JButton btnAddRuleNew = this.kDContainer1.add((Action)this.actionAddLine);
        JButton btnDelRuleNew = this.kDContainer1.add((Action)this.actionRemoveLine);
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setSize(22, 19);
        btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelRuleNew.setSize(22, 19);
        this.setColumnFormat(VEHICLEEXPENSE_AMOUNT, "%r-[&]{#,##0.00}n");
        KDBizPromptBox materailPromptBox = new KDBizPromptBox();
        materailPromptBox.setEditable(false);
        materailPromptBox.setCommitFormat("$id$");
        materailPromptBox.setEditFormat("$vehNumber$");
        materailPromptBox.setDisplayFormat("$vehNumber$");
        materailPromptBox.setQueryInfo("com.kingdee.eas.cp.bc.app.F7VehicleBaseQuery");
        materailPromptBox.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        materailPromptBox.setEntityViewInfo(evi);
        this.kdtEntries.getColumn("vehNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)materailPromptBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$vehNumber$"));
        this.kdtEntries.getColumn("vehNumber").setRenderer((IBasicRender)avr);
        this.kdtEntries.getColumn(VEHICLEEXPENSE_VEHNAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("itemApproved").getStyleAttributes().setLocked(true);
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getState() != null && (60 == (state = this.editData.getState().getValue()) || 25 == state || 30 == state)) {
            btnAddRuleNew.setEnabled(false);
            btnDelRuleNew.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        this.tempMark = false;
        this.btnAddNew.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnCreateFrom.setVisible(true);
        this.btnEdit.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.setButtonState();
        super.initBtnToKVoucher();
        this.dataBinder.loadHeader();
        this.bindDataToTable(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
        this.initDefaultLines(this.kdtEntries);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            Object obj = this.getUIContext().get("InitDataObject");
            if (obj == null) {
                this.reCalculateColulmnAmount(this.getTotalRow(this.kdtEntries), columns);
            }
        } else {
            this.reCalculateColulmnAmount(this.getTotalRow(this.kdtEntries), columns);
        }
        this.tempMark = true;
    }

    public void bindDataToTable(KDTable table, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        table.removeRows();
        if (detailCollection != null) {
            table.setUserObject((Object)detailCollection);
        }
        int detailCount = detailCollection.size();
        IObjectValue detailData = null;
        IRow row = null;
        for (int i = 0; i < detailCount; ++i) {
            detailData = detailCollection.getObject(i);
            row = table.addRow();
            row.setUserObject((Object)detailData);
            this.loadLineFields(table, row, detailData);
        }
        super.loadFields();
    }

    public void bindTableToData(KDTable table, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        detailCollection.clear();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            if (this.checkIsCountLine(row)) continue;
            IObjectValue obj = (IObjectValue)row.getUserObject();
            this.storeLineFields2(table, row, obj);
            if (this.checkIsBlankLine((AbstractObjectValue)obj) || !detailCollection.addObject(obj)) continue;
            this.storeLineFields(table, row, obj);
        }
    }

    private void storeLineFields2(KDTable table, IRow row, IObjectValue obj) {
        table.checkParsed();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj == null) continue;
                subObj.put(subItems[subItems.length - 1], row.getCell(i).getValue());
                continue;
            }
            Class<?> type = obj.getClass();
            try {
                String setMethodName = "set" + StringUtils.headCharUpperCase((String)bindField);
                Method[] methods = type.getMethods();
                Method method = null;
                int l = methods.length;
                for (int k = 0; k < l; ++k) {
                    if (!setMethodName.equalsIgnoreCase(methods[k].getName())) continue;
                    method = methods[k];
                    break;
                }
                if (method != null) {
                    method.invoke((Object)obj, row.getCell(i).getValue());
                    continue;
                }
                obj.put(bindField, row.getCell(i).getValue());
                continue;
            }
            catch (Exception e) {
                obj.put(bindField, row.getCell(i).getValue());
            }
        }
    }

    private boolean checkIsBlankLine(AbstractObjectValue objValue) {
        return ObjectValueUtil.objectValueEquals((AbstractObjectValue)((AbstractObjectValue)this.createNewDetailData(this.kdtEntries)), (AbstractObjectValue)objValue);
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            return;
        }
        this.dataBinder.storeHeader();
        this.bindTableToData(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getBaseSelectors();
        SelectorItemCollection superSic = super.getSelectors();
        int n = superSic.size();
        for (int i = 0; i < n; ++i) {
            sic.add(superSic.get(i));
        }
        return sic;
    }

    public void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.storeLineFields(table, row, obj);
        this.dataBinder.storeLineFields(table, row, obj);
    }

    @Override
    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldData, (AbstractObjectValue)this.editData);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        Object object;
        super.kdtEntries_editStopped(e);
        if (e.getColIndex() == this.kdtEntries.getColumnIndex(VEHICLEEXPENSE_AMOUNT)) {
            BigDecimal bd = this.totalAmount(this.kdtEntries);
            this.txtAmount.setValue((Object)bd);
            this.txtAmountApproved.setValue((Object)bd);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell(VEHICLEEXPENSE_AMOUNT).setValue((Object)bd);
        } else if (e.getColIndex() == this.kdtEntries.getColumnIndex("vehNumber") && (object = e.getValue()) != null && object != e.getOldValue()) {
            IRow row = this.kdtEntries.getRow(e.getRowIndex());
            VehicleBaseDataInfo tempInfo = (VehicleBaseDataInfo)object;
            row.getCell(VEHICLEEXPENSE_VEHNAME).setValue((Object)tempInfo.getName());
            row.getCell("itemApproved").setValue((Object)this.getVehicleBudget(tempInfo));
        }
    }

    protected String getVehicleBudget(VehicleBaseDataInfo info) {
        if (info == null) {
            return null;
        }
        String id = info.getId().toString();
        Object tree = null;
        ItemApprovedTreeCollection tempCollection = null;
        ItemApprovedTreeInfo tempInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("linkId", (Object)id, CompareType.EQUALS));
        filter.setMaskString("( #0 or #1) and #2");
        ev.setFilter(filter);
        try {
            tempCollection = ItemApprovedTreeFactory.getRemoteInstance().getItemApprovedTreeCollection(ev);
            if (tempCollection.size() > 0) {
                tempInfo = tempCollection.get(0);
                return tempInfo.getItemNumber();
            }
            return null;
        }
        catch (BOSException e) {
            return null;
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        AbstractObjectValue objectValue = (AbstractObjectValue)dataObject;
        this.oldData = (AbstractObjectValue)objectValue.clone();
    }

    @Override
    protected String getTableName() {
        return "T_BC_VehicleExpenseBill";
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_VehicleExpenseBillEntry";
    }

    protected void setEntryNumber() {
        this.entryNumber.setText(String.valueOf(this.kdtEntries.getRowCount() - 1));
    }

    @Override
    protected IObjectValue createNewData() {
        VehicleExpenseBillInfo tempInfo = new VehicleExpenseBillInfo();
        tempInfo.setName(BILLNAME);
        tempInfo.setBiller(SysContext.getSysContext().getCurrentUserInfo());
        tempInfo.setBillDate(new Timestamp(System.currentTimeMillis()));
        tempInfo.setBizReqDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        tempInfo.setState(StateEnum.NEW);
        tempInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        tempInfo.setPrior(PriorEnum.LOW);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        tempInfo.setBiller(user);
        if (user != null && user.getPerson() != null) {
            try {
                IPerson ip = PersonFactory.getRemoteInstance();
                PersonInfo applier = (PersonInfo)ip.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
                tempInfo.setApplier(applier);
                if (applier != null) {
                    IPositionMember ipm = PositionMemberFactory.getRemoteInstance();
                    PositionInfo poInfo = null;
                    PositionMemberCollection pco = ipm.getPositionsByPerson(applier.getId());
                    poInfo = pco == null || pco.size() == 0 ? null : pco.get(0).getPosition();
                    tempInfo.setPosition(poInfo);
                    tempInfo.setOrgUnit(this.getOrgUnitReferToApplier(applier));
                }
            }
            catch (Exception e) {
                tempInfo.setApplier(null);
                tempInfo.setPosition(null);
                tempInfo.setOrgUnit(null);
            }
        }
        String sysNumber = null;
        try {
            sysNumber = this.getCodeRuleClient(tempInfo);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (sysNumber != null && sysNumber.trim().length() > 0) {
            tempInfo.setNumber(sysNumber);
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        return tempInfo;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        VehicleExpenseBillEntryInfo info = new VehicleExpenseBillEntryInfo();
        info.setAmount(new BigDecimal(new String("0.00")));
        return info;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return VehicleExpenseBillFactory.getRemoteInstance();
    }

    private void setColumnFormat(String column, String format) {
        KDTDefaultCellEditor itemEditor = null;
        this.kdtEntries.getColumn(column).getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        this.kdtEntries.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtHotelQuatity = new KDFormattedTextField(1);
        txtHotelQuatity.setEditable(true);
        txtHotelQuatity.setSupportedEmpty(true);
        txtHotelQuatity.setPrecision(2);
        itemEditor = new KDTDefaultCellEditor((JTextField)txtHotelQuatity);
        this.getDetailTable().getColumn(column).setEditor((ICellEditor)itemEditor);
    }

    @Override
    protected void initDefaultLines(KDTable table) {
        if (table == null) {
            return;
        }
        if (!this.hasTotalLine(table)) {
            this.addTotalLine(table);
        }
        for (int i = table.getRowCount(); i <= 1; ++i) {
            this.addLine(table);
        }
    }

    @Override
    protected boolean hasTotalLine(KDTable table) {
        if (table == null) {
            return false;
        }
        return this.getTotalRow(table) != null;
    }

    @Override
    protected IRow getTotalRow(KDTable table) {
        int n = table.getRowCount();
        for (int i = n - 1; i > -1; --i) {
            IRow row = table.getRow(i);
            if (!this.checkIsCountLine(row)) continue;
            return row;
        }
        return null;
    }

    @Override
    protected boolean checkIsCountLine(IRow row) {
        if (row == null) {
            return false;
        }
        if (row.getCell("id") == null || row.getCell("id").getValue() == null) {
            return false;
        }
        return "flag".equals(row.getCell("id").getValue().toString());
    }

    @Override
    protected void addTotalLine(KDTable table) {
        this.addLine(table);
        IRow row = table.getRow(table.getRowCount() - 1);
        row.getCell(0).setValue((Object)"flag");
        row.getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"TOTAL"));
        row.getStyleAttributes().setBackground(countLineColor);
        row.getStyleAttributes().setLocked(true);
    }

    protected void addLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        row = table.getRowCount() > 0 ? (this.checkIsCountLine(table.getRow(table.getRowCount() - 1)) ? table.addRow(table.getRowCount() - 1) : table.addRow()) : table.addRow();
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    private BigDecimal totalAmount(KDTable table) {
        if (table == null) {
            return new BigDecimal("0.00");
        }
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.00");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object value;
            row = table.getRow(i);
            if (this.checkIsCountLine(row) || (amount = BizCollUtil.toBigDecimal(value = (cell = row.getCell(VEHICLEEXPENSE_AMOUNT)).getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        return columnAmount;
    }

    private void setButtonState() {
        String billState = null;
        String string = billState = this.editData.getState() == null ? StateEnum.NEW.toString() : this.editData.getState().toString();
        if (billState.equals(StateEnum.CHECKED.toString())) {
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnPayFormat.setEnabled(true);
        } else if (billState.equals(StateEnum.DRAFT.toString())) {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.btnPayFormat.setEnabled(false);
        }
    }

    private void reCalculateColulmnAmount(IRow iRow, String[] columnArray) {
        int len = columnArray.length;
        for (int i = 0; i < len; ++i) {
            this.calculateColumnAmount(iRow, columnArray[i]);
        }
    }

    private void calculateColumnAmount(IRow countRow, int indexColumn) {
        if (countRow == null) {
            return;
        }
        KDTable table = this.getDetailTable();
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.0");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object value;
            row = table.getRow(i);
            if (this.checkIsCountLine(row) || (amount = BizCollUtil.toBigDecimal(value = (cell = row.getCell(indexColumn)).getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        countRow.getCell(indexColumn).setValue((Object)columnAmount);
    }

    private void calculateColumnAmount(IRow countRow, String columnName) {
        if (countRow == null || columnName == null || columnName.equals("")) {
            return;
        }
        KDTable table = this.getDetailTable();
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.0");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object value;
            row = table.getRow(i);
            if (this.checkIsCountLine(row) || (amount = BizCollUtil.toBigDecimal(value = (cell = row.getCell(columnName)).getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        countRow.getCell(columnName).setValue((Object)columnAmount);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        IRow iRow = null;
        iRow = this.getTotalRow(this.kdtEntries);
        this.reCalculateColulmnAmount(iRow, columns);
        BigDecimal tempValue = this.totalAmount(this.kdtEntries);
        this.txtAmount.setValue((Object)tempValue);
        this.txtAmountApproved.setValue((Object)tempValue);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.hasTotalLine(this.kdtEntries)) {
            return;
        }
        this.addTotalLine(this.kdtEntries);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.getDetailTable().getSelectManager().get().getTop();
        if (this.getDetailTable().getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.checkIsCountLine(this.getDetailTable().getRow(top))) {
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        this.initDefaultLines(this.kdtEntries);
    }

    @Override
    protected void setUIState() {
        super.setUIState();
        this.kDContainer1.setEnabled(false);
        this.kdtEntries.setEnabled(false);
        this.kdtEntries.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void checkEntry(KDTable table) throws ExpAccException {
        int rows = this.getDetailTable().getRowCount();
        IRow row = null;
        if (rows < 1) {
            throw new ExpAccException(ExpAccException.ENTRY_NOT_NULL);
        }
        KDTEditManager kdtManager = this.getDetailTable().getEditManager();
        for (int i = 0; i < rows; ++i) {
            row = this.getDetailTable().getRow(i);
            if (row == null || this.checkIsCountLine(row)) continue;
            if (this.objectIsNull(row.getCell("vehNumber").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("vehNumber"));
                throw new ExpAccException(ExpAccException.VEHICLE_NUMBER_NOT_NULL);
            }
            if (row.getCell("vehNumber").getValue().toString().length() > 80) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("vehNumber"));
                throw new ExpAccException(ExpAccException.VEHICLE_NUMBER_TOO_LONG);
            }
            if (this.objectIsNull(row.getCell(VEHICLEEXPENSE_VEHNAME).getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex(VEHICLEEXPENSE_VEHNAME));
                throw new ExpAccException(ExpAccException.VEHICLE_NAME_NOT_NULL);
            }
            if (row.getCell(VEHICLEEXPENSE_VEHNAME).getValue().toString().length() > 80) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex(VEHICLEEXPENSE_VEHNAME));
                throw new ExpAccException(ExpAccException.VEHICLE_NAME_TOO_LONG);
            }
            BigDecimal obj = row.getCell(VEHICLEEXPENSE_AMOUNT) == null ? DEFAULTZERO : row.getCell(VEHICLEEXPENSE_AMOUNT).getValue();
            BigDecimal max = new BigDecimal("999999999999999999");
            if (VehicleExpenseEditUI.toBigDecimal(obj).compareTo(DEFAULTZERO) <= 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex(VEHICLEEXPENSE_AMOUNT));
                throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
            }
            if (row.getCell("comment").getValue() == null || ((String)row.getCell("comment").getValue()).length() <= 200) continue;
            kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("comment"));
            throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
        }
    }

    protected boolean[] getBudgetMark(ExpenseSortInfo expenseSort, int itemClassID) {
        boolean[] mark = null;
        try {
            mark = TravelAccountWKFacadeFactory.getRemoteInstance().checkAccHasBudget(expenseSort, itemClassID);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return mark;
    }

    @Override
    protected String getDbSql(String id) {
        return this.getDefaultSql().toString();
    }

    @Override
    protected StringBuffer getDefaultSql() {
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT ");
        querySql.append(" CURDATE() AS FDate, YEAR(NOW()) AS FYear,  ");
        querySql.append(" MONTH(NOW()) AS FPeriod, d.FGroup AS FGroupID, ");
        querySql.append(" 0 AS FNumber, ");
        querySql.append(" d.FDebitAccountNumber AS FAccountNum, ");
        querySql.append(" d.FDebitAccountName AS FAccountName, ");
        querySql.append(" d.FCreditAccountNumber AS FAccountNum1, ");
        querySql.append(" d.FCreditAccountName AS FAccountName1,");
        querySql.append(" d.FCurrencyNumber AS FCurrencyNum, ");
        querySql.append(" d.FCurrencyName AS FCurrencyName, ");
        querySql.append(" a.FAmountApproved AS FAmountFor, a.FAmountApproved AS FDebit, ");
        querySql.append(" a.FAmountApproved AS FCredit,d.FK3user AS FPreparerID, ");
        querySql.append(" '' AS FCheckID, '' AS FApproveID, '' AS FCashierID, ");
        querySql.append(" '' AS FHandler, '' AS FSettleTypeID, 0 AS FSettleNo, ");
        querySql.append(" CONCAT( CONCAT(CONCAT(ORGUNIT.FName_L2,'_'),APPLIER.FName_L2 ) , CONCAT('_',a.FCause))  AS FExplanation , ");
        querySql.append(" 0 AS FQuantity, 0 AS FMeasureUnitID, 0 AS FUnitPrice, ");
        querySql.append(" a.FNumber AS FReference, ");
        querySql.append(" CURDATE() AS FTransDate, 0 AS FTransNo,0 AS FAttachments, ");
        querySql.append(" 0 AS FSerialNum, '' AS FObjectName, '' AS FParameter, ");
        querySql.append(" d.FRate AS FExchangeRate, 0 AS FEntryID, a.FCreditNumber AS FCreditItem , ");
        querySql.append(" a.FDebitNumber AS FDebitItem,'' AS FPosted,");
        querySql.append(" '' AS FInternalInd, '' AS FCashFlow  , ");
        querySql.append(" b.FAmount FAmount,b.FItemApproved  FItemApproved, a.FSortName FSortName, ");
        querySql.append(" a.FID,a.FState,e.FK3DataCenter, ");
        querySql.append(" d.FK3user FK3user,d.FK3userPwd FK3userPwd, d.FSimpleName FSimpleName ");
        querySql.append(" FROM ");
        querySql.append(this.getTableName());
        querySql.append("  a INNER JOIN\t");
        querySql.append(this.getEntryTableName());
        querySql.append("  b ON a.FID = b.FBillID INNER JOIN ");
        querySql.append("  T_BC_ExpenseSort c ON a.FSortName = c.FID INNER JOIN ");
        querySql.append("  T_BC_VoucherTemplateEntry d ON c.FID = d.FExpenseTypeID INNER JOIN ");
        querySql.append("  T_BC_VoucherTemplate e ON d.FVoucherID = e.FID ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_BD_Person AS  APPLIER  ON  a.FApplierID = APPLIER.FID ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_ORG_Admin AS  ORGUNIT ON a.FOrgUnitID = ORGUNIT.FID ");
        querySql.append("  AND a.FID = ? ");
        return querySql;
    }

    @Override
    public void actionToKVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkBillState()) {
            return;
        }
        Object tempList1 = null;
        Object tempList = null;
        VoucherImpl impl = new VoucherImpl();
        if (VoucherImpl.MARK.equals("FAILTURE")) {
            throw new VoucherTempException(VoucherTempException.K3CONNECT_ERROR);
        }
        Object[] tempObj = VoucherImplFacadeFactory.getRemoteInstance().getVehicleResult(this.getDbSql(this.getId()), this.getId(), ReadBudgetType.VEHICLEIDVALUE);
        Object[] backObj = null;
        if (tempObj == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"THIS_BILL_NO_VOUCHER_TEMPLATE"));
            return;
        }
        backObj = impl.voucherImplVehicle(SourceInfo.TARGETFILE, SourceInfo.SOURCEFILE, 2, tempObj, this.getCurFrame(this.getParent()));
        String showMessage = "";
        showMessage = EASResource.getString((String)RES, (String)"SUCCESS_TO_VOUCHER_NUMBER");
        showMessage = MessageFormat.format(showMessage, new Integer(1));
        if (backObj != null) {
            boolean result = impl.voucherImplVehicle(SourceInfo.TARGETFILE, 1, tempObj, this.getCurFrame(this.getParent()));
            if (result) {
                MsgBox.showInfo((String)showMessage);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"FAILTURE_TO_VOUCHER"));
            }
        } else {
            MsgBox.showInfo((String)showMessage);
        }
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }
}

