/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.VehicleExpenseBillFactory;
import com.kingdee.eas.cp.bc.VoucherImplFacadeFactory;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.client.AbstractVehicleExpenseListUI;
import com.kingdee.eas.cp.bc.client.TempBillBean;
import com.kingdee.eas.cp.bc.client.TravelAccountWKQueryUI;
import com.kingdee.eas.cp.bc.client.VehicleExpenseEditUI;
import com.kingdee.eas.cp.bc.util.ReadBudgetType;
import com.kingdee.eas.cp.bc.util.SourceInfo;
import com.kingdee.eas.cp.bc.util.VoucherImpl;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VehicleExpenseListUI
extends AbstractVehicleExpenseListUI {
    private static final Logger logger = CoreUIObject.getLogger(VehicleExpenseListUI.class);
    private final String RES_EXPENSE = "com.kingdee.eas.cp.bc.client.ExpenseAccountResource";
    private static final String RES_VOUCHER = "com.kingdee.eas.cp.bc.VouchetImplResource";
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.client.ForPrintResource";
    private static final String BILLQUERYNAME = "com.kingdee.eas.cp.bc.app.VehicleExpenseForPrintQuery";
    private static final String MULTIAPPROVEQUERYNAME = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    private static final String DATAPATH = "/cp/bc/wk/veh";
    private String id = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"VEHICLEEXPENSE_VIEW"));
        return dialog;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return VehicleExpenseBillFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return VehicleExpenseEditUI.class.getName();
    }

    @Override
    protected KDPanel getUserPanel() {
        TravelAccountWKQueryUI ret = null;
        try {
            ret = new TravelAccountWKQueryUI();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return ret;
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_VehicleExpenseBillEntry";
    }

    @Override
    protected String getTableName() {
        return "T_BC_VehicleExpenseBill";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionToKVoucher_actionPerformed(ActionEvent e) throws Exception {
        VoucherImpl impl = new VoucherImpl();
        if (VoucherImpl.MARK.equals("FAILTURE")) {
            throw new VoucherTempException(VoucherTempException.K3CONNECT_ERROR);
        }
        int validSize = 0;
        int invalidSize = 0;
        List[] arr = null;
        String disc = "";
        arr = this.getSelectIdList(StateEnum.CHECKED.toString(), StateEnum.ALREADIMPORTPAYFORMAT.toString(), StateEnum.ALREADVOUCHER.toString());
        ArrayList validList = (ArrayList)arr[0];
        ArrayList invalidList = (ArrayList)arr[1];
        validSize = validList.size();
        invalidSize = invalidList.size();
        ArrayList totalList = validList;
        if (validSize + invalidSize > 0 && invalidSize > 0 && MsgBox.showConfirm2((String)(disc = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"BILL_STATE_NOT_PAYMODE"))) != 0) {
            return;
        }
        String tempStr = null;
        ArrayList<TempBillBean> noTempList = new ArrayList<TempBillBean>();
        ArrayList<TempBillBean> hasTempList = new ArrayList<TempBillBean>();
        TempBillBean tempBean = null;
        int n = totalList.size();
        for (int i = 0; i < n; ++i) {
            tempBean = (TempBillBean)totalList.get(i);
            tempStr = VoucherImplFacadeFactory.getRemoteInstance().hasResult(this.getExistSql(), tempBean.getBillId());
            if (tempStr == null) {
                noTempList.add(tempBean);
                continue;
            }
            hasTempList.add(tempBean);
        }
        TempBillBean billBean = null;
        int totalSize = totalList.size();
        int noTempSize = noTempList.size();
        int hasTempSize = hasTempList.size();
        StringBuffer errorFNumber = null;
        if (noTempSize == totalSize) {
            if (noTempSize > 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"ALL_BILLS_NOT_VOUCHERTEMPLATE"));
                return;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"BILL_NO_VOUCHERTEMPLATE"));
            return;
        }
        if (noTempSize > 0) {
            errorFNumber = new StringBuffer();
            errorFNumber.append(EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"BILLS_NO_VOUCHERTEMPLATE"));
            errorFNumber.append("(");
            errorFNumber.append(noTempSize);
            errorFNumber.append("):\n");
            for (int j = 0; j < noTempSize; ++j) {
                billBean = (TempBillBean)noTempList.get(j);
                errorFNumber.append(billBean.getBillNumber());
                errorFNumber.append("\n");
            }
            errorFNumber.append(EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"CONTINUE_YES_OR_NO"));
            if (MsgBox.showConfirm2((String)errorFNumber.toString()) != 0) {
                return;
            }
        }
        Object[] tempObj = null;
        Object[] backObj = null;
        ArrayList<Object[]> backList = new ArrayList<Object[]>();
        int failSize = 0;
        int succSize = 0;
        for (int m = 0; m < hasTempSize; ++m) {
            billBean = (TempBillBean)hasTempList.get(m);
            tempObj = VoucherImplFacadeFactory.getRemoteInstance().getVehicleResult(this.getDbSql(billBean.getBillId()), billBean.getBillId(), ReadBudgetType.VEHICLEIDVALUE);
            backObj = impl.voucherImplVehicle(SourceInfo.TARGETFILE, SourceInfo.SOURCEFILE, 2, tempObj, this.getCurFrame(this.getParent()));
            if (backObj != null) {
                backList.add(tempObj);
                ++failSize;
                continue;
            }
            ++succSize;
        }
        String message = "";
        if (succSize > 0) {
            if (failSize <= 0) {
                message = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"SUCCESS_TO_VOUCHER_NUMBER");
                message = MessageFormat.format(message, new Integer(succSize));
                MsgBox.showInfo((String)message.toString());
                return;
            }
            message = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"BILL_TO_VOUCHER_NUMBER");
            message = MessageFormat.format(message, new Integer(succSize), new Integer(failSize));
        } else {
            message = failSize > 1 ? EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"ALL_BILL_TOVOUCHER_ERROR") : EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"ONE_BILL_TOVOUCHER_ERROR");
        }
        if (MsgBox.showConfirm2((String)message.toString()) != 0) return;
        int failSize1 = 0;
        int succSize1 = 0;
        for (int m = 0; m < failSize; ++m) {
            tempObj = (Object[])backList.get(m);
            backObj = impl.voucherImplVehicle(SourceInfo.TARGETFILE, SourceInfo.SOURCEFILE, 1, tempObj, this.getCurFrame(this.getParent()));
            if (backObj != null) {
                ++failSize1;
                continue;
            }
            ++succSize1;
        }
        String showMessage = "";
        if (succSize1 == 0) {
            showMessage = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"FAIL_TO_VOUCHER_NUMBER");
            showMessage = MessageFormat.format(showMessage, new Integer(failSize1));
        } else if (failSize1 == 0) {
            showMessage = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"SUCCESS_TO_VOUCHER_NUMBER");
            showMessage = MessageFormat.format(showMessage, new Integer(succSize1));
        } else {
            showMessage = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"SUCC_NUMBET_FAIL_NUMBER");
            showMessage = MessageFormat.format(showMessage, new Integer(succSize1), new Integer(failSize1));
        }
        if (showMessage.equals("")) return;
        MsgBox.showInfo((String)showMessage);
    }

    @Override
    protected List[] getSelectIdList(String state1, String state2, String state3) {
        ArrayList<TempBillBean> validList = new ArrayList<TempBillBean>();
        ArrayList<TempBillBean> unvalidList = new ArrayList<TempBillBean>();
        List[] arr = new List[]{validList, unvalidList};
        String state = null;
        String tempId = null;
        String tempNumber = null;
        Object tempObj = null;
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        TempBillBean vehicleBean = null;
        boolean index = false;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                tempObj = this.tblMain.getRow(j).getCell("state").getValue();
                state = tempObj == null ? "" : tempObj.toString();
                tempId = this.tblMain.getRow(j).getCell("id").getValue().toString();
                tempNumber = this.tblMain.getRow(j).getCell("number").getValue().toString();
                vehicleBean = new TempBillBean();
                vehicleBean.setBillId(tempId);
                vehicleBean.setBillNumber(tempNumber);
                if (state.equals(state2) || state.equals(state3)) {
                    validList.add(vehicleBean);
                    continue;
                }
                unvalidList.add(vehicleBean);
            }
        }
        return arr;
    }

    @Override
    public String getDbSql(String fnumber) {
        return this.getDefaultSql().toString();
    }

    @Override
    public StringBuffer getDefaultSql() {
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT ");
        querySql.append(" CURDATE() AS FDate, YEAR(NOW()) AS FYear,  ");
        querySql.append(" MONTH(NOW()) AS FPeriod, d.FGroup AS FGroupID, ");
        querySql.append(" 0 AS FNumber,   ");
        querySql.append(" d.FDebitAccountNumber AS FAccountNum, ");
        querySql.append(" d.FDebitAccountName AS FAccountName, ");
        querySql.append(" d.FCreditAccountNumber AS FAccountNum1, ");
        querySql.append(" d.FCreditAccountName AS FAccountName1,");
        querySql.append(" d.FCurrencyNumber AS FCurrencyNum, ");
        querySql.append(" d.FCurrencyName AS FCurrencyName,  ");
        querySql.append(" a.FAmountApproved AS FAmountFor, ");
        querySql.append(" a.FAmountApproved AS FDebit, a.FAmountApproved AS FCredit, ");
        querySql.append(" d.FK3user AS FPreparerID, '' AS FCheckID, ");
        querySql.append(" '' AS FApproveID, '' AS FCashierID,");
        querySql.append(" '' AS FHandler, '' AS FSettleTypeID, 0 AS FSettleNo, ");
        querySql.append(" CONCAT( CONCAT(CONCAT(ORGUNIT.FName_L2,'_'),APPLIER.FName_L2 ) , CONCAT('_',a.FCause))  AS FExplanation , ");
        querySql.append(" 0 AS FQuantity, 0 AS FMeasureUnitID, 0 AS FUnitPrice, ");
        querySql.append(" a.FNumber AS FReference, ");
        querySql.append(" CURDATE() AS FTransDate, 0 AS FTransNo, ");
        querySql.append(" 0 AS FAttachments, 0 AS FSerialNum, ");
        querySql.append(" '' AS FObjectName, '' AS FParameter,     ");
        querySql.append(" d.FRate AS FExchangeRate, 0 AS FEntryID, ");
        querySql.append(" a.FCreditNumber AS FCreditItem ,a.FDebitNumber AS FDebitItem, ");
        querySql.append(" '' AS FPosted, '' AS FInternalInd, '' AS FCashFlow  ,");
        querySql.append(" b.FAmount FAmount,b.FItemApproved  FItemApproved, ");
        querySql.append(" a.FSortName FSortName, ");
        querySql.append(" a.FID,a.FState,e.FK3DataCenter, ");
        querySql.append(" d.FK3user FK3user,d.FK3userPwd FK3userPwd , ");
        querySql.append(" d.FSimpleName FSimpleName ");
        querySql.append(" FROM ");
        querySql.append(this.getTableName());
        querySql.append("  \ta INNER JOIN\t");
        querySql.append(this.getEntryTableName());
        querySql.append("   b ON a.FID = b.FBillID INNER JOIN  ");
        querySql.append("   T_BC_ExpenseSort c ON a.FSortName = c.FID INNER JOIN  ");
        querySql.append("   T_BC_VoucherTemplateEntry d ON c.FID = d.FExpenseTypeID INNER JOIN  ");
        querySql.append("   T_BC_VoucherTemplate e ON d.FVoucherID = e.FID  ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_BD_Person AS  APPLIER  ON  a.FApplierID = APPLIER.FID ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_ORG_Admin AS  ORGUNIT ON a.FOrgUnitID = ORGUNIT.FID ");
        querySql.append("   AND a.FID = ? ");
        return querySql;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, false);
    }

    private void methodForPrint(ActionEvent e, boolean noPreview) {
        this.id = this.getSelectedKeyValue();
        KDNoteHelper appHlp = new KDNoteHelper();
        if (this.id != null) {
            DataProvider data = new DataProvider();
            if (noPreview) {
                appHlp.print(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            } else {
                appHlp.printPreview(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"NO_SELECT_ROW"));
        }
    }

    @Override
    public Object parseEnumValue1(IRowSet rowSet, String value, String valueAlias, List list) throws SQLException {
        if (rowSet == null) {
            return rowSet;
        }
        if (list == null) {
            return rowSet;
        }
        if (value == null || value.equals("")) {
            return rowSet;
        }
        OptionEnum optenum2 = null;
        String mark = "";
        int tempPrior = -1;
        int pos = -1;
        Iterator ite = null;
        String pass = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"PASS");
        String noPass = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpenseAccountResource", (String)"NO_PASS");
        while (rowSet.next()) {
            tempPrior = rowSet.getInt(value);
            for (OptionEnum optenum2 : list) {
                if (tempPrior == optenum2.getValue()) {
                    mark = optenum2.getAlias();
                }
                rowSet.updateString("MultiApprove.id", mark);
            }
            rowSet.updateString("MultiApprove.isPass", rowSet.getString("MultiApprove.isPass").equals("true") ? pass : noPass);
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    @Override
    public boolean isPrepareActionTraceUp() {
        return true;
    }

    @Override
    public boolean isPrepareActionTraceDown() {
        return true;
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            block7: {
                IRowSet rowSet = null;
                try {
                    Variant paramVal = null;
                    ArrayList ps = ds.getParams();
                    if (ps.size() > 0) {
                        DSParam param = (DSParam)ps.get(0);
                        paramVal = param.getValue();
                    }
                    String oprId = ds.getID();
                    String tempQuery = null;
                    IForPrintFacade ibizForPrint = ForPrintFacadeFactory.getRemoteInstance();
                    if ("vehbill".equals(oprId)) {
                        tempQuery = VehicleExpenseListUI.BILLQUERYNAME;
                        rowSet = ibizForPrint.getRowset(VehicleExpenseListUI.this.id, tempQuery);
                        if (rowSet.next()) {
                            rowSet.previous();
                        }
                        return VehicleExpenseListUI.this.parseEnumValue(rowSet, "prior", "prioralias", PriorEnum.getEnumList());
                    }
                    if ("vehbill_a".equals(oprId)) {
                        tempQuery = VehicleExpenseListUI.MULTIAPPROVEQUERYNAME;
                        rowSet = ibizForPrint.getRowset(tempQuery, new String[]{"MultiApprove.billId"}, new String[]{VehicleExpenseListUI.this.id});
                        if (rowSet.next()) {
                            rowSet.previous();
                            rowSet = (IRowSet)VehicleExpenseListUI.this.parseEnumValue1(rowSet, "MultiApprove.handlerOpinion", "MultiApprove.handlerOpinion", OptionEnum.getEnumList());
                            return rowSet;
                        }
                        break block7;
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

