/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.SSCUnitInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import javax.swing.tree.MutableTreeNode;

public class SSCUnitHelper {
    public static DefaultKingdeeTreeNode createSSCUnitTreeNode(SSCUnitInfo rootInfo, boolean includeChild) throws Exception {
        IForPrintFacade facade = ForPrintFacadeFactory.getRemoteInstance();
        IRowSet rows = SSCUnitHelper.getSSCUnitRowSet(rootInfo, includeChild);
        return SSCUnitHelper.buildTreeNodeByRowSet(rows, rootInfo);
    }

    public static IRowSet getSSCUnitRowSet(SSCUnitInfo rootInfo, boolean includeChild) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)"rootNote", CompareType.NOTEQUALS));
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.bc.app.SSCUnitQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows, SSCUnitInfo rootInfo) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = new KDTreeNode((Object)rootInfo);
        DefaultKingdeeTreeNode parentNode = null;
        KDTreeNode subTreeNode = null;
        Object childNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        nodeMap.put(rootInfo.getId().toString(), rootTreeNode);
        boolean flag = true;
        int index = 0;
        int childCount = 0;
        SSCUnitInfo unitInfo = null;
        while (rows.next()) {
            unitInfo = SSCUnitHelper.createSSCUnitInfo(rows);
            subTreeNode = new KDTreeNode((Object)unitInfo);
            if (unitInfo.getParent() != null && nodeMap.containsKey(unitInfo.getParent().getId().toString())) {
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(unitInfo.getParent().getId().toString());
                index = 20;
                childCount = parentNode.getChildCount();
                if (childCount == 0 || index == 0) {
                    parentNode.add((MutableTreeNode)subTreeNode);
                } else if (index == 1) {
                    parentNode.insert((MutableTreeNode)subTreeNode, 0);
                } else {
                    parentNode.add((MutableTreeNode)subTreeNode);
                }
            }
            nodeMap.put(unitInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    private static SSCUnitInfo createSSCUnitInfo(IRowSet row) throws Exception {
        SSCUnitInfo sscUnitInfo = new SSCUnitInfo();
        sscUnitInfo.setId(BOSUuid.read((String)row.getString("ID")));
        sscUnitInfo.setName(row.getString("Name"));
        sscUnitInfo.setNumber(row.getString("Number"));
        sscUnitInfo.setLongNumber(row.getString("LONGNUMBER"));
        sscUnitInfo.setLevel(row.getInt("LEVEL"));
        sscUnitInfo.setIsLeaf(row.getBoolean("ISLEAF"));
        SSCUnitInfo parentInfo = new SSCUnitInfo();
        if (row.getString("PARENT.ID") == null || row.getString("PARENT.ID").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("PARENT.ID")));
            parentInfo.setNumber(row.getString("PARENT.NUMBER"));
            parentInfo.setLongNumber(row.getString("PARENT.LONGNUMBER"));
        }
        sscUnitInfo.setSscCenter(row.getBoolean("SSCCENTER"));
        sscUnitInfo.setParent(parentInfo);
        return sscUnitInfo;
    }
}

