/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.IBizAccountBill;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizAccountCollectionEntriesAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.BizAccountBillReceivablesInfoAddByExcel");
    private String[] STRING_FIELDS_EN = new String[]{"FPayerName", "FPayerBank", "FPayerAccount"};
    private String[] STRING_OBJS_EN = new String[]{"payerName", "payerBank", "payerAccount"};
    private IObjectPK TEMPPK = null;
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.BizAccountCollectionEntryForDatatask";
    private Set idsEverImported = new HashSet();
    private static final String[] notNullFields = new String[]{"FNumber", "FPayerName"};
    private static final String[] notNullColNames = new String[]{"\u5355\u636e\u5934_\u5355\u636e\u7f16\u53f7", "\u6536\u6b3e\u4eba"};
    private HashMap<String, BizAccountBillEntryInfo> map;
    private HashMap<String, CoreBaseInfo> objectMap = new HashMap();

    private IObjectPK getInfoPKbyNumber(Context ctx, String number) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            CoreBaseCollection col = BizAccountBillFactory.getLocalInstance(ctx).getCollection(viewInfo);
            if (col.size() > 0) {
                return new ObjectUuidPK(col.get(0).getId());
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BizAccountBillAccountEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BizImportUtil.validateNotNullField(hsData, notNullFields, notNullColNames);
        BizAccountBillInfo bill = null;
        Object data = null;
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        BizAccountBillEntryCollection entryCol = null;
        BizAccountBillAccountEntryInfo entryInfo = null;
        str = numberdata.toString();
        if (str != null && str.trim().length() > 0) {
            block29: {
                this.TEMPPK = this.getInfoPKbyNumber(ctx, str);
                if (this.TEMPPK != null) {
                    try {
                        IBizAccountBill iFixBill = BizAccountBillFactory.getLocalInstance(ctx);
                        SelectorItemCollection items = new SelectorItemCollection();
                        items.add(new SelectorItemInfo("state"));
                        items.add(new SelectorItemInfo("currencyType.number"));
                        items.add(new SelectorItemInfo("entries.currencyType.number"));
                        items.add(new SelectorItemInfo("entries.exchangeRate"));
                        items.add(new SelectorItemInfo("entries.convertMode"));
                        items.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
                        BizAccountBillInfo bizAccountBillInfo = iFixBill.getBizAccountBillInfo(this.TEMPPK, items);
                        if (!bizAccountBillInfo.getState().equals((Object)StateEnum.DRAFT)) {
                            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_DRAFT_VALUE", (Locale)ctx.getOriginLocale()));
                        }
                        entryCol = bizAccountBillInfo.getEntries();
                        bill = bizAccountBillInfo;
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_BILL", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                }
                if (this.map == null) {
                    this.map = new HashMap();
                    for (int i = 0; i < entryCol.size(); ++i) {
                        BizAccountBillEntryInfo bizentryInfo = entryCol.get(i);
                        if (bizentryInfo.getCurrencyType() == null) continue;
                        this.map.put(bizentryInfo.getCurrencyType().getNumber().trim(), bizentryInfo);
                    }
                    if (bill.getCurrencyType() != null) {
                        BizAccountBillEntryInfo bizentryInfo = new BizAccountBillEntryInfo();
                        bizentryInfo.setExchangeRatePrecision(new Integer(4));
                        bizentryInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                        bizentryInfo.setExchangeRate(new BigDecimal(1));
                        this.map.put(bill.getCurrencyType().getNumber().trim(), bizentryInfo);
                    }
                }
                entryInfo = new BizAccountBillAccountEntryInfo();
                entryInfo.setBill(bill);
                entryInfo.setSeq(bill.getCollectionEntries().size() + 1);
                data = ((DataToken)hsData.get((Object)"FCurrencyNumber")).data;
                if (data != null) {
                    str = data.toString().trim();
                    if (str == null || "".equals(str)) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"CURRENCYTYPE_NOT_NULL", (Locale)ctx.getOriginLocale()));
                    }
                    if (this.map.containsKey(str)) {
                        BizAccountBillEntryInfo bizinfo = this.map.get(str);
                        entryInfo.setConvertMode(bizinfo.getConvertMode());
                        entryInfo.setExchangeRatePrecision(bizinfo.getExchangeRatePrecision());
                        entryInfo.setExchangeRate(bizinfo.getExchangeRate());
                        try {
                            CurrencyInfo info;
                            ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                            viewInfo.setFilter(filter);
                            viewInfo.getSelector().add(new SelectorItemInfo("id"));
                            CurrencyCollection collection = icurreny.getCurrencyCollection(viewInfo);
                            if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                                entryInfo.setCurrencyType(info);
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_CURRENCYTYPE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                    }
                }
                for (int i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
                    Object o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
                    if (o == null) continue;
                    String value = o.toString();
                    entryInfo.setString(this.STRING_OBJS_EN[i], value);
                }
                BizImportUtil.initImportPayerId(ctx, entryInfo, hsData, this.objectMap);
                try {
                    Object o = ((DataToken)hsData.get((Object)"FAmountOri")).data;
                    if (o != null && o.toString().trim().length() > 0) {
                        BigDecimal value = new BigDecimal(o.toString());
                        if (value != null) {
                            entryInfo.setAmountOri(value);
                        }
                        break block29;
                    }
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"FAMOUNTORI_NOT_NULL", (Locale)ctx.getOriginLocale()));
                }
                catch (NumberFormatException nex) {
                    logger.error((Object)nex.getMessage());
                    throw new TaskExternalException("amountOri" + ResourceBase.getString((String)RES, (String)"NUMBERFORMET", (Locale)ctx.getOriginLocale()));
                }
            }
            BigDecimal rate = entryInfo.getExchangeRate();
            BigDecimal amountOri = entryInfo.getAmountOri();
            BigDecimal amount = entryInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? amountOri.multiply(rate).setScale(2, 4) : amountOri.divide(rate, 2, 4);
            entryInfo.setAmount(amount);
            data = ((DataToken)hsData.get((Object)"FOpenAreaNumber")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                OpenAreaInfo info = null;
                try {
                    info = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaInfo("select id where number = '" + str + "'");
                }
                catch (ObjectNotFoundException e) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_FOPENAREANUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                entryInfo.setOpenArea(info);
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"FNUMBER_NOT_NULL", (Locale)ctx.getOriginLocale()));
        }
        return entryInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            this.idsEverImported.add(this.TEMPPK);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.BizAccountCollectionEntryForDatatask";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        DateFormat df = null;
        try {
            df = MultilingualUtil.getDateFormat(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            if (!StringUtils.isEmpty((String)rs.getString("number"))) {
                result.put("FNumber", rs.getString("number"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("collectionEntry.payerName"))) {
                result.put("FPayerName", rs.getString("collectionEntry.payerName"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("collectionEntry.payerAccount"))) {
                result.put("FPayerAccount", rs.getString("collectionEntry.payerAccount"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("collectionEntry.payerBank"))) {
                result.put("FPayerBank", rs.getString("collectionEntry.payerBank"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("openArea.number"))) {
                result.put("FOpenAreaNumber", rs.getString("openArea.number"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("openArea.name"))) {
                result.put("FOpenAreaName", rs.getString("openArea.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("currency.number"))) {
                result.put("FCurrencyNumber", rs.getString("currency.number"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("currency.name"))) {
                result.put("FCurrencyName", rs.getString("currency.name"));
            }
            if (rs.getBigDecimal("collectionEntry.exchangeRate") != null) {
                result.put("FExchangeRate", rs.getBigDecimal("collectionEntry.exchangeRate"));
            }
            if (rs.getBigDecimal("collectionEntry.amount") != null) {
                result.put("FAmount", rs.getBigDecimal("collectionEntry.amount"));
            }
            if (rs.getBigDecimal("collectionEntry.amountOri") != null) {
                result.put("FAmountOri", rs.getBigDecimal("collectionEntry.amountOri"));
            }
            if (StringUtils.isEmpty((String)rs.getString("collectionEntry.payerId"))) {
                result.put("isNoSysPayer", "1");
            } else {
                result.put("isNoSysPayer", "0");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }
}

