/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.IBizCollCoreBillBase;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.AssistantAccountUtil;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizAccountOutBillAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.BizAccountOutBillAddByExcel");
    Map<String, Object> personPositionMap = new HashMap<String, Object>(128);
    String[] IMP_STRING = new String[]{"tel", "cause", "name"};
    String[] IMP_DATE = new String[]{"bizReqDate"};
    String[] IMP_BIGDECIMAL_FIELDS_EN = new String[]{"entries.amountOri", "entries.amount", "entries.amountApprovedOri", "entries.amountApproved", "entries.taxRate", "entries.tax", "entries.taxApproved", "entries.amountApprovedWithoutTax", "entries.amountApprovedOriWithoutTax", "entries.amountOriWithoutTax", "entries.amountWithoutTax"};
    String[] IMP_BIGDECIMAL_OBJS_EN = new String[]{"amountOri", "amount", "amountApprovedOri", "amountApproved", "taxRate", "tax", "taxApproved", "amountApprovedWithoutTax", "amountApprovedOriWithoutTax", "amountOriWithoutTax", "amountWithoutTax"};
    String[] IMP_DATE_FIELDS_EN = new String[]{"entries.happenTime", "entries.billingDate"};
    String[] IMP_DATE_OBJS_EN = new String[]{"happenTime", "billingDate"};
    String[] IMP_STRING_FIELDS_EN = new String[]{"entries.purpose"};
    String[] IMP_STRING_OBJS_EN = new String[]{"purpose"};
    String[] EXP_STRING = new String[]{"number", "name", "currencyType.name", "applier.name", "orgUnit.name", "applierCompany.name", "company.name", "costedDept.name", "tel", "cause", "biller.name", "description"};
    String[] EXP_STRING_EN = new String[]{"entries.purpose", "operationType1.name", "expenseType.name", "costCenter.name", "company1.name", "currencyType1.name", "entries.exchangeRate", "entries.convertMode", "entries.exchangeRatePrecision"};
    String[] EXP_DATE = new String[]{"bizReqDate", "entries.happenTime", "billDate", "entries.billingDate"};
    String[] EXP_BIGDECIMAL = new String[]{"amountApproved", "amount", "entries.amountOri", "entries.amount", "entries.amountApprovedOri", "entries.amountApproved", "entries.taxRate", "entries.tax", "entries.taxApproved", "entries.amountApprovedWithoutTax", "entries.amountApprovedOriWithoutTax", "entries.amountOriWithoutTax", "entries.amountWithoutTax"};
    private IObjectPK TEMPPK = null;
    private String TEMPNUMBER = null;
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.BizAccountOutBillForDatatask";
    private Set idsEverImported = new HashSet();

    private IObjectPK getInfoPKbyNumber(Context ctx, String number) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            CoreBaseCollection col = this.getController(ctx).getCollection(viewInfo);
            if (col.size() > 0) {
                return new ObjectUuidPK(col.get(0).getId());
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BizAccountOutBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            this.idsEverImported.add(this.TEMPPK);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable chsData, Context ctx) throws TaskExternalException {
        BizAccountOutBillInfo billInfo = new BizAccountOutBillInfo();
        boolean importDataByRule = BizImportUtil.getBooleanParam(ctx, "importDataByRule");
        boolean isAddNew = !this.isSltImportUpdate();
        ICodingRuleManager iCodingRuleManager = BizImportUtil.getICodingRuleManager(ctx, isAddNew);
        IBizCollCoreBillBase iFixBill = (IBizCollCoreBillBase)this.getController(ctx);
        Object str = null;
        for (int t = 0; t < chsData.size(); ++t) {
            Hashtable hsData = (Hashtable)chsData.get(new Integer(t));
            if (t == 0) {
                if (isAddNew) {
                    this.TEMPPK = BizImportUtil.dealWithNumberAddNew(ctx, iFixBill, billInfo, hsData, importDataByRule);
                } else {
                    billInfo = (BizAccountOutBillInfo)BizImportUtil.dealWithNumberUpdate(ctx, iFixBill, hsData);
                    this.TEMPPK = new ObjectUuidPK(billInfo.getId());
                }
                if (this.TEMPPK == null || this.isSltImportUpdate()) {
                    BizCollUtil.initInportDateData(ctx, billInfo, null, hsData, this.IMP_DATE, this.IMP_DATE);
                    BizCollUtil.initInportStringData(ctx, billInfo, null, hsData, this.IMP_STRING, this.IMP_STRING);
                    this.personPositionMap.put("perm.permItem", "cp_bc_BizAccountOutBill_Import");
                    BizCollUtil.initInportCommonData(ctx, billInfo, hsData, this.personPositionMap);
                    billInfo.setBillTypeCode(BizCollBillTypeEnum.BIZ_ACCOUNT_OUT);
                    billInfo.setState(StateEnum.DRAFT);
                    billInfo.setBillDate(new Date());
                }
                if (this.isSltImportUpdate() && this.TEMPPK != null && !this.idsEverImported.contains(this.TEMPPK)) {
                    billInfo.getEntries().clear();
                    billInfo.setAmount(null);
                    billInfo.setAmountApproved(null);
                }
                if (isAddNew && importDataByRule) {
                    BizImportUtil.buildNumber(ctx, billInfo, iCodingRuleManager);
                }
            }
            this.handleEntry(billInfo, hsData, ctx);
        }
        return billInfo;
    }

    private void handleEntry(BizAccountOutBillInfo info, Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal entryAmountApproved;
        BizAccountOutBillEntryInfo entryInfo = null;
        Object data = ((DataToken)hsData.get((Object)"entries.seq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            BizAccountOutBillEntryCollection entryCollection = info.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                BizAccountOutBillEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"Repetition_Coding", (Locale)ctx.getOriginLocale()));
            }
            entryInfo = new BizAccountOutBillEntryInfo();
            entryInfo.setBill(info);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        } else {
            BizAccountOutBillEntryCollection entryCollection = info.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new BizAccountOutBillEntryInfo();
            entryInfo.setBill(info);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        BizCollUtil.initInportEntryCommonData(ctx, info, entryInfo, hsData, this.personPositionMap);
        BizCollUtil.initInportBigDecimalData(ctx, null, entryInfo, hsData, this.IMP_BIGDECIMAL_FIELDS_EN, this.IMP_BIGDECIMAL_OBJS_EN);
        BigDecimal tempAmount = info.getAmount();
        BigDecimal tempAmountApproved = info.getAmountApproved();
        BigDecimal entryAmount = entryInfo.getAmount() == null ? BizCollUtil.ZERO : entryInfo.getAmount();
        BigDecimal bigDecimal = entryAmountApproved = entryInfo.getAmountApproved() == null ? BizCollUtil.ZERO : entryInfo.getAmountApproved();
        if (tempAmount != null) {
            entryAmount = entryAmount.add(tempAmount);
        }
        if (tempAmountApproved != null) {
            entryAmountApproved = entryAmountApproved.add(tempAmountApproved);
        }
        info.setAmount(entryAmount);
        info.setAmountEncashed(entryAmount);
        info.setAmountApproved(entryAmountApproved);
        BizCollUtil.initInportDateData(ctx, null, entryInfo, hsData, this.IMP_DATE_FIELDS_EN, this.IMP_DATE_OBJS_EN);
        BizCollUtil.initInportStringData(ctx, null, entryInfo, hsData, this.IMP_STRING_FIELDS_EN, this.IMP_STRING_OBJS_EN);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("state", AssistantAccountUtil.getStateAlias(String.valueOf(rs.getInt("state"))));
            result.put("entries.seq", new Integer(rs.getInt("entries.seq")).toString());
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING);
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING_EN);
            BizCollUtil.initExportBigDecimalData(ctx, rs, result, this.EXP_BIGDECIMAL);
            BizCollUtil.initExportDateData(ctx, rs, result, this.EXP_DATE);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filterInfo = BizCollUtil.getExportFilterForQuery(ctx, paramMap);
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.BizAccountOutBillForDatatask";
    }

    public static PayerTypeEnum getPayerTypeValue(String value) {
        PayerTypeEnum tSaved = PayerTypeEnum.other;
        if (value != null) {
            value = value.trim();
            List EnumList = PayerTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                PayerTypeEnum payerTypeEnum = (PayerTypeEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(payerTypeEnum.getValue());
                String enumName = payerTypeEnum.getName();
                String enumAlias = payerTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = payerTypeEnum;
                break;
            }
        }
        return tSaved;
    }

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }
}

