/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DbUtilFromClient {
    private static Logger logger = Logger.getLogger((String)DbUtilFromClient.class.getName());
    private static final String DBDRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";

    public static Connection getConn(String dbIp, String dbPort, String dbName, String userName, String password) {
        Connection conn = null;
        String url = "jdbc:microsoft:sqlserver://" + dbIp + ":1433;DatabaseName=" + dbName;
        try {
            Class.forName(DBDRIVER).newInstance();
            conn = DriverManager.getConnection(url, userName, password);
        }
        catch (Exception e) {
            conn = null;
            logger.info((Object)"\n\n\n\n\n\n\n\n\n\n\n\n");
            logger.info((Object)e.getMessage());
            logger.info((Object)e.getStackTrace());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"102_DbUtilFromClient"));
        }
        return conn;
    }

    public static IRowSet executeQuery(Connection conn, String sql) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.info((Object)("SQLException:" + exc.getMessage()));
                throw new SQLException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws SQLException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.info((Object)("SQLException:" + exc.getMessage()));
                throw new SQLException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void execute(Connection conn, String sql) throws SQLException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLException:" + exc.getMessage()));
            throw new SQLException();
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void execute(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLException:" + exc.getMessage()));
            throw new SQLException();
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }
}

