/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizBillUtil;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.IInvoiceTypeEntry;
import com.kingdee.eas.cp.bc.InvoiceException;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryFactory;
import com.kingdee.eas.cp.bc.TraTicketEntryCollection;
import com.kingdee.eas.cp.bc.TraTicketEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.app.mobile.MbizCollUtil;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceUtilCustom {
    private static Logger logger = Logger.getLogger(InvoiceUtilCustom.class);

    public static Map buildEntryByFirstEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map billEntryCollectionMap = null;
        JSONArray ticketData = null;
        if (!(baseInfo instanceof DailyPurchaseAccountBillInfo) && BizCollUtil.objectIsNull(ticketData = JSONObject.parseArray((String)invoiceData))) {
            throw new InvoiceException(InvoiceException.INVOICEDATAISNULL);
        }
        if (baseInfo instanceof BizAccountBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByBizFirstEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByBizFirstEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByBizOutFirstEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByBizOutFirstEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            JSONArray purDataOut = JSONObject.parseArray((String)JSONObject.parseObject((String)invoiceData).getString("purchaseInfo"));
            JSONArray ticketPurData = JSONObject.parseArray((String)JSONObject.parseObject((String)invoiceData).getString("invoiceData"));
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByPurFirstEntry(ticketPurData, purDataOut, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByPurFirstEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByTraFirstEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByTraFirstEntry(ctx, ticketData, baseInfo, groupMap, spareMap);
        }
        return billEntryCollectionMap;
    }

    public static Map buildEntryByMoreEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map billEntryCollectionMap = null;
        JSONArray ticketData = null;
        if (!(baseInfo instanceof DailyPurchaseAccountBillInfo) && BizCollUtil.objectIsNull(ticketData = JSONObject.parseArray((String)invoiceData))) {
            throw new InvoiceException(InvoiceException.INVOICEDATAISNULL);
        }
        if (baseInfo instanceof BizAccountBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByBizMoreEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByBizMoreEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByBizOutMoreEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByBizOutMoreEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            JSONArray purDataOut = JSONObject.parseArray((String)JSONObject.parseObject((String)invoiceData).getString("purchaseInfo"));
            JSONArray ticketPurData = JSONObject.parseArray((String)JSONObject.parseObject((String)invoiceData).getString("invoiceData"));
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByPurMoreEntry(ticketPurData, purDataOut, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByPurMoreEntry(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            Map groupMap = InvoiceUtilCustom.invoiceCloudGroupByTraMoreEntry(ticketData, spareMap);
            billEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildEntryByTraMoreEntry(ctx, ticketData, baseInfo, groupMap, spareMap);
        }
        return billEntryCollectionMap;
    }

    public static Map buildAccountEntryByFirstEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map accountEntryCollectionMap = null;
        JSONArray ticketData = null;
        if (!(baseInfo instanceof DailyPurchaseAccountBillInfo) && BizCollUtil.objectIsNull(ticketData = JSONObject.parseArray((String)invoiceData))) {
            throw new InvoiceException(InvoiceException.INVOICEDATAISNULL);
        }
        if (baseInfo instanceof BizAccountOutBillInfo) {
            accountEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildAccountEntryByBizOutFirstAccount(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            JSONArray ticketPurData = JSONObject.parseArray((String)JSONObject.parseObject((String)invoiceData).getString("purchaseInfo"));
            accountEntryCollectionMap = InvoiceUtilCustom.invoiceCloudBuildAccountEntryByPurFirstAccount(ctx, ticketPurData, baseInfo, spareMap);
        } else {
            BizBillUtil.initDefaultPersonalBank(ctx, baseInfo, null, true);
            return null;
        }
        return accountEntryCollectionMap;
    }

    public static Map invoiceCloudGroupByBizFirstEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap<String, Map<String, String>> groupMapByFirstEntry = new HashMap<String, Map<String, String>>();
        Map<String, String> valueMapByFirstEntry = new HashMap();
        String ticketCode = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        boolean first = true;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"fp_zl");
            String invoiceId = eJsStrOut.get((Object)"fid").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"jshjje") && "" != eJsStrOut.get((Object)"jshjje")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"jshjje").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"kphjse") && "" != eJsStrOut.get((Object)"kphjse")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"kphjse").toString());
            }
            if (null != eJsStrOut.get((Object)"fpdm") && "" != eJsStrOut.get((Object)"fpdm")) {
                ticketCode = eJsStrOut.get((Object)"fpdm").toString();
            } else {
                logger.info((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"spbm") && "" != eJsStrOut.get((Object)"spbm")) {
                iTaxClassNumber = eJsStrOut.get((Object)"spbm").toString();
            } else {
                logger.info((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            int count = 1;
            if (!first) {
                valueMapByFirstEntry = (Map)groupMapByFirstEntry.get("firstEntry");
                amount = (BigDecimal)valueMapByFirstEntry.get("amount");
                taxAmount = (BigDecimal)valueMapByFirstEntry.get("taxAmount");
                count = Integer.valueOf(valueMapByFirstEntry.get("count").toString());
                String invoice = valueMapByFirstEntry.get("fid").toString();
                amount = amount.add(ftotalpricetax);
                taxAmount = taxAmount.add(ftotaltax);
                ++count;
                invoiceId = invoice + "," + invoiceId;
                valueMapByFirstEntry.put("fid", invoiceId);
                valueMapByFirstEntry.put("amount", (String)((Object)amount));
                valueMapByFirstEntry.put("taxAmount", (String)((Object)taxAmount));
                valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(count)));
                continue;
            }
            valueMapByFirstEntry = new HashMap();
            valueMapByFirstEntry.put("amount", (String)((Object)ftotalpricetax));
            valueMapByFirstEntry.put("taxAmount", (String)((Object)ftotaltax));
            valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(1)));
            valueMapByFirstEntry.put("fid", invoiceId);
            groupMapByFirstEntry.put("firstEntry", valueMapByFirstEntry);
            first = false;
        }
        groupMap.put("groupMapByFirstEntry", groupMapByFirstEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByBizFirstEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByFirstEntry = (Map)groupMap.get("groupMapByFirstEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        BizAccountBillEntryCollection bizCollection = new BizAccountBillEntryCollection();
        Set keysetByFirstEntry = groupMapByFirstEntry.keySet();
        Iterator itByInvoiceType = keysetByFirstEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetByFirstEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            Map valuemap = (Map)groupMapByFirstEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByFirstEntry.get(Integer.parseInt(invoiceif));
            }
            BizAccountBillEntryInfo entry = new BizAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            entryLinkInvoice.put("firstEntry", entryBosId.toString());
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(MbizCollUtil.getCurrentType((Context)ctx));
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount.setScale(2, 4));
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            bizCollection.add(entry);
        }
        HashMap<String, Object> bizCollectionMap = new HashMap<String, Object>();
        bizCollectionMap.put("bizCollection", (Object)bizCollection);
        bizCollectionMap.put("entriesJson", entriesJson);
        bizCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return bizCollectionMap;
    }

    public static Map invoiceCloudGroupByBizOutFirstEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap<String, Map<String, String>> groupMapByFirstEntry = new HashMap<String, Map<String, String>>();
        Map<String, String> valueMapByFirstEntry = new HashMap();
        String ticketCode = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        boolean first = true;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
            String invoiceId = eJsStrOut.get((Object)"serialNo").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"taxAmount") && "" != eJsStrOut.get((Object)"taxAmount")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"taxAmount").toString());
            }
            if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode")) {
                ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
            } else {
                logger.error((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode")) {
                iTaxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
            } else {
                logger.error((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            int count = 1;
            if (!first) {
                valueMapByFirstEntry = (Map)groupMapByFirstEntry.get("firstEntry");
                amount = (BigDecimal)valueMapByFirstEntry.get("amount");
                taxAmount = (BigDecimal)valueMapByFirstEntry.get("taxAmount");
                count = Integer.valueOf(valueMapByFirstEntry.get("count").toString());
                String invoice = valueMapByFirstEntry.get("fid").toString();
                amount = amount.add(ftotalpricetax);
                taxAmount = taxAmount.add(ftotaltax);
                ++count;
                invoiceId = invoice + "," + invoiceId;
                valueMapByFirstEntry.put("fid", invoiceId);
                valueMapByFirstEntry.put("amount", (String)((Object)amount));
                valueMapByFirstEntry.put("taxAmount", (String)((Object)taxAmount));
                valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(count)));
                continue;
            }
            valueMapByFirstEntry = new HashMap();
            valueMapByFirstEntry.put("amount", (String)((Object)ftotalpricetax));
            valueMapByFirstEntry.put("taxAmount", (String)((Object)ftotaltax));
            valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(1)));
            valueMapByFirstEntry.put("fid", invoiceId);
            groupMapByFirstEntry.put("firstEntry", valueMapByFirstEntry);
            first = false;
        }
        groupMap.put("groupMapByFirstEntry", groupMapByFirstEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByBizOutFirstEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByFirstEntry = (Map)groupMap.get("groupMapByFirstEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        BizAccountOutBillEntryCollection bizOutCollection = new BizAccountOutBillEntryCollection();
        Set keysetByFirstEntry = groupMapByFirstEntry.keySet();
        Iterator itByInvoiceType = keysetByFirstEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetByFirstEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            Map valuemap = (Map)groupMapByFirstEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByFirstEntry.get(Integer.parseInt(invoiceif));
            }
            BizAccountOutBillEntryInfo entry = new BizAccountOutBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryLinkInvoice.put("firstEntry", entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(baseInfo.getCurrencyType());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount);
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setName("bizOutEntry");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            bizOutCollection.add(entry);
        }
        HashMap<String, Object> bizOutCollectionMap = new HashMap<String, Object>();
        bizOutCollectionMap.put("bizOutCollection", (Object)bizOutCollection);
        bizOutCollectionMap.put("entriesJson", entriesJson);
        bizOutCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return bizOutCollectionMap;
    }

    public static Map invoiceCloudGroupByPurFirstEntry(JSONArray returnDataOut, JSONArray purDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap<String, Map<String, String>> groupMapByFirstEntry = new HashMap<String, Map<String, String>>();
        Map<String, String> valueMapByFirstEntry = new HashMap();
        String ticketCode = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal unitPrice = BizCollUtil.ZERO;
        String unit = null;
        BigDecimal num = null;
        String goodsName = null;
        boolean first = true;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
            String invoiceId = eJsStrOut.get((Object)"serialNo").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalTaxAmount") && "" != eJsStrOut.get((Object)"totalTaxAmount")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"totalTaxAmount").toString());
            }
            if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode")) {
                ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
            } else {
                logger.info((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode")) {
                iTaxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
            } else {
                logger.info((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            int count = 1;
            if (!first) {
                valueMapByFirstEntry = (Map)groupMapByFirstEntry.get("firstEntry");
                amount = (BigDecimal)valueMapByFirstEntry.get("amount");
                taxAmount = (BigDecimal)valueMapByFirstEntry.get("taxAmount");
                count = Integer.valueOf(valueMapByFirstEntry.get("count").toString());
                String invoice = valueMapByFirstEntry.get("fid").toString();
                unitPrice = purDataOut.getJSONObject(i).getBigDecimal("unitPrice");
                unit = purDataOut.getJSONObject(i).getString("unit");
                num = purDataOut.getJSONObject(i).getBigDecimal("num");
                goodsName = purDataOut.getJSONObject(i).getString("goodsName");
                amount = amount.add(ftotalpricetax);
                taxAmount = taxAmount.add(ftotaltax);
                ++count;
                invoiceId = invoice + "," + invoiceId;
                valueMapByFirstEntry.put("fid", invoiceId);
                valueMapByFirstEntry.put("amount", (String)((Object)amount));
                valueMapByFirstEntry.put("taxAmount", (String)((Object)taxAmount));
                valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(count)));
                valueMapByFirstEntry.put("unit", unit);
                valueMapByFirstEntry.put("unitPrice", (String)((Object)unitPrice));
                valueMapByFirstEntry.put("num", (String)((Object)num));
                valueMapByFirstEntry.put("goodsName", goodsName);
                continue;
            }
            valueMapByFirstEntry = new HashMap();
            valueMapByFirstEntry.put("amount", (String)((Object)ftotalpricetax));
            valueMapByFirstEntry.put("taxAmount", (String)((Object)ftotaltax));
            valueMapByFirstEntry.put("count", (String)((Object)Integer.valueOf(1)));
            valueMapByFirstEntry.put("fid", invoiceId);
            valueMapByFirstEntry.put("unit", purDataOut.getJSONObject(i).getString("unit"));
            valueMapByFirstEntry.put("unitPrice", (String)((Object)purDataOut.getJSONObject(i).getBigDecimal("unitPrice")));
            valueMapByFirstEntry.put("num", (String)((Object)purDataOut.getJSONObject(i).getBigDecimal("num")));
            valueMapByFirstEntry.put("goodsName", purDataOut.getJSONObject(i).getString("goodsName"));
            groupMapByFirstEntry.put("firstEntry", valueMapByFirstEntry);
            first = false;
        }
        groupMap.put("groupMapByFirstEntry", groupMapByFirstEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByPurFirstEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByFirstEntry = (Map)groupMap.get("groupMapByFirstEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        IInvoiceTypeEntry invoiceService = InvoiceTypeEntryFactory.getLocalInstance(ctx);
        DailyPurchaseAccountBillEntryCollection purCollection = new DailyPurchaseAccountBillEntryCollection();
        Set keysetByFirstEntry = groupMapByFirstEntry.keySet();
        Iterator itByInvoiceType = keysetByFirstEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetByFirstEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            BigDecimal ePrice = BizCollUtil.ZERO;
            BigDecimal eCount = BizCollUtil.ZERO;
            String eGoodsName = null;
            String eUnit = null;
            Map valuemap = (Map)groupMapByFirstEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByFirstEntry.get(Integer.parseInt(invoiceif));
            }
            DailyPurchaseAccountBillEntryInfo entry = new DailyPurchaseAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryLinkInvoice.put("firstEntry", entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(baseInfo.getCurrencyType());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null && !"".equals(eTaxAmount)) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null && !"".equals(eAmount)) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null && !"".equals(eTaxAmount)) {
                entry.setTax(eTaxAmount.setScale(2, 4));
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            ePrice = (BigDecimal)valuemap.get("unitPrice");
            eCount = (BigDecimal)valuemap.get("num");
            eGoodsName = valuemap.get("goodsName") != null ? valuemap.get("goodsName").toString() : null;
            eUnit = valuemap.get("unit") != null ? valuemap.get("unit").toString() : null;
            entry.setName(eGoodsName);
            if (ePrice != null && !"".equals(ePrice)) {
                entry.setPrice(ePrice.setScale(2, 4));
                entry.setPriceWithTax(ePrice.add(eTaxAmount).setScale(2, 4));
            }
            entry.setCount(eCount);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("name", (Object)eUnit));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            MeasureUnitCollection items = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection(entityViewInfo);
            MeasureUnitInfo item = null;
            if (items != null && items.size() > 0) {
                item = items.get(0);
            }
            entry.setMeasurement(item);
            entry.setPurpose("");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            purCollection.add(entry);
        }
        HashMap<String, Object> purCollectionMap = new HashMap<String, Object>();
        purCollectionMap.put("purCollection", (Object)purCollection);
        purCollectionMap.put("entriesJson", entriesJson);
        purCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return purCollectionMap;
    }

    public static Map invoiceCloudGroupByTraFirstEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByTraFirstEntry(Context ctx, JSONArray returnDataOut, BizCollBillBaseInfo baseInfo, Map groupMap, Map spareMap) throws EASBizException, BOSException {
        TravelAccountBillEntryCollection traBizCollection = new TravelAccountBillEntryCollection();
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, date);
        TravelAccountBillEntryInfo entry = new TravelAccountBillEntryInfo();
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
        entry.setId(entryBosId);
        entry.setTicketUrl(entryBosId.toString());
        entry.setInvoiceNum(spareMap.get("invoiceNum").toString());
        entry.setStartDate(date);
        entry.setEndDate(date);
        entry.setFrom("\u5317\u4eac");
        entry.setTo("\u4e0a\u6d77");
        entry.setVehicle(VehicleEnum.AIRPLANE);
        entry.setCostCenter(baseInfo.getCostedDept());
        entry.setCompany(baseInfo.getCompany());
        entry.setTax(BizCollUtil.ZERO);
        entry.setBussesExpenseTax(BizCollUtil.ZERO);
        JSONObject entryJson = new JSONObject();
        entryJson.put("entryid", (Object)entryBosId.toString());
        entry.setCurrencyType(baseInfo.getCurrencyType());
        if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
            entry.setExchangeRate(exchangeRate.getConvertRate());
        } else {
            entry.setExchangeRate(new BigDecimal("1.0000"));
        }
        if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
            entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
            entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
        } else {
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
        }
        BigDecimal amountTotal = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        JSONArray invoiceArray = new JSONArray();
        for (int i = 0; i < returnDataOut.size(); ++i) {
            SimpleDateFormat sdf;
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            BigDecimal amount = eJsStrOut.getBigDecimal("totalAmount").setScale(2, 4);
            if ("city".equals(eJsStrOut.get((Object)"costType"))) {
                if (!BizCollUtil.objectIsNull(eJsStrOut.getString("invoiceDate"))) {
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        entry.setEndDate(sdf.parse(eJsStrOut.getString("invoiceDate")));
                        entry.setStartDate(sdf.parse(eJsStrOut.getString("invoiceDate")));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                entry.setTaxiExpense(amount);
                amountTotal = amountTotal.add(amount);
                invoiceArray.addAll((Collection)eJsStrOut.getJSONArray("invoiceData"));
                continue;
            }
            if ("suburb".equals(eJsStrOut.get((Object)"costType"))) {
                if (!BizCollUtil.objectIsNull(amount)) {
                    entry.setBussesExpense(amount);
                } else {
                    entry.setBussesExpense(BizCollUtil.ZERO);
                }
                if (!BizCollUtil.objectIsNull(eJsStrOut.getBigDecimal("taxAmount"))) {
                    entry.setBussesExpenseTax(eJsStrOut.getBigDecimal("taxAmount").setScale(2, 4));
                } else {
                    entry.setBussesExpenseTax(BizCollUtil.ZERO);
                }
                entry.setBussesExpenseWithoutTax(entry.getBussesExpense().subtract(entry.getBussesExpenseTax()).setScale(2, 4));
                if (!BizCollUtil.objectIsNull(eJsStrOut.getBigDecimal("everTaxRate"))) {
                    entry.setBussesExpenseTaxRate(eJsStrOut.getBigDecimal("everTaxRate").multiply(new BigDecimal(100)).setScale(2, 4));
                }
                if (!BizCollUtil.objectIsNull(eJsStrOut.getString("invoiceDate"))) {
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        entry.setEndDate(sdf.parse(eJsStrOut.getString("invoiceDate")));
                        entry.setStartDate(sdf.parse(eJsStrOut.getString("invoiceDate")));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                amountTotal = amountTotal.add(amount);
                invoiceArray.addAll((Collection)eJsStrOut.getJSONArray("invoiceData"));
                continue;
            }
            if ("hotel".equals(eJsStrOut.get((Object)"costType"))) {
                if (!BizCollUtil.objectIsNull(amount)) {
                    entry.setHotelExpense(amount);
                } else {
                    entry.setHotelExpense(BizCollUtil.ZERO);
                }
                if (!BizCollUtil.objectIsNull(eJsStrOut.getBigDecimal("taxAmount"))) {
                    entry.setTax(eJsStrOut.getBigDecimal("taxAmount").setScale(2, 4));
                } else {
                    entry.setTax(BizCollUtil.ZERO);
                }
                entry.setHotelExpenseWithoutTax(entry.getHotelExpense().subtract(entry.getTax()).setScale(2, 4));
                if (!BizCollUtil.objectIsNull(eJsStrOut.getBigDecimal("everTaxRate"))) {
                    entry.setTaxRate(eJsStrOut.getBigDecimal("everTaxRate").multiply(new BigDecimal(100)).setScale(2, 4));
                }
                taxAmount.add(eJsStrOut.getBigDecimal("taxAmount"));
                amountTotal = amountTotal.add(amount);
                invoiceArray.addAll((Collection)eJsStrOut.getJSONArray("invoiceData"));
                continue;
            }
            if (!"other".equals(eJsStrOut.get((Object)"costType"))) continue;
            entry.setOtherExpense(amount);
            amountTotal = amountTotal.add(amount);
            invoiceArray.addAll((Collection)eJsStrOut.getJSONArray("invoiceData"));
        }
        if (amountTotal != null) {
            entry.setAmountOri(amountTotal.setScale(2, 4));
            entry.setAmountOriWithoutTax(amountTotal.subtract(entry.getTax()).subtract(entry.getBussesExpenseTax()).setScale(2, 4));
            if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                entry.setAmount(amountTotal.divide(entry.getExchangeRate()).setScale(2, 4));
                entry.setAmountWithoutTax(entry.getAmountOriWithoutTax().divide(entry.getExchangeRate()).subtract(taxAmount).setScale(2, 4));
            } else {
                entry.setAmount(amountTotal.multiply(entry.getExchangeRate()).setScale(2, 4));
                entry.setAmountWithoutTax(entry.getAmountOriWithoutTax().multiply(entry.getExchangeRate()).subtract(taxAmount).setScale(2, 4));
            }
        }
        traBizCollection.add(entry);
        HashMap<String, TravelAccountBillEntryCollection> traCollectionMap = new HashMap<String, TravelAccountBillEntryCollection>();
        traCollectionMap.put("traBizCollection", traBizCollection);
        traCollectionMap.put("entryJson", (TravelAccountBillEntryCollection)entryJson);
        traCollectionMap.put("invoiceArray", (TravelAccountBillEntryCollection)invoiceArray);
        return traCollectionMap;
    }

    public static Map invoiceCloudGroupByBizMoreEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap groupMapByMoreEntry = new HashMap();
        HashMap<String, Object> valueMapByMoreEntry = new HashMap<String, Object>();
        String ticketCode = null;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"fp_zl");
            String invoiceId = eJsStrOut.get((Object)"fid").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"jshjje") && "" != eJsStrOut.get((Object)"jshjje")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"jshjje").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"kphjse") && "" != eJsStrOut.get((Object)"kphjse")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"kphjse").toString());
            }
            if (null != eJsStrOut.get((Object)"fpdm") && "" != eJsStrOut.get((Object)"fpdm")) {
                ticketCode = eJsStrOut.get((Object)"fpdm").toString();
            } else {
                logger.info((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"spbm") && "" != eJsStrOut.get((Object)"spbm")) {
                iTaxClassNumber = eJsStrOut.get((Object)"spbm").toString();
            } else {
                logger.info((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            valueMapByMoreEntry = new HashMap();
            valueMapByMoreEntry.put("amount", ftotalpricetax);
            valueMapByMoreEntry.put("taxAmount", ftotaltax);
            valueMapByMoreEntry.put("count", 1);
            valueMapByMoreEntry.put("fid", invoiceId);
            groupMapByMoreEntry.put(invoiceId, valueMapByMoreEntry);
        }
        groupMap.put("groupMapByMoreEntry", groupMapByMoreEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByBizMoreEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByMoreEntry = (Map)groupMap.get("groupMapByMoreEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        BizAccountBillEntryCollection bizCollection = new BizAccountBillEntryCollection();
        Set keysetBymoreEntry = groupMapByMoreEntry.keySet();
        Iterator itByInvoiceType = keysetBymoreEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetBymoreEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            Map valuemap = (Map)groupMapByMoreEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByMoreEntry.get(Integer.parseInt(invoiceif));
            }
            BizAccountBillEntryInfo entry = new BizAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            entryLinkInvoice.put(valuemap.get("fid").toString(), entryBosId.toString());
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(MbizCollUtil.getCurrentType((Context)ctx));
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount.setScale(2, 4));
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            bizCollection.add(entry);
        }
        HashMap<String, Object> bizCollectionMap = new HashMap<String, Object>();
        bizCollectionMap.put("bizCollection", (Object)bizCollection);
        bizCollectionMap.put("entriesJson", entriesJson);
        bizCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return bizCollectionMap;
    }

    public static Map invoiceCloudGroupByBizOutMoreEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap groupMapByMoreEntry = new HashMap();
        HashMap<String, Object> valueMapByMoreEntry = new HashMap<String, Object>();
        String ticketCode = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
            String invoiceId = eJsStrOut.get((Object)"serialNo").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"taxAmount") && "" != eJsStrOut.get((Object)"taxAmount")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"taxAmount").toString());
            }
            if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode")) {
                ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
            } else {
                logger.error((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode")) {
                iTaxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
            } else {
                logger.error((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            valueMapByMoreEntry = new HashMap();
            valueMapByMoreEntry.put("amount", ftotalpricetax);
            valueMapByMoreEntry.put("taxAmount", ftotaltax);
            valueMapByMoreEntry.put("count", 1);
            valueMapByMoreEntry.put("fid", invoiceId);
            groupMapByMoreEntry.put(invoiceId, valueMapByMoreEntry);
        }
        groupMap.put("groupMapByMoreEntry", groupMapByMoreEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByBizOutMoreEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByMoreEntry = (Map)groupMap.get("groupMapByMoreEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        BizAccountOutBillEntryCollection bizOutCollection = new BizAccountOutBillEntryCollection();
        Set keysetByMoreEntry = groupMapByMoreEntry.keySet();
        Iterator itByInvoiceType = keysetByMoreEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetByMoreEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            Map valuemap = (Map)groupMapByMoreEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByMoreEntry.get(Integer.parseInt(invoiceif));
            }
            BizAccountOutBillEntryInfo entry = new BizAccountOutBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryLinkInvoice.put(valuemap.get("fid").toString(), entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(baseInfo.getCurrencyType());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount);
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setName("bizOutEntry");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            bizOutCollection.add(entry);
        }
        HashMap<String, Object> bizOutCollectionMap = new HashMap<String, Object>();
        bizOutCollectionMap.put("bizOutCollection", (Object)bizOutCollection);
        bizOutCollectionMap.put("entriesJson", entriesJson);
        bizOutCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return bizOutCollectionMap;
    }

    public static Map invoiceCloudGroupByPurMoreEntry(JSONArray returnDataOut, JSONArray purDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        HashMap groupMapByMoreEntry = new HashMap();
        HashMap<String, Object> valueMapByMoreEntry = new HashMap<String, Object>();
        String ticketCode = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal unitPrice = BizCollUtil.ZERO;
        Object unit = null;
        Object num = null;
        Object goodsName = null;
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
            String invoiceId = eJsStrOut.get((Object)"serialNo").toString();
            BigDecimal ftotalpricetax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount")) {
                ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
            }
            BigDecimal ftotaltax = BizCollUtil.ZERO;
            if (null != eJsStrOut.get((Object)"totalTaxAmount") && "" != eJsStrOut.get((Object)"totalTaxAmount")) {
                ftotaltax = new BigDecimal(eJsStrOut.get((Object)"totalTaxAmount").toString());
            }
            if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode")) {
                ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
            } else {
                logger.info((Object)"######## cpbc  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode")) {
                iTaxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
            } else {
                logger.info((Object)("### cpbc ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            boolean count = true;
            valueMapByMoreEntry = new HashMap();
            valueMapByMoreEntry.put("amount", ftotalpricetax);
            valueMapByMoreEntry.put("taxAmount", ftotaltax);
            valueMapByMoreEntry.put("count", 1);
            valueMapByMoreEntry.put("fid", invoiceId);
            valueMapByMoreEntry.put("unit", purDataOut.getJSONObject(i).getString("unit"));
            valueMapByMoreEntry.put("unitPrice", purDataOut.getJSONObject(i).getBigDecimal("unitPrice"));
            valueMapByMoreEntry.put("num", purDataOut.getJSONObject(i).getBigDecimal("num"));
            valueMapByMoreEntry.put("goodsName", purDataOut.getJSONObject(i).getString("goodsName"));
            groupMapByMoreEntry.put(invoiceId, valueMapByMoreEntry);
        }
        groupMap.put("groupMapByMoreEntry", groupMapByMoreEntry);
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByPurMoreEntry(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map groupMapByMoreEntry = (Map)groupMap.get("groupMapByMoreEntry");
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, new Date());
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        IInvoiceTypeEntry invoiceService = InvoiceTypeEntryFactory.getLocalInstance(ctx);
        DailyPurchaseAccountBillEntryCollection purCollection = new DailyPurchaseAccountBillEntryCollection();
        Set keysetByMoreEntry = groupMapByMoreEntry.keySet();
        Iterator itByInvoiceType = keysetByMoreEntry.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        for (int k = 0; k < keysetByMoreEntry.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = BizCollUtil.ZERO;
            BigDecimal eTaxAmount = BizCollUtil.ZERO;
            BigDecimal ePrice = BizCollUtil.ZERO;
            BigDecimal eCount = BizCollUtil.ZERO;
            String eGoodsName = null;
            String eUnit = null;
            Map valuemap = (Map)groupMapByMoreEntry.get(invoiceif);
            if (null == valuemap) {
                valuemap = (Map)groupMapByMoreEntry.get(Integer.parseInt(invoiceif));
            }
            DailyPurchaseAccountBillEntryInfo entry = new DailyPurchaseAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entryLinkInvoice.put(valuemap.get("fid").toString(), entryBosId.toString());
            entryJson.put("entryid", (Object)entryBosId.toString());
            String[] jsonStr = valuemap.get("fid").toString().split(",");
            entryJson.put("fid", (Object)jsonStr);
            entriesJson.add((Object)entryJson);
            eAmount = (BigDecimal)valuemap.get("amount");
            eTaxAmount = (BigDecimal)valuemap.get("taxAmount");
            entry.setCurrencyType(baseInfo.getCurrencyType());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            BigDecimal tempAmount = BizCollUtil.ZERO;
            if (eTaxAmount != null && !"".equals(eTaxAmount)) {
                tempAmount = eTaxAmount;
            }
            if (eAmount != null && !"".equals(eAmount)) {
                entry.setAmountOri(eAmount.setScale(2, 4));
                entry.setAmountOriWithoutTax(eAmount.subtract(tempAmount).setScale(2, 4));
                if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    entry.setAmount(eAmount.divide(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.divide(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                } else {
                    entry.setAmount(eAmount.multiply(entry.getExchangeRate()).setScale(2, 4));
                    entry.setAmountWithoutTax(eAmount.multiply(entry.getExchangeRate()).subtract(tempAmount).setScale(2, 4));
                }
            }
            if (eTaxAmount != null && !"".equals(eTaxAmount)) {
                entry.setTax(eTaxAmount.setScale(2, 4));
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                if (BizCollUtil.greateThenZero(tempDec)) {
                    entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
                } else {
                    entry.setTaxRate(BizCollUtil.ZERO);
                }
            }
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            ePrice = (BigDecimal)valuemap.get("unitPrice");
            eCount = (BigDecimal)valuemap.get("num");
            eGoodsName = valuemap.get("goodsName") != null ? valuemap.get("goodsName").toString() : null;
            eUnit = valuemap.get("unit") != null ? valuemap.get("unit").toString() : null;
            entry.setName(eGoodsName);
            if (ePrice != null && !"".equals(ePrice)) {
                entry.setPrice(ePrice.setScale(2, 4));
                entry.setPriceWithTax(ePrice.add(eTaxAmount).setScale(2, 4));
            }
            entry.setCount(eCount);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("name", (Object)eUnit));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            MeasureUnitCollection items = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection(entityViewInfo);
            MeasureUnitInfo item = null;
            if (items != null && items.size() > 0) {
                item = items.get(0);
            }
            entry.setMeasurement(item);
            entry.setPurpose("");
            entry.setAmountApproved(BizCollUtil.ZERO);
            entry.setAmountApprovedOri(BizCollUtil.ZERO);
            entry.setCompany(baseInfo.getCompany());
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(BizCollUtil.ZERO);
            purCollection.add(entry);
        }
        HashMap<String, Object> purCollectionMap = new HashMap<String, Object>();
        purCollectionMap.put("purCollection", (Object)purCollection);
        purCollectionMap.put("entriesJson", entriesJson);
        purCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        return purCollectionMap;
    }

    public static Map invoiceCloudGroupByTraMoreEntry(JSONArray returnDataOut, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = new HashMap();
        return groupMap;
    }

    public static Map invoiceCloudBuildEntryByTraMoreEntry(Context ctx, JSONArray returnDataOut, BizCollBillBaseInfo baseInfo, Map groupMap, Map spareMap) throws EASBizException, BOSException {
        TravelAccountBillEntryCollection traBizCollection = new TravelAccountBillEntryCollection();
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(baseInfo.getCurrencyType().getId().toString(), null, null, date);
        JSONArray invoiceArray = new JSONArray();
        JSONObject entryJson = new JSONObject();
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            String costType = eJsStrOut.get((Object)"costType").toString();
            JSONArray inviceDataArray = eJsStrOut.getJSONArray("invoiceData");
            for (int j = 0; j < inviceDataArray.size(); ++j) {
                JSONObject invoiceData = inviceDataArray.getJSONObject(j);
                invoiceArray.add((Object)invoiceData);
                InvoiceUtilCustom.buildTraMoreEntry(date, exchangeRate, baseInfo, spareMap, invoiceData, entryJson, traBizCollection, costType);
            }
        }
        HashMap<String, TravelAccountBillEntryCollection> traCollectionMap = new HashMap<String, TravelAccountBillEntryCollection>();
        traCollectionMap.put("traBizCollection", traBizCollection);
        traCollectionMap.put("entryJson", (TravelAccountBillEntryCollection)entryJson);
        traCollectionMap.put("invoiceArray", (TravelAccountBillEntryCollection)invoiceArray);
        return traCollectionMap;
    }

    public static void buildTraMoreEntry(Date date, ExchangeRateInfo exchangeRate, BizCollBillBaseInfo baseInfo, Map spareMap, JSONObject invoiceData, JSONObject entryJson, TravelAccountBillEntryCollection traBizCollection, String costType) {
        TravelAccountBillEntryInfo entry = new TravelAccountBillEntryInfo();
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
        entry.setId(entryBosId);
        entry.setTicketUrl(entryBosId.toString());
        entry.setInvoiceNum("\u53d1\u79681\u5f20");
        entry.setStartDate(date);
        entry.setEndDate(date);
        entry.setFrom("\u5317\u4eac");
        entry.setTo("\u4e0a\u6d77");
        entry.setVehicle(VehicleEnum.AIRPLANE);
        entry.setCostCenter(baseInfo.getCostedDept());
        entry.setCompany(baseInfo.getCompany());
        entry.setTax(BizCollUtil.ZERO);
        entry.setBussesExpenseTax(BizCollUtil.ZERO);
        entryJson.put(invoiceData.getString("serialNo"), (Object)entryBosId.toString());
        entry.setCurrencyType(baseInfo.getCurrencyType());
        if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
            entry.setExchangeRate(exchangeRate.getConvertRate());
        } else {
            entry.setExchangeRate(new BigDecimal("1.0000"));
        }
        if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
            entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
            entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
        } else {
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
        }
        if (!BizCollUtil.objectIsNull(invoiceData.getString("invoiceDate"))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                entry.setEndDate(sdf.parse(invoiceData.getString("invoiceDate")));
                entry.setStartDate(sdf.parse(invoiceData.getString("invoiceDate")));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BigDecimal amount = invoiceData.getBigDecimal("totalAmount").setScale(2, 4);
        BigDecimal taxAmount = invoiceData.getBigDecimal("taxAmount").setScale(2, 4);
        BigDecimal TaxRate = invoiceData.getBigDecimal("everTaxRate");
        if ("city".equals(costType)) {
            entry.setTaxiExpense(amount);
        } else if ("suburb".equals(costType)) {
            if (!BizCollUtil.objectIsNull(amount)) {
                entry.setBussesExpense(amount);
            } else {
                entry.setBussesExpense(BizCollUtil.ZERO);
            }
            if (!BizCollUtil.objectIsNull(taxAmount)) {
                entry.setBussesExpenseTax(taxAmount);
            } else {
                entry.setBussesExpenseTax(BizCollUtil.ZERO);
            }
            entry.setBussesExpenseWithoutTax(entry.getBussesExpense().subtract(entry.getBussesExpenseTax()).setScale(2, 4));
            if (!BizCollUtil.objectIsNull(TaxRate)) {
                entry.setBussesExpenseTaxRate(TaxRate.multiply(new BigDecimal(100)).setScale(2, 4));
            }
        } else if ("hotel".equals(costType)) {
            if (!BizCollUtil.objectIsNull(amount)) {
                entry.setHotelExpense(amount);
            } else {
                entry.setHotelExpense(BizCollUtil.ZERO);
            }
            if (!BizCollUtil.objectIsNull(taxAmount)) {
                entry.setTax(taxAmount.setScale(2, 4));
            } else {
                entry.setTax(BizCollUtil.ZERO);
            }
            entry.setHotelExpenseWithoutTax(entry.getHotelExpense().subtract(entry.getTax()).setScale(2, 4));
            if (!BizCollUtil.objectIsNull(TaxRate)) {
                entry.setTaxRate(TaxRate.multiply(new BigDecimal(100)).setScale(2, 4));
            }
        } else if ("other".equals(costType)) {
            entry.setOtherExpense(amount);
        }
        entry.setAmountOri(amount.setScale(2, 4));
        entry.setAmountOriWithoutTax(amount.subtract(entry.getTax()).subtract(entry.getBussesExpenseTax()).setScale(2, 4));
        if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
            entry.setAmount(amount.divide(entry.getExchangeRate()).setScale(2, 4));
            entry.setAmountWithoutTax(entry.getAmountOriWithoutTax().divide(entry.getExchangeRate()).subtract(taxAmount).setScale(2, 4));
        } else {
            entry.setAmount(amount.multiply(entry.getExchangeRate()).setScale(2, 4));
            entry.setAmountWithoutTax(entry.getAmountOriWithoutTax().multiply(entry.getExchangeRate()).subtract(taxAmount).setScale(2, 4));
        }
        traBizCollection.add(entry);
    }

    public static Map invoiceCloudBuildTicketEntryByTraMoreTicketEntry(Context ctx, JSONArray ticketData, Map entryLinkInvoice, Map spareMap) throws BOSException {
        TraTicketEntryCollection traTicketCollection = new TraTicketEntryCollection();
        JSONArray entriesJson = new JSONArray();
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)spareMap.get("baseInfo");
        JSONObject entryJson = (JSONObject)entryLinkInvoice.get("entryJson");
        JSONArray invoiceArray = (JSONArray)entryLinkInvoice.get("invoiceArray");
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoiceJsonObject = invoiceArray.getJSONObject(i);
            TraTicketEntryInfo traTicketEntryInfo = new TraTicketEntryInfo();
            BOSUuid traTicketEntryBosId = BOSUuid.create((BOSObjectType)traTicketEntryInfo.getBOSType());
            traTicketEntryInfo.setId(traTicketEntryBosId);
            Object invoiceTypeOut = invoiceJsonObject.get((Object)"invoiceType");
            TravelAccountBillEntryInfo entry = new TravelAccountBillEntryInfo();
            String entryId = (String)entryJson.get((Object)invoiceJsonObject.getString("serialNo"));
            JSONObject entryJsonCustom = new JSONObject();
            JSONArray fidInvoiceArray = new JSONArray();
            entry.setId(BOSUuid.read((String)entryId));
            InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)traTicketEntryInfo, entry);
            traTicketEntryInfo.setTaxClassNumber(invoiceJsonObject.getString("goodsCode"));
            traTicketEntryInfo.setTax(invoiceJsonObject.getBigDecimal("taxAmount"));
            traTicketEntryInfo.setTicketCode(invoiceJsonObject.getString("invoiceCode"));
            traTicketEntryInfo.setTicketTypeId(InvoiceUtil.getTicketTypeId(invoiceJsonObject.getString("invoiceType")));
            traTicketEntryInfo.setTicketType(InvoiceUtil.getTicketType(invoiceJsonObject.getString("invoiceType")));
            traTicketEntryInfo.setTicketNumber(invoiceJsonObject.getString("invoiceNo"));
            traTicketEntryInfo.setAmout(invoiceJsonObject.getBigDecimal("totalAmount").setScale(2, 4));
            traTicketEntryInfo.setTaxRate(invoiceJsonObject.getBigDecimal("taxRate").multiply(new BigDecimal(100)));
            traTicketEntryInfo.setSerialNo(invoiceJsonObject.getString("serialNo"));
            fidInvoiceArray.add((Object)invoiceJsonObject.getString("serialNo"));
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
                traTicketEntryInfo.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, traTicketEntryInfo.getTaxClassNumber(), invoiceTypeOut.toString(), baseInfo, spareMap));
            } else {
                traTicketEntryInfo.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, null, invoiceTypeOut.toString(), baseInfo, spareMap));
            }
            if (traTicketEntryInfo.isIsDeduction()) {
                traTicketEntryInfo.setDeductionTax(traTicketEntryInfo.getTax());
            }
            entryJsonCustom.put("fid", (Object)fidInvoiceArray);
            entryJsonCustom.put("entryid", (Object)entryId);
            entriesJson.add((Object)entryJsonCustom);
            traTicketCollection.add(traTicketEntryInfo);
        }
        HashMap<String, TraTicketEntryCollection> traTicketCollectionMap = new HashMap<String, TraTicketEntryCollection>();
        traTicketCollectionMap.put("traTicketCollection", traTicketCollection);
        traTicketCollectionMap.put("entriesJson", (TraTicketEntryCollection)entriesJson);
        return traTicketCollectionMap;
    }

    public static Map invoiceCloudBuildAccountEntryByBizOutFirstAccount(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        BizAccountOutBillAccountEntryCollection accountCollection = new BizAccountOutBillAccountEntryCollection();
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal amountOri = BizCollUtil.ZERO;
        boolean first = true;
        for (int i = 0; i < ticketData.size(); ++i) {
            JSONObject eJsStrOut = ticketData.getJSONObject(i);
            if (first) {
                BizAccountOutBillAccountEntryInfo bizOutAccountEntry = new BizAccountOutBillAccountEntryInfo();
                InvoiceUtil.buildPurAndBizOutBillAccountEntryInfo(bizOutAccountEntry, eJsStrOut);
                bizOutAccountEntry.setCurrencyType(MbizCollUtil.getCurrentType((Context)ctx));
                accountCollection.add(bizOutAccountEntry);
                amount = amount.add(bizOutAccountEntry.getAmount());
                amountOri = amountOri.add(bizOutAccountEntry.getAmountOri());
                first = false;
                continue;
            }
            if (null == eJsStrOut.get((Object)"totalAmount") || "".equals(eJsStrOut.get((Object)"totalAmount").toString())) continue;
            amount = amount.add(new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString()));
            amountOri = amountOri.add(new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString()));
        }
        BizAccountOutBillAccountEntryInfo firstBizOutAccount = accountCollection.get(0);
        firstBizOutAccount.setAmount(amount);
        firstBizOutAccount.setAmountOri(amountOri);
        HashMap<String, BizAccountOutBillAccountEntryCollection> bizOutAccountCollectionMap = new HashMap<String, BizAccountOutBillAccountEntryCollection>();
        bizOutAccountCollectionMap.put("bizOutAccountCollection", accountCollection);
        return bizOutAccountCollectionMap;
    }

    public static Map invoiceCloudBuildAccountEntryByPurFirstAccount(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        DailyPurchaseAccountBillAccountEntryCollection purAccountCollection = new DailyPurchaseAccountBillAccountEntryCollection();
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal amountOri = BizCollUtil.ZERO;
        for (int i = 0; i < ticketData.size(); ++i) {
            JSONObject eJsStrPur = ticketData.getJSONObject(i);
            DailyPurchaseAccountBillAccountEntryInfo purAccountEntry = new DailyPurchaseAccountBillAccountEntryInfo();
            InvoiceUtil.buildPurAndBizOutBillAccountEntryInfo(purAccountEntry, eJsStrPur);
            amount = amount.add(purAccountEntry.getAmount());
            amountOri = amountOri.add(purAccountEntry.getAmountOri());
            purAccountCollection.add(purAccountEntry);
        }
        DailyPurchaseAccountBillAccountEntryInfo firstPurAccount = purAccountCollection.get(0);
        purAccountCollection.clear();
        firstPurAccount.setCurrencyType(MbizCollUtil.getCurrentType((Context)ctx));
        firstPurAccount.setAmount(amount);
        firstPurAccount.setAmountOri(amountOri);
        purAccountCollection.add(firstPurAccount);
        HashMap<String, DailyPurchaseAccountBillAccountEntryCollection> bizOutAccountCollectionMap = new HashMap<String, DailyPurchaseAccountBillAccountEntryCollection>();
        bizOutAccountCollectionMap.put("purAccountCollection", purAccountCollection);
        return bizOutAccountCollectionMap;
    }
}

