/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSONUtil {
    public static JSONObject convertAdminOrgInfo2Json(IRowSet rowSet) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)rowSet.getString("id"));
        jsonObj.put("text", (Object)rowSet.getString("name"));
        jsonObj.put("level", rowSet.getInt("level"));
        jsonObj.put("leaf", rowSet.getBoolean("isLeaf"));
        jsonObj.put("children", (Object)new JSONArray());
        jsonObj.put("parentid", (Object)(null != rowSet.getString("parent.id") ? rowSet.getString("parent.id") : ""));
        return jsonObj;
    }

    public static JSONObject convertPersonInfo2Json(IRowSet rowSet) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("personId", (Object)rowSet.getString("id"));
        jsonObj.put("personName", (Object)rowSet.getString("name"));
        jsonObj.put("personNumber", (Object)rowSet.getString("number"));
        return jsonObj;
    }

    public static JSONArray toConvertJSON(JSONArray tree) {
        int max;
        Map indexMap = JSONUtil.initIndexMap(tree);
        int size = indexMap.size();
        if (size == 1) {
            return tree;
        }
        int[] indexArr = JSONUtil.initIndexArr(indexMap);
        int min = JSONUtil.getMinValue(indexArr);
        if (min + (size - 1) != (max = JSONUtil.getMaxValue(indexArr))) {
            try {
                throw new Exception(JSONUtil.class + " toConvertJSON() method may be error");
            }
            catch (Exception e) {
                e.printStackTrace();
                return tree;
            }
        }
        for (int j = max - 1; j >= min; --j) {
            JSONUtil.sort(indexMap, j);
        }
        return JSONUtil.sortJsonArray(indexMap, min);
    }

    static void sort(Map indexMap, int currentIndex) {
        Map curMap = (Map)indexMap.get(new Integer(currentIndex));
        Iterator keyValuePairs1 = curMap.entrySet().iterator();
        for (int m = 0; m < curMap.size(); ++m) {
            Map.Entry entry1 = keyValuePairs1.next();
            Object key1 = entry1.getKey();
            Object value1 = entry1.getValue();
            JSONArray treeArray = new JSONArray();
            Map leafMap = (Map)indexMap.get(new Integer(currentIndex + 1));
            Iterator keyValuePairs2 = leafMap.entrySet().iterator();
            for (int n = 0; n < leafMap.size(); ++n) {
                Map.Entry entry2 = keyValuePairs2.next();
                Object value2 = entry2.getValue();
                try {
                    if (!key1.equals(((JSONObject)value2).get("parentid"))) continue;
                    treeArray.put(value2);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                JSONObject parentObj = (JSONObject)value1;
                parentObj.put("children", (Object)treeArray);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static JSONArray sortJsonArray(Map indexMap, int minLevel) {
        JSONArray ay = new JSONArray();
        Map lastMap = (Map)indexMap.get(new Integer(minLevel));
        Iterator keyValuePairs3 = lastMap.entrySet().iterator();
        for (int m = 0; m < lastMap.size(); ++m) {
            Map.Entry entry1 = keyValuePairs3.next();
            Object value1 = entry1.getValue();
            ay.put(value1);
        }
        return ay;
    }

    static Map initIndexMap(JSONArray tree) {
        LinkedHashMap indexMap = new LinkedHashMap();
        JSONObject jo = null;
        for (int i = 0; i < tree.length(); ++i) {
            jo = (JSONObject)tree.get(i);
            int level = jo.getInt("level");
            if (null == indexMap.get(new Integer(level))) {
                LinkedHashMap<String, JSONObject> valueMap = new LinkedHashMap<String, JSONObject>();
                valueMap.put(jo.getString("id"), jo);
                indexMap.put(new Integer(level), valueMap);
                continue;
            }
            Map oriMap = (Map)indexMap.get(new Integer(level));
            oriMap.put(jo.getString("id"), jo);
        }
        return indexMap;
    }

    static int[] initIndexArr(Map indexMap) {
        int[] indexArr = new int[indexMap.size()];
        int i = 0;
        for (Object obj : indexMap.keySet()) {
            indexArr[i] = (Integer)obj;
            ++i;
        }
        return indexArr;
    }

    public static int getMaxValue(int[] arr) {
        int n = arr.length;
        int max = arr[0];
        for (int i = 1; i < n; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
        }
        return max;
    }

    public static int getMinValue(int[] arr) {
        int n = arr.length;
        int min = arr[0];
        for (int i = 1; i < n; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }
}

