/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.cp.bc.IMarketAccountBill;
import com.kingdee.eas.cp.bc.MarketAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.MarketAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.MarketAccountBillFactory;
import com.kingdee.eas.cp.bc.MarketAccountBillInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class MarketExpenseAccountAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.MarketExpenseAccountAddByExcel");
    String[] STRING_FIELDS = new String[]{"FTel", "FCause", "FName"};
    String[] STRING_OBJS = new String[]{"tel", "cause", "name"};
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntryAmount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"amount"};
    String[] DATE_FIELDS_EN = new String[]{"FHappenTime"};
    String[] DATE_OBJS_EN = new String[]{"happenTime"};
    String[] STRING_FIELDS_EN = new String[]{"FPurpose", "FEntryName", "FComment"};
    String[] STRING_OBJS_EN = new String[]{"purpose", "name", "comment"};
    private IObjectPK TEMPPK = null;
    private static String TEMPNUMBER = null;
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.ExportMarketAccountBillQuery";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MarketAccountBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        MarketAccountBillInfo marketExpenseAccInfo = new MarketAccountBillInfo();
        Object data = null;
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata == null) throw new TaskExternalException("number  not found!!!!");
        str = numberdata.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException("number  not found!!!!");
        if (str.equals(TEMPNUMBER)) {
            try {
                IMarketAccountBill iFixBill = MarketAccountBillFactory.getLocalInstance(ctx);
                MarketAccountBillInfo marketExpenseInfo = iFixBill.getMarketAccountBillInfo(this.TEMPPK);
                if (marketExpenseInfo != null) {
                    marketExpenseAccInfo = marketExpenseInfo;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            marketExpenseAccInfo.setNumber(str);
            TEMPNUMBER = str;
            for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
                Object o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
                if (o == null) continue;
                String value = o.toString();
                marketExpenseAccInfo.setString(this.STRING_OBJS[i], value);
            }
            data = ((DataToken)hsData.get((Object)"FPrior")).data;
            String value = null;
            if (data != null && (value = data.toString()) != null) {
                marketExpenseAccInfo.setPrior(this.getPriorValue(value));
            }
            try {
                ICurrency icurreny;
                CompanyOrgUnitInfo info;
                ICompanyOrgUnit icompany;
                CompanyOrgUnitCollection collection;
                FilterInfo filter;
                EntityViewInfo viewInfo;
                IUser iuser = UserFactory.getLocalInstance((Context)ctx);
                UserInfo userInfo = null;
                userInfo = iuser.getUserInfo(ctx.getCaller());
                marketExpenseAccInfo.setBiller(userInfo);
                PersonInfo personInfo = null;
                Object tempData = ((DataToken)hsData.get((Object)"FApplier")).data;
                if (tempData == null) {
                    throw new TaskExternalException(EASResource.getString((String)RES, (String)"USER_NAME_NOT_NULL"));
                }
                str = tempData.toString();
                if (str != null && str.trim().length() > 0) {
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    PersonCollection perCollection = iPerson.getPersonCollection(viewInfo);
                    if (perCollection == null || perCollection.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"NOT_EXIST_USERNAME"));
                    if (perCollection.size() > 1) {
                        throw new TaskExternalException(EASResource.getString((String)RES, (String)"EXIST_SAME_USERNAME"));
                    }
                    personInfo = perCollection.get(0);
                    if (personInfo != null) {
                        marketExpenseAccInfo.setApplier(personInfo);
                        IPersonFacade iPersonFacade = PersonFacadeFactory.getLocalInstance((Context)ctx);
                        AdminOrgUnitCollection aouc = iPersonFacade.getAdminOrgUnitByPerson(personInfo.getId());
                        AdminOrgUnitInfo aouInfo = null;
                        if (aouc != null && aouc.size() > 0) {
                            aouInfo = aouc.get(0);
                        }
                        marketExpenseAccInfo.setOrgUnit(aouInfo);
                        IPositionMember iPoMe = PositionMemberFactory.getLocalInstance((Context)ctx);
                        PositionMemberCollection poCol = iPoMe.getPositionsByPerson(personInfo.getId());
                        if (poCol != null && poCol.size() > 0) {
                            marketExpenseAccInfo.setPosition(poCol.get(0).getPosition());
                        }
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCostedDept")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    ICostCenterOrgUnit iCost = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    CostCenterOrgUnitCollection costCollection = iCost.getCostCenterOrgUnitCollection(viewInfo);
                    if (costCollection == null || costCollection.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"COSTDEPT_ERROR"));
                    CostCenterOrgUnitInfo costCenterOrgUnitInfo = costCollection.get(0);
                    if (personInfo != null) {
                        marketExpenseAccInfo.setCostedDept(costCenterOrgUnitInfo);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FTypeName")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    ExpenseTypeInfo expenseTypeInfo;
                    IExpenseType iExpenseType = ExpenseTypeFactory.getLocalInstance(ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("typeName", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    ExpenseTypeCollection expenseTypeCollection = iExpenseType.getExpenseTypeCollection(viewInfo);
                    if (expenseTypeCollection != null && expenseTypeCollection.size() > 0 && (expenseTypeInfo = expenseTypeCollection.get(0)) != null) {
                        marketExpenseAccInfo.setExpenseType(expenseTypeInfo);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCompany")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    marketExpenseAccInfo.setCompany(info);
                }
                if ((data = ((DataToken)hsData.get((Object)"FPayMode")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    ISettlementType iSet = SettlementTypeFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    SettlementTypeCollection collection2 = iSet.getSettlementTypeCollection(viewInfo);
                    if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"PAYMODE_ERROR"));
                    SettlementTypeInfo settlementTypeInfo = collection2.get(0);
                    if (settlementTypeInfo != null) {
                        marketExpenseAccInfo.setPayMode(settlementTypeInfo);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCurrency")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    marketExpenseAccInfo.setCurrencyType((CurrencyInfo)info);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
                throw new TaskExternalException("");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                throw new TaskExternalException("");
            }
            marketExpenseAccInfo.setBillTypeCode(BizCollBillTypeEnum.ALL);
            marketExpenseAccInfo.setState(StateEnum.DRAFT);
            marketExpenseAccInfo.setBizReqDate(new java.util.Date());
            marketExpenseAccInfo.setBillDate(new java.util.Date());
        }
        MarketAccountBillEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)hsData.get((Object)"FSeq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            MarketAccountBillEntryCollection entryCollection = marketExpenseAccInfo.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                MarketAccountBillEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new MarketAccountBillEntryInfo();
                entryInfo.setBill(marketExpenseAccInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            MarketAccountBillEntryCollection entryCollection = marketExpenseAccInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new MarketAccountBillEntryInfo();
            entryInfo.setBill(marketExpenseAccInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(marketExpenseAccInfo, entryInfo, hsData, ctx);
        return marketExpenseAccInfo;
    }

    private void handleEntry(MarketAccountBillInfo info, MarketAccountBillEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
            try {
                BigDecimal value2;
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], value2);
                BigDecimal tempValue = info.getAmount();
                if (tempValue != null) {
                    value2 = value2.add(tempValue);
                }
                info.setAmount(value2);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex.getMessage());
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + EASResource.getString((String)RES, (String)"NUMBERFORMET"));
            }
        }
        DateFormat df = MultilingualUtil.getDateFormat();
        for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                logger.error((Object)pex.getMessage());
                throw new TaskExternalException(this.DATE_FIELDS_EN[i] + EASResource.getString((String)RES, (String)"DATAERROE"));
            }
            if (o == null || !(o instanceof java.util.Date) || (value = (java.util.Date)o) == null) continue;
            entryInfo.setDate(this.DATE_OBJS_EN[i], (java.util.Date)value);
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS_EN[i], (String)value);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        DateFormat df = null;
        try {
            df = MultilingualUtil.getDateFormat(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            Date date;
            if (!StringUtils.isEmpty((String)rs.getString("number"))) {
                result.put("FNumber", rs.getString("number"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("name"))) {
                result.put("FName", rs.getString("name"));
            }
            if (rs.getBigDecimal("amountApproved") != null) {
                result.put("FAmountApproved", rs.getBigDecimal("amountApproved"));
            }
            if (rs.getBigDecimal("amount") != null) {
                result.put("FAmount", rs.getBigDecimal("amount"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("currencyType.name"))) {
                result.put("FCurrency", rs.getString("currencyType.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("applier.name"))) {
                result.put("FApplier", rs.getString("applier.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("orgUnit.name"))) {
                result.put("FOrgUnit", rs.getString("orgUnit.name"));
            }
            if (rs.getDate("bizReqDate") != null) {
                date = rs.getDate("bizReqDate");
                result.put("FBizReqDate", df.format(date));
            }
            if (!StringUtils.isEmpty((String)rs.getString("expenseType.typeName"))) {
                result.put("FTypeName", rs.getString("expenseType.typeName"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("company.name"))) {
                result.put("FCompany", rs.getString("company.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("costedDept.name"))) {
                result.put("FCostedDept", rs.getString("costedDept.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("prior"))) {
                result.put("FPrior", rs.getString("prior"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("tel"))) {
                result.put("FTel", rs.getString("tel"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("cause"))) {
                result.put("FCause", rs.getString("cause"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("payMode.name"))) {
                result.put("FPayMode", rs.getString("payMode.name"));
            }
            result.put("FSeq", new Integer(rs.getInt("entries.seq")).toString());
            if (!StringUtils.isEmpty((String)rs.getString("entries.name"))) {
                result.put("FEntryName", rs.getString("entries.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("entries.purpose"))) {
                result.put("FPurpose", rs.getString("entries.purpose"));
            }
            if (rs.getDate("entries.happenTime") != null) {
                date = rs.getDate("entries.happenTime");
                result.put("FHappenTime", df.format(date));
            }
            if (rs.getBigDecimal("entries.amount") != null) {
                result.put("FEntryAmount", rs.getBigDecimal("entries.amount"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("entries.comment"))) {
                result.put("FComment", rs.getString("entries.comment"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.ExportMarketAccountBillQuery";
    }

    private PriorEnum getPriorValue(String value) {
        PriorEnum tSaved = PriorEnum.LOW;
        if (value != null) {
            value = value.trim();
            List EnumList = PriorEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                PriorEnum priorenum = (PriorEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(priorenum.getValue());
                String enumName = priorenum.getName();
                String enumAlias = priorenum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = priorenum;
                break;
            }
        }
        return tSaved;
    }
}

