/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.de.web;

import com.kingdee.eas.cp.eip.de.web.DataBaseInfo;
import com.kingdee.eas.cp.eip.de.web.DataContent;
import com.kingdee.eas.cp.eip.de.web.DataHead;
import com.kingdee.eas.cp.eip.de.web.DataPackage;
import com.kingdee.eas.cp.eip.de.web.DocumentAttechment;
import com.kingdee.eas.cp.eip.de.web.DocumentBase;
import com.kingdee.eas.cp.eip.de.web.DocumentBody;
import com.kingdee.eas.cp.eip.de.web.DocumentInfo;
import com.kingdee.eas.cp.eip.de.web.DocumentUrl;
import com.kingdee.eas.cp.eip.de.web.FileHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DataPackageHandler {
    private DataPackage dataPackage = new DataPackage();
    private InputStream inputStream;
    private byte[] readBuffer = new byte[8];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataPackage getDataPackage() {
        if (this.inputStream == null) {
            return null;
        }
        int headSize = 16;
        int totleSize = 0;
        int docInfoSize = 0;
        int contentSize = 0;
        int extraInfoSize = 0;
        boolean position = false;
        boolean dataPackageVer = false;
        Object attechId = null;
        boolean fileSize = false;
        Object headString = null;
        Object operateCommand = null;
        Object userName = null;
        Object docInfo = null;
        Object docType = null;
        String tempFilePath = null;
        Object uuid = null;
        Object targetDocumentLib = null;
        Object fileName = null;
        Object url = null;
        Object title = null;
        Object refPath = null;
        Object errorInfo = null;
        Object verifyWord = null;
        Object lastUpdate = null;
        boolean isZip = false;
        Object dataPackageStream = null;
        Object fileStream = null;
        Object extraInfoStream = null;
        DataPackage dataPackage = new DataPackage();
        FileHandler fileHandler = new FileHandler();
        try {
            dataPackage.setHead(this.getDataHead());
            docInfoSize = dataPackage.getHead().getDocInfoSize();
            contentSize = dataPackage.getHead().getContentSize();
            extraInfoSize = dataPackage.getHead().getExtraInfoSize();
            totleSize = headSize + docInfoSize + contentSize + extraInfoSize;
            dataPackage.setInfo(this.getDataInfo());
            if (contentSize >= 0) {
                DataContent content = new DataContent();
                if ("txt".equalsIgnoreCase(dataPackage.getInfo().getDataType())) {
                    if ("body".equalsIgnoreCase(dataPackage.getInfo().getDocType())) {
                        byte[] bodyContent = new byte[contentSize];
                        this.readFully(bodyContent, 0, contentSize);
                        content.setByteContent(bodyContent);
                    }
                    if ("title".equalsIgnoreCase(dataPackage.getInfo().getDocType())) {
                        content.setTxtContent(this.readString(contentSize));
                        dataPackage.getInfo().setTitle(content.getTxtContent());
                    }
                    if ("path".equalsIgnoreCase(dataPackage.getInfo().getDocType())) {
                        content.setTxtContent(this.readString(contentSize));
                        dataPackage.getInfo().setRefPath(content.getTxtContent());
                    }
                }
                if ("att".equalsIgnoreCase(dataPackage.getInfo().getDataType()) && "attech".equalsIgnoreCase(dataPackage.getInfo().getDocType())) {
                    tempFilePath = fileHandler.getTempFileName(dataPackage.getInfo().getFileName());
                    long fileLen = dataPackage.getInfo().isZip() ? this.saveAttechmentToFile(tempFilePath) : this.saveAttechmentToFile(contentSize, tempFilePath);
                    dataPackage.setTempFilePath(tempFilePath);
                    dataPackage.getInfo().setFileSize(fileLen);
                }
                if ("lis".equalsIgnoreCase(dataPackage.getInfo().getDataType())) {
                    // empty if block
                }
                dataPackage.setContent(content);
            }
            if (extraInfoSize <= 0) return dataPackage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long saveAttechmentToFile(int contentSize, String tempFilePath) {
        int bufferLen = 2048;
        int readTimes = contentSize / bufferLen;
        int remaining = 0;
        boolean totalBytes = false;
        byte[] buffer = new byte[bufferLen];
        File attechFile = new File(tempFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(attechFile);
            for (int i = 0; i < readTimes; ++i) {
                this.readFully(buffer, 0, bufferLen);
                fos.write(buffer);
            }
            remaining = contentSize - bufferLen * readTimes;
            if (remaining > 0) {
                byte[] remainByte = new byte[remaining];
                this.readFully(remainByte, 0, remaining);
                fos.write(remainByte);
            }
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return contentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long saveAttechmentToFile(String tempFilePath) {
        boolean isOK = false;
        int bufferLen = 2048;
        byte[] buffer = new byte[bufferLen];
        File attechFile = new File(tempFilePath);
        FileOutputStream fos = null;
        try {
            int num;
            fos = new FileOutputStream(attechFile);
            GZIPInputStream zipIn = new GZIPInputStream(this.inputStream);
            while ((num = zipIn.read(buffer, 0, buffer.length)) != -1) {
                fos.write(buffer, 0, num);
            }
            fos.flush();
            zipIn.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return attechFile.length();
    }

    private DataBaseInfo getDataInfo() throws IOException {
        DataBaseInfo info = new DataBaseInfo();
        byte command = this.readByte();
        byte dataType = this.readByte();
        byte zipType = this.readByte();
        int userLength = 0;
        int attechIdLen = 0;
        String attechId = null;
        int targetDocLibLength = 0;
        int uuidLen = 0;
        int attechNameLen = 0;
        int lastUpdateLen = 0;
        int verifyWordLen = 0;
        long fileSize = 0L;
        String uuid = null;
        String targetDocLib = null;
        String userName = null;
        String attechName = null;
        String lastUpdate = null;
        String verifyWord = null;
        userLength = this.readUnsignedShort();
        userName = this.readString(userLength);
        targetDocLibLength = this.readUnsignedShort();
        targetDocLib = this.readString(targetDocLibLength);
        uuidLen = this.readUnsignedShort();
        uuid = this.readString(uuidLen);
        byte detailType = this.readByte();
        attechIdLen = this.readUnsignedShort();
        attechId = this.readString(attechIdLen);
        attechNameLen = this.readUnsignedShort();
        attechName = this.readString(attechNameLen);
        lastUpdateLen = this.readUnsignedShort();
        lastUpdate = this.readString(lastUpdateLen);
        fileSize = this.readLong();
        verifyWordLen = this.readUnsignedShort();
        verifyWord = this.readString(verifyWordLen);
        if (command == 1) {
            info.setOperateCommand("save");
        } else if (command == 2) {
            info.setOperateCommand("delete");
        } else if (command == 3) {
            info.setOperateCommand("load");
        }
        if (dataType == 1) {
            info.setDataType("txt");
            if (detailType == 0) {
                info.setDocType("body");
            } else if (detailType == 1) {
                info.setDocType("title");
            } else if (detailType == 2) {
                info.setDocType("path");
            }
        } else if (dataType == 2) {
            info.setDataType("att");
            if (detailType == 0) {
                info.setDocType("attech");
            } else if (detailType == 1) {
                info.setDocType("url");
            }
        } else if (dataType == 3) {
            info.setDataType("lis");
            info.setDocType("lis");
        }
        if (zipType == 1) {
            info.setZip(true);
        } else {
            info.setZip(false);
        }
        if (attechName != null) {
            info.setFileName(attechName);
        }
        if (verifyWord != null) {
            info.setVerifyWord(verifyWord);
        }
        if (uuid != null) {
            info.setUuid(uuid);
        }
        if (targetDocLib != null) {
            info.setTargetDocumentLib(targetDocLib);
        }
        if (userName != null) {
            info.setUserName(userName);
        }
        if (lastUpdate != null) {
            // empty if block
        }
        if (attechId != null) {
            info.setAttechId(attechId);
        }
        if ("url".equalsIgnoreCase(info.getDocType())) {
            info.setUrl(attechName);
        }
        return info;
    }

    private String readString(int size) throws IOException {
        if (size == 0) {
            return null;
        }
        String str = null;
        byte[] tempByte = new byte[size];
        this.readFully(tempByte, 0, size);
        str = new String(tempByte, "UTF-8");
        return str;
    }

    private DataHead getDataHead() throws IOException {
        DataHead head = new DataHead();
        head.setDataPackageVersion(this.readInt());
        head.setDocInfoSize(this.readInt());
        head.setContentSize(this.readInt());
        head.setExtraInfoSize(this.readInt());
        return head;
    }

    public DocumentBody dataPackageToDucumentBody(DataPackage dataPackage) {
        DocumentBody docBody = new DocumentBody();
        DataContent content = dataPackage.getContent();
        if (content != null) {
            docBody.setContent(content.getByteContent());
        }
        docBody.setTargetDocumentLib(dataPackage.getInfo().getTargetDocumentLib());
        docBody.setUuid(dataPackage.getInfo().getUuid());
        return docBody;
    }

    public DocumentAttechment dataPackageToDucumentAttechment(DataPackage dataPackage) {
        if (dataPackage == null) {
            return null;
        }
        DocumentAttechment documentAttechment = new DocumentAttechment();
        documentAttechment.setZip(dataPackage.getInfo().isZip());
        documentAttechment.setTargetDocumentLib(dataPackage.getInfo().getTargetDocumentLib());
        documentAttechment.setUuid(dataPackage.getInfo().getUuid());
        documentAttechment.setAttechId(dataPackage.getInfo().getAttechId());
        documentAttechment.setFileName(dataPackage.getInfo().getFileName());
        documentAttechment.setFileSize(dataPackage.getInfo().getFileSize());
        documentAttechment.setTempFilePath(dataPackage.getTempFilePath());
        return documentAttechment;
    }

    public DocumentUrl dataPackageToDucumentUrl(DataPackage dataPackage) {
        DocumentUrl docUrl = new DocumentUrl();
        docUrl.setId(dataPackage.getInfo().getAttechId());
        docUrl.setUrl(dataPackage.getInfo().getUrl());
        docUrl.setTargetDocumentLib(dataPackage.getInfo().getTargetDocumentLib());
        docUrl.setUuid(dataPackage.getInfo().getUuid());
        return docUrl;
    }

    public boolean verifyDataPackage(DataPackage dataPackage) {
        boolean isRight = false;
        if (dataPackage.getInfo().getVerifyWord().equalsIgnoreCase("kingdee")) {
            isRight = true;
        }
        return isRight;
    }

    public DocumentInfo dataPackageToDucumentInfo(DataPackage dataPackage) {
        DocumentInfo doc = new DocumentInfo();
        doc.setTargetDocumentLib(dataPackage.getInfo().getTargetDocumentLib());
        doc.setRefPath(dataPackage.getInfo().getRefPath());
        doc.setTitle(dataPackage.getInfo().getTitle());
        doc.setUuid(dataPackage.getInfo().getUuid());
        return doc;
    }

    public DocumentBase dataPackageToDucumentBase(DataPackage dataPackage) {
        DocumentBase doc = new DocumentBase();
        doc.setUuid(dataPackage.getInfo().getUuid());
        doc.setTargetDocumentLib(dataPackage.getInfo().getTargetDocumentLib());
        return doc;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public final byte readByte() throws IOException {
        int ch = this.inputStream.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.inputStream.read();
        if ((ch1 | (ch2 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.inputStream.read();
        if ((ch1 | (ch2 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    public final int readInt() throws IOException {
        int ch3;
        int ch2;
        int ch1;
        int ch0 = this.inputStream.read();
        if ((ch0 | (ch1 = this.inputStream.read()) | (ch2 = this.inputStream.read()) | (ch3 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (ch3 << 24) + (ch2 << 16) + (ch1 << 8) + (ch0 << 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[7] << 56) + ((long)(this.readBuffer[6] & 0xFF) << 48) + ((long)(this.readBuffer[5] & 0xFF) << 40) + ((long)(this.readBuffer[4] & 0xFF) << 32) + ((long)(this.readBuffer[3] & 0xFF) << 24) + (long)((this.readBuffer[2] & 0xFF) << 16) + (long)((this.readBuffer[1] & 0xFF) << 8) + (long)((this.readBuffer[0] & 0xFF) << 0);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.inputStream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

