/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.de.web;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataParserUtil {
    private byte[] readBuffer = new byte[8];
    private InputStream inputStream = null;

    public final byte readByte() throws IOException {
        int ch = this.inputStream.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.inputStream.read();
        if ((ch1 | (ch2 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.inputStream.read();
        if ((ch1 | (ch2 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    public final int readInt() throws IOException {
        int ch3;
        int ch2;
        int ch1;
        int ch0 = this.inputStream.read();
        if ((ch0 | (ch1 = this.inputStream.read()) | (ch2 = this.inputStream.read()) | (ch3 = this.inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (ch3 << 24) + (ch2 << 16) + (ch1 << 8) + (ch0 << 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[7] << 56) + ((long)(this.readBuffer[6] & 0xFF) << 48) + ((long)(this.readBuffer[5] & 0xFF) << 40) + ((long)(this.readBuffer[4] & 0xFF) << 32) + ((long)(this.readBuffer[3] & 0xFF) << 24) + (long)((this.readBuffer[2] & 0xFF) << 16) + (long)((this.readBuffer[1] & 0xFF) << 8) + (long)((this.readBuffer[0] & 0xFF) << 0);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.inputStream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

