/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.de.web;

import com.kingdee.eas.cp.common.web.config.DocEngineConfigItem;
import com.kingdee.eas.cp.common.web.config.PortalXmlConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class FileHandler {
    static Logger logger = Logger.getLogger((String)FileHandler.class.getName());
    private String tempFilePath;
    private long zipSize = 1024000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long saveFile(InputStream in, String fileName, long fileSize) {
        int bufferSize = 2048;
        int readTimes = (int)fileSize / bufferSize;
        int remaining = 0;
        boolean totalBytes = false;
        long tempFileSize = 0L;
        byte[] buffer = new byte[bufferSize];
        boolean num = false;
        BufferedInputStream inStream = new BufferedInputStream(in);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            for (int i = 0; i < readTimes; ++i) {
                ((InputStream)inStream).read(buffer);
                fos.write(buffer);
            }
            remaining = (int)fileSize - bufferSize * readTimes;
            if (remaining > 0) {
                byte[] remainByte = new byte[remaining];
                ((InputStream)inStream).read(remainByte);
                fos.write(remainByte);
            }
            tempFileSize = fileSize;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return tempFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long saveFile(InputStream in, String fileName) {
        logger.debug((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u6b63\u5728\u538b\u7f29\u6587\u4ef6...");
        int bufferSize = 2048;
        long tempFileSize = 0L;
        byte[] buffer = new byte[bufferSize];
        int num = 0;
        BufferedInputStream inStream = new BufferedInputStream(in);
        File file = new File(fileName);
        FileOutputStream fos = null;
        GZIPOutputStream zipOut = null;
        try {
            fos = new FileOutputStream(file);
            zipOut = new GZIPOutputStream(fos);
            while ((num = ((InputStream)inStream).read(buffer)) != -1) {
                zipOut.write(buffer, 0, num);
            }
            zipOut.close();
            fos.close();
            ((InputStream)inStream).close();
            tempFileSize = file.length();
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u538b\u7f29\u6587\u4ef6\u5931\u8d25\uff01");
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger.error((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u538b\u7f29\u6587\u4ef6\u5931\u8d25\uff01");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        logger.debug((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u538b\u7f29\u6587\u4ef6\u5b8c\u6210\uff01");
        return tempFileSize;
    }

    public static String filterFileName(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = str.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '/': {
                    continue block10;
                }
                case ':': {
                    continue block10;
                }
                case '*': {
                    continue block10;
                }
                case '?': {
                    continue block10;
                }
                case '\"': {
                    continue block10;
                }
                case '<': {
                    continue block10;
                }
                case '>': {
                    continue block10;
                }
                case '|': {
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String getTempFileName(String fileName) {
        this.loadConfig();
        StringBuffer filePath = new StringBuffer();
        String tempString = null;
        filePath.append(this.tempFilePath);
        filePath.append(File.separator);
        tempString = new Timestamp(System.currentTimeMillis()).toString();
        tempString = FileHandler.filterFileName(tempString);
        filePath.append(tempString);
        filePath.append(".");
        if (fileName == null) {
            fileName = "untile.dm";
        }
        filePath.append(fileName);
        fileName = filePath.toString();
        return fileName;
    }

    public boolean getIsMustZip(long fileSize) {
        this.loadConfig();
        boolean isMustZip = false;
        isMustZip = fileSize > this.zipSize;
        return isMustZip;
    }

    public void loadConfig() {
        logger.info((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u6b63\u5728\u8bfb\u53d6\u914d\u7f6e\u53c2\u6570...");
        DocEngineConfigItem config = PortalXmlConfiguration.newInstance().getDocEngineConfigItem();
        this.tempFilePath = config.getDocEngineTempDir();
        int minSize = 0;
        minSize = config.getZipDocMinSize();
        this.zipSize = minSize == 0 ? 1024000L : (long)(minSize * 1024000);
        File file = new File(this.tempFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        file.mkdirs();
        logger.info((Object)"\u6587\u6863\u5f15\u64ce\uff1a\u8bfb\u53d6\u914d\u7f6e\u53c2\u6570\u6210\u529f\uff01");
    }
}

