/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.index;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eps.ModuleInfo;
import com.kingdee.eas.cp.eps.analysis.AnalyzerManager;
import com.kingdee.eas.cp.eps.app.BusinessDocument;
import com.kingdee.eas.cp.eps.plugin.IModulePlugin;
import com.kingdee.eas.cp.eps.plugin.ModulePluginFactory;
import com.kingdee.eas.cp.eps.utils.EPSUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.document.Field;
import org.apache.lucene1.index.IndexReader;
import org.apache.lucene1.index.IndexWriter;
import org.apache.lucene1.index.Term;

public class IndexManager {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eps.index.IndexManager");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static synchronized void rebuildIndex(Context ctx, List moduleList) {
        if (moduleList == null) {
            return;
        }
        Iterator iterator = moduleList.iterator();
        ModuleInfo moduleInfo = null;
        while (iterator.hasNext()) {
            moduleInfo = (ModuleInfo)iterator.next();
            IndexManager.rebuildIndex(ctx, moduleInfo);
        }
    }

    public static synchronized void rebuildIndex(Context ctx, ModuleInfo moduleInfo) {
        IndexManager.index(ctx, moduleInfo, false);
    }

    public static synchronized void refreshIndex(Context ctx, ModuleInfo moduleInfo) {
        IndexManager.index(ctx, moduleInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void index(Context ctx, ModuleInfo moduleInfo, boolean isUpdate) {
        File indexDir;
        String indexPath = EPSUtils.getIndexDbPath(ctx.getAIS(), moduleInfo.getNumber());
        if (!isUpdate) {
            IndexManager.removeIndex(indexPath);
        }
        if (!(indexDir = new File(indexPath)).exists()) {
            indexDir.mkdirs();
        }
        if (!indexDir.exists()) {
            logger.info((Object)"\u7d22\u5f15\u8def\u5f84\u521b\u5efa\u5931\u8d25");
            return;
        }
        try {
            IModulePlugin mp = ModulePluginFactory.getModulePlugin(ctx, moduleInfo);
            IRowSet rowSet = null;
            if (isUpdate) {
                rowSet = mp.getUpdateData();
                try {
                    Term term = null;
                    while (rowSet.next()) {
                        term = new Term("id", rowSet.getString("id"));
                        IndexReader ir = IndexReader.open((File)indexDir);
                        ir.delete(term);
                        ir.close();
                    }
                    rowSet.beforeFirst();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                rowSet = mp.getData();
            }
            IndexWriter fsWriter = null;
            try {
                fsWriter = !indexDir.exists() || indexDir.isDirectory() && indexDir.list().length == 0 ? new IndexWriter(indexDir, AnalyzerManager.getAnalyzer(), true) : new IndexWriter(indexDir, AnalyzerManager.getAnalyzer(), !isUpdate);
                fsWriter.setUseCompoundFile(false);
                fsWriter.minMergeDocs = 1000;
                fsWriter.maxMergeDocs = 1000;
                BusinessDocument bizDoc = null;
                Document doc = null;
                while (rowSet.next()) {
                    bizDoc = mp.getBusinessDocument(rowSet);
                    doc = IndexManager.getLuceneDoc(bizDoc);
                    fsWriter.addDocument(doc);
                }
                fsWriter.optimize();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fsWriter != null) {
                    fsWriter.close();
                }
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static void removeIndex(String path) {
        if (!StringUtils.isEmpty((String)path)) {
            File f = new File(path);
            f.deleteOnExit();
        }
    }

    private static Document getLuceneDoc(BusinessDocument dataObject) {
        Document doc = new Document();
        doc.add(Field.Keyword((String)"id", (String)dataObject.getId()));
        if (!StringUtils.isEmpty((String)dataObject.getTitle())) {
            doc.add(Field.Text((String)"title", (String)dataObject.getTitle()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getKeyWord())) {
            doc.add(Field.Text((String)"keyWord", (String)dataObject.getKeyWord()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getContent())) {
            doc.add(Field.Text((String)"content", (String)dataObject.getContent()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getCreateUser())) {
            doc.add(Field.Text((String)"createuser", (String)dataObject.getCreateUser()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getLastUpdateUser())) {
            doc.add(Field.Text((String)"lastUpdateUser", (String)dataObject.getLastUpdateUser()));
        }
        if (dataObject.getCreateTime() != null) {
            doc.add(Field.Keyword((String)"createTime", (String)sdf.format(dataObject.getCreateTime())));
        }
        if (dataObject.getLastUpdateTime() != null) {
            doc.add(Field.Keyword((String)"lastUpdateTime", (String)sdf.format(dataObject.getLastUpdateTime())));
        }
        if (!StringUtils.isEmpty((String)dataObject.getPath())) {
            doc.add(Field.Keyword((String)"path", (String)dataObject.getPath()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getGategory())) {
            doc.add(Field.Keyword((String)"module", (String)dataObject.getGategory()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getCategoryID())) {
            doc.add(Field.Keyword((String)"category", (String)dataObject.getCategoryID()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getCategoryName())) {
            doc.add(Field.Keyword((String)"categoryName", (String)dataObject.getCategoryName()));
        }
        if (!StringUtils.isEmpty((String)dataObject.getAttachType())) {
            doc.add(Field.Keyword((String)"attachType", (String)dataObject.getAttachType()));
        }
        return doc;
    }
}

