/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.fme.ftp.FMEFtpFactory;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.IFMEFtp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.eps.app.BusinessDocument;
import com.kingdee.eas.cp.eps.plugin.AbstractModulePlugin;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DMPlugin
extends AbstractModulePlugin {
    private String attchType;
    private String localDirectoryAndFileName = null;
    private Map ftpInfoMap = null;

    public DMPlugin() {
        this.queryName = "DocumentQuery";
        this.queryPackage = "com.kingdee.eas.cp.dm.app";
    }

    protected EntityViewInfo getEntityView(boolean isUpdate) {
        EntityViewInfo ev = super.getEntityView(isUpdate);
        FilterInfo filterInfo = ev.getFilter() == null ? new FilterInfo() : ev.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfState", (Object)String.valueOf(3), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isHistory", (Object)Boolean.FALSE, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        SorterItemInfo item = new SorterItemInfo("lastUpdateTime");
        item.setSortType(SortType.DESCEND);
        ev.getSorter().add(item);
        return ev;
    }

    public BusinessDocument getBusinessDocument(IRowSet rowSet) {
        BusinessDocument obj = null;
        try {
            obj = new BusinessDocument();
            obj.setId(rowSet.getString("id"));
            obj.setTitle(rowSet.getString("TITLE"));
            obj.setCreateUser(rowSet.getString("AUTHOR.NAME"));
            obj.setCreateTime(rowSet.getTimestamp("CREATETIME"));
            obj.setLastUpdateTime(rowSet.getTimestamp("LASTUPDATETIME"));
            obj.setKeyWord(rowSet.getString("TAG"));
            obj.setPath(this.getURL(rowSet.getString("id")));
            obj.setGategory("dm");
            obj.setCategoryID(rowSet.getString("category.id"));
            obj.setCategoryName(rowSet.getString("category.name"));
            obj.setContent(this.getContent(rowSet));
            obj.setAttachType(this.attchType);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("dmrowset Exception id:" + rowSet.getString("id")));
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return obj;
    }

    public String getURL(String bizID) {
        try {
            return "/easweb/cp/dm/documentPreView.jsf?docId=" + URLEncoder.encode(bizID, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasPermission(String bizID) {
        boolean result = true;
        String perId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
        DocumentInfo document = null;
        ObjectUuidPK pk = new ObjectUuidPK(bizID);
        try {
            document = DocumentFactory.getLocalInstance((Context)this.ctx).getDocumentInfo((IObjectPK)pk);
            if (document == null || 2 == document.getState().getValue()) {
                result = false;
            } else {
                String authorId;
                String string = authorId = document.getAuthor() == null ? "" : document.getAuthor().getId().toString();
                if (perId.equals(authorId)) {
                    result = true;
                } else {
                    String categoryId;
                    String string2 = categoryId = document.getCategory() != null ? document.getCategory().getId().toString() : "";
                    if (categoryId != null && !"".equals(categoryId)) {
                        result = document.isIsEnablePerm() ? this.hasPermissionByDocument(document.getId().toString(), perId, "4") : this.hasPermissionByCatetory(categoryId, perId, "4");
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean hasPermissionByCatetory(String categoryId, String personId, String permType) {
        boolean result = true;
        String sql = this.getHasPermissionSql(permType, "T_DM_Category");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])new Object[]{categoryId, personId, categoryId, personId, categoryId, personId});
            result = rowset.next();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean hasPermissionByDocument(String documentId, String personId, String permType) {
        boolean result = true;
        String sql = this.getHasPermissionSql(permType, "T_DM_DocumentInfo");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])new Object[]{documentId, personId, documentId, personId, documentId, personId});
            result = rowset.next();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getHasPermissionSql(String permType, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("select ca.fid from ").append(tableName).append("Admin ca ");
        sql.append("where ca.fparentid = ? and ca.fpermlist like '%").append(permType).append("%' ");
        sql.append("and exists ( ");
        sql.append("\tSELECT  subADMIN.FID FROM T_BD_Person AS PERSON ");
        sql.append("    INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        sql.append("    INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        sql.append("    INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        sql.append("    INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID ");
        sql.append("    where PERSON.fid = ? and subADMIN.fid = ca.FAdminID) ");
        sql.append("union all ");
        sql.append("select cr.fid from ").append(tableName).append("Role cr ");
        sql.append("where cr.fparentid =? and cr.fpermlist like '%").append(permType).append("%' ");
        sql.append("and exists ( ");
        sql.append("\tselect userRole.froleid from T_PM_UserRoleOrg userRole ");
        sql.append("\tINNER JOIN T_PM_USER AS pmuser ON pmuser.FID = userRole.fuserid ");
        sql.append("\twhere pmuser.FPERSONID = ? ");
        sql.append("\tand userRole.froleid = cr.froleid ) ");
        sql.append("union all ");
        sql.append("select cp.fid from ").append(tableName).append("Person cp ");
        sql.append("where cp.fparentid = ? and cp.fpermlist like '%").append(permType).append("%' ");
        sql.append("   and cp.fpersonid = ? ");
        return sql.toString();
    }

    protected String getContent(IRowSet rowSet) throws SQLException {
        this.attchType = "";
        String type = "";
        BoAttchAssoCollection bac = this.getAttach(rowSet.getString("id"));
        StringBuffer sb = new StringBuffer();
        sb.append(rowSet.getString("summary") == null ? "" : rowSet.getString("summary"));
        if (bac != null && bac.size() > 0) {
            ByteArrayInputStream stream = null;
            int size = bac.size();
            for (int n = 0; n < size; ++n) {
                if (bac.get(n).getAttachment() == null) continue;
                String contentType = rowSet.getString("CONTENTTYPE");
                type = "1".equals(contentType) ? ",html," : ("2".equals(contentType) ? ",doc," : ("3".equals(contentType) ? ",xls," : ("4".equals(contentType) ? ",pdf," : "")));
                if (this.attchType.indexOf(type) < 0 && type.length() > 0) {
                    this.attchType = this.attchType + type;
                }
                if (bac.get(n).getAttachment().getFile() == null || bac.get(n).getAttachment().getFile().length <= 0) continue;
                stream = new ByteArrayInputStream(bac.get(n).getAttachment().getFile());
                sb.append(this.parseToString(stream));
            }
        }
        sb.append(this.getFtpContent(rowSet.getString("id")));
        return sb.toString();
    }

    private String getFtpContent(String docID) {
        if (StringUtils.isEmpty((String)docID)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FMEDOC.FDocumentID ,FMEDOC.FName,FMEDOC.FPath, ");
            sql.append("FMEDOC.FDescription,FMEDOC.FOperdate,FMEDOC.FServerID ");
            sql.append("FROM T_FME_BusiDoc AS BUSIDOC ");
            sql.append("INNER JOIN T_FME_Document AS FMEDOC ");
            sql.append("ON BUSIDOC.FDocumentID = FMEDOC.FDocumentID ");
            sql.append("WHERE BUSIDOC.FBusinessID = '" + docID + "'");
            IRowSet rowset = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
            String fileType = null;
            File file = null;
            while (rowset.next()) {
                String serverId = rowset.getString("FServerID");
                String fileName = rowset.getString("FName");
                String path = rowset.getString("FPath");
                fileType = this.getFileType(fileName);
                if (("," + this.attchType).indexOf("," + fileType + ",") < 0) {
                    this.attchType = this.attchType + fileType + ",";
                }
                file = this.getFile(serverId, path, fileName, fileType);
                sb.append(this.parseToString(file));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private File getFile(String serverID, String path, String fileName, String filetype) {
        Map ftpMap = this.getFtpInfo();
        if (ftpMap.get(serverID) == null) {
            logger.info((Object)("\u672a\u627e\u5230\u5bf9\u5e94\u7684ftp\u914d\u7f6e\u9879\uff1aserverid= " + serverID));
            return null;
        }
        String ftpInfo = ftpMap.get(serverID).toString();
        String[] ftpInfoArray = ftpInfo.split(";");
        String serverHost = ftpInfoArray[0];
        int serverPort = Integer.parseInt(ftpInfoArray[1]);
        String serverUserName = ftpInfoArray[2];
        String serverPassWord = ftpInfoArray[3];
        FtpConfig config = new FtpConfig();
        config.setFtpid(serverID);
        config.setHost(serverHost);
        config.setPort(serverPort);
        config.setUsername(serverUserName);
        config.setPassword(serverPassWord);
        config.setIsDefault(1);
        logger.info((Object)("ftpconfig \uff1a " + config));
        IFMEFtp ftp = FMEFtpFactory.getFMEFtpInstanceWithFtpConfig((FtpConfig)config);
        this.localDirectoryAndFileName = new StringBuffer().append(System.getProperty("eas.deploy")).append("/").append("fts2.").append(filetype).toString();
        String ftpDirectoryAndFileName = path + fileName;
        File ftpFile = null;
        try {
            boolean downloadResult = ftp.downloadStreamByFileName(ftpDirectoryAndFileName, this.localDirectoryAndFileName);
            if (downloadResult) {
                ftpFile = new File(this.localDirectoryAndFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ftpFile;
    }

    private String getFileType(String fileName) {
        int beginIndex = fileName.lastIndexOf(".") + 1;
        String fileType = fileName.substring(beginIndex);
        return fileType;
    }

    private Map getFtpInfo() {
        if (this.ftpInfoMap == null) {
            this.ftpInfoMap = new HashMap();
            try {
                IRowSet rowset = DbUtil.executeQuery((Context)this.getCtx(), (String)"select FServerHost,FServerPort,FServerUser,FServerPswd,FServerID from T_FME_FtpServer");
                while (rowset.next()) {
                    StringBuffer sb = new StringBuffer();
                    String serverID = rowset.getString("FServerID");
                    String serverHost = rowset.getString("FServerHost");
                    String serverPort = String.valueOf(rowset.getInt("FServerPort"));
                    String serverUser = rowset.getString("FServerUser");
                    String serverPassWord = rowset.getString("FServerPswd");
                    sb.append(serverHost).append(";").append(serverPort).append(";").append(serverUser).append(";").append(serverPassWord);
                    this.ftpInfoMap.put(serverID, sb.toString());
                }
            }
            catch (Exception e) {
                logger.info((Object)"\u83b7\u53d6ftp\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            }
        }
        return this.ftpInfoMap;
    }
}

